/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import jsbugs.CountRenderer;
import jsbugs.MarkerRenderer;
import jsbugs.TaxonWellOccItem;
import model2.Sample;
import model2.TaxonOcc;
import model2.WellInterp;
import util.ColouredRenderer;
import util.SB;
import util.TableSorter;

class TableModelTaxonWellOcc
extends AbstractTableModel {
    List<TaxonWellOccItem> occs;
    static String[] columnTitles = new String[]{"Sample", "LOC Age", "Stratigraphy", "Discipline", "Analyst", "Suite", "Mkr?", "Image", "RW", "?", "Abund.", "Coarse", "Medium", "Fine", "CV", "Type", "Preserv.", "Colour", "Comments"};
    static int[] columnWidths = new int[]{60, 25, 80, 20, 20, 10, 20, 20, 20, 20, 20, 20, 20, 20, 20, 40, 50, 20, 80};
    static final int COL_SAMPLE = 0;
    static final int COL_LOCAGE = 1;
    static final int COL_LOCSTRAT = 2;
    static final int COL_DISC = 3;
    static final int COL_ANALYST = 4;
    static final int COL_SUITE = 5;
    static final int COL_MARKER = 6;
    static final int COL_IMAGE = 7;
    static final int COL_RW = 8;
    static final int COL_QUESTION = 9;
    static final int COL_ABUND = 10;
    static final int COL_COARSE = 11;
    static final int COL_MEDIUM = 12;
    static final int COL_FINE = 13;
    static final int COL_CAVED = 14;
    static final int COL_SPECTYPE = 15;
    static final int COL_PRESERV = 16;
    static final int COL_COLOUR = 17;
    static final int COL_COMMENTS = 18;
    static final int IMAGE_ROW_HEIGHT = 50;
    static final int NORMAL_ROW_HEIGHT = 15;

    TableModelTaxonWellOcc() {
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public int getRowCount() {
        if (this.occs == null) {
            return 0;
        }
        return this.occs.size();
    }

    public void setRowHeight(JTable table, TableSorter sorter) {
        if (this.occs == null) {
            return;
        }
        Iterator<TaxonWellOccItem> it = this.occs.iterator();
        int row = 0;
        while (it.hasNext()) {
            try {
                if (it.next().occ.getImage() != null) {
                    table.setRowHeight(sorter.getRowOf(row), 50);
                } else {
                    table.setRowHeight(sorter.getRowOf(row), 15);
                }
            }
            catch (Exception e) {
                table.setRowHeight(sorter.getRowOf(row), 15);
            }
            ++row;
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.occs == null) {
            return null;
        }
        TaxonOcc fss = this.occs.get((int)row).occ;
        Sample sample = this.occs.get((int)row).sample;
        WellInterp wellInterp = this.occs.get((int)row).wellInterp;
        switch (col) {
            case 0: {
                return sample;
            }
            case 3: {
                return this.occs.get((int)row).smpdtl.getHeader().getDiscipline().getAbr(true);
            }
            case 4: {
                try {
                    return this.occs.get((int)row).smpdtl.getAnalyst();
                }
                catch (Exception ex) {
                    return ex.getMessage();
                }
            }
            case 5: {
                try {
                    return this.occs.get((int)row).smpdtl.getAnalyNo();
                }
                catch (Exception ex) {
                    return ex.getMessage();
                }
            }
            case 6: {
                return fss.isMarker();
            }
            case 8: {
                if (fss.getReworked()) {
                    return "Rw";
                }
                return "";
            }
            case 9: {
                if (fss.getIdentType() == '?') {
                    return "?";
                }
                return "";
            }
            case 10: {
                if (fss.isOutsideCount()) {
                    return "+";
                }
                return fss.getSubAbund();
            }
            case 11: {
                return fss.getCoarse();
            }
            case 12: {
                return fss.getMedium();
            }
            case 13: {
                return fss.getFine();
            }
            case 14: {
                if (fss.getCaved()) {
                    return "Cv";
                }
                return "";
            }
            case 15: {
                try {
                    return fss.getSpecTypeString();
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
            case 16: {
                return fss.getPreservation();
            }
            case 17: {
                return fss.getColour();
            }
            case 18: {
                return fss.getComment();
            }
            case 7: {
                try {
                    if (fss.getImage() != null) {
                        return fss.getImage().getThumb(50);
                    }
                    return null;
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
            case 1: {
                if (wellInterp != null && wellInterp.getLOC() != null) {
                    double age = wellInterp.getLOC().getAge(sample.getDepth(), false);
                    if (age > 0.0) {
                        return SB.floatString((double)age, (int)3);
                    }
                    return "";
                }
                return "";
            }
            case 2: {
                try {
                    return sample.getStratigraphy(wellInterp, false);
                }
                catch (Exception ex) {
                    return ex.getMessage();
                }
            }
        }
        return "Error col: " + col;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 11: 
            case 12: 
            case 13: {
                return Integer.class;
            }
            case 7: {
                return ImageIcon.class;
            }
            case 0: 
        }
        return Sample.class;
    }

    void setupTable(JTable jTableOccurrences) {
        SB.setTableHeaderBold((JTable)jTableOccurrences);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            jTableOccurrences.getColumnModel().getColumn(i).setHeaderValue(columnTitles[i]);
            jTableOccurrences.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i] * 2);
        }
        jTableOccurrences.getColumnModel().getColumn(6).setCellRenderer(new MarkerRenderer());
        jTableOccurrences.getColumnModel().getColumn(11).setCellRenderer(new CountRenderer(false));
        jTableOccurrences.getColumnModel().getColumn(12).setCellRenderer(new CountRenderer(false));
        jTableOccurrences.getColumnModel().getColumn(13).setCellRenderer(new CountRenderer(false));
        jTableOccurrences.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new ColouredRenderer(true, new Color(220, 220, 220)));
        jTableOccurrences.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)new ColouredRenderer(true, new Color(220, 220, 220)));
        jTableOccurrences.getTableHeader().setToolTipText("(age and Stratigraphy from Default Version)");
    }
}

