/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.table.TableCellRenderer;
import model2.Taxon;

class TaxonNameRenderer
extends JLabel
implements TableCellRenderer {
    TaxonNameRenderer() {
        this.setUI(new BasicLabelUI(){
            private final Pattern pattern = Pattern.compile("\\<(.*?)\\>");

            @Override
            protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
                if (text.startsWith("<html>")) {
                    String stripped = this.pattern.matcher(text).replaceAll("");
                    int before = stripped.length();
                    label.setText(stripped);
                    String s = super.layoutCL(label, fontMetrics, stripped, icon, viewR, iconR, textR);
                    int after = s.length();
                    if (after < before) {
                        Matcher m = this.pattern.matcher(text);
                        int totalTagChars = 0;
                        String toReturn = null;
                        while (m.find()) {
                            int start = m.start();
                            if (start - totalTagChars > after) {
                                int diff = start - totalTagChars - after;
                                toReturn = text.substring(0, Math.max(start - diff - 3, 0)).trim() + "...";
                            }
                            int end = m.end();
                            if (toReturn != null) {
                                toReturn = toReturn + text.substring(start, end);
                                continue;
                            }
                            totalTagChars += end - start;
                        }
                        label.setText(toReturn);
                        return super.layoutCL(label, fontMetrics, toReturn, icon, viewR, iconR, textR);
                    }
                    label.setText(text);
                }
                return super.layoutCL(label, fontMetrics, text, icon, viewR, iconR, textR);
            }
        });
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        if (value != null) {
            if (value instanceof Taxon) {
                Taxon taxon = (Taxon)value;
                String string = taxon.toString(true, false);
                this.setText(string);
                String author = taxon.getAuthorString(true).trim();
                if (!author.isEmpty()) {
                    int start = string.indexOf(author);
                    int end = start + author.length();
                    string = "<html>" + string.substring(0, start) + "<font color='gray'>" + string.substring(start, end) + "</font>" + string.substring(end) + "</html>";
                    this.setText(string);
                }
            } else {
                this.setText(value.toString());
            }
        }
        return this;
    }
}

