/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.event.MouseMotionListener;
import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import jsbugs.TableModelSB;
import jsbugs.TaxonNameRenderer;
import model2.SBdb;
import model2.Taxon;
import util.SB;
import util.TableSorter;

public class TaxonTableModel
extends TableModelSB {
    List<Taxon> taxa;
    int synSchemeID = 1;
    static String[] columnTitles = new String[]{"Category", "Genus", "Species", "Name", "Code", "Preferred Name", "Type Image", "Mod. By", "Modified"};
    static String[] columnTooltips = new String[]{null, null, null, null, "Alphanumeric code", null, "If taxon has a type specimen image", null, null};
    private static final int[] defaultColumnWidths = new int[]{10, 20, 20, 120, 20, 20, 20, 15, 25};
    static final int COL_CAT = 0;
    static final int COL_GENUS = 1;
    static final int COL_SPECIES = 2;
    static final int COL_NAME = 3;
    static final int COL_CODE = 4;
    static final int COL_PREF = 5;
    static final int COL_IMAGE = 6;
    static final int COL_MODIFIER = 7;
    static final int COL_MODIFIED = 8;
    boolean showPreferred = false;

    public TaxonTableModel(boolean showPreferred) {
        this.showPreferred = showPreferred;
    }

    public TaxonTableModel() {
    }

    @Override
    int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    @Override
    String[] getColumnTitles() {
        return columnTitles;
    }

    @Override
    public int getColumnCount() {
        int cols = columnTitles.length;
        if (!this.showPreferred) {
            --cols;
        }
        return cols;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.taxa == null) {
            return "";
        }
        Taxon taxon = this.taxa.get(row);
        switch (col) {
            case 0: {
                return taxon.getCatMnem();
            }
            case 1: {
                return taxon.getGenusName();
            }
            case 2: {
                return taxon.getSpecies();
            }
            case 3: {
                return taxon;
            }
            case 4: {
                return taxon.getAlphaCode();
            }
            case 5: {
                try {
                    return taxon.getPreferred(this.synSchemeID);
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
            case 6: {
                try {
                    return taxon.hasTypeImage() ? "Y" : "";
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
            case 8: {
                return taxon.getModified();
            }
            case 7: {
                return taxon.getModifier();
            }
        }
        return "";
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 8: {
                return Date.class;
            }
            default: {
                return String.class;
            }
            case 3: 
        }
        return Taxon.class;
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
        try {
            Taxon taxon = this.taxa.get(row);
            switch (col) {
                case 4: {
                    taxon.setAlphaCode(o.toString());
                    taxon.getDatabase().commit();
                    taxon.notifyObservers();
                }
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    @Override
    public int getRowCount() {
        if (this.taxa == null) {
            return 0;
        }
        return this.taxa.size();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    final String getPrefString() {
        return "TMTAXON";
    }

    @Override
    String getPrefOrderString() {
        return "TOTAXON";
    }

    @Override
    final String getAutoResizeString() {
        return "TARTAXON";
    }

    void setupTable(JTable jTableTaxa, TableSorter sorter, boolean tips, SBdb sbdb) {
        this.init(jTableTaxa, sbdb);
        sorter.addMouseListenerToHeaderInTable(jTableTaxa);
        if (tips) {
            jTableTaxa.getTableHeader().addMouseMotionListener((MouseMotionListener)sorter.createColumnHeaderToolTips(columnTooltips, jTableTaxa));
        }
        jTableTaxa.setDefaultRenderer(Taxon.class, new TaxonNameRenderer());
    }
}

