/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableModel;
import jsbugs.DialogTaxonTransferConfirm;
import jsbugs.InternalFrameCmpStd;
import jsbugs.InternalFrameGroup;
import jsbugs.InternalFrameRangeChart;
import jsbugs.InternalFrameTaxa;
import jsbugs.JPanelPicklist;
import jsbugs.OverlayJPanel;
import jsbugs.SBEventsTableModel;
import jsbugs.TableModelCmpStd;
import jsbugs.TableModelOccurence;
import jsbugs.TaxonListMember;
import jsbugs.TaxonTableModel;
import jsbugs.TaxonTransfer;
import model2.CompositeStandardEvent;
import model2.Overlay;
import model2.Taxon;
import model2.TaxonOcc;
import model2.TxGroup;
import util.SB;
import util.TableSorter;

public class TaxonTransferHandler
extends TransferHandler {
    private int[] indices = null;
    static String taxonMimeType = "application/x-java-jvm-local-objectref;class=java.util.List";
    static String componentMimeType = "application/x-java-jvm-local-objectref;class=javax.swing.JComponent";
    private boolean overlayDrop = false;
    private Point lastDropPoint = null;
    TxGroup sourceGroup = null;

    public TaxonTransferHandler(TxGroup group) {
        this.sourceGroup = group;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        try {
            if (!info.isDataFlavorSupported(new DataFlavor(taxonMimeType))) {
                return false;
            }
            Component target = info.getComponent();
            JComponent comp = (JComponent)info.getTransferable().getTransferData(new DataFlavor(componentMimeType));
            if (comp instanceof JTable && ((JTable)comp).getModel() instanceof TableSorter && ((TableSorter)((JTable)comp).getModel()).getModel() instanceof SBEventsTableModel && !(target instanceof InternalFrameCmpStd)) {
                return false;
            }
            if (target instanceof InternalFrameGroup) {
                InternalFrameGroup groupFrame;
                try {
                    groupFrame = (InternalFrameGroup)target;
                }
                catch (Exception e) {
                    return false;
                }
                return !groupFrame.hasList(comp);
            }
            if (target instanceof OverlayJPanel) {
                OverlayJPanel ojp = (OverlayJPanel)target;
                if (ojp.isCountMode()) {
                    return false;
                }
                boolean overlayMove = false;
                if (ojp == comp) {
                    info.setDropAction(2);
                    overlayMove = true;
                } else {
                    info.setDropAction(1);
                }
                Transferable t = info.getTransferable();
                List list = (List)t.getTransferData(new DataFlavor(taxonMimeType));
                if (overlayMove) {
                    boolean canDrop = ojp.setCellMoveDropRange(this.lastDropPoint, info.getDropLocation().getDropPoint());
                    this.lastDropPoint = info.getDropLocation().getDropPoint();
                    return canDrop;
                }
                ojp.setCellDropRange(this.lastDropPoint, info.getDropLocation().getDropPoint(), list.size());
                this.lastDropPoint = info.getDropLocation().getDropPoint();
                return true;
            }
            if (target instanceof InternalFrameTaxa || target instanceof InternalFrameCmpStd || target instanceof JPanelPicklist) {
                info.setDropAction(1);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Exception in canImport: " + e.toString(), "Transfer Handler", 0);
            System.out.println("Exception in canImport: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        List list;
        if (!info.isDrop()) {
            return false;
        }
        if (!this.canImport(info)) {
            info.getComponent().getToolkit().beep();
            return false;
        }
        Component target = info.getComponent();
        Transferable t = info.getTransferable();
        try {
            list = (List)t.getTransferData(new DataFlavor(taxonMimeType));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (target instanceof InternalFrameGroup) {
            InternalFrameGroup groupFrame = (InternalFrameGroup)target;
            int sizeBefore = list.size();
            try {
                list.removeAll(groupFrame.getDatabase().getTxGroupTaxa(groupFrame.getGroup()));
            }
            catch (SQLException e) {
                SB.showStackError((String)"SQL error removing from group", (SQLException)e);
            }
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(groupFrame, "All selected taxa are already in group", "Taxon Copy", 1);
                return false;
            }
            String msg = "Do you want to " + (info.getDropAction() == 1 ? "COPY" : "MOVE") + (list.size() == 1 ? " this taxon " : " these " + list.size() + " taxa ") + "into this group?";
            if (list.size() < sizeBefore) {
                msg = msg + "\n(only " + (list.size() > 1 ? list.size() + " new taxa " : " one new taxon ") + "out of selected " + sizeBefore + " to be added, remainder removed from source group only)";
            }
            if (info.getDropAction() == 1 && DialogTaxonTransferConfirm.confirmCopy || info.getDropAction() == 2 && DialogTaxonTransferConfirm.confirmMove) {
                DialogTaxonTransferConfirm confDialog = new DialogTaxonTransferConfirm(groupFrame.frameTaxa, true, msg, info.getDropAction() == 1);
                confDialog.setLocationRelativeTo(groupFrame);
                confDialog.setVisible(true);
                if (!confDialog.yes) {
                    return false;
                }
            }
            return groupFrame.importData(list);
        }
        if (target instanceof OverlayJPanel) {
            OverlayJPanel overlayPanel = (OverlayJPanel)target;
            Overlay overlay = overlayPanel.getOverlay();
            this.overlayDrop = true;
            if (overlay != null) {
                try {
                    JComponent comp = (JComponent)info.getTransferable().getTransferData(new DataFlavor(componentMimeType));
                    if (comp == overlayPanel) {
                        overlayPanel.moveSelectedTaxa(info.getDropLocation().getDropPoint());
                        overlay.clearSelection();
                        overlayPanel.selectedCell = -1;
                    } else {
                        overlayPanel.fillSpecies(info.getDropLocation().getDropPoint(), list);
                    }
                    overlay.notifyObservers();
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return false;
        }
        if (target instanceof InternalFrameTaxa) {
            InternalFrameTaxa taxaFrame = (InternalFrameTaxa)target;
            for (Object obj : list) {
                Taxon tx = (Taxon)obj;
                if (taxaFrame.modelTaxa.taxa.contains(tx)) continue;
                taxaFrame.modelTaxa.taxa.add(tx);
            }
            taxaFrame.sorterTaxa.reallocateIndexes();
            taxaFrame.sorterTaxa.sort((Object)this);
            taxaFrame.sorterTaxa.fireTableDataChanged();
            return true;
        }
        if (target instanceof InternalFrameCmpStd) {
            InternalFrameCmpStd cmpStdFrame = (InternalFrameCmpStd)target;
            return cmpStdFrame.importList(list);
        }
        if (target instanceof JPanelPicklist) {
            for (Object obj : list) {
                JPanelPicklist picklistPanel = (JPanelPicklist)target;
                picklistPanel.setTaxa(list);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        if (this.overlayDrop) {
            return;
        }
        if (c.getClass() == JList.class && action == 2) {
            try {
                JList source = (JList)c;
                DefaultListModel listModel = (DefaultListModel)source.getModel();
                for (int i = this.indices.length - 1; i >= 0; --i) {
                    listModel.remove(this.indices[i]);
                }
                ListDataListener[] ldl = listModel.getListDataListeners();
                if (ldl.length > 0) {
                    ldl[0].contentsChanged(null);
                }
                this.indices = null;
                if (this.sourceGroup != null) {
                    LinkedList groupTaxa = new LinkedList(this.sourceGroup.getDatabase().getTxGroupTaxa(this.sourceGroup));
                    LinkedList<Taxon> listTaxa = new LinkedList<Taxon>();
                    Enumeration en = listModel.elements();
                    while (en.hasMoreElements()) {
                        TaxonListMember member = (TaxonListMember)en.nextElement();
                        listTaxa.add(member.taxon);
                    }
                    groupTaxa.removeAll(listTaxa);
                    this.sourceGroup.deleteTaxa(groupTaxa);
                    this.sourceGroup.getDatabase().commit();
                }
            }
            catch (SQLException ex) {
                JOptionPane.showMessageDialog(null, "SQL Exception in deleting cleanup: " + ex.toString(), "Transfer Handler", 0);
                System.out.println("SQL Exception in deleting cleanup: " + ex.getMessage());
                ex.printStackTrace();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception getting source for cleanup: " + e.toString(), "Transfer Handler", 0);
                System.out.println("Exception getting source for cleanup: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        InternalFrameRangeChart cjpr;
        ArrayList<Object> alist = new ArrayList<Object>();
        System.out.println("In createTransferable, class is: " + c.getName() + ", " + c.getClass());
        if (c.getClass() == JList.class) {
            Object[] values;
            JList list = (JList)c;
            this.indices = list.getSelectedIndices();
            for (Object obj : values = list.getSelectedValues()) {
                if (obj instanceof Taxon) {
                    alist.add((Taxon)obj);
                    continue;
                }
                if (!(obj instanceof TaxonListMember)) continue;
                alist.add(((TaxonListMember)obj).taxon);
            }
        } else if (c instanceof JTable) {
            JTable list = (JTable)c;
            this.indices = list.getSelectedRows();
            TableSorter sorter = (TableSorter)list.getModel();
            TableModel model = sorter.getModel();
            if (model instanceof TaxonTableModel) {
                TaxonTableModel taxaModel = (TaxonTableModel)sorter.getModel();
                for (int i : this.indices) {
                    alist.add(taxaModel.taxa.get(sorter.getIndexOf(i)));
                }
            } else if (model instanceof TableModelCmpStd) {
                TableModelCmpStd stdModel = (TableModelCmpStd)sorter.getModel();
                HashSet<Taxon> txSet = new HashSet<Taxon>();
                for (int i : this.indices) {
                    CompositeStandardEvent.Builder b = stdModel.cmpStd.get(sorter.getIndexOf(i));
                    if (b.getEvent().getTaxon() == null) continue;
                    txSet.add(b.getEvent().getTaxon());
                }
                alist.addAll(txSet);
            } else if (model instanceof SBEventsTableModel) {
                SBEventsTableModel evModel = (SBEventsTableModel)model;
                for (int i : this.indices) {
                    alist.add(evModel.getEvents().get(sorter.getIndexOf(i)));
                }
            } else if (model instanceof TableModelOccurence) {
                TableModelOccurence occModel = (TableModelOccurence)model;
                for (int i : this.indices) {
                    TaxonOcc occ = (TaxonOcc)occModel.smpdtl.getOccur().get(sorter.getIndexOf(i));
                    if (occ != null) {
                        alist.add(occ.getTaxon());
                        continue;
                    }
                    System.out.println("Occurrence null in TaxonTransferHandler for index: " + i + ", sorter index: " + sorter.getIndexOf(i));
                }
            }
        } else if (c instanceof OverlayJPanel) {
            OverlayJPanel overlayPanel = (OverlayJPanel)c;
            if (!overlayPanel.countMode) {
                try {
                    Overlay overlay = overlayPanel.getOverlay();
                    for (int row = 0; row < overlay.getRows(); ++row) {
                        for (int col = 0; col < overlay.getCols(); ++col) {
                            if (!overlay.getSelection(row, col)) continue;
                            alist.add(overlay.getTaxon(row, col));
                        }
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Exception from TaxonTransferHandler.createTransferable" + ex.toString(), "Transfer Handler", 0);
                    System.out.println("Exception from TaxonTransferHandler.createTransferable");
                    ex.printStackTrace();
                }
            }
        } else if (c instanceof InternalFrameRangeChart && (cjpr = (InternalFrameRangeChart)c).getTxDragOrigin() != null) {
            alist.add(cjpr.getTxDragOrigin());
        }
        return new TaxonTransfer(alist, c);
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
    }

    @Override
    public int getSourceActions(JComponent c) {
        if (c.getClass() == JTable.class) {
            return 1;
        }
        return 3;
    }
}

