/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import util.SB;

class TickScheme {
    float start;
    float labelInterval;
    float tickInterval;
    int precision;

    TickScheme() {
    }

    void calcScaleLabels(float top, float scale, char units) {
        int NINTERVALS = 4;
        float[] interval = new float[]{1.0f, 2.0f, 2.5f, 5.0f};
        float[] tick = new float[]{0.2f, 0.5f, 0.5f, 1.0f};
        if (units == 'F') {
            scale = (float)((double)scale / 0.3048);
            top = (float)SB.convFromM((double)top, (char)units);
        }
        float mult = (float)Math.pow(10.0, (int)SB.log10((double)scale) - 2);
        int i = 0;
        while (i < 4) {
            int n = i;
            interval[n] = interval[n] * mult;
            int n2 = i++;
            tick[n2] = tick[n2] * mult;
        }
        float preferred = 20.0f;
        float closest = 99999.0f;
        int index = 0;
        for (i = 0; i < 4; ++i) {
            float val = Math.abs(preferred - interval[i] * 1000.0f / scale);
            if (!(val < closest)) continue;
            index = i;
            closest = val;
        }
        this.labelInterval = interval[index];
        this.tickInterval = tick[index];
        this.start = (float)((int)(((double)top - 0.01) / (double)this.labelInterval) + 1) * this.labelInterval;
        this.precision = 0;
        if ((double)this.labelInterval < 1.0) {
            this.precision = (int)Math.abs(SB.log10((double)this.labelInterval) - 1.0);
        }
        if ((double)(this.labelInterval / mult) == 2.5 && (double)this.labelInterval < 10.0) {
            ++this.precision;
        }
        if (units == 'F') {
            this.start = SB.convToM((float)this.start, (char)units);
            this.labelInterval = SB.convToM((float)this.labelInterval, (char)units);
            this.tickInterval = SB.convToM((float)this.tickInterval, (char)units);
        }
    }

    void calcScaleLabels(float top, float scale) {
        int NINTERVALS = 4;
        float[] interval = new float[]{1.0f, 2.0f, 2.5f, 5.0f};
        float[] tick = new float[]{0.2f, 0.5f, 0.5f, 1.0f};
        float mult = (float)Math.pow(10.0, (int)SB.log10((double)scale));
        int i = 0;
        while (i < 4) {
            int n = i;
            interval[n] = interval[n] / mult;
            int n2 = i++;
            tick[n2] = tick[n2] / mult;
        }
        float preferred = 20.0f;
        float closest = 9999.0f;
        int index = 0;
        for (i = 0; i < 4; ++i) {
            float val = Math.abs(preferred - interval[i] * scale);
            if (!(val < closest)) continue;
            index = i;
            closest = val;
        }
        this.labelInterval = interval[index];
        this.tickInterval = tick[index];
        this.start = (float)((int)(((double)top - 0.01) / (double)this.labelInterval) + 1) * this.labelInterval;
        this.precision = 0;
        if ((double)this.labelInterval < 1.0) {
            this.precision = (int)Math.abs(SB.log10((double)this.labelInterval) - 1.0);
        }
        if ((double)(this.labelInterval / mult) == 2.5 && (double)this.labelInterval < 10.0) {
            ++this.precision;
        }
    }
}

