/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import model2.IGDScheme;
import util.SB;

class UnlinkedTableModel
extends AbstractTableModel {
    IGDScheme scheme = null;
    List<IGDScheme.UnlinkedInterval> data;
    static String[] colTitles = new String[]{"Informal name", "Occs.", "Exists in Scheme?"};
    static int[] colWidths = new int[]{90, 30, 40};
    static final int COL_NAME = 0;
    static final int COL_OCCS = 1;
    static final int COL_EXISTS = 2;

    UnlinkedTableModel() {
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        IGDScheme.UnlinkedInterval item = this.data.get(row);
        switch (col) {
            case 0: {
                return item.name;
            }
            case 1: {
                return new Integer(item.occs);
            }
            case 2: {
                return item.linked ? "Yes" : "";
            }
        }
        return "";
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 2: {
                return String.class;
            }
            case 1: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    void setUpTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        table.getTableHeader().setReorderingAllowed(false);
    }
}

