/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartBlock;
import jsbugs.ChartPanel;
import jsbugs.ChartProperties;
import jsbugs.PanelBiocoms;
import jsbugs.PanelBiozones;
import jsbugs.PanelCasing;
import jsbugs.PanelCoreImages;
import jsbugs.PanelCores;
import jsbugs.PanelDepth;
import jsbugs.PanelEnv;
import jsbugs.PanelEvents;
import jsbugs.PanelIntLith;
import jsbugs.PanelIntcoms;
import jsbugs.PanelMarkers;
import jsbugs.PanelSQPicks;
import jsbugs.PanelSampleLithology;
import jsbugs.PanelSamples;
import jsbugs.PanelTaxon;
import jsbugs.PanelTaxonGroup;
import jsbugs.PanelWellDepthAge;
import jsbugs.PanelWellHeader;
import jsbugs.PanelWellName;
import jsbugs.PanelWellVS;
import jsbugs.PanelWirelineLog;
import jsbugs.PanelZones;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.SBPanelHTML;
import jsbugs.SBPanelHdr;
import jsbugs.SubBlockProperties;
import model2.Discipline;
import model2.IGDInterval;
import model2.IGDIntervalZone;
import model2.InterpHdr;
import model2.LOC;
import model2.Project;
import model2.SBdb;
import model2.Sample;
import model2.TVDList;
import model2.TVDepth;
import model2.Well;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class WellBlock
extends ChartBlock {
    protected LinkedList packets = new LinkedList();
    Well well;
    SBdb db;
    LinkedList<SBPanel> removedPanels = new LinkedList();
    private LinkedList<SubBlockProperties> subBlockProperties = null;
    static final float SUBBLOCK_GAP = 5.0f;

    public WellBlock(Well well, SBdb db) {
        this.well = well;
        this.db = db;
        this.prop = new BlockProperties(BlockProperties.ScaleType.MD);
        if (well != null) {
            this.prop.units = well.getWellUnits();
        }
    }

    public WellBlock(Well well, SBdb db, BlockProperties bp) {
        this.well = well;
        this.db = db;
        if (bp == null) {
            throw new IllegalArgumentException("Properties null in WellBlock constructor");
        }
        this.prop = bp;
        if (well != null) {
            this.prop.units = well.getWellUnits();
        }
    }

    void addPanels(List<Chart.ChartPref> keys, InterpHdr interp) throws SQLException, SBException {
        String lastPTG = null;
        block18: for (int i = 0; i < keys.size(); ++i) {
            Chart.ChartPref key = keys.get(i);
            String panelKey = key.key.substring(1);
            if (panelKey.length() != 2) continue;
            switch (key.panelType) {
                case 29: {
                    this.addPanel(new PanelDepth(this.db, this, key.value));
                    continue block18;
                }
                case 10: 
                case 12: {
                    this.addPanel(new PanelZones(this.db, this, IGDInterval.dType2IGDtype((int)key.panelType), key.identifier, key.value));
                    continue block18;
                }
                case 11: {
                    if (this.db.getIGDScheme(key.identifier2) == null) continue block18;
                    this.addPanel(new PanelBiozones(this.db, this, IGDInterval.dType2IGDtype((int)key.panelType), key.identifier, key.value, key.identifier2));
                    continue block18;
                }
                case 16: {
                    this.addPanel(new PanelEvents(this, key.identifier, this.db, key.value));
                    continue block18;
                }
                case 3: {
                    this.addPanel(new PanelBiocoms(this, key.identifier, this.db, key.value));
                    continue block18;
                }
                case 1: {
                    this.addPanel(new PanelSamples(this.db, this, key.value));
                    continue block18;
                }
                case 15: {
                    this.addPanel(new PanelEnv(this, key.identifier, key.value));
                    continue block18;
                }
                case 22: {
                    this.addPanel(new PanelSampleLithology(this.db, this, key.value));
                    continue block18;
                }
                case 2: 
                case 17: 
                case 23: {
                    LinkedList<Chart.ChartPref> ancillaryPanels = new LinkedList<Chart.ChartPref>();
                    for (int j = 0; j < keys.size(); ++j) {
                        Chart.ChartPref comp = keys.get(j);
                        String compKey = comp.key.substring(1);
                        if (compKey.length() != 3 || !compKey.startsWith(panelKey)) continue;
                        ancillaryPanels.add(comp);
                    }
                    switch (key.panelType) {
                        case 23: {
                            this.addPanel(new PanelWirelineLog(this, this.db, key.value, ancillaryPanels));
                            break;
                        }
                        case 17: {
                            PanelWellDepthAge panel = new PanelWellDepthAge(this.db, this, key.value, ancillaryPanels, interp, this.getProject());
                            if (panel.getProperties().drawLOCAlternatives) {
                                Iterator interpIterator = this.well.getInterpIterator();
                                while (interpIterator.hasNext()) {
                                    WellInterp wi = (WellInterp)interpIterator.next();
                                    this.well.loadInterp(wi);
                                }
                            }
                            this.addPanel(panel);
                            break;
                        }
                        case 2: {
                            if (lastPTG != null && key.value.equals(lastPTG)) {
                                PanelTaxonGroup ptg = (PanelTaxonGroup)this.panels.getLast();
                                ptg.addPanel(ancillaryPanels);
                                break;
                            }
                            this.addPanel(new PanelTaxonGroup(this.db, this, key.value, ancillaryPanels));
                            lastPTG = key.value;
                        }
                    }
                    continue block18;
                }
                case 44: {
                    if (this.prop.scaleType != BlockProperties.ScaleType.TVD) continue block18;
                    this.addPanel(new PanelWellVS(this.db, this, interp.getInterpID(), key.value));
                    continue block18;
                }
                case 46: {
                    this.headers.add(new PanelWellHeader(this, key.value));
                }
            }
        }
    }

    void removeAllPanels() {
        this.panels.clear();
    }

    Project getProject() {
        return null;
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties p, Chart.Mode mode) {
        if (this.well == null || this.panels.isEmpty()) {
            return x;
        }
        switch (mode) {
            case NORMAL: 
            case HEADER_ONLY: {
                Iterator it = this.headers.iterator();
                while (it.hasNext()) {
                    y = ((SBPanelHdr)it.next()).draw(g, x, y, this.getWidth(), p, this.prop);
                }
                break;
            }
        }
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            this.setSubBlocks();
        }
        LinkedList<GeneralPath> disconformities = null;
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            disconformities = this.setDisconformityClip(g, x, y, p, mode);
        }
        float xpos = x;
        Iterator it = this.panels.iterator();
        if (this.subBlockProperties != null && !this.subBlockProperties.isEmpty()) {
            int drawn = 0;
            while (it.hasNext()) {
                SBPanel panel = (SBPanel)it.next();
                if (panel.pipe()) continue;
                float newxpos = panel.draw(g, xpos, y, p, this.prop, mode);
                panel.drawFrame(g, xpos, y, p, this.prop, panel.getCaption(), panel.getSubCaption());
                panel.drawSubHeader(g, xpos, y, p, this.prop, panel.getSubHeader());
                xpos = newxpos;
                ++drawn;
            }
            if (drawn == this.panels.size()) {
                return xpos;
            }
            int i = 0;
            Float lastBase = null;
            for (SubBlockProperties bp : this.subBlockProperties) {
                float ypos = y;
                if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
                    float minDepthAge = (float)this.interp.getLOC().getAge(bp.min, bp.normal);
                    float maxDepthAge = (float)this.interp.getLOC().getAge(bp.max, !bp.normal);
                    bp.height = Math.abs(maxDepthAge - minDepthAge) * this.prop.scale;
                    if (i > 0 || minDepthAge > this.prop.min) {
                        ypos += this.scaleAge(Math.min(minDepthAge, maxDepthAge));
                    }
                } else {
                    float minScaleDepth = this.scaleDepth(bp.min);
                    float maxScaleDepth = this.scaleDepth(bp.max);
                    bp.height = Math.abs(maxScaleDepth - minScaleDepth);
                    if (i > 0) {
                        ypos += Math.min(minScaleDepth, maxScaleDepth);
                    }
                }
                for (SBPanel panel : this.panels) {
                    if (!panel.pipe()) continue;
                    float newxpos = panel.draw(g, xpos, y, p, bp, mode);
                    if (i == 0 && mode != Chart.Mode.NO_HEADER) {
                        panel.drawFrame(g, xpos, ypos, p, bp, panel.getCaption(), panel.getSubCaption());
                        panel.drawSubHeader(g, xpos, ypos, p, this.prop, panel.getSubHeader());
                    } else {
                        panel.drawOutline(g, xpos, ypos, p, bp, mode);
                    }
                    xpos = newxpos;
                }
                if (i > 0) {
                    this.drawPipeArrows(bp, this.subBlockProperties.get(i - 1), p, mode, g, xpos, ypos, lastBase.floatValue());
                }
                xpos += 5.0f;
                lastBase = Float.valueOf(ypos + bp.height);
                ++i;
            }
        } else {
            xpos = this.drawPanels(g, xpos, y, p, mode);
        }
        if (disconformities != null) {
            g.clearClip();
            g.setColor(Color.BLACK);
            g.setStroke(0.8f);
            for (GeneralPath path : disconformities) {
                g.drawShape(path);
            }
        }
        return xpos;
    }

    private void drawPipeArrows(SubBlockProperties bp, SubBlockProperties lastProp, ChartProperties p, Chart.Mode mode, SBGraphics g, float xpos, float ypos, float lastBase) {
        float[] arrowY;
        if (this.getSubBlockWidth(false) <= 0.0f) {
            return;
        }
        if ((double)Math.abs(bp.min - lastProp.max) > 0.1) {
            return;
        }
        g.setStroke(0.2f);
        g.setColor(Color.BLACK);
        float x1 = xpos - this.getSubBlockWidth(false) * 1.5f - 5.0f;
        float x2 = xpos - this.getSubBlockWidth(false) / 2.0f;
        float[] arrowX = new float[]{x2, x2 + 2.5f, x2 - 2.5f};
        if (bp.normal ^ lastProp.normal) {
            float y2;
            float y1;
            boolean up = lastProp.normal;
            if (up) {
                y1 = ypos + bp.height + SBPanel.getPanelHeaderHeight(p, mode);
                y2 = y1 + 10.0f;
                arrowY = new float[]{y1, y1 + 3.0f, y1 + 3.0f};
            } else {
                y1 = ypos + SBPanel.getPanelHeaderHeight(p, mode);
                y2 = y1 - 10.0f;
                arrowY = new float[]{y1, y1 - 3.0f, y1 - 3.0f};
            }
            g.drawLine(x1, y1, x1, y2);
            g.drawLine(x1, y2, x2, y2);
            g.drawLine(x2, y2, x2, y1);
        } else {
            float y1 = lastBase + p.getPanelHeaderHeight();
            float y2 = y1 + 10.0f;
            g.drawLine(x1, y1, x1, y2);
            g.drawLine(x1, y2, x1 + (x2 - x1) / 2.0f, y2);
            float y3 = ypos + SBPanel.getPanelHeaderHeight(p, mode) - 10.0f;
            float y4 = y3 + 10.0f;
            g.drawLine(x1 + (x2 - x1) / 2.0f, y2, x1 + (x2 - x1) / 2.0f, y3);
            g.drawLine(x1 + (x2 - x1) / 2.0f, y3, x2, y3);
            g.drawLine(x2, y3, x2, y4);
            arrowY = new float[]{y4, y4 - 3.0f, y4 - 3.0f};
        }
        g.fillPolygon(arrowX, arrowY, 3);
    }

    private TVDList getTVDList() {
        TVDList list;
        try {
            list = this.well.getTVDlist(false);
        }
        catch (SQLException sql) {
            sql.printStackTrace();
            return null;
        }
        if (list.getList().isEmpty()) {
            return null;
        }
        return list;
    }

    private void setSubBlocks() {
        double[][] reversals;
        this.subBlockProperties = null;
        switch (this.prop.scaleType) {
            default: {
                return;
            }
            case AGE: {
                if (this.interp == null || this.interp.getLOC() == null) {
                    return;
                }
                reversals = this.interp.getLOC().getReversals();
                break;
            }
            case TVD: {
                if (this.getTVDList() == null) {
                    return;
                }
                reversals = this.getTVDList().getReversals();
            }
        }
        if (reversals != null) {
            this.subBlockProperties = new LinkedList();
            float top = this.getTopDepth();
            float base = this.getBaseDepth();
            for (double[] rev : reversals) {
                if (Math.abs((double)top - rev[0]) > 0.01) {
                    this.subBlockProperties.add(new SubBlockProperties(top, (float)rev[0], true));
                }
                if (Math.abs(rev[0] - rev[1]) > 0.01) {
                    this.subBlockProperties.add(new SubBlockProperties((float)rev[0], (float)rev[1], false));
                }
                top = (float)rev[1];
            }
            if ((double)Math.abs(top - base) > 0.001) {
                this.subBlockProperties.add(new SubBlockProperties(top, base, true));
            }
            LinkedList<SubBlockProperties> newProp = new LinkedList<SubBlockProperties>();
            for (SubBlockProperties sbp : this.subBlockProperties) {
                float convMax = this.convDepth(sbp.max);
                if (convMax < this.prop.min) continue;
                float convMin = this.convDepth(sbp.min);
                if (convMin > this.prop.max) break;
                if (convMin < this.prop.min) {
                    sbp.min = this.getTopDepth(false);
                }
                if (convMax > this.prop.max) {
                    sbp.max = this.getBaseDepth(true);
                }
                newProp.add(sbp);
            }
            this.subBlockProperties = newProp;
        } else {
            this.subBlockProperties = null;
        }
    }

    private LinkedList<GeneralPath> setDisconformityClip(SBGraphics g, float x, float y, ChartProperties p, Chart.Mode mode) {
        LinkedList<GeneralPath> disconformities = null;
        LOC.Disconformity[] discnfs = this.interp.getLOC().getDisconformities();
        if (discnfs != null) {
            disconformities = new LinkedList<GeneralPath>();
            try {
                float x1 = x - 1.0f;
                GeneralPath path = null;
                for (LOC.Disconformity u : discnfs) {
                    float y2;
                    float y1;
                    float x2;
                    int i;
                    double[] d = u.getAges();
                    if (d[1] < (double)this.prop.min || d[0] > (double)this.prop.max) continue;
                    float uDepth = (float)u.getDepth();
                    boolean foundSubBlock = true;
                    if (this.subBlockProperties != null && !this.subBlockProperties.isEmpty()) {
                        foundSubBlock = false;
                        for (i = 0; i < this.subBlockProperties.size(); ++i) {
                            SubBlockProperties sbp = this.subBlockProperties.get(i);
                            if (sbp.normal != u.getNormal() || !(uDepth >= sbp.min) || !(uDepth <= sbp.max)) continue;
                            x1 = x + (float)i * this.getSubBlockWidth(true) + (float)i * 5.0f - 1.0f;
                            foundSubBlock = true;
                            break;
                        }
                    }
                    if (!foundSubBlock) {
                        for (i = 0; i < this.subBlockProperties.size(); ++i) {
                            if (!((double)Math.abs(uDepth - this.subBlockProperties.get((int)i).max) < 0.1)) continue;
                            x1 += (float)i * this.getSubBlockWidth(true) + (float)i * 5.0f - 1.0f;
                            break;
                        }
                        x2 = x1 + this.getSubBlockWidth(true) + 2.0f;
                        float x3 = x2 + 5.0f - 2.0f;
                        float x4 = x3 + this.getSubBlockWidth(true) + 2.0f;
                        if (u.getNormal()) {
                            y1 = (float)(d[0] - (double)this.prop.min) * this.prop.scale + y + SBPanel.getPanelHeaderHeight(p, mode);
                            y2 = (float)(d[1] - (double)this.prop.min) * this.prop.scale + y + SBPanel.getPanelHeaderHeight(p, mode);
                        } else {
                            y2 = (float)(d[0] - (double)this.prop.min) * this.prop.scale + y + SBPanel.getPanelHeaderHeight(p, mode);
                            y1 = (float)(d[1] - (double)this.prop.min) * this.prop.scale + y + SBPanel.getPanelHeaderHeight(p, mode);
                        }
                        GeneralPath gp = SBGraphics.createGeneralPath(x1, y1);
                        if (IGDIntervalZone.isUnconformableBnd((int)u.getBnd())) {
                            g.appendUnconf(gp, x1, x2, y1, false, true, true, false);
                        } else {
                            SBGraphics.appendLine(gp, x2, y1);
                        }
                        disconformities.add(gp);
                        gp = SBGraphics.createGeneralPath(x4, y2);
                        if (IGDIntervalZone.isUnconformableBnd((int)u.getBnd())) {
                            g.appendUnconf(gp, x4, x3, y2, false, true, true, false);
                        } else {
                            SBGraphics.appendLine(gp, x3, y2);
                        }
                        disconformities.add(gp);
                        continue;
                    }
                    x2 = x1 + this.getSubBlockWidth(true) + 2.0f;
                    y1 = (float)(d[0] - (double)this.prop.min) * this.prop.scale + y + SBPanel.getPanelHeaderHeight(p, mode);
                    y2 = (float)(d[1] - (double)this.prop.min) * this.prop.scale + y + SBPanel.getPanelHeaderHeight(p, mode);
                    if (path == null) {
                        path = SBGraphics.createGeneralPath(x1, y1);
                    } else {
                        SBGraphics.appendMove(path, x1, y1);
                    }
                    GeneralPath gp = SBGraphics.createGeneralPath(x1, y1);
                    if (IGDIntervalZone.isUnconformableBnd((int)u.getBnd())) {
                        SBGraphics.appendLine(path, x2, y1);
                        g.appendUnconf(gp, x1, x2, y1, false, true, true, false);
                    } else {
                        SBGraphics.appendLine(path, x2, y1);
                        SBGraphics.appendLine(gp, x2, y1);
                    }
                    disconformities.add(gp);
                    SBGraphics.appendLine(path, x2, y2);
                    gp = SBGraphics.createGeneralPath(x2, y2);
                    if (IGDIntervalZone.isUnconformableBnd((int)u.getBnd())) {
                        SBGraphics.appendLine(path, x1, y2);
                        g.appendUnconf(gp, x2, x1, y2, false, true, true, false);
                    } else {
                        SBGraphics.appendLine(path, x1, y2);
                        SBGraphics.appendLine(gp, x1, y2);
                    }
                    disconformities.add(gp);
                    SBGraphics.appendLine(path, x1, y1);
                }
                if (path != null) {
                    Area unconfArea = new Area(path);
                    Area outside = g.visibleRect != null ? new Area(g.visibleRect) : new Area(g.createRect(x - 1.0f, y - 1.0f, this.getWidth() + 3.0f, this.getHeight() + SBPanel.getPanelHeaderHeight(p, mode) + 2.0f));
                    outside.subtract(unconfArea);
                    g.setClip(outside);
                }
            }
            catch (Exception e) {
                SB.showStackError((String)"Error setting unconformities", (Exception)e);
            }
        }
        return disconformities;
    }

    private double[][] getDataSections() {
        if (this.prop.scaleType == BlockProperties.ScaleType.MD) {
            this.subBlockProperties = null;
            return null;
        }
        this.setSubBlocks();
        LOC.Disconformity[] discnfs = null;
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            discnfs = this.interp.getLOC().getDisconformities();
        }
        if ((this.subBlockProperties == null || this.subBlockProperties.isEmpty()) && discnfs == null) {
            return null;
        }
        LinkedList<SubBlockProperties> sbp = this.subBlockProperties;
        if (sbp == null || sbp.isEmpty()) {
            sbp = new LinkedList();
            sbp.add(new SubBlockProperties(this.getTopDepth(), this.getBaseDepth(), true));
        }
        LinkedList<double[]> sections = new LinkedList<double[]>();
        for (int j = 0; j < sbp.size(); ++j) {
            SubBlockProperties p = sbp.get(j);
            if (j == 0) {
                if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
                    sections.add(new double[]{this.scaleAge((float)this.interp.getLOC().getAge(p.min, !p.normal)), p.min});
                } else {
                    sections.add(new double[]{this.scaleDepth(p.min), p.min});
                }
            } else if (this.prop.scaleType == BlockProperties.ScaleType.AGE && p.normal && sbp.get((int)(j - 1)).normal) {
                sections.add(new double[]{this.scaleAge((float)this.interp.getLOC().getAge(p.min, p.normal)), p.min});
            }
            if (discnfs != null) {
                for (int i = 0; i < discnfs.length; ++i) {
                    LOC.Disconformity u = discnfs[i];
                    if (u.getNormal() != p.normal) continue;
                    if (u.getDepth() > (double)p.max) break;
                    if (!(u.getDepth() >= (double)p.min) || !(u.getDepth() <= (double)p.max)) continue;
                    if (u.getNormal()) {
                        sections.add(new double[]{this.scaleAge((float)u.getAges()[0]), u.getDepth()});
                        sections.add(new double[]{this.scaleAge((float)u.getAges()[1]), u.getDepth()});
                        continue;
                    }
                    sections.add(new double[]{this.scaleAge((float)u.getAges()[1]), u.getDepth()});
                    sections.add(new double[]{this.scaleAge((float)u.getAges()[0]), u.getDepth()});
                }
            }
            if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
                sections.add(new double[]{this.scaleAge((float)this.interp.getLOC().getAge(p.max, !p.normal)), p.max});
                continue;
            }
            sections.add(new double[]{this.scaleDepth(p.max), p.max});
        }
        double[][] sectionArr = new double[sections.size()][];
        for (int i = 0; i < sections.size(); ++i) {
            sectionArr[i] = (double[])sections.get(i);
        }
        return sectionArr;
    }

    void setData(ChartProperties cp) throws SBException, SQLException, IOException {
        if (this.well == null) {
            return;
        }
        Iterator it = this.panels.iterator();
        double[][] sections = this.getDataSections();
        while (it.hasNext()) {
            SBPanel panel = (SBPanel)it.next();
            panel.setData(cp, sections);
        }
    }

    private float getSubBlockWidth(boolean includeNonPipers) {
        float width = 0.0f;
        for (SBPanel panel : this.panels) {
            if (!includeNonPipers && !panel.pipe()) continue;
            width += panel.getWidth(this.prop);
        }
        return width;
    }

    @Override
    float getWidth() {
        float width = this.getSubBlockWidth(true);
        if (this.subBlockProperties != null && this.getNPipers() > 0) {
            width = this.getSubBlockWidth(false) * (float)this.subBlockProperties.size() + 5.0f * (float)(this.subBlockProperties.size() - 1);
            for (SBPanel p : this.panels) {
                if (p.pipe()) continue;
                width += p.getWidth(this.prop);
            }
        }
        return width;
    }

    private int getNPipers() {
        int pipers = 0;
        for (SBPanel p : this.panels) {
            if (!p.pipe()) continue;
            ++pipers;
        }
        return pipers;
    }

    @Override
    boolean setData(SBPanel panel, ChartProperties cp) throws SBException, SQLException, IOException {
        for (SBPanel p : this.panels) {
            PanelTaxonGroup ptg;
            if (p == panel) {
                p.setData(cp, this.getDataSections());
                return true;
            }
            if (!(panel instanceof PanelTaxon) || !(p instanceof PanelTaxonGroup) || !(ptg = (PanelTaxonGroup)p).contains(panel)) continue;
            ptg.setData(cp, this.getDataSections(), (PanelTaxon)panel);
            return true;
        }
        return false;
    }

    @Override
    float getHeight() {
        return WellBlock.getHeight(this.prop);
    }

    float scaleDepth(float depth) {
        return this.scaleDepth(depth, true);
    }

    float scaleDepth(float depth, Well well) {
        return this.scaleDepth(depth, true, well);
    }

    float scaleDepth(float depth, boolean minPrefered) {
        return this.scaleDepth(depth, minPrefered, this.well);
    }

    float scaleDepth(float depth, boolean minPrefered, Well well) {
        switch (this.prop.scaleType) {
            case AGE: {
                if (this.interp == null || this.interp.getLOC() == null) break;
                float age = (float)this.interp.getLOC().getAge(depth, minPrefered);
                return this.scaleAge(age);
            }
            case TVD: 
            case SUBSIDENCE: {
                try {
                    if (well.getTVDlist(false) == null) break;
                    depth = well.getTVDlist(false).getTVD((double)depth).getTVDepth().floatValue();
                    if (this.prop.scaleType != BlockProperties.ScaleType.SUBSIDENCE) break;
                    float td = well.getTVDlist(false).getTVD(well.getTD()).getTVDepth().floatValue();
                    depth = td - depth;
                    break;
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
        }
        return (depth - this.prop.min) * 1000.0f / this.prop.scale;
    }

    private float scaleAge(float age) {
        return (age - this.prop.min) * this.prop.scale;
    }

    float scaleTVD(double depth) {
        return (float)(depth - (double)this.prop.min) * 1000.0f / this.prop.scale;
    }

    float getDepth(float yPos) {
        return yPos * this.prop.scale / 1000.0f + this.prop.min;
    }

    float getDepth(float yPos, BlockProperties sbp) {
        TVDepth depth;
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            if (!(sbp instanceof SubBlockProperties)) {
                sbp = null;
            }
            float age = yPos / this.prop.scale + this.prop.min;
            return (float)this.interp.getLOC().getDepth((double)age, sbp != null ? new Double(sbp.min) : null, sbp != null ? new Double(sbp.max) : null, true);
        }
        if (this.prop.scaleType == BlockProperties.ScaleType.TVD && sbp instanceof SubBlockProperties && this.getTVDList() != null && (depth = this.getTVDList().getDepth((double)(yPos * this.prop.scale / 1000.0f + this.prop.min), true, new Double(sbp.min), new Double(sbp.max))) != null) {
            return (float)depth.getDDepth();
        }
        return yPos * this.prop.scale / 1000.0f + this.prop.min;
    }

    float getBracket(float bracketBase, float zoom, float depth) {
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            float ma = bracketBase / this.prop.scale / zoom;
            return ma * Math.abs(this.interp.getLOC().getSedimentationRate((double)depth));
        }
        return bracketBase * this.prop.scale / 1000.0f / zoom;
    }

    private SubBlockProperties getSBP(float x) {
        SubBlockProperties sbp = null;
        if (this.subBlockProperties != null && this.subBlockProperties.size() > 1) {
            float xLeft = 0.0f;
            int n = 0;
            float w = this.getSubBlockWidth(true);
            while (true) {
                boolean bl = n == 0;
                if (!(x > xLeft + this.getSubBlockWidth(bl))) break;
                if (x < (xLeft += this.getSubBlockWidth(n == 0)) + 5.0f) {
                    return null;
                }
                xLeft += 5.0f;
                ++n;
            }
            sbp = this.subBlockProperties.get(n);
        }
        return sbp;
    }

    @Override
    ChartPanel getPanel(float x, float y) {
        if (y < this.getHeaderHeight()) {
            return this.getHeaderPanel(y);
        }
        float xLeft = 0.0f;
        if (this.subBlockProperties != null && this.subBlockProperties.size() > 1) {
            int n = 0;
            while (true) {
                boolean bl = n == 0;
                if (!(x > xLeft + this.getSubBlockWidth(bl))) break;
                if (x < (xLeft += this.getSubBlockWidth(n == 0)) + 5.0f) {
                    return null;
                }
                xLeft += 5.0f;
                ++n;
            }
        }
        float width = xLeft;
        for (SBPanel panel : this.panels) {
            if (!(x < (width += panel.getWidth(this.prop)))) continue;
            return panel;
        }
        return null;
    }

    @Override
    Point2D.Float getPanelOrigin(SBPanel panel, float x, float y, Chart.Mode mode, float xPos) {
        float xLeft = x;
        float yPos = y;
        switch (mode) {
            case NO_HEADER: {
                break;
            }
            default: {
                for (SBPanelHdr hdr : this.headers) {
                    yPos += hdr.getHeight();
                }
            }
        }
        if (this.subBlockProperties != null && this.subBlockProperties.size() > 1) {
            int n = 0;
            while (true) {
                boolean bl = n == 0;
                if (!(xPos > xLeft + this.getSubBlockWidth(bl))) break;
                if (xPos < (xLeft += this.getSubBlockWidth(n == 0)) + 5.0f) {
                    return null;
                }
                xLeft += 5.0f;
                ++n;
            }
        }
        for (SBPanel p : this.panels) {
            if (p == panel) {
                return new Point2D.Float(xLeft, yPos);
            }
            xLeft += p.getWidth(this.prop);
        }
        return null;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, float zoom) {
        Object obj = null;
        float xLeft = 0.0f;
        for (SBPanel panel : this.panels) {
            float xRight = xLeft + panel.getWidth(this.prop);
            if (x < xRight) {
                obj = panel.getObject(x - xLeft, y, cp, this.prop, zoom);
                break;
            }
            xLeft = xRight;
        }
        return obj;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, float zoom) {
        float xLeft = 0.0f;
        SubBlockProperties sbp = null;
        if (this.subBlockProperties != null && this.subBlockProperties.size() > 1) {
            int n = 0;
            while (true) {
                boolean bl = n == 0;
                if (!(x > xLeft + this.getSubBlockWidth(bl))) break;
                if (x < (xLeft += this.getSubBlockWidth(n == 0)) + 5.0f) {
                    return null;
                }
                xLeft += 5.0f;
                ++n;
            }
            sbp = this.subBlockProperties.get(n);
        }
        String obj = null;
        for (SBPanel panel : this.panels) {
            if (sbp != null && sbp != this.subBlockProperties.get(0) && !panel.pipe()) continue;
            float xRight = xLeft + panel.getWidth(this.prop);
            if (x < xRight) {
                obj = panel.getTooltip(x - xLeft, y, cp, sbp != null ? sbp : this.prop, zoom);
                break;
            }
            xLeft = xRight;
        }
        return obj;
    }

    boolean hasPanel(int igdType, int schID, int interpID, char discID) throws SBException {
        if (this.panels.size() != 0) {
            for (int i = 0; i < this.panels.size(); ++i) {
                SBPanel panel = (SBPanel)this.panels.get(i);
                if (panel instanceof PanelZones) {
                    PanelZones panelZones = (PanelZones)panel;
                    if (panelZones.igdType != igdType || panelZones.interpID != interpID) continue;
                    if (igdType == 4) {
                        for (SBPanel motherPanel : this.panels) {
                            if (!(motherPanel instanceof PanelBiozones) || ((PanelBiozones)motherPanel).schID != schID) continue;
                            return true;
                        }
                        return false;
                    }
                    return true;
                }
                if (panel instanceof PanelTaxonGroup) {
                    PanelTaxonGroup panelTaxon = (PanelTaxonGroup)panel;
                    if (panelTaxon.getDiscID() != Discipline.getDisc((char)discID)) continue;
                    return true;
                }
                if (panel instanceof PanelSQPicks) {
                    PanelSQPicks panelSQ = (PanelSQPicks)panel;
                    if (igdType != 21 || panelSQ.interpID != interpID || panelSQ.schID != schID) continue;
                    return true;
                }
                if (panel instanceof PanelEvents) {
                    PanelEvents panelEvents = (PanelEvents)panel;
                    if (igdType != 20 || panelEvents.interpID != interpID) continue;
                    return true;
                }
                if (panel instanceof PanelBiocoms) {
                    PanelBiocoms panelBiocoms = (PanelBiocoms)panel;
                    if (igdType != 19 || panelBiocoms.interpID != interpID) continue;
                    return true;
                }
                if (panel instanceof PanelEnv) {
                    PanelEnv panelEnv = (PanelEnv)panel;
                    if (igdType != 5 || panelEnv.interpID != interpID || panelEnv.getSchemeID() != schID) continue;
                    return true;
                }
                if (!(panel instanceof PanelIntcoms)) continue;
                PanelIntcoms panelIntcoms = (PanelIntcoms)panel;
                if (igdType != 22 || panelIntcoms.interpID != interpID) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasIntLithPanel() {
        if (this.panels.size() != 0) {
            for (int i = 0; i < this.panels.size(); ++i) {
                if (!(this.panels.get(i) instanceof PanelIntLith)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasDepthPanel() {
        if (this.panels.size() != 0) {
            for (int i = 0; i < this.panels.size(); ++i) {
                if (!(this.panels.get(i) instanceof PanelDepth)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasCasingPanel() {
        if (this.panels.size() != 0) {
            for (int i = 0; i < this.panels.size(); ++i) {
                if (!(this.panels.get(i) instanceof PanelCasing)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasCoresPanel() {
        if (this.panels.size() != 0) {
            for (int i = 0; i < this.panels.size(); ++i) {
                if (!(this.panels.get(i) instanceof PanelCores)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasCoreImagesPanel() {
        if (this.panels.size() != 0) {
            for (int i = 0; i < this.panels.size(); ++i) {
                if (!(this.panels.get(i) instanceof PanelCoreImages)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasMarkersPanel() {
        if (this.panels.size() != 0) {
            for (int i = 0; i < this.panels.size(); ++i) {
                if (!(this.panels.get(i) instanceof PanelMarkers)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasSampleLithologyPanel() {
        if (this.panels.size() != 0) {
            for (int i = 0; i < this.panels.size(); ++i) {
                if (!(this.panels.get(i) instanceof PanelSampleLithology)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasSamplesPanel() {
        if (this.panels.size() != 0) {
            for (int i = 0; i < this.panels.size(); ++i) {
                if (!(this.panels.get(i) instanceof PanelSamples)) continue;
                return true;
            }
        }
        return false;
    }

    boolean addIGDPanel(int IGDtype, int schID, WellInterp interp, boolean checkRemoved) throws SQLException, SBException {
        SBPanel panel;
        this.well.loadInterp(interp);
        char discID = '\u0000';
        if (IGDtype != 19 && this.hasPanel(IGDtype, schID, interp.getHeader().getInterpID(), discID)) {
            return false;
        }
        switch (IGDtype) {
            case 2: 
            case 3: {
                panel = new PanelZones(this.db, this, IGDtype, interp.getHeader().getInterpID());
                break;
            }
            case 4: {
                panel = new PanelBiozones(this.db, this, 4, interp.getHeader().getInterpID(), schID);
                break;
            }
            case 21: {
                panel = new PanelSQPicks(this.db, this, interp.getHeader().getInterpID(), schID);
                break;
            }
            case 20: {
                panel = new PanelEvents(this, interp.getHeader().getInterpID(), this.db);
                break;
            }
            case 5: {
                panel = new PanelEnv(this, interp.getHeader().getInterpID(), schID, this.db);
                break;
            }
            case 19: {
                panel = new PanelBiocoms(this, interp.getHeader().getInterpID(), this.db);
                break;
            }
            case 22: {
                panel = new PanelIntcoms(this, interp.getHeader().getInterpID(), this.db);
                break;
            }
            default: {
                panel = null;
            }
        }
        if (panel == null || checkRemoved && this.panelRemoved(panel)) {
            return false;
        }
        this.addPanel(panel);
        return true;
    }

    boolean addDiscPanel(char discID, boolean checkRemoved) throws SBException {
        PanelTaxonGroup panel = new PanelTaxonGroup(this.db, this, Discipline.getDisc((char)discID));
        if (checkRemoved) {
            if (this.panelRemoved(panel)) {
                return false;
            }
        } else {
            for (SBPanel removed : this.removedPanels) {
                PanelTaxonGroup t;
                if (!(removed instanceof PanelTaxonGroup) || (t = (PanelTaxonGroup)removed).getDiscID() != Discipline.getDisc((char)discID)) continue;
                this.removedPanels.remove(t);
                this.addPanel(t);
                return true;
            }
            panel.addDefaultPanel(false);
            this.addPanel(panel);
            this.setChanged();
            this.notifyObservers(panel);
        }
        return true;
    }

    boolean addLogPanel(boolean checkRemoved) {
        PanelWirelineLog panel = new PanelWirelineLog(this, this.db);
        if (checkRemoved && this.panelRemoved(panel)) {
            return false;
        }
        this.addPanel(panel);
        return true;
    }

    boolean addDepthPanel(boolean checkRemoved) {
        if (this.hasDepthPanel()) {
            return false;
        }
        PanelDepth panel = new PanelDepth(this.db, this);
        if (checkRemoved && this.panelRemoved(panel)) {
            return false;
        }
        this.addPanel(panel);
        return true;
    }

    boolean addCasingPanel(boolean checkRemoved) {
        if (this.hasCasingPanel()) {
            return false;
        }
        PanelCasing panel = new PanelCasing(this.db, this);
        if (checkRemoved && this.panelRemoved(panel)) {
            return false;
        }
        this.addPanel(panel);
        return true;
    }

    boolean addCoresPanel() {
        if (this.hasCoresPanel()) {
            return false;
        }
        PanelCores panel = new PanelCores(this.db, this);
        this.addPanel(panel);
        return true;
    }

    boolean addCoreImagesPanel() {
        if (this.hasCoreImagesPanel()) {
            return false;
        }
        PanelCoreImages panel = new PanelCoreImages(this, this.db);
        this.addPanel(panel);
        return true;
    }

    boolean addWellHeaderPanel() {
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!(this.headers.get(i) instanceof PanelWellHeader)) continue;
            return false;
        }
        PanelWellHeader panel = new PanelWellHeader(this);
        this.headers.add(panel);
        return true;
    }

    boolean addWellNamePanel() {
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!(this.headers.get(i) instanceof PanelWellName)) continue;
            return false;
        }
        PanelWellName panel = new PanelWellName(this);
        this.headers.add(panel);
        return true;
    }

    boolean addMarkersPanel() {
        if (this.hasMarkersPanel()) {
            return false;
        }
        PanelMarkers panel = new PanelMarkers(this, this.db);
        this.addPanel(panel);
        return true;
    }

    boolean addSampleLithologyPanel() {
        if (this.hasSampleLithologyPanel()) {
            return false;
        }
        PanelSampleLithology panel = new PanelSampleLithology(this.db, this);
        this.addPanel(panel);
        return true;
    }

    boolean addSamplesPanel(boolean checkRemoved) {
        if (this.hasSamplesPanel()) {
            return false;
        }
        PanelSamples panel = new PanelSamples(this.db, this);
        if (checkRemoved && this.panelRemoved(panel)) {
            return false;
        }
        this.addPanel(panel);
        return true;
    }

    boolean addIntLithPanel(boolean checkRemoved) {
        if (this.hasIntLithPanel()) {
            return false;
        }
        PanelIntLith panel = new PanelIntLith(this.db, this);
        if (checkRemoved && this.panelRemoved(panel)) {
            return false;
        }
        this.addPanel(panel);
        return true;
    }

    boolean panelRemoved(SBPanel panel) {
        PanelZones panelZones = null;
        PanelBiozones panelBiozones = null;
        PanelSQPicks panelSQ = null;
        PanelEvents panelEv = null;
        PanelEnv panelEnv = null;
        PanelBiocoms panelBiocoms = null;
        PanelIntcoms panelIntcoms = null;
        int i = -1;
        if (panel instanceof PanelZones) {
            panelZones = (PanelZones)panel;
            if (panelZones instanceof PanelBiozones) {
                panelBiozones = (PanelBiozones)panelZones;
                i = 1;
            } else {
                i = 0;
            }
        } else if (panel instanceof PanelSQPicks) {
            panelSQ = (PanelSQPicks)panel;
            i = 2;
        } else if (panel instanceof PanelEvents) {
            panelEv = (PanelEvents)panel;
            i = 3;
        } else if (panel instanceof PanelEnv) {
            panelEnv = (PanelEnv)panel;
            i = 4;
        } else if (panel instanceof PanelIntcoms) {
            panelIntcoms = (PanelIntcoms)panel;
            i = 5;
        } else if (panel instanceof PanelBiocoms) {
            panelBiocoms = (PanelBiocoms)panel;
            i = 6;
        }
        switch (i) {
            case 0: {
                for (SBPanel removedPanel : this.removedPanels) {
                    if (!(removedPanel instanceof PanelZones)) continue;
                    PanelZones removedPanelZones = (PanelZones)removedPanel;
                    if (removedPanelZones.igdType != panelZones.igdType || removedPanelZones.interpID != panelZones.interpID) continue;
                    return true;
                }
                break;
            }
            case 1: {
                for (SBPanel removedPanel : this.removedPanels) {
                    if (!(removedPanel instanceof PanelBiozones)) continue;
                    PanelBiozones removedPanelBiozones = (PanelBiozones)removedPanel;
                    if (removedPanelBiozones.igdType != panelBiozones.igdType || removedPanelBiozones.interpID != panelBiozones.interpID || removedPanelBiozones.schID != panelBiozones.schID) continue;
                    return true;
                }
                break;
            }
            case 2: {
                for (SBPanel removedPanel : this.removedPanels) {
                    if (!(removedPanel instanceof PanelSQPicks)) continue;
                    PanelSQPicks removedPanelSQ = (PanelSQPicks)removedPanel;
                    if (removedPanelSQ.interpID != panelSQ.interpID) continue;
                    return true;
                }
                break;
            }
            case 3: {
                for (SBPanel removedPanel : this.removedPanels) {
                    if (!(removedPanel instanceof PanelEvents)) continue;
                    PanelEvents removedPanelEvents = (PanelEvents)removedPanel;
                    if (removedPanelEvents.interpID != panelEv.interpID) continue;
                    return true;
                }
                break;
            }
            case 4: {
                for (SBPanel removedPanel : this.removedPanels) {
                    if (!(removedPanel instanceof PanelEnv)) continue;
                    PanelEnv removedPanelEnv = (PanelEnv)removedPanel;
                    if (removedPanelEnv.interpID != panelEnv.interpID || removedPanelEnv.getSchemeID() != panelEnv.getSchemeID()) continue;
                    return true;
                }
                break;
            }
            case 5: {
                for (SBPanel removedPanel : this.removedPanels) {
                    if (!(removedPanel instanceof PanelIntcoms)) continue;
                    PanelIntcoms removedPanelIntcoms = (PanelIntcoms)removedPanel;
                    if (removedPanelIntcoms.interpID != panelIntcoms.interpID) continue;
                    return true;
                }
                break;
            }
            case 6: {
                for (SBPanel removedPanel : this.removedPanels) {
                    if (!(removedPanel instanceof PanelBiocoms)) continue;
                    PanelBiocoms removedPanelBiocoms = (PanelBiocoms)removedPanel;
                    if (removedPanelBiocoms.interpID != panelBiocoms.interpID) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private float convDepth(float depth) {
        switch (this.prop.scaleType) {
            default: {
                return depth;
            }
            case TVD: {
                return this.getTVDList().getTVD((double)depth).getTVDepth().floatValue();
            }
            case AGE: 
        }
        return (float)this.interp.getLOC().getAge(depth, true);
    }

    public float getTopDepth() {
        return this.getTopDepth(true);
    }

    private float getTopDepth(boolean first) {
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            return (float)this.interp.getLOC().getDepth((double)this.prop.min, null, null, first);
        }
        if (this.prop.scaleType == BlockProperties.ScaleType.TVD && this.getTVDList() != null) {
            TVDepth d = this.getTVDList().getDepth((double)this.prop.min, first, null, null);
            if (d != null) {
                return (float)d.getDDepth();
            }
            try {
                return this.prop.min;
            }
            catch (Exception e) {
                SB.showStackError(null, (Exception)e);
            }
        }
        return this.prop.min;
    }

    float getMin() {
        return this.prop.min;
    }

    float getMax() {
        return this.prop.max;
    }

    public void setTopDepth(float topDepth) {
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            throw new UnsupportedOperationException("Attempt to set wellBlock topDepth in age scale");
        }
        this.prop.min = topDepth;
    }

    public float getBaseDepth() {
        return this.getBaseDepth(this.subBlockProperties != null && this.subBlockProperties.size() == 1);
    }

    private float getBaseDepth(boolean first) {
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            return (float)this.interp.getLOC().getDepth((double)this.prop.max, null, null, first);
        }
        if (this.prop.scaleType == BlockProperties.ScaleType.TVD && this.getTVDList() != null) {
            TVDepth d = this.getTVDList().getDepth((double)this.prop.max, first, null, null);
            if (d != null) {
                return (float)d.getDDepth();
            }
            try {
                return (float)this.well.getTVDlist(false).getBaseDD();
            }
            catch (Exception e) {
                SB.showStackError(null, (Exception)e);
            }
        }
        return this.prop.max;
    }

    public void setBaseDepth(float baseDepth) {
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            this.prop.max = (float)this.interp.getLOC().getMaxAge(new Double(baseDepth));
            if ((double)this.prop.max > this.interp.getLOC().getMaxAge()) {
                this.prop.max = (float)this.interp.getLOC().getMaxAge();
            }
            System.out.println("setProp.max to " + this.prop.max + " (" + baseDepth + ")");
            return;
        }
        this.prop.max = baseDepth;
    }

    public void setDepthRange(double topDepth, double baseDepth) {
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            Point2D ageRange = this.interp.getLOC().getAgeRange(topDepth, baseDepth);
            this.prop.min = (float)ageRange.getX();
            this.prop.max = (float)ageRange.getY();
        } else {
            this.prop.min = (float)topDepth;
            this.prop.max = (float)baseDepth;
        }
    }

    public void setScaleRange(float top, float base) {
        this.prop.min = top;
        this.prop.max = base;
    }

    public float getScale() {
        if (this.prop.scaleType == BlockProperties.ScaleType.AGE) {
            return (this.getBaseDepth() - this.getTopDepth()) / this.getHeight() * 1000.0f;
        }
        return this.prop.scale;
    }

    public void setScale(float scale) {
        this.prop.scale = scale;
    }

    float getAge(float depth, boolean minPref) {
        return (float)this.interp.getLOC().getAge(depth, minPref);
    }

    WellInterp getInterp() {
        return this.interp;
    }

    char getWellType() {
        return this.well.getType();
    }

    void setWell(Well well) {
        this.well = well;
        if (well == null) {
            this.subBlockProperties = null;
        }
    }

    void writeHTML(FileWriter out, ChartProperties cp) throws IOException, SBException {
        String row;
        LinkedList<SBPanelHTML> outPanels = new LinkedList<SBPanelHTML>();
        for (SBPanel panel : this.panels) {
            if (!(panel instanceof SBPanelHTML)) continue;
            outPanels.add((SBPanelHTML)panel);
        }
        LinkedList<Sample> samples = new LinkedList<Sample>();
        Iterator it = outPanels.iterator();
        while (it.hasNext()) {
            SBPanelHTML panel = (SBPanelHTML)it.next();
            int nSamples = panel.addSamples(samples, cp);
            if (nSamples >= 1) continue;
            it.remove();
        }
        if (samples.isEmpty()) {
            throw new SBException("No data to export");
        }
        out.write("<head>\n");
        out.write("<style type=\"text/css\"> table.SBTable {font-family:" + cp.font + "; border-collapse:collapse; }" + "table.SBTable td,th { border:1px solid black; }" + "</style>");
        out.write("\n</head>\n\n");
        out.write("<body>\n");
        out.write("<table class=\"SBTable\">\n");
        for (int j = 0; j < 2; ++j) {
            row = "<tr>";
            for (SBPanelHTML p : outPanels) {
                switch (j) {
                    case 0: {
                        row = row + p.getCaptionString();
                        break;
                    }
                    case 1: {
                        row = row + p.getSubHeaderString();
                    }
                }
            }
            row = row + "</tr>\n";
            out.write(row);
        }
        for (int i = 0; i < samples.size(); ++i) {
            row = "<tr>";
            for (SBPanelHTML p : outPanels) {
                row = row + p.getRowString(samples, i, cp);
            }
            row = row + "</tr>\n";
            out.write(row);
        }
        out.write("</table>\n");
        out.write("</body>");
    }

    String getPrefKey(int temp_id) {
        return WellBlock.getPrefKey(this.well.getWellID(), temp_id);
    }

    static String getPrefKey(int id, int temp_id) {
        String wellID = "" + id;
        if (wellID.length() > 4) {
            wellID = wellID.substring(wellID.length() - 4, wellID.length());
        } else if (wellID.length() < 4) {
            while ((wellID = "0" + wellID).length() < 4) {
            }
        }
        return "C" + temp_id + wellID;
    }
}

