/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import jsbugs.TableModelMatchSamples;
import model2.Project;
import model2.SBdb;
import model2.Well;
import model2.WsWell;
import util.ArrowCellRenderer;
import util.SB;
import util.SbugsStatusRenderer;
import util.StringStatus;

class WellsTableModel
extends AbstractTableModel {
    SBdb ws;
    int rowCount = 0;
    static String[] colTitle = new String[]{"File", "Name", "Code", "", "Name", "Code"};
    static final int COL_WS_FILE = 0;
    static final int COL_WS_NAME = 1;
    static final int COL_WS_CODE = 2;
    static final int COL_ARROW = 3;
    static final int COL_DB_NAME = 4;
    static final int COL_DB_CODE = 5;
    static int[] colWidths = new int[]{80, 60, 60, 16, 60, 60};

    WellsTableModel() {
    }

    @Override
    public int getColumnCount() {
        return colTitle.length;
    }

    @Override
    public int getRowCount() {
        try {
            Project project = this.ws.getProject(0);
            return project.getSize();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            Project project = this.ws.getProject(0);
            WsWell well = (WsWell)project.getWellAt(row);
            if (well == null) {
                return "";
            }
            Well link = well.getLink();
            switch (col) {
                case 0: {
                    return well.fileName == null || well.fileName.isEmpty() ? new StringStatus("", well.getStatus()) : new StringStatus(well.fileName, well.getHeader().getStatus());
                }
                case 1: {
                    return new StringStatus(well.getWellName(), well.getHeader().getStatus());
                }
                case 2: {
                    return new StringStatus(well.getWellCode(), well.getHeader().getStatus());
                }
                case 4: {
                    return link != null ? link.getWellName() : "";
                }
                case 5: {
                    return link != null ? link.getWellCode() : "";
                }
                case 3: {
                    return new Boolean(link != null);
                }
            }
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        switch (col) {
            default: 
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: {
                return StringStatus.class;
            }
            case 4: 
            case 5: {
                return String.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    void setupTable(JTable jTableWells) {
        for (int i = 0; i < colTitle.length; ++i) {
            jTableWells.getColumnModel().getColumn(i).setHeaderValue(colTitle[i]);
            jTableWells.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
        }
        jTableWells.getColumnModel().getColumn(3).setMaxWidth(TableModelMatchSamples.colWidths[3]);
        jTableWells.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        jTableWells.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        SB.setTableHeaderBold((JTable)jTableWells);
    }
}

