/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import jsbugs.DepthRenderer;
import jsbugs.TableModelSB;
import model2.IGDIntervalZone;
import model2.SBdb;
import util.ColorRenderer;
import util.ColouredRenderer;

public class ZonesTableModel
extends TableModelSB {
    char units = (char)77;
    List<IGDIntervalZone> zones = null;
    static String[] columnTitles = new String[]{"Top Sample", "Boundary", "Base Sample", "Boundary", "Level", "Unit", "Colour - Upper", "Colour - Lower", "Linked?", "Scheme", "Mod. By", "Modified"};
    private static final int[] defaultColumnWidths = new int[]{55, 25, 55, 25, 40, 50, 10, 10, 30, 60, 30, 30};
    static final int COL_TOP = 0;
    static final int COL_TOPBND = 1;
    static final int COL_BASE = 2;
    static final int COL_BASEBND = 3;
    static final int COL_COLUMN = 4;
    static final int COL_ZONE = 5;
    static final int COL_UPP_COLOUR = 6;
    static final int COL_LOW_COLOUR = 7;
    static final int COL_LINKED = 8;
    static final int COL_SCHEME = 9;
    static final int COL_MODIFIER = 10;
    static final int COL_MODIFIED = 11;

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        IGDIntervalZone zone = this.zones.get(row);
        switch (col) {
            case 0: {
                return zone.getTopSample().toString(this.units, false, false, true);
            }
            case 2: {
                return zone.getBaseSample().toString(this.units, false, false, true);
            }
            case 1: {
                return zone.getTopBnd();
            }
            case 3: {
                return zone.getBaseBnd();
            }
            case 5: {
                return zone.toString();
            }
            case 8: {
                return zone.getLinkString();
            }
            case 4: {
                return IGDIntervalZone.getHierName((int)zone.getIGDType(), (int)zone.getHier(), (boolean)true);
            }
            case 11: {
                return zone.getModified();
            }
            case 10: {
                return zone.getModifierAbr();
            }
            case 9: {
                try {
                    return zone.getSchemeName();
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
            case 6: {
                try {
                    return zone.getUnitColour(true);
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
            case 7: {
                try {
                    return zone.getUnitColour(false);
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
        }
        return "";
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 11: {
                return Date.class;
            }
            case 6: 
            case 7: 
        }
        return Color.class;
    }

    @Override
    public int getRowCount() {
        if (this.zones == null) {
            return 0;
        }
        return this.zones.size();
    }

    void setupTable(JTable jTable, SBdb sbdb) {
        this.init(jTable, sbdb);
        jTable.getColumnModel().getColumn(0).setCellRenderer(new DepthRenderer());
        jTable.getColumnModel().getColumn(2).setCellRenderer(new DepthRenderer());
        jTable.getColumnModel().getColumn(4).setCellRenderer((TableCellRenderer)new ColouredRenderer(true, new Color(220, 220, 220)));
        jTable.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
        jTable.setRowHeight(20);
    }

    @Override
    String[] getColumnTitles() {
        return columnTitles;
    }

    @Override
    int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    @Override
    String getPrefString() {
        return "TMZONES";
    }

    @Override
    String getPrefOrderString() {
        return "TOZONES";
    }

    @Override
    final String getAutoResizeString() {
        return "TARZONES";
    }
}

