/*
 * Decompiled with CFR 0.152.
 */
package com.reprisesoftware.rlm;

import com.reprisesoftware.rlm.RlmAvailableProduct;
import com.reprisesoftware.rlm.RlmConstants;
import com.reprisesoftware.rlm.RlmException;
import java.util.Vector;

public class RlmHandle
implements RlmConstants {
    private long handle;
    private boolean previouslyActivated;
    private static final String defaultLibName = "rlm902";

    private static native void rlmPutenv(String var0);

    private native long rlmInit(String var1, String var2, String var3);

    private native int rlmClose(long var1);

    private native int rlmStat(long var1);

    private native int rlmHostID(long var1, int var3, byte[] var4);

    private native void rlmAllHostIDs(long var1, int var3, byte[] var4);

    private native int rlmRlog(long var1, String var3);

    private native int rlmDlog(long var1, String var3);

    private native int rlmDetachedDemo(long var1, int var3, String var4);

    private native long rlmProducts(long var1, String var3, String var4);

    private native void rlmProductFirst(long var1);

    private native int rlmProductNext(long var1);

    private native String rlmProductName(long var1);

    private native String rlmProductVersion(long var1);

    private native int rlmProductCount(long var1);

    private native int rlmProductCurrentInUse(long var1);

    private native int rlmProductCurrentResUse(long var1);

    private native String rlmProductExpiration(long var1);

    private native int rlmProductHostBased(long var1);

    private native int rlmProductHold(long var1);

    private native int rlmProductIsRoaming(long var1);

    private native int rlmMaxRoam(long var1);

    private native int rlmMaxRoamCount(long var1);

    private native int rlmMaxShare(long var1);

    private native int rlmMinRemove(long var1);

    private native int rlmMinCheckout(long var1);

    private native int rlmMinTimeout(long var1);

    private native int rlmNRes(long var1);

    private native int rlmNRoamAllowed(long var1);

    private native String rlmOptions(long var1);

    private native int rlmCurrentRoam(long var1);

    private native int rlmShare(long var1);

    private native int rlmSoftLimit(long var1);

    private native int rlmTimeout(long var1);

    private native int rlmTimezone(long var1);

    private native int rlmIsTokenBased(long var1);

    private native int rlmType(long var1);

    private native int rlmUserBased(long var1);

    private native void rlmSetUser(long var1, String var3);

    private native void rlmSetHost(long var1, String var3);

    private native void rlmSetIsvData(long var1, String var3);

    private native void rlmSkipIsvDown(long var1);

    private native void rlmForgetIsvDown(long var1);

    private native void rlmKeepConn(long var1);

    private native void rlmErrstringNum(int var1, byte[] var2);

    private native int rlmActRequest(long var1, String var3, String var4, String var5, String var6, String var7, int var8, String var9, byte[] var10);

    private void createHandle(String licLoc, String appPath, String license, String libName, String[] env) throws RlmException {
        System.loadLibrary(libName);
        if (env != null) {
            for (int i = 0; i < env.length; ++i) {
                RlmHandle.rlmPutenv(env[i]);
            }
        }
        this.handle = this.rlmInit(licLoc, appPath, license);
        int stat = this.rlmStat(this.handle);
        if (stat != 0 && stat != -102) {
            throw new RlmException(stat, this);
        }
    }

    public RlmHandle(String licLoc, String appPath, String license) throws RlmException {
        this.createHandle(licLoc, appPath, license, defaultLibName, null);
    }

    public RlmHandle(String licLoc, String appPath, String license, String[] env) throws RlmException {
        this.createHandle(licLoc, appPath, license, defaultLibName, env);
    }

    public RlmHandle(String licLoc, String appPath, String license, String libName) throws RlmException {
        String lib = null;
        lib = libName != null && libName.length() > 0 ? libName : defaultLibName;
        this.createHandle(licLoc, appPath, license, lib, null);
    }

    public RlmHandle(String licLoc, String appPath, String license, String libName, String[] env) throws RlmException {
        String lib = null;
        lib = libName != null && libName.length() > 0 ? libName : defaultLibName;
        this.createHandle(licLoc, appPath, license, lib, env);
    }

    protected long getHandle() {
        return this.handle;
    }

    public void close() {
        if (this.handle != 0L) {
            this.rlmClose(this.handle);
        }
        this.handle = 0L;
    }

    public String getHostID(int type) {
        byte[] buf = new byte[76];
        String hid = null;
        int stat = this.rlmHostID(this.handle, type, buf);
        if (stat == 0) {
            hid = new String(buf);
        }
        return hid;
    }

    public String[] getAllHostIDs(int type) {
        byte[] buf = new byte[1900];
        this.rlmAllHostIDs(this.handle, type, buf);
        String all = new String(buf).trim();
        String[] split = all.split(" ");
        return split;
    }

    public void writeReportLog(String logString) throws RlmException {
        int stat = this.rlmRlog(this.handle, logString);
        if (stat != 0) {
            throw new RlmException(stat, this);
        }
    }

    public void writeDebugLog(String logString) throws RlmException {
        int stat = this.rlmDlog(this.handle, logString);
        if (stat != 0) {
            throw new RlmException(stat, this);
        }
    }

    public void createDetachedDemo(int days, String license) throws RlmException {
        int stat = this.rlmDetachedDemo(this.handle, days, license);
        if (stat != 0) {
            throw new RlmException(stat, this);
        }
    }

    private void addProduct(long prodHandle, Vector v) {
        RlmAvailableProduct prod = new RlmAvailableProduct();
        prod.setName(this.rlmProductName(prodHandle));
        prod.setVersion(this.rlmProductVersion(prodHandle));
        prod.setCount(this.rlmProductCount(prodHandle));
        prod.setCurrentInUse(this.rlmProductCurrentInUse(prodHandle));
        prod.setCurrentResUse(this.rlmProductCurrentResUse(prodHandle));
        prod.setExpiration(this.rlmProductExpiration(prodHandle));
        prod.setHostBased(this.rlmProductHostBased(prodHandle));
        prod.setHold(this.rlmProductHold(prodHandle));
        prod.setIsRoaming(this.rlmProductIsRoaming(prodHandle));
        prod.setMaxRoam(this.rlmMaxRoam(prodHandle));
        prod.setMaxRoamCount(this.rlmMaxRoamCount(prodHandle));
        prod.setMaxShare(this.rlmMaxShare(prodHandle));
        prod.setMinRemove(this.rlmMinRemove(prodHandle));
        prod.setMinCheckout(this.rlmMinCheckout(prodHandle));
        prod.setMinTimeout(this.rlmMinTimeout(prodHandle));
        prod.setNRes(this.rlmNRes(prodHandle));
        prod.setNRoamAllowed(this.rlmNRoamAllowed(prodHandle));
        prod.setOptions(this.rlmOptions(prodHandle));
        prod.setCurrentRoam(this.rlmCurrentRoam(prodHandle));
        prod.setShare(this.rlmShare(prodHandle));
        prod.setSoftLimit(this.rlmSoftLimit(prodHandle));
        prod.setTimeout(this.rlmTimeout(prodHandle));
        prod.setTimezone(this.rlmTimezone(prodHandle));
        prod.setIsTokenBased(this.rlmIsTokenBased(prodHandle));
        prod.setType(this.rlmType(prodHandle));
        prod.setUserBased(this.rlmUserBased(prodHandle));
        v.add(prod);
    }

    public Vector getAvailableProducts(String product, String version) {
        Vector v = null;
        long prodHandle = this.rlmProducts(this.handle, product, version);
        if (prodHandle != 0L) {
            v = new Vector();
            this.rlmProductFirst(prodHandle);
            this.addProduct(prodHandle, v);
            while (this.rlmProductNext(prodHandle) == 0) {
                this.addProduct(prodHandle, v);
            }
        }
        return v;
    }

    public void setUser(String user) {
        this.rlmSetUser(this.handle, user);
    }

    public void setHost(String host) {
        this.rlmSetHost(this.handle, host);
    }

    public void setIsvData(String isvData) {
        this.rlmSetIsvData(this.handle, isvData);
    }

    public void skipIsvDown() {
        this.rlmSkipIsvDown(this.handle);
    }

    public void forgetIsvDown() {
        this.rlmForgetIsvDown(this.handle);
    }

    public void keepConn() {
        this.rlmKeepConn(this.handle);
    }

    public String actRequest(String url, String isv, String key, String hostidList, String hostName, int count, String extra) throws RlmException {
        int stat;
        byte[] buf = new byte[3072];
        if (hostidList == null) {
            hostidList = "";
        }
        if (hostName == null) {
            hostName = "";
        }
        if (extra == null) {
            extra = "";
        }
        if ((stat = this.rlmActRequest(this.handle, url, isv, key, hostidList, hostName, count, extra, buf)) < 0) {
            throw new RlmException(stat, this);
        }
        this.previouslyActivated = stat == 1;
        return new String(buf).trim();
    }

    public boolean previouslyActivated() {
        return this.previouslyActivated;
    }

    protected void finalize() {
        this.close();
    }

    public String getMessageByCode(int code) {
        String ret = null;
        byte[] errString = new byte[513];
        this.rlmErrstringNum(code, errString);
        ret = new String(errString).trim();
        return ret;
    }
}

