/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import javax.swing.JComboBox;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Well;
import util.SB;

public class AbnScheme
extends Observable
implements Comparable {
    SBdb SB;
    static final int MAXCLASSES = 12;
    static final int MAXABRLENGTH = 4;
    private String name = "";
    private int ID = 0;
    int donorID = 0;
    private int nClasses = 0;
    private String[] className;
    private String[] entry;
    private int[] lowBound;
    private int[] outputValue;

    public AbnScheme() {
        this.init();
    }

    public AbnScheme(AbnScheme rhs) {
        this.init();
        if (rhs != null) {
            this.name = rhs.name;
            this.ID = rhs.ID;
            this.donorID = rhs.donorID;
            this.nClasses = rhs.nClasses;
            for (int i = 0; i < this.nClasses; ++i) {
                this.entry[i] = rhs.entry[i];
                this.lowBound[i] = rhs.lowBound[i];
                this.className[i] = rhs.className[i];
                this.outputValue[i] = rhs.outputValue[i];
            }
        }
    }

    void copy(AbnScheme rhs) {
        this.SB = rhs.SB;
        this.init();
        this.name = rhs.name;
        this.ID = rhs.ID;
        this.donorID = rhs.donorID;
        this.nClasses = rhs.nClasses;
        for (int i = 0; i < this.nClasses; ++i) {
            this.entry[i] = rhs.entry[i];
            this.lowBound[i] = rhs.lowBound[i];
            this.className[i] = rhs.className[i];
            this.outputValue[i] = rhs.outputValue[i];
        }
    }

    public int compareTo(Object rhs) {
        return this.name.compareToIgnoreCase(((AbnScheme)rhs).name);
    }

    public void insertRow(int insertPoint) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to modify stored abundance scheme");
        }
        for (int i = this.nClasses; i > insertPoint; --i) {
            this.entry[i] = this.entry[i - 1];
            this.lowBound[i] = this.lowBound[i - 1];
            this.className[i] = this.className[i - 1];
            this.outputValue[i] = this.outputValue[i - 1];
        }
        this.entry[insertPoint] = "";
        this.lowBound[insertPoint] = 0;
        this.className[insertPoint] = "";
        this.outputValue[insertPoint] = 0;
        ++this.nClasses;
    }

    public void deleteRow(int deletePoint) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to modify stored abundance scheme");
        }
        for (int i = deletePoint; i < this.nClasses; ++i) {
            this.entry[i] = this.entry[i + 1];
            this.lowBound[i] = this.lowBound[i + 1];
            this.className[i] = this.className[i + 1];
            this.outputValue[i] = this.outputValue[i + 1];
        }
        --this.nClasses;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        if (this.name.length() == 0) {
            if (this.ID != 0) {
                return "Scheme ID no. " + this.ID;
            }
            if (this.donorID > 0) {
                return "Donor scheme no. " + this.donorID;
            }
            return "<No Name or ID>";
        }
        if (this.ID == 0 && this.donorID != 0) {
            return "Donor scheme: " + this.donorID + " : " + this.name;
        }
        return this.name;
    }

    private void init() {
        this.className = new String[12];
        this.entry = new String[12];
        this.lowBound = new int[12];
        this.outputValue = new int[12];
    }

    public void fillCombo(JComboBox combo) {
        for (int i = 0; i < this.nClasses; ++i) {
            combo.addItem(this.className[i]);
        }
    }

    public String getAbr(String desc) {
        for (int i = 0; i < this.nClasses; ++i) {
            if (!desc.equalsIgnoreCase(this.className[i])) continue;
            return this.entry[i];
        }
        return "";
    }

    public String getClassName(String abr) throws SBException {
        for (int i = 0; i < this.nClasses; ++i) {
            if (!abr.equalsIgnoreCase(this.entry[i])) continue;
            return this.className[i];
        }
        throw new SBException("Abundance scheme entry not found for abr: " + abr);
    }

    public String getEntry(int index) {
        return this.entry[index];
    }

    public String getClassName(int index) {
        return this.className[index];
    }

    public int getLowBound(int index) {
        return this.lowBound[index];
    }

    public int getOutputValue(int index) {
        return this.outputValue[index];
    }

    public void setName(String name) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set abnScheme");
        }
        this.name = name;
    }

    public void setEntry(String entry, int index) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set abnScheme");
        }
        this.entry[index] = entry;
    }

    public void setClassName(String className, int index) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set abnScheme");
        }
        this.className[index] = className;
    }

    public void setLowBound(int lowBound, int index) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set abnScheme");
        }
        this.lowBound[index] = lowBound;
    }

    public void setOutputValue(int outputValue, int index) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set abnScheme");
        }
        this.outputValue[index] = outputValue;
    }

    public int getCount(String abr) {
        for (int i = 0; i < this.nClasses; ++i) {
            if (!abr.equalsIgnoreCase(this.entry[i])) continue;
            if (this.outputValue[i] != 0) {
                return this.outputValue[i];
            }
            return this.lowBound[i];
        }
        return 0;
    }

    public String getAbr(int bound) {
        for (int i = this.nClasses - 1; i >= 0; --i) {
            if (this.entry[i].equals("+") && bound == 0) {
                return "+";
            }
            if (bound < this.lowBound[i] || this.entry[i].equals("+") || this.lowBound[i] <= 0) continue;
            return this.entry[i];
        }
        return "";
    }

    public int getNoccs() throws SQLException {
        if (this.ID == 0) {
            return 0;
        }
        String sql = "SELECT count(sch_abn) as nOcc FROM " + this.SB.DBTableName("WELLABN") + " WHERE sch_abn=" + this.ID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        int nOccs = 0;
        if (rs.next()) {
            nOccs = rs.getInt("nOcc");
        }
        return nOccs;
    }

    public List getOccs() throws SQLException {
        String sql = "SELECT w.well_name,v.well_id,v.code,a.disc_id FROM " + this.SB.DBTableName("WELLABN") + " a," + this.SB.DBTableName("VERSION") + " v," + this.SB.DBTableName("WELLS") + " w" + " WHERE a.sch_abn=" + this.ID + " AND a.well_id=v.well_id AND v.code=w.well_code ORDER BY well_name";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        ArrayList<String> occs = new ArrayList<String>();
        while (rs.next()) {
            occs.add(rs.getString("well_name") + "|" + rs.getInt("well_id") + "|" + rs.getString("code") + "|" + rs.getString("disc_id").trim().charAt(0));
        }
        stmt.close();
        return occs;
    }

    public int getIndex(String subj) {
        if (subj == null) {
            return -1;
        }
        if (subj.length() == 0) {
            return -1;
        }
        for (int i = 0; i < this.nClasses; ++i) {
            if (!subj.equalsIgnoreCase(this.entry[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean checkNameUnique(SBdb db) throws SQLException, SBException {
        if (this.SB != null) {
            throw new SBException("Cannot check stored abundance scheme - use copy");
        }
        String sql = "SELECT scheme_id FROM " + db.DBTableName("ABNSCHME") + " WHERE ucase(name)='" + this.name.toUpperCase() + "'";
        if (this.ID != 0) {
            sql = sql + " AND scheme_id <> " + this.ID;
        }
        Statement stmt = db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(db.modQuery(sql));
        boolean unique = true;
        if (rs.next()) {
            unique = false;
        }
        stmt.close();
        return unique;
    }

    public boolean checkAndSort() throws SBException {
        int i;
        if (this.SB != null) {
            throw new SBException("Cannot check stored abundance scheme - use copy");
        }
        for (i = 0; i < this.nClasses; ++i) {
            if (this.entry[i] == null || this.entry[i].length() == 0) {
                throw new SBException("Entry at row " + (i + 1) + " is blank.");
            }
            if (this.entry[i].length() > 4) {
                throw new SBException("Entry at row " + (i + 1) + " exceeds Maximum length of :" + 4);
            }
            if (this.className[i] == null || this.className[i].length() == 0) {
                throw new SBException("Description at row " + (i + 1) + " is blank.");
            }
            if (this.lowBound[i] >= 0) continue;
            throw new SBException("Minimum value at row " + (i + 1) + " is invalid.");
        }
        for (i = 0; i < this.nClasses; ++i) {
            for (int j = 0; j < this.nClasses; ++j) {
                if (i == j) continue;
                if (this.entry[i].equalsIgnoreCase(this.entry[j])) {
                    throw new SBException("Duplicate entries at rows : " + (i + 1) + " and " + (j + 1));
                }
                if (this.className[i].equalsIgnoreCase(this.className[j])) {
                    throw new SBException("Duplicate descriptions at rows : " + (i + 1) + " and " + (j + 1));
                }
                if (this.lowBound[i] != this.lowBound[j]) continue;
                throw new SBException("Duplicate values at rows : " + (i + 1) + " and " + (j + 1));
            }
        }
        boolean swap = true;
        block3: while (swap) {
            swap = false;
            for (int i2 = 0; i2 < this.nClasses - 1; ++i2) {
                if (this.lowBound[i2 + 1] == 0 || this.lowBound[i2] <= this.lowBound[i2 + 1]) continue;
                swap = true;
                int temp = this.lowBound[i2];
                this.lowBound[i2] = this.lowBound[i2 + 1];
                this.lowBound[i2 + 1] = temp;
                String tempString = this.entry[i2];
                this.entry[i2] = this.entry[i2 + 1];
                this.entry[i2 + 1] = tempString;
                temp = this.outputValue[i2];
                this.outputValue[i2] = this.outputValue[i2 + 1];
                this.outputValue[i2 + 1] = temp;
                tempString = this.className[i2];
                this.className[i2] = this.className[i2 + 1];
                this.className[i2 + 1] = tempString;
                continue block3;
            }
        }
        return true;
    }

    public void addClass(String abr, String name, int bound, int oVal) throws SBException {
        int i;
        if (this.SB != null) {
            throw new SBException("Cannot add class to stored abundance scheme - use copy");
        }
        int insertPoint = this.nClasses;
        for (i = 0; i < this.nClasses; ++i) {
            if (abr.equalsIgnoreCase(this.entry[i])) {
                throw new SBException("Abundance scheme entry: '" + abr + "' is already defined in scheme");
            }
            if (bound >= this.lowBound[i]) continue;
            insertPoint = i;
            break;
        }
        if (this.nClasses + 1 > 12) {
            throw new SBException("Number of abundance scheme classes exceeded");
        }
        if (bound == 0) {
            insertPoint = this.nClasses;
        }
        for (i = this.nClasses; i > insertPoint; --i) {
            this.entry[i] = this.entry[i - 1];
            this.lowBound[i] = this.lowBound[i - 1];
            this.className[i] = this.className[i - 1];
            this.outputValue[i] = this.outputValue[i - 1];
        }
        this.entry[insertPoint] = abr;
        this.lowBound[insertPoint] = bound;
        this.className[insertPoint] = name;
        this.outputValue[insertPoint] = oVal;
        ++this.nClasses;
    }

    public AbnScheme(SBdb SB2, int iID) throws SQLException {
        this.SB = SB2;
        this.init();
        String sql = "SELECT name,noof_abn FROM " + SB2.DBTableName("ABNSCHME") + " WHERE scheme_id=" + iID;
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            this.ID = iID;
            this.name = util.SB.getDBString(rs, "name");
            this.nClasses = rs.getInt("noof_abn");
            rs.close();
            this.loadClasses(stmt);
        }
        stmt.close();
    }

    public AbnScheme(SBdb SB2, String findName) throws SQLException {
        this.init();
        String sql = "SELECT scheme_id,noof_abn FROM " + SB2.DBTableName("ABNSCHME") + " WHERE name='" + findName + "'";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            this.ID = rs.getInt("scheme_id");
            this.SB = SB2;
            this.name = findName;
            this.nClasses = rs.getInt("noof_abn");
            rs.close();
            this.loadClasses(stmt);
        }
        stmt.close();
    }

    private void loadClasses(Statement stmt) throws SQLException {
        for (int i = 0; i < this.nClasses; ++i) {
            int j = i + 1;
            String sql = "SELECT abn" + j + "_text,abn" + j + "_abr,abn" + j + "_val,abn" + j + "_ov FROM " + this.SB.DBTableName("ABNSCHME") + " WHERE scheme_id=" + this.ID;
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            if (rs.next()) {
                this.className[i] = util.SB.getDBString(rs, "abn" + j + "_text");
                this.entry[i] = util.SB.getDBString(rs, "abn" + j + "_abr");
                this.lowBound[i] = rs.getInt("abn" + j + "_val");
                this.outputValue[i] = rs.getInt("abn" + j + "_ov");
            }
            rs.close();
        }
    }

    void merge(AbnScheme donor) throws SQLException, SBException {
        if (this.ID == 0 || donor.ID == 0) {
            throw new SBException("Scheme ID zero in AbnScheme.merge");
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "UPDATE " + this.SB.DBTableName("WELLABN") + " SET sch_abn=" + this.ID + " WHERE sch_abn=" + donor.ID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("ABNSCHME") + " WHERE scheme_id=" + donor.ID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    public boolean match(AbnScheme rhs) {
        if (this.nClasses != rhs.nClasses) {
            return false;
        }
        for (int i = 0; i < this.nClasses; ++i) {
            if (this.lowBound[i] != rhs.lowBound[i]) {
                return false;
            }
            if (this.entry[i].equals(rhs.entry[i])) continue;
            return false;
        }
        return true;
    }

    static void loadAll(SBdb SB2, List abnSchemes) throws SQLException {
        String sql = "SELECT scheme_id FROM " + SB2.DBTableName("ABNSCHME") + " ORDER BY scheme_id";
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            AbnScheme scheme;
            int ID = rs.getInt("scheme_id");
            AbnScheme abnScheme = AbnScheme.get(abnSchemes, ID, 0);
            if (abnScheme != null || (scheme = new AbnScheme(SB2, ID)).getID() <= 0 && (ID != 0 || scheme.getID() != 0)) continue;
            abnSchemes.add(scheme);
        }
        Collections.sort(abnSchemes);
        stmt.close();
    }

    static AbnScheme get(List abns, int hostID, int donorID) {
        AbnScheme scheme2 = null;
        for (AbnScheme scheme2 : abns) {
            if (!(hostID > 0 ? scheme2.ID == hostID : donorID > 0 && scheme2.donorID == donorID)) continue;
            return scheme2;
        }
        return null;
    }

    static AbnScheme get(List abns, String name) {
        AbnScheme scheme2 = null;
        for (AbnScheme scheme2 : abns) {
            if (!scheme2.name.equals(name)) continue;
            return scheme2;
        }
        return null;
    }

    static AbnScheme getDefault(SBdb SB2, List abnSchemes) throws SQLException {
        AbnScheme abn = AbnScheme.get(abnSchemes, "Default Abundance Scheme");
        if (abn == null) {
            AbnScheme.loadAll(SB2, abnSchemes);
            abn = AbnScheme.get(abnSchemes, "Default Abundance Scheme");
        }
        if (abn == null) {
            for (AbnScheme testAbn : abnSchemes) {
                if (abn != null && testAbn.ID >= abn.ID) continue;
                abn = testAbn;
            }
        }
        return abn;
    }

    static void clearDonor(List abnSchemes) {
        if (abnSchemes == null) {
            return;
        }
        Iterator it = abnSchemes.iterator();
        while (it.hasNext()) {
            AbnScheme scheme = (AbnScheme)it.next();
            if (scheme.donorID <= 0) continue;
            it.remove();
        }
    }

    int match() throws SQLException, Exception {
        if (this.ID != 0) {
            return this.ID;
        }
        String sql = "SELECT name,scheme_id FROM " + this.SB.DBTableName("ABNSCHME") + " WHERE ";
        for (int i = 0; i < this.nClasses; ++i) {
            int j = i + 1;
            if (i > 0) {
                sql = sql + " AND ";
            }
            sql = sql + "abn" + j + "_abr='" + this.entry[i] + "' AND abn" + j + "_val=" + this.lowBound[i];
        }
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        int rowCount = 0;
        while (rs.next()) {
            ++rowCount;
        }
        if (rowCount == 1) {
            rs.first();
            this.ID = rs.getInt("scheme_id");
            this.name = rs.getString("name");
        } else if (rowCount != 0) {
            Hashtable matches = new Hashtable();
            boolean oneMatch = true;
            rs.beforeFirst();
            while (rs.next()) {
                this.ID = rs.getInt("scheme_id");
                this.name = rs.getString("name");
            }
        }
        return this.ID;
    }

    public List getWellUsage() throws SQLException, SBException {
        if (this.SB == null) {
            throw new SBException("Database pointer null in AbnScheme.getWellUsage");
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "SELECT well_id, disc_id FROM " + this.SB.DBTableName("WELLABN") + " WHERE sch_abn=" + this.ID;
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        class WellDisc {
            int wellID;
            char discID;

            WellDisc() {
            }
        }
        LinkedList<WellDisc> wells = new LinkedList<WellDisc>();
        while (rs.next()) {
            WellDisc wellDisc = new WellDisc();
            wellDisc.wellID = rs.getInt("well_id");
            wellDisc.discID = util.SB.getDBChar(rs, "disc_id");
            wells.add(wellDisc);
        }
        Iterator it = wells.iterator();
        LinkedList<String> foundWells = new LinkedList<String>();
        while (it.hasNext()) {
            WellDisc wellDisc = (WellDisc)it.next();
            sql = "SELECT distinct subj_abund FROM " + this.SB.DBTableName("FSSABND") + " WHERE samp_id>=" + wellDisc.wellID * 65536 + " AND samp_id<" + wellDisc.wellID * 65537 + " AND disc_id=" + util.SB.DBChar(wellDisc.discID) + " AND subj_abund <> '+' AND subj_abund is not null";
            rs = stmt.executeQuery(this.SB.modQuery(sql));
            boolean found = false;
            String abrs = "";
            while (rs.next()) {
                String subjAbund = rs.getString("subj_abund");
                if (subjAbund.trim().length() <= 0) continue;
                found = true;
                if (abrs.length() > 0) {
                    abrs = abrs + ",";
                }
                abrs = abrs + subjAbund;
            }
            if (!found) continue;
            String well = Well.getName(this.SB, wellDisc.wellID);
            well = well + " (" + SBdb.getDiscAbr(wellDisc.discID) + ")";
            well = well + " Usage: " + abrs;
            foundWells.add(well);
        }
        stmt.close();
        return foundWells;
    }

    void delete() throws SQLException, SBException {
        if (this.SB == null) {
            throw new SBException("Null database pointer in AbnScheme.delete");
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        if (this.ID != 0) {
            String sql = "DELETE FROM " + this.SB.DBTableName("ABNSCHME") + " WHERE scheme_id=" + this.ID;
            stmt.executeUpdate(this.SB.modQuery(sql));
            sql = "DELETE FROM " + this.SB.DBTableName("WELLABN") + " WHERE sch_abn=" + this.ID;
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
    }

    public void update(AbnScheme rhs) throws SQLException, SBException {
        rhs.checkAndSort();
        rhs.store(this.SB);
        this.copy(rhs);
        this.setChanged();
        this.notifyObservers();
    }

    void store(SBdb SB2) throws SQLException, SBException {
        String sql;
        Statement stmt = SB2.getDatabase().createStatement();
        if (this.ID != 0) {
            sql = "DELETE FROM " + SB2.DBTableName("ABNSCHME") + " WHERE scheme_id=" + this.ID;
            stmt.executeUpdate(SB2.modQuery(sql));
        } else {
            this.ID = SB2.nextControl("ABN_SCH");
            SBdb.DBType cfr_ignored_0 = SB2.dbType;
            if (SB2.dbType == SBdb.DBType.ORACLE) {
                int otherId = SB2.nextControl("ABN_SCHEME");
                while (otherId < this.ID) {
                    otherId = SB2.nextControl("ABN_SCHEME");
                }
                while (this.ID < otherId) {
                    this.ID = SB2.nextControl("ABN_SCH");
                }
            }
        }
        sql = "INSERT INTO " + SB2.DBTableName("ABNSCHME");
        sql = sql + " ( scheme_id,name,noof_abn";
        for (int j = 1; j <= this.nClasses; ++j) {
            sql = sql + ",abn" + j + "_text,abn" + j + "_abr,abn" + j + "_val,abn" + j + "_ov";
        }
        sql = sql + " ) VALUES (";
        sql = sql + this.ID + ",'" + this.name + "'," + this.nClasses;
        for (int i = 0; i < this.nClasses; ++i) {
            sql = sql + ",'" + this.className[i] + "','" + this.entry[i] + "'," + this.lowBound[i] + "," + this.outputValue[i];
        }
        sql = sql + ")";
        stmt.executeUpdate(SB2.modQuery(sql));
        this.SB = SB2;
    }

    void writeSbugs(FileWriter out) throws IOException {
        out.write("ABNSCHME\n");
        String blanks = "                                                        ";
        for (int i = 0; i < this.nClasses; ++i) {
            out.write(blanks.substring(0, 4 - this.entry[i].length()) + this.entry[i]);
            out.write(blanks.substring(0, 25 - this.className[i].length()) + this.className[i]);
            out.write(String.valueOf(this.lowBound[i]) + '\n');
        }
    }

    void writeXML(FileWriter out, int indent) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        String ind2 = new String();
        while (ind2.length() < indent + 3) {
            ind2 = ind2 + ' ';
        }
        out.write(ind + "<SchemeName>" + this.name + "</SchemeName>\n");
        for (int i = 0; i < this.nClasses; ++i) {
            out.write(ind + "<Category>\n");
            out.write(ind2 + "<Name>" + this.className[i] + "</Name>\n");
            out.write(ind2 + "<Entry>" + this.entry[i] + "</Entry>\n");
            out.write(ind2 + "<LowBound>" + this.lowBound[i] + "</LowBound>\n");
            out.write(ind2 + "<OutputValue>" + this.outputValue[i] + "</OutputValue>\n");
            out.write(ind + "</Category>\n");
        }
    }

    void writeDEX(FileWriter out, String eol) throws IOException {
        String ind = new String();
        out.write("Scheme ID = " + (this.ID > 0 ? this.ID : this.donorID) + eol);
        out.write("Scheme name = " + this.name + eol);
        out.write("Number of categories = " + this.nClasses + eol);
        for (int i = 0; i < this.nClasses; ++i) {
            out.write("  Category number = " + (i + 1) + eol);
            out.write("    Name : " + this.className[i] + eol);
            out.write("    Entry : " + this.entry[i] + eol);
            out.write("    Low Bound : " + this.lowBound[i] + eol);
            out.write("    Output Value : " + this.outputValue[i] + eol);
        }
        out.write(eol);
    }

    void parseXML(String chars, String element) {
        if (element.compareTo("SchemeName") == 0) {
            this.name = chars;
        } else if (element.compareTo("Name") == 0) {
            if (this.className[this.nClasses] != null && this.nClasses < 12) {
                ++this.nClasses;
            }
            this.className[this.nClasses] = chars;
        } else if (element.compareTo("Entry") == 0) {
            if (this.entry[this.nClasses] != null && this.nClasses < 12) {
                ++this.nClasses;
            }
            this.entry[this.nClasses] = chars;
        } else if (element.compareTo("LowBound") == 0) {
            if (this.lowBound[this.nClasses] != 0 && this.nClasses < 12) {
                ++this.nClasses;
            }
            this.lowBound[this.nClasses] = Integer.parseInt(chars);
        } else if (element.compareTo("OutputValue") == 0) {
            if (this.outputValue[this.nClasses] != 0 && this.nClasses < 12) {
                ++this.nClasses;
            }
            this.outputValue[this.nClasses] = Integer.parseInt(chars);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.ID;
    }

    public int getNClasses() {
        return this.nClasses;
    }
}

