/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import model1_8.SBdb;
import util.SB;

public class AnalystHeader {
    SBdb SB;
    String analyst;
    char discID;
    Date from;
    Date to;
    double depthFrom = 0.0;
    double depthTo = 0.0;
    String comments;
    int envSchId = 0;

    public String getAnalyst() {
        return this.analyst;
    }

    public char getDiscID() {
        return this.discID;
    }

    public Date getDateFrom() {
        return this.from;
    }

    public Date getDateTo() {
        return this.to;
    }

    public double getDepthFrom() {
        return this.depthFrom;
    }

    public double getDepthTo() {
        return this.depthTo;
    }

    public String getComments() {
        return this.comments;
    }

    public int getEnvSchID() {
        return this.envSchId;
    }

    public AnalystHeader(SBdb SB2) {
        this.SB = SB2;
    }

    public AnalystHeader(SBdb SB2, String analyst, char discID) {
        this.SB = SB2;
        this.analyst = analyst;
        this.discID = discID;
    }

    public void load(int wellID, String analyst, char discID) throws SQLException {
        String sql = "SELECT date_from,date_to,depth_from,depth_to,comments,envsch_id FROM " + this.SB.DBTableName("ANALY_HDR") + " WHERE well_id=" + wellID + " AND disc_id='" + discID + "' AND analyst='" + analyst + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            this.analyst = analyst;
            this.discID = discID;
            this.from = rs.getDate("date_from");
            this.to = rs.getDate("date_to");
            this.depthFrom = rs.getDouble("depth_from");
            this.depthTo = rs.getDouble("depth_to");
            this.comments = rs.getString("comments");
            this.envSchId = rs.getInt("envsch_id");
        }
        stmt.close();
    }

    public void save(int wellID, String analyst, char discID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("ANALY_HDR") + " WHERE well_id=" + wellID + " AND disc_id='" + discID + "' AND analyst='" + analyst + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "INSERT INTO " + this.SB.DBTableName("ANALY_HDR") + " (well_id,disc_id,analyst,date_from,date_to,depth_from,depth_to,comments,envsch_id) VALUES (" + wellID + ",'" + discID + "','" + analyst + "'," + util.SB.DBString(util.SB.DBdf.format(this.from)) + "," + util.SB.DBString(util.SB.DBdf.format(this.to)) + "," + this.depthFrom + "," + this.depthTo + "," + util.SB.DBString(this.comments) + "," + this.envSchId + ")";
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    static void createTable(SBdb SB2) throws SQLException {
        String text = "text";
        SBdb.DBType cfr_ignored_0 = SB2.dbType;
        if (SB2.dbType == SBdb.DBType.ORACLE) {
            text = "VARCHAR2";
        }
        String sql = "CREATE TABLE " + SB2.DBTableName("ANALY_HDR") + " (" + "well_id number," + "disc_id " + text + "(1)," + "analyst " + text + "(5)," + "date_from date," + "date_to date," + "depth_from number," + "depth_to number," + "comments " + text + "(240)," + "envsch_id number" + ")";
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
    }
}

