/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import model1_8.IGDInterval;
import model1_8.InterpHdr;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Sample;
import model1_8.Well;
import model1_8.WellInterp;
import util.SB;
import util.SbugsStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Biocom
implements SbugsStatus {
    private SBdb SB;
    private char discID = '\u0000';
    private String analyst = "";
    private String text;
    private String source;
    private int topID = 0;
    private Sample topSample = null;
    private int baseID = 0;
    private Sample baseSample = null;
    Color status = UNKNOWN;

    public Sample getTopSample() {
        return this.topSample;
    }

    public int getTopID() {
        return this.topID;
    }

    public int getBaseID() {
        return this.baseID;
    }

    public Sample getBaseSample() {
        return this.baseSample;
    }

    public String getAnalyst() {
        return this.analyst;
    }

    public char getDiscID() {
        return this.discID;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public Biocom(SBdb SB2) {
        this.SB = SB2;
    }

    public Biocom(SBdb SB2, Sample topSample, Sample baseSample, char discID, String analyst, String text, String source) {
        this.SB = SB2;
        this.topSample = topSample;
        this.baseSample = baseSample;
        this.discID = discID;
        this.topID = topSample.getSampID();
        if (baseSample != null) {
            this.baseID = baseSample.getSampID();
        }
        this.analyst = analyst;
        this.text = text;
        this.source = source;
    }

    public Biocom(SBdb SB2, int interpID, char discID, Sample topSample, Sample baseSample, String analyst, String text, String source) throws SQLException {
        this.SB = SB2;
        this.discID = discID;
        this.topSample = topSample;
        this.baseSample = baseSample;
        this.topID = topSample.getSampID();
        if (baseSample != null) {
            this.baseID = baseSample.getSampID();
        }
        this.analyst = analyst;
        this.text = text;
        this.source = source;
        this.status = NOTSTORED;
        this.store(interpID);
    }

    public Biocom(Biocom i) {
        if (i == null) {
            return;
        }
        this.SB = i.SB;
        this.topSample = i.topSample;
        this.baseSample = i.baseSample;
        this.topID = i.topID;
        this.baseID = i.baseID;
        this.discID = i.discID;
        this.text = i.text;
        this.analyst = i.analyst;
        this.source = i.source;
    }

    @Override
    public Color getStatus() {
        return this.status;
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    @Override
    public String statusString() {
        return this.toString();
    }

    public String toString() {
        if (this.text == null) {
            this.text = "";
        }
        String strg = this.text.replace('\n', '/');
        strg = strg.replace('\r', '/');
        return strg;
    }

    public void store(int interpID) throws SQLException {
        String sql;
        if (this.topSample == null) {
            return;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        if (this.status == PARTSTORED) {
            sql = "DELETE FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE usamp_id=" + this.topSample.getSampID() + " AND disc_id='" + this.discID + "'" + " AND analyst='" + this.analyst + "'";
            stmt.executeUpdate(this.SB.modQuery(sql));
            this.status = NOTSTORED;
        }
        if (this.status == NOTSTORED || this.status == PARTSTORED) {
            sql = "INSERT INTO " + this.SB.DBTableName("BCMMNTS") + " (usamp_id,lsamp_id,disc_id,analyst,comments,interp_id";
            if (this.SB.hasBiocomSource) {
                sql = sql + ",source";
            }
            sql = sql + ") VALUES (" + this.topSample.getSampID() + "," + (this.baseSample == null ? String.valueOf(this.topSample.getSampID()) : String.valueOf(this.baseSample.getSampID())) + ",'" + this.discID + "'" + ",'" + this.analyst + "'" + "," + util.SB.DBString(this.text) + "," + interpID;
            if (this.SB.hasBiocomSource) {
                sql = sql + "," + util.SB.DBString(this.source);
            }
            sql = sql + ")";
            stmt.executeUpdate(this.SB.modQuery(sql));
            this.status = STORED;
        }
        stmt.close();
    }

    void delete(int interpID) throws SQLException, SBException {
        if (this.topID == 0 && this.topSample != null) {
            this.topID = this.topSample.getSampID();
        }
        if (this.topID == 0) {
            throw new SBException("Cannot delete comment: " + this.toString() + ". Not in database");
        }
        String sql = "DELETE FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE usamp_id=" + this.topID + " AND disc_id='" + this.discID + "' ";
        sql = this.analyst.length() > 0 ? sql + "AND analyst='" + this.analyst + "' " : sql + " AND (analyst is null OR analyst='')";
        sql = sql + " AND " + IGDInterval.interpString(interpID, null);
        Statement stmt = this.SB.getDatabase().createStatement();
        int nDel = stmt.executeUpdate(this.SB.modQuery(sql));
        if (nDel == 0) {
            throw new SBException("Cannot delete comment: " + this.toString() + ". Top ID=" + this.topID);
        }
        stmt.close();
    }

    void updateStatus(List comments) throws SQLException, SBException {
        if (this.topSample != null) {
            this.topID = this.topSample.getSampID();
        }
        this.baseID = this.baseSample != null ? this.baseSample.getSampID() : this.topID;
        this.status = NOTSTORED;
        int nzTD = (int)Math.round(100.0 * this.topSample.getDepth('M'));
        for (Biocom comment : comments) {
            int cTD;
            if (comment == this) continue;
            if (this.topID != 0 && this.topID == comment.topID && this.discID == comment.discID && this.analyst.equals(comment.analyst)) {
                this.status = STORED;
                if (!util.SB.DBString(this.text).equalsIgnoreCase(util.SB.DBString(comment.text))) {
                    this.status = CONFLICT;
                }
                if (!this.SB.hasBiocomSource) break;
                if (this.source != null && !this.source.equals(comment.source)) {
                    this.status = CONFLICT;
                    break;
                }
                if (this.source != null || comment.source == null || comment.source.length() <= 0) break;
                this.status = CONFLICT;
                break;
            }
            if (this.discID != comment.discID || !this.analyst.equals(comment.analyst)) continue;
            int cBD = cTD = (int)Math.round(100.0 * comment.topSample.getDepth('M'));
            if (comment.baseSample != null) {
                cBD = (int)Math.round(100.0 * comment.baseSample.getDepth('M'));
            }
            if (nzTD == cTD && comment.topSample.getType().equals(this.topSample.getType())) {
                this.status = CONFLICT;
            }
            if (this.status != CONFLICT) continue;
            break;
        }
    }

    void writeDEX(FileWriter out, String eol) throws IOException, SBException {
        out.write("[BIOSTRATIGRAPHIC COMMENT " + this.topSample.toString() + "]" + eol);
        out.write("Discipline = " + SBdb.getDiscNoun(this.discID) + eol);
        out.write("Sample ID = " + this.topSample.getID() + eol);
        if (this.baseSample != null && this.baseSample.getID() != this.topSample.getID()) {
            out.write("Base Sample ID = " + this.baseSample.getID() + eol);
        }
        if (this.analyst != null && this.analyst.length() > 0) {
            out.write("Analyst = " + this.analyst + eol);
        }
        if (this.SB.hasBiocomSource && this.source != null && this.source.length() > 0) {
            out.write("Source = " + this.source + eol);
        }
        StringTokenizer tok = new StringTokenizer(this.text, "\n\r");
        while (tok.hasMoreTokens()) {
            out.write("Comment = " + tok.nextToken() + eol);
        }
        out.write(eol);
    }

    static int loadAll(SBdb SB2, HashMap<Integer, Well> wells, HashMap<Integer, InterpHdr> interpHdrs) throws SQLException {
        int nInserted = 0;
        String sql = "SELECT interp_id,usamp_id,lsamp_id,disc_id,analyst,comments";
        if (SB2.hasBiocomSource) {
            sql = sql + ",source";
        }
        sql = sql + " FROM " + SB2.DBTableName("BCMMNTS");
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            Biocom comment = new Biocom(SB2);
            int interpID = rs.getInt("interp_id");
            comment.topID = rs.getInt("usamp_id");
            comment.baseID = rs.getInt("lsamp_id");
            comment.discID = util.SB.getDBChar(rs, "disc_id");
            if (comment.baseID == comment.topID) {
                comment.baseID = 0;
            }
            comment.analyst = rs.getString("analyst");
            if (comment.analyst == null) {
                comment.analyst = "";
            }
            comment.text = rs.getString("comments");
            if (comment.text == null) {
                comment.text = "";
            }
            if (SB2.hasBiocomSource) {
                comment.source = rs.getString("source");
            }
            comment.status = STORED;
            Well well = wells.get(comment.topID / 65536);
            if (well == null) {
                System.out.println("Null well ID for comment: " + comment.discID + "," + comment.analyst + "," + comment.topID);
                continue;
            }
            try {
                WellInterp interp = well.getAddInterp(interpID, interpHdrs);
                comment.topSample = well.getSample(comment.topID);
                comment.baseSample = well.getSample(comment.baseID);
                interp.insertBiocom(comment);
                ++nInserted;
            }
            catch (SBException sbe) {
                System.out.println("Cannot insert biocom: " + comment.discID + "," + comment.analyst + "," + comment.topID + " " + sbe.getMessage());
            }
        }
        stmt.close();
        return nInserted;
    }
}

