/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import model1_8.CasingPoint;
import model1_8.SBException;
import model1_8.SBdb;

public class Casing
extends Observable {
    private SBdb SB;
    private ArrayList<CasingPoint> casing = new ArrayList();

    public Casing(SBdb SB2) {
        this.SB = SB2;
    }

    public int getSize() {
        return this.casing.size();
    }

    void clear() {
        this.casing.clear();
    }

    public SBdb getDataModel() {
        return this.SB;
    }

    public CasingPoint getCasingPoint(int row) {
        return this.casing.get(row);
    }

    public boolean add(CasingPoint casingPoint) throws SBException {
        this.casing.add(this.checkOverlap(casingPoint), casingPoint);
        this.setChanged();
        return true;
    }

    public int checkOverlap(CasingPoint casingPoint) throws SBException {
        Iterator<CasingPoint> it = this.casing.iterator();
        int insertPoint = 0;
        int lastDiamIndex = -1;
        int diamIndex = -1;
        try {
            diamIndex = this.SB.getCasingDiameters().indexOf(casingPoint.getDiameter());
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        int nzD = (int)(casingPoint.getDepth() * 100.0);
        while (it.hasNext()) {
            CasingPoint compareWith = it.next();
            try {
                lastDiamIndex = this.SB.getCasingDiameters().indexOf(compareWith.getDiameter());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            if (compareWith != casingPoint) {
                int cD = (int)(compareWith.getDepth() * 100.0);
                if (nzD == cD) {
                    throw new SBException("Casing point depth already exists: " + casingPoint.toString());
                }
                if (nzD < cD) {
                    if (diamIndex <= lastDiamIndex) break;
                    throw new SBException("Casing point not in descending diameter" + casingPoint);
                }
                ++insertPoint;
                continue;
            }
            return -1;
        }
        return insertPoint;
    }

    public void load(String wellCode) throws SQLException, SBException {
        this.casing.clear();
        String sql = "SELECT depth, diam FROM " + this.SB.DBTableName("casing") + " WHERE well_code='" + wellCode + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            double depth = rs.getDouble("depth");
            String diam = rs.getString("diam");
            CasingPoint casingPoint = new CasingPoint(depth, diam);
            casingPoint.status = CasingPoint.STORED;
            try {
                this.add(casingPoint);
            }
            catch (SBException e) {
                System.out.println("Error adding casing point: " + e.getMessage());
            }
        }
        stmt.close();
        this.setChanged();
    }

    public void deleteAll(String wellCode) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("casing") + " WHERE well_code='" + wellCode + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    public void delete(String wellCode, CasingPoint point) throws SQLException, SBException {
        String sql = "DELETE FROM " + this.SB.DBTableName("casing") + " WHERE well_code='" + wellCode + "'" + " AND depth > " + (point.getDepth() - 0.01) + " AND depth < " + (point.getDepth() + 0.01);
        Statement stmt = this.SB.getDatabase().createStatement();
        int nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        if (nRows < 1) {
            throw new SBException("Failed to delete casing point at depth: " + point.getDepth());
        }
        this.casing.remove(point);
        this.setChanged();
    }

    void setIntervalStatus(Color status) {
        Iterator<CasingPoint> it = this.casing.iterator();
        while (it.hasNext()) {
            it.next().status = status;
        }
    }

    public void store(String wellCode) throws SQLException {
        Iterator<CasingPoint> it = this.casing.iterator();
        boolean refresh = false;
        while (it.hasNext()) {
            if (it.next().status != CasingPoint.NOTSTORED) continue;
            refresh = true;
            break;
        }
        if (!refresh) {
            return;
        }
        this.deleteAll(wellCode);
        for (CasingPoint point : this.casing) {
            point.status = CasingPoint.NOTSTORED;
            point.store(this.SB, wellCode);
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        Iterator<CasingPoint> it = this.casing.iterator();
        while (it.hasNext()) {
            it.next().writeDEX(out, eol, units);
        }
    }
}

