/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import model1_8.Casing;
import model1_8.SBdb;
import util.SB;
import util.SbugsStatus;

public class CasingPoint
implements SbugsStatus {
    private double depth;
    private String diameter = "";
    Color status = SbugsStatus.UNKNOWN;

    public CasingPoint(double depth, String diameter) {
        this.depth = depth;
        this.setDiameter(diameter);
        this.status = NOTSTORED;
    }

    public CasingPoint(CasingPoint rhs) {
        this.copy(rhs);
    }

    public void copy(CasingPoint rhs) {
        this.depth = rhs.depth;
        this.diameter = rhs.diameter;
    }

    public double getDepth() {
        return this.depth;
    }

    public String getDiameter() {
        return this.diameter;
    }

    public String toString() {
        if (!this.diameter.endsWith("in") && !this.diameter.endsWith("\"")) {
            return this.diameter + "in";
        }
        return this.diameter;
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    public String statusString() {
        return this.toString();
    }

    public Color getStatus() {
        return this.status;
    }

    public void store(SBdb SB2, String wellCode) throws SQLException {
        if (this.status == NOTSTORED) {
            String diamString = this.diameter;
            if (diamString.endsWith("in")) {
                diamString = diamString.substring(0, diamString.length() - 2);
            }
            if (diamString.endsWith("\"")) {
                diamString = diamString.substring(0, diamString.length() - 1);
            }
            String sql = "INSERT INTO " + SB2.DBTableName("CASING") + " (well_code,depth,diam) VALUES ('" + wellCode + "'," + this.depth + ",'" + diamString + "')";
            Statement stmt = SB2.getDatabase().createStatement();
            stmt.executeUpdate(SB2.modQuery(sql));
            stmt.close();
            this.status = STORED;
        }
    }

    public void delete(SBdb SB2, String wellCode) throws SQLException {
        String sql = "DELETE FROM " + SB2.DBTableName("CASING") + " WHERE well_code='" + wellCode + "' AND depth > " + (this.depth - 0.01) + " AND depth < " + (this.depth + 0.01);
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        this.status = NOTSTORED;
        stmt.close();
    }

    public void updateStatus(Casing oldData) {
        int nzD = (int)(this.depth * 100.0);
        this.status = NOTSTORED;
        for (int i = 0; i < oldData.getSize(); ++i) {
            int cD;
            CasingPoint casingPoint = oldData.getCasingPoint(i);
            if (casingPoint == this || (cD = (int)(casingPoint.depth * 100.0)) != nzD) continue;
            this.status = STORED;
            if (this.diameter.equalsIgnoreCase(casingPoint.diameter)) continue;
            this.status = CONFLICT;
            break;
        }
    }

    private void setDiameter(String diam) {
        if (diam != null) {
            this.diameter = (diam = diam.trim().toLowerCase()).endsWith("in") ? diam.substring(0, diam.length() - 2) : (diam.endsWith("\"") ? diam.substring(0, diam.length() - 1) : diam);
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        out.write("[CASING " + SB.getDepthString(this.depth, units, 2).trim() + "]" + eol);
        out.write("Depth = " + SB.getDepthString(this.depth, units, 2) + eol);
        out.write("Diameter = " + this.diameter);
        if (this.diameter.indexOf("in") < 0 && this.diameter.indexOf("\"") < 0) {
            out.write("in");
        }
        out.write(eol + eol);
    }
}

