/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Observable;
import java.util.TreeMap;
import javax.swing.JComboBox;
import model1_8.Category;
import model1_8.SBdb;
import util.SB;

public class Categories
extends Observable {
    boolean generaCounted = false;
    TreeMap<String, Category> cats = new TreeMap();

    public Categories(SBdb SB2) throws SQLException {
        String sql = "SELECT disc_id, cat_mnem, cat_name from ";
        sql = sql + SB2.DBTableName("category") + " ORDER BY cat_mnem";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            char discID = SB.getDBChar(rs, "disc_id");
            String mnem = rs.getString("cat_mnem");
            String name = rs.getString("cat_name");
            String temp = "";
            temp = temp + name.charAt(0);
            name = name.toLowerCase();
            name = temp = temp + name.substring(1);
            Category cat = new Category(discID, mnem, name);
            this.cats.put(cat.getMnem(), cat);
        }
        stmt.close();
        this.loadColours(SB2);
    }

    void loadColours(SBdb SB2) throws SQLException {
        PreparedStatement pStmt = SB2.getDatabase().prepareStatement(SB2.modQuery("SELECT red,green,blue FROM " + SB2.DBTableName("CATCOL") + " WHERE ABR=?"));
        for (Category cat : this.cats.values()) {
            SB2.modQuery("Executing prepared statement for category '" + cat.getMnem() + "'");
            pStmt.setString(1, cat.getMnem());
            ResultSet rs = pStmt.executeQuery();
            if (!rs.next()) continue;
            cat.setColour(new Color(rs.getInt("red"), rs.getInt("green"), rs.getInt("blue")));
        }
    }

    public Category add(SBdb SB2, String mnem, char discID, String name) throws SQLException {
        String sql = "INSERT INTO " + SB2.DBTableName("category") + " (disc_id, cat_mnem, cat_name) VALUES (";
        sql = sql + SB.DBChar(discID) + "," + SB.DBString(mnem) + "," + SB.DBString(name) + ")";
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
        Category cat = new Category(discID, mnem, name);
        this.insert(cat);
        this.setChanged();
        return cat;
    }

    public void insert(Category cat) {
        this.cats.put(cat.getMnem(), cat);
    }

    public Category getCategory(String mnem) {
        return this.cats.get(mnem);
    }

    public Iterator getIterator() {
        return this.cats.values().iterator();
    }

    public void loadGenOcc(SBdb SB2) throws SQLException {
        for (Category cat : this.cats.values()) {
            cat.nGenera = 0;
        }
        String sql = "SELECT cat_mnem, count(cat_mnem) AS genera FROM " + SB2.DBTableName("genus") + " GROUP BY (cat_mnem) ORDER BY (cat_mnem)";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            String mnem = rs.getString("cat_mnem");
            int genera = rs.getInt("genera");
            Category cat = this.getCategory(mnem);
            if (cat == null) {
                cat = this.add(SB2, mnem, 'P', "NO NAME category " + mnem);
            }
            cat.nGenera = genera;
        }
        this.generaCounted = true;
    }

    public void fillCombo(JComboBox combo, boolean mnemOnly, char discID) {
        for (Category cat : this.cats.values()) {
            if (discID != '\u0000' && cat.getDiscID() != discID) continue;
            String item = cat.getMnem();
            if (!mnemOnly) {
                while (item.length() < 10) {
                    item = item + " ";
                }
                item = item + cat.getName();
            }
            combo.addItem(item);
        }
        combo.insertItemAt("", 0);
    }

    public void setSelection(JComboBox combo, String cat_mnem, char discID) {
        int index = 0;
        for (Category cat : this.cats.values()) {
            if (discID != '\u0000' && cat.getDiscID() != discID) continue;
            if (cat.getMnem().equals(cat_mnem)) {
                combo.setSelectedIndex(index + 1);
                return;
            }
            ++index;
        }
        combo.setSelectedIndex(0);
    }

    public String getCatmnem(JComboBox combo) {
        String cat_mnem = (String)combo.getSelectedItem();
        if ((cat_mnem = cat_mnem.trim()).length() > 0) {
            cat_mnem = cat_mnem.substring(0, cat_mnem.indexOf(32));
        }
        return cat_mnem;
    }

    public char getDiscID(String cat_mnem) {
        for (Category cat : this.cats.values()) {
            if (!cat.getMnem().equals(cat_mnem)) continue;
            return cat.getDiscID();
        }
        return '\u0000';
    }

    public String getName(String cat_mnem) {
        Category cat = this.cats.get(cat_mnem);
        if (cat == null) {
            return "";
        }
        return cat.getName();
    }

    public boolean exists(String cat_mnem) {
        return this.cats.get(cat_mnem) != null;
    }
}

