/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import model1_8.SBdb;
import model1_8.Taxon;
import util.SB;

public class Category {
    private char discID;
    private String mnem;
    private String name;
    private Color colour;
    int nGenera;

    public char getDiscID() {
        return this.discID;
    }

    public String getMnem() {
        return this.mnem;
    }

    public String getName() {
        return this.name;
    }

    public Category(char discID, String mnem, String name) {
        this.discID = discID;
        this.mnem = mnem;
        this.name = name;
        this.colour = Color.BLACK;
    }

    public void setColour(Color colour) {
        this.colour = colour;
    }

    public Color getColour() {
        return this.colour;
    }

    public String toString() {
        return this.mnem;
    }

    public void storeColour(SBdb SB2) throws SQLException {
        String sql = "UPDATE " + SB2.DBTableName("catcol") + " SET red=" + this.colour.getRed() + ",green=" + this.colour.getGreen() + ",blue=" + this.colour.getBlue() + " WHERE ABR=" + SB.DBString(this.mnem);
        Statement stmt = SB2.getDatabase().createStatement();
        if (stmt.executeUpdate(SB2.modQuery(sql)) < 1) {
            sql = "INSERT INTO " + SB2.DBTableName("catcol") + " (abr,red,green,blue) VALUES (" + SB.DBString(this.mnem) + "," + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + ")";
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        stmt.close();
    }

    public int checkOcc(SBdb SB2) throws SQLException {
        String sql = "SELECT count(f.spec_id) AS spec_id FROM " + SB2.DBTableName("genus") + " g, " + SB2.DBTableName("species") + " s," + SB2.DBTableName("fssabnd") + " f " + " WHERE g.cat_mnem=" + SB.DBString(this.mnem) + " AND g.gen_id=s.gen_id AND s.spec_id=f.spec_id";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        int count = 0;
        if (rs.next()) {
            count = rs.getInt("spec_id");
        }
        stmt.close();
        return count;
    }

    public void update(SBdb SB2, String mnem, char discID, String name) throws SQLException {
        String sql;
        Statement stmt = SB2.getDatabase().createStatement();
        if (!mnem.equals(this.mnem)) {
            sql = "UPDATE " + SB2.DBTableName("genus") + " SET cat_mnem=" + SB.DBString(mnem) + " WHERE cat_mnem=" + SB.DBString(mnem);
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "UPDATE " + SB2.DBTableName("catcol") + " SET abr=" + SB.DBString(mnem) + " WHERE abr=" + SB.DBString(mnem);
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        sql = "UPDATE " + SB2.DBTableName("category") + " SET disc_id=" + SB.DBChar(discID) + ", cat_mnem=" + SB.DBString(mnem) + ",cat_name=" + SB.DBString(name) + " WHERE cat_mnem=" + SB.DBString(mnem);
        stmt.executeUpdate(SB2.modQuery(sql));
        this.discID = discID;
        this.mnem = mnem;
        this.name = name;
        stmt.close();
    }

    public int checkEvents(SBdb SB2) throws SQLException {
        String sql = "SELECT count(e.spec_id) AS spec_id FROM " + SB2.DBTableName("genus") + " g, " + SB2.DBTableName("species") + " s," + SB2.DBTableName("eventdic") + " e " + " WHERE g.cat_mnem=" + SB.DBString(this.mnem) + " AND g.gen_id=s.gen_id AND s.spec_id=e.spec_id";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        int count = 0;
        if (rs.next()) {
            count = rs.getInt("spec_id");
        }
        stmt.close();
        return count;
    }

    public void delete(SBdb SB2, Hashtable taxa) throws SQLException {
        String sql = "SELECT spec_id FROM " + SB2.DBTableName("genus") + " g, " + SB2.DBTableName("species") + " s WHERE g.cat_mnem=" + SB.DBString(this.mnem) + " AND g.gen_id=s.gen_id";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        LinkedList<Integer> specIDs = new LinkedList<Integer>();
        while (rs.next()) {
            int specID = rs.getInt("spec_id");
            if (taxa != null) {
                taxa.remove("H" + specID);
            }
            specIDs.add(new Integer(specID));
        }
        if (specIDs.size() > 0) {
            Taxon.deleteSpecies(SB2, specIDs, true, null);
            Iterator it = specIDs.iterator();
            sql = "DELETE FROM " + SB2.DBTableName("fssabnd") + " WHERE spec_id=?";
            PreparedStatement pStmt = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
            while (it.hasNext()) {
                pStmt.setInt(1, (Integer)it.next());
                pStmt.executeUpdate();
            }
            pStmt.close();
            it = specIDs.iterator();
            sql = "UPDATE " + SB2.DBTableName("eventdic") + " SET spec_id=0, generate='N' WHERE spec_id=?";
            pStmt = SB2.getDatabase().prepareStatement(SB2.modQuery(sql));
            while (it.hasNext()) {
                pStmt.setInt(1, (Integer)it.next());
                pStmt.executeUpdate();
            }
            pStmt.close();
        }
        sql = "DELETE FROM " + SB2.DBTableName("genus") + " WHERE cat_mnem=" + SB.DBString(this.mnem);
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("category") + " WHERE cat_mnem=" + SB.DBString(this.mnem);
        stmt.executeUpdate(SB2.modQuery(sql));
    }
}

