/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import model1_8.CompositeStandardEvent;
import model1_8.SBEvent;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Taxon;
import util.SB;
import util.SbugsStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeStandard
implements SbugsStatus {
    SBdb SB;
    private int stdID = 0;
    private List<CompositeStandardEvent> events = new LinkedList<CompositeStandardEvent>();
    private String name = null;
    String donorName = "";
    private double top = 0.0;
    private double base = 0.0;
    private String units = "";
    private Date created;
    private String creator;
    Color status = UNKNOWN;
    boolean isFiltered = false;

    public CompositeStandard(SBdb SB2) {
        this.SB = SB2;
    }

    @Override
    public Color getStatus() {
        return this.status;
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    @Override
    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.name;
    }

    public CompositeStandard(SBdb SB2, String name, boolean loadIt) throws SQLException, SBException {
        this.name = name;
        this.SB = SB2;
        String sql = "SELECT std_id,creator,created,topcsu,basecsu,units FROM " + SB2.DBTableName("CMPSTD") + " WHERE ucase(name)='" + name + "'";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            this.status = STORED;
            this.stdID = rs.getInt("std_id");
            this.creator = rs.getString("creator");
            this.created = rs.getTimestamp("created");
            this.top = rs.getDouble("topcsu");
            this.base = rs.getDouble("basecsu");
            this.units = rs.getString("units");
        }
        stmt.close();
        if (loadIt) {
            this.load();
        }
    }

    public CompositeStandard(SBdb SB2, int id, boolean loadIt, Hashtable taxa) throws SQLException, SBException {
        this.stdID = id;
        this.SB = SB2;
        String sql = "SELECT name,creator,created,topcsu,basecsu,units FROM " + SB2.DBTableName("CMPSTD") + " WHERE std_id=" + this.stdID;
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            this.status = STORED;
            this.name = rs.getString("name");
            this.creator = rs.getString("creator");
            this.created = rs.getTimestamp("created");
            this.top = rs.getDouble("topcsu");
            this.base = rs.getDouble("basecsu");
            this.units = rs.getString("units");
        }
        stmt.close();
        if (loadIt) {
            this.load();
        }
    }

    void fillTaxa(Hashtable taxa) throws SQLException, SBException {
        for (SBEvent sBEvent : this.events) {
            if (sBEvent.getTaxon() != null || sBEvent.getSpecID() <= 0) continue;
            Taxon taxon = (Taxon)taxa.get("H" + sBEvent.getSpecID());
            if (taxon == null) {
                taxon = new Taxon(this.SB, sBEvent.getSpecID());
                taxa.put("H" + sBEvent.getSpecID(), taxon);
            }
            sBEvent.setTaxon(taxon);
        }
    }

    public double getAge(int evID, char evType) {
        for (CompositeStandardEvent event : this.events) {
            if (event.getEvID() != evID || evType != event.getEvType()) continue;
            return event.getCsu();
        }
        return -1.0;
    }

    public double getSpecAge(int specID, char evType) {
        for (CompositeStandardEvent event : this.events) {
            if (event.getEvent().getSpecID() != specID || !event.getEvent().isGenerate() || evType != event.getEvType()) continue;
            return event.getCsu();
        }
        return 0.0;
    }

    void sort(int sort) {
        CompositeStandardEvent.sort(this.events, sort);
    }

    void filterEvents(double minAge, double maxAge) {
        Iterator<CompositeStandardEvent> it = this.events.iterator();
        while (it.hasNext()) {
            CompositeStandardEvent event = it.next();
            if (!(event.getCsu() < minAge) && !(event.getCsu() > maxAge)) continue;
            it.remove();
            this.isFiltered = true;
        }
    }

    public void load() throws SQLException, SBException {
        if (this.stdID == 0 || this.events.size() > 0) {
            return;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "SELECT ev_id,ev_type,csu FROM " + this.SB.DBTableName("CMPSTDEV") + " WHERE std_id=" + this.stdID + " ORDER BY ev_id";
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            int evID = rs.getInt("ev_id");
            char evType = util.SB.getDBChar(rs, "ev_type");
            SBEvent sbEvent = this.SB.getSBEvent(evID);
            if (sbEvent.getEvID() <= 0) continue;
            CompositeStandardEvent event = new CompositeStandardEvent(this.SB, sbEvent, rs.getDouble("csu"), evType);
            this.events.add(event);
        }
        stmt.close();
    }

    void save() throws SQLException, SBException {
        if (this.stdID != 0) {
            int savedID = this.stdID;
            this.delete();
            this.stdID = savedID;
        } else {
            this.stdID = this.SB.nextControl("STD_ID");
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        this.created = new Date();
        this.creator = this.SB.user.getUsrID();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String sql = "INSERT INTO " + this.SB.DBTableName("CMPSTD") + " (std_id,name,creator,created,topcsu,basecsu,units) VALUES (" + this.stdID + ",'" + this.name + "','" + this.creator + "','" + df.format(this.created) + "'," + this.top + "," + this.base + ",'" + this.units + "')";
        stmt.executeUpdate(this.SB.modQuery(sql));
        for (CompositeStandardEvent event : this.events) {
            sql = "INSERT INTO " + this.SB.DBTableName("CMPSTDEV") + " (std_id,ev_id,ev_type,csu) VALUES (" + this.stdID + "," + event.getEvID() + "," + event.getEvType() + "," + event.getCsu() + ")";
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        stmt.close();
    }

    static CompositeStandard get(SBdb db, int stdID, List stds) throws SQLException, SBException {
        Iterator it = stds.iterator();
        CompositeStandard std = null;
        while (it.hasNext()) {
            std = (CompositeStandard)it.next();
            if (std.stdID != stdID) continue;
            return std;
        }
        std = new CompositeStandard(db, stdID, false, null);
        stds.add(std);
        return std;
    }

    static void load(SBdb SB2, List stds) throws SQLException, SBException {
        String sql = "SELECT std_id,name,creator,created,topcsu,basecsu,units FROM " + SB2.DBTableName("CMPSTD") + " ORDER BY name";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int id = rs.getInt("std_id");
            if (CompositeStandard.get(SB2, id, stds) != null) continue;
            CompositeStandard std = new CompositeStandard(SB2);
            std.status = STORED;
            std.name = rs.getString("name");
            std.creator = rs.getString("creator");
            std.created = rs.getTimestamp("created");
            std.top = rs.getDouble("topcsu");
            std.base = rs.getDouble("basecsu");
            std.units = rs.getString("units");
            stds.add(std);
        }
        stmt.close();
    }

    static CompositeStandard getHostFromDonor(String donorName, List stds) {
        Iterator it = stds.iterator();
        CompositeStandard std = null;
        while (it.hasNext()) {
            std = (CompositeStandard)it.next();
            if (!std.donorName.equalsIgnoreCase(donorName)) continue;
            return std;
        }
        return null;
    }

    void delete() throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "DELETE from " + this.SB.DBTableName("CMPSTD") + " WHERE std_id=" + this.stdID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE from " + this.SB.DBTableName("CMPSTDEV") + " WHERE std_id=" + this.stdID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        this.stdID = 0;
        this.status = NOTSTORED;
    }

    public int getStdID() {
        return this.stdID;
    }

    public List<CompositeStandardEvent> getEventsByCSU(boolean isIncreasing) {
        if (isIncreasing) {
            this.sort(2);
        } else {
            this.sort(1);
        }
        return this.events;
    }

    public List<CompositeStandardEvent> getEventsByAlpha() {
        this.sort(0);
        return this.events;
    }

    public List getEvents() {
        return this.events;
    }

    public String getName() {
        return this.name;
    }

    public double getTop() {
        return this.top;
    }

    public double getBase() {
        return this.base;
    }

    public String getUnits() {
        return this.units;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getCreator() {
        return this.creator;
    }
}

