/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import model1_8.Cores;
import model1_8.SBException;
import model1_8.SBdb;
import util.SB;
import util.SbugsStatus;

public class CoredInterval
implements SbugsStatus {
    private double topDepth;
    private double baseDepth;
    private String corenum = "";
    private boolean recovered = true;
    private double deltaTop;
    private double deltaBase;
    private boolean deltaData = false;
    Color status = UNKNOWN;

    public CoredInterval(double top, double base, String corenum, boolean recovered, double deltaTop, double deltaBase, boolean deltaData) {
        this.topDepth = top;
        this.baseDepth = base;
        this.recovered = recovered;
        this.corenum = corenum;
        this.deltaTop = deltaTop;
        this.deltaBase = deltaBase;
        this.deltaData = deltaData;
    }

    public CoredInterval(CoredInterval rhs) {
        this.copy(rhs);
    }

    public void copy(CoredInterval rhs) {
        this.topDepth = rhs.topDepth;
        this.baseDepth = rhs.baseDepth;
        this.recovered = rhs.recovered;
        this.corenum = rhs.corenum;
        this.deltaTop = rhs.deltaTop;
        this.deltaBase = rhs.deltaBase;
        this.deltaData = rhs.deltaData;
    }

    public double getTopDepth() {
        return this.topDepth;
    }

    public double getBaseDepth() {
        return this.baseDepth;
    }

    public String getCorenum() {
        return this.corenum;
    }

    public boolean getRecovered() {
        return this.recovered;
    }

    public double getDeltaTop() {
        return this.deltaTop;
    }

    public double getDeltaBase() {
        return this.deltaBase;
    }

    public boolean getDeltaData() {
        return this.deltaData;
    }

    public String toString() {
        if (this.corenum == null) {
            if (this.recovered) {
                return "(no number)";
            }
            return "(unrecovered)";
        }
        return this.corenum;
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    public String statusString() {
        return this.toString();
    }

    public Color getStatus() {
        return this.status;
    }

    public void store(SBdb SB2, String wellCode) throws SQLException {
        if (this.status == NOTSTORED || this.status == UNKNOWN) {
            String sql = "INSERT INTO " + SB2.DBTableName("CORES") + " (well_code,top_depth,base_depth,corenum,recovered,d_top,d_base,d_data) VALUES ('" + wellCode + "'," + this.topDepth + "," + this.baseDepth + ",'" + this.corenum + "','" + (this.recovered ? (char)'Y' : 'N') + "'," + this.deltaTop + "," + this.deltaBase + ",'" + (this.deltaData ? (char)'Y' : 'N') + "')";
            Statement stmt = SB2.getDatabase().createStatement();
            stmt.executeUpdate(SB2.modQuery(sql));
            stmt.close();
            this.status = STORED;
        }
    }

    public void delete(SBdb SB2, String wellCode) throws SQLException, SBException {
        String sql = "DELETE FROM " + SB2.DBTableName("CORES") + " WHERE well_code='" + wellCode + "' AND top_depth > " + (this.topDepth - 0.01) + " AND top_depth < " + (this.topDepth + 0.01);
        Statement stmt = SB2.getDatabase().createStatement();
        int rows = stmt.executeUpdate(SB2.modQuery(sql));
        this.status = NOTSTORED;
        stmt.close();
        if (rows != 1) {
            throw new SBException("Error deleting core: " + this + ", nRows=" + rows);
        }
    }

    public void updateStatus(Cores oldData) {
        Iterator it = oldData.getIterator();
        if (this.corenum == null) {
            this.corenum = "";
        }
        int nzTD = (int)(this.topDepth * 100.0);
        int nzBD = (int)(this.baseDepth * 100.0);
        this.status = NOTSTORED;
        while (it.hasNext()) {
            CoredInterval core = (CoredInterval)it.next();
            if (core.corenum == null) {
                core.corenum = "";
            }
            if (core == this) continue;
            int cTD = (int)(core.topDepth * 100.0);
            int cBD = (int)(core.baseDepth * 100.0);
            if (cTD == nzTD && cBD == nzBD) {
                this.status = STORED;
                if (!this.corenum.equalsIgnoreCase(core.corenum)) {
                    this.status = CONFLICT;
                }
                if (this.recovered != core.recovered) {
                    this.status = CONFLICT;
                }
                if (this.deltaData && !core.deltaData) {
                    this.status = PARTSTORED;
                    break;
                }
                if (!this.deltaData || !core.deltaData) break;
                if ((int)(this.deltaTop * 100.0) != (int)(core.deltaTop * 100.0)) {
                    this.status = CONFLICT;
                }
                if ((int)(this.deltaBase * 100.0) == (int)(core.deltaBase * 100.0)) break;
                this.status = CONFLICT;
                break;
            }
            try {
                SB.checkOverlap(nzTD, nzBD, cTD, cBD);
            }
            catch (util.SBException sbe) {
                this.status = CONFLICT;
            }
            if (this.status != CONFLICT) continue;
            break;
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        out.write("[CORE " + SB.getDepthString(this.topDepth, units, 2).trim() + " - " + SB.getDepthString(this.baseDepth, units, 2).trim() + "]" + eol);
        if (this.corenum != null) {
            out.write("Core number = " + this.corenum + eol);
        }
        out.write("Recovered = ");
        if (this.recovered) {
            out.write("yes");
        } else {
            out.write("no");
        }
        out.write(eol);
        out.write("Top depth = " + SB.getDepthString(this.topDepth, units, 2).trim() + eol);
        out.write("Base depth = " + SB.getDepthString(this.baseDepth, units, 2).trim() + eol);
        if (Math.abs(this.deltaTop) > 0.0) {
            out.write("Top depth correction = " + SB.getDepthString(this.deltaTop, units, 2).trim() + eol);
        }
        if (Math.abs(this.deltaBase) > 0.0) {
            out.write("Base depth correction = " + SB.getDepthString(this.deltaBase, units, 2).trim() + eol);
        }
        out.write(eol);
    }
}

