/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import model1_8.CoredInterval;
import model1_8.SBException;
import model1_8.SBdb;
import util.SB;

public class Cores
extends Observable {
    private SBdb SB;
    private List<CoredInterval> cores = new ArrayList<CoredInterval>();

    public Cores(SBdb SB2) {
        this.SB = SB2;
    }

    public int getSize() {
        return this.cores.size();
    }

    public void clear() {
        this.cores.clear();
    }

    Iterator getIterator() {
        return this.cores.iterator();
    }

    public CoredInterval getCore(int index) {
        return this.cores.get(index);
    }

    public boolean add(CoredInterval core) throws SBException {
        if (this.cores.contains(core)) {
            return false;
        }
        int insertPoint = this.checkOverlap(null, core);
        this.cores.add(insertPoint, core);
        this.setChanged();
        return true;
    }

    public int checkOverlap(CoredInterval original, CoredInterval core) throws SBException {
        Iterator<CoredInterval> it = this.cores.iterator();
        int insertPoint = 0;
        int nzTD = (int)(core.getTopDepth() * 100.0);
        int nzBD = (int)(core.getBaseDepth() * 100.0);
        while (it.hasNext()) {
            CoredInterval compareWith = it.next();
            if (compareWith == original) continue;
            int cTD = (int)(compareWith.getTopDepth() * 100.0);
            int cBD = (int)(compareWith.getBaseDepth() * 100.0);
            try {
                util.SB.checkOverlap(nzTD, nzBD, cTD, cBD);
            }
            catch (util.SBException ex) {
                throw new SBException("Error inserting cored interval: " + ex.getMessage() + " core " + core);
            }
            if (nzTD < cTD) break;
            ++insertPoint;
        }
        return insertPoint;
    }

    public void load(String wellCode) throws SQLException, SBException {
        this.cores.clear();
        String sql = "SELECT top_depth, base_depth, corenum, recovered, d_top, d_base, d_data FROM " + this.SB.DBTableName("CORES") + " WHERE well_code='" + wellCode + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            double topDepth = rs.getDouble("top_depth");
            double baseDepth = rs.getDouble("base_depth");
            String corenum = rs.getString("corenum");
            if (corenum == null) {
                corenum = "";
            }
            String strg = rs.getString("recovered");
            boolean recovered = true;
            if (strg != null && strg.charAt(0) == 'N') {
                recovered = false;
            }
            double deltaTop = rs.getDouble("d_top");
            double deltaBase = rs.getDouble("d_base");
            strg = rs.getString("d_data");
            boolean deltaData = false;
            if (strg != null && strg.charAt(0) == 'Y') {
                deltaData = true;
            }
            CoredInterval core = new CoredInterval(topDepth, baseDepth, corenum, recovered, deltaTop, deltaBase, deltaData);
            this.add(core);
        }
        stmt.close();
        this.notifyObservers();
    }

    public static void deleteAll(SBdb SB2, String wellCode) throws SQLException {
        String sql = "DELETE FROM " + SB2.DBTableName("CORES") + " WHERE well_code='" + wellCode + "'";
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
    }

    public void delete(SBdb SB2, String wellCode, CoredInterval core) throws SQLException, SBException {
        core.delete(SB2, wellCode);
        this.cores.remove(core);
        this.setChanged();
    }

    public void store(String wellCode) throws SQLException {
        Iterator<CoredInterval> it = this.cores.iterator();
        boolean refresh = false;
        while (it.hasNext()) {
            if (it.next().status != CoredInterval.NOTSTORED) continue;
            refresh = true;
            break;
        }
        if (!refresh) {
            return;
        }
        Cores.deleteAll(this.SB, wellCode);
        it = this.cores.iterator();
        while (it.hasNext()) {
            it.next().store(this.SB, wellCode);
        }
    }

    void setIntervalStatus(Color status) {
        Iterator<CoredInterval> it = this.cores.iterator();
        while (it.hasNext()) {
            it.next().status = status;
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        Iterator<CoredInterval> it = this.cores.iterator();
        while (it.hasNext()) {
            it.next().writeDEX(out, eol, units);
        }
    }
}

