/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import javax.swing.JComboBox;
import model1_8.SBException;
import model1_8.SBdb;
import util.SB;
import util.SbugsStatus;

public class EnvScheme
extends Observable
implements SbugsStatus,
Comparable {
    SBdb SB;
    static final int MAXCLASSES = 20;
    private int ID;
    int donorID;
    private String name;
    private String[] term = new String[20];
    private Color[] colour = new Color[20];
    private int nClasses = 0;
    final String NOTERMTEXT = "<no term>";
    Color status = UNKNOWN;

    EnvScheme(SBdb SB2) {
        this.SB = SB2;
    }

    public EnvScheme() {
    }

    public Color getColour(int number) {
        return this.colour[number - 1];
    }

    public EnvScheme(EnvScheme rhs) {
        this.name = rhs.name;
        this.ID = rhs.ID;
        this.donorID = rhs.donorID;
        this.nClasses = rhs.nClasses;
        for (int i = 0; i < this.nClasses; ++i) {
            this.term[i] = rhs.term[i];
            this.colour[i] = rhs.colour[i];
        }
    }

    public int compareTo(Object rhs) {
        return this.name.compareTo(rhs.toString());
    }

    public void copy(EnvScheme rhs) {
        this.name = rhs.name;
        this.ID = rhs.ID;
        this.donorID = rhs.donorID;
        this.nClasses = rhs.nClasses;
        for (int i = 0; i < this.nClasses; ++i) {
            this.term[i] = rhs.term[i];
            this.colour[i] = rhs.colour[i];
        }
    }

    public boolean match(EnvScheme rhs) {
        if (this.nClasses != rhs.nClasses) {
            return false;
        }
        for (int i = 0; i < this.nClasses; ++i) {
            if (this.term[i].equals(rhs.term[i])) continue;
            return false;
        }
        return true;
    }

    public Color getStatus() {
        return this.status;
    }

    public String statusString() {
        return this.name;
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    public String toString() {
        if (this.name.length() == 0) {
            if (this.ID != 0) {
                return "Scheme ID no. " + this.ID;
            }
            return "Donor scheme no. " + this.donorID;
        }
        if (this.ID == 0 && this.donorID != 0) {
            return "Donor scheme: " + this.donorID + " : " + this.name;
        }
        return this.name;
    }

    EnvScheme(SBdb SB2, int iID) throws SQLException {
        this.SB = SB2;
        String sql = "SELECT name FROM " + SB2.DBTableName("ENV_SCH") + " WHERE envid=" + iID;
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            this.ID = iID;
            this.name = util.SB.getDBString(rs, "name");
            rs.close();
            for (int i = 0; i < 20; ++i) {
                sql = "SELECT term_" + (i + 1) + ",c" + (i + 1) + " FROM " + SB2.DBTableName("ENV_SCH") + " WHERE envid=" + iID;
                rs = stmt.executeQuery(SB2.modQuery(sql));
                if (!rs.next()) continue;
                this.term[i] = util.SB.getDBString(rs, "term_" + (i + 1));
                if (this.term[i] == null || this.term[i].length() == 0) break;
                this.colour[i] = util.SB.getSBColorFromInt(rs.getInt("c" + (i + 1)));
                this.nClasses = i + 1;
            }
        }
        stmt.close();
    }

    public void insertRow(int insertPoint) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to update env scheme");
        }
        for (int i = this.nClasses; i > insertPoint; --i) {
            this.term[i] = this.term[i - 1];
            this.colour[i] = this.colour[i - 1];
        }
        this.term[insertPoint] = "";
        this.colour[insertPoint] = Color.CYAN;
        ++this.nClasses;
    }

    public void addRow() throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to update env scheme");
        }
        if (this.nClasses >= 20) {
            throw new SBException("Maxiumum number of classes reached");
        }
        this.term[this.nClasses] = "";
        this.colour[this.nClasses] = Color.CYAN;
        ++this.nClasses;
    }

    public void setTerm(int row, String term) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to update env scheme");
        }
        if (row > this.nClasses) {
            throw new SBException("Attempt to update env scheme row: " + row + " outside range: " + this.nClasses);
        }
        this.term[row] = term;
    }

    public void setColour(int row, Color colour) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to update env scheme");
        }
        if (row > this.nClasses) {
            throw new SBException("Attempt to update env scheme row: " + row + " outside range: " + this.nClasses);
        }
        this.colour[row] = colour;
    }

    public void deleteRow(int deletePoint) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to update env scheme");
        }
        for (int i = deletePoint; i < this.nClasses; ++i) {
            this.term[i] = this.term[i + 1];
            this.colour[i] = this.colour[i + 1];
        }
        --this.nClasses;
    }

    public boolean checkNameUnique() throws SQLException {
        String sql = "SELECT envid FROM " + this.SB.DBTableName("ENV_SCH") + " WHERE ucase(name)='" + this.name.toUpperCase() + "'";
        if (this.ID != 0) {
            sql = sql + " AND envid <> " + this.ID;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        boolean unique = true;
        if (rs.next()) {
            unique = false;
        }
        stmt.close();
        return unique;
    }

    public int getNoccs() throws SQLException {
        String sql = "SELECT count(sch_id) as nOcc FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE sch_id=" + this.ID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        int nOccs = 0;
        if (rs.next()) {
            nOccs = rs.getInt("nOcc");
        }
        return nOccs;
    }

    public List getOccs() throws SQLException {
        String sql = "SELECT DISTINCT w.well_name,v.code FROM " + this.SB.DBTableName("IGD_ENV") + " i," + this.SB.DBTableName("VERSION") + " v," + this.SB.DBTableName("WELLS") + " w" + " WHERE i.sch_id=" + this.ID + " AND floor(i.top_id/65536)=v.well_id AND v.code=w.well_code ORDER BY well_name";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        ArrayList<String> occs = new ArrayList<String>();
        while (rs.next()) {
            occs.add(rs.getString("well_name") + " (" + rs.getString("code") + ") ");
        }
        stmt.close();
        return occs;
    }

    void deleteEntries() throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        if (this.ID != 0) {
            String sql = "DELETE FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE sch_id=" + this.ID;
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
    }

    void delete() throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        if (this.ID != 0) {
            String sql = "DELETE FROM " + this.SB.DBTableName("ENV_SCH") + " WHERE envid=" + this.ID;
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
    }

    public void update(EnvScheme rhs) throws SQLException, SBException {
        rhs.store(this.SB);
        this.copy(rhs);
        this.setChanged();
    }

    void store(SBdb SB2) throws SQLException, SBException {
        String sql;
        Statement stmt = SB2.getDatabase().createStatement();
        if (this.ID != 0) {
            sql = "DELETE FROM " + SB2.DBTableName("ENV_SCH") + " WHERE envid=" + this.ID;
            stmt.executeUpdate(SB2.modQuery(sql));
        } else {
            this.ID = SB2.nextControl("ENV_SCHEME");
        }
        sql = "INSERT INTO " + SB2.DBTableName("ENV_SCH");
        sql = sql + " ( envid,name";
        for (int j = 1; j <= this.nClasses; ++j) {
            sql = sql + ",term_" + j + ",c" + j;
        }
        sql = sql + " ) VALUES (";
        sql = sql + this.ID + ",'" + this.name + "'";
        for (int i = 0; i < this.nClasses; ++i) {
            sql = sql + ",'" + this.term[i] + "'," + util.SB.getSBIntFromColor(this.colour[i]);
        }
        sql = sql + ")";
        stmt.executeUpdate(SB2.modQuery(sql));
        SB2.getDatabase().commit();
        this.SB = SB2;
    }

    public String getTerm(int classNumber) {
        if (classNumber > 0 && classNumber <= this.nClasses) {
            return this.term[classNumber - 1];
        }
        return "<no term>";
    }

    public int getTermIndex(String className) throws SBException {
        if (className.equals("<no term>")) {
            return 0;
        }
        for (int i = 0; i < this.nClasses; ++i) {
            if (!className.equalsIgnoreCase(this.term[i])) continue;
            return i + 1;
        }
        throw new SBException("Cannot find palaeoenvironment term '" + className + "' in scheme: " + this.name);
    }

    static void loadAll(SBdb SB2, List envSchemes) throws SQLException {
        String sql = "SELECT envid FROM " + SB2.DBTableName("ENV_SCH") + " ORDER BY envid";
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int ID = rs.getInt("envid");
            EnvScheme envScheme = EnvScheme.get(envSchemes, ID, 0);
            if (envScheme != null) continue;
            envSchemes.add(new EnvScheme(SB2, ID));
        }
        stmt.close();
    }

    static void clearDonor(List envSchemes) {
        if (envSchemes == null) {
            return;
        }
        Iterator it = envSchemes.iterator();
        while (it.hasNext()) {
            EnvScheme scheme = (EnvScheme)it.next();
            if (scheme.donorID <= 0) continue;
            it.remove();
        }
    }

    public void fillCombo(JComboBox combo, int selectedIndex, boolean allowBlank) {
        combo.removeAllItems();
        if (allowBlank) {
            combo.addItem("");
        }
        for (int i = 0; i < this.nClasses; ++i) {
            combo.addItem(this.term[i]);
        }
        if (selectedIndex > 0 && selectedIndex <= this.nClasses) {
            combo.setSelectedIndex(selectedIndex - (allowBlank ? 0 : 1));
        }
    }

    void writeDEX(FileWriter out, String eol) throws IOException {
        out.write("[Palaeoenvironment Scheme]" + eol);
        out.write("Scheme name = " + this.name + eol);
        out.write("  Scheme ID : " + this.ID + eol);
        out.write("  Number of columns : ");
        out.write(this.nClasses + eol);
        for (int i = 0; i < this.nClasses; ++i) {
            out.write("Column name = " + this.term[i] + eol);
            out.write("  Colour : " + this.colour[i].getRed() + ',' + this.colour[i].getGreen() + ',' + this.colour[i].getBlue() + eol);
        }
        out.write(eol);
    }

    static EnvScheme get(List schemes, int hostID, int donorID) {
        EnvScheme scheme2 = null;
        for (EnvScheme scheme2 : schemes) {
            if (!(hostID > 0 ? scheme2.ID == hostID : donorID > 0 && scheme2.donorID == donorID)) continue;
            return scheme2;
        }
        return null;
    }

    static EnvScheme get(List schemes, String name) {
        EnvScheme scheme2 = null;
        for (EnvScheme scheme2 : schemes) {
            if (!scheme2.name.equals(name)) continue;
            return scheme2;
        }
        return null;
    }

    public int getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to update env scheme");
        }
        this.name = name;
    }

    public int getNClasses() {
        return this.nClasses;
    }
}

