/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import model1_8.CompositeStandard;
import model1_8.CompositeStandardEvent;
import model1_8.Fssabnd;
import model1_8.QSLOC;
import model1_8.SBEvent;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Sample;
import model1_8.Smpdtl;
import model1_8.Taxon;
import model1_8.Well;
import model1_8.WellEvent;
import util.SB;

public class EvProject
extends Observable {
    SBdb SB;
    int qsID;
    String name;
    String description;
    String creator;
    Date created;
    List events = new LinkedList();
    List LOCs = new LinkedList();
    boolean addedToProject = false;
    static final String nullProject = "Default version";

    public EvProject(SBdb SB2) {
        this.SB = SB2;
    }

    public String toString() {
        return this.name;
    }

    public List getEvents() {
        return this.events;
    }

    static void loadList(SBdb SB2, List projects) throws SQLException, SBException {
        if (projects.size() > 0) {
            throw new SBException("Attempt to load projects into non-empty list");
        }
        String sql = "SELECT qs_id,name,creator,created,comments FROM " + SB2.DBTableName("QSPROJ") + " ORDER BY qs_id";
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            EvProject project = new EvProject(SB2);
            project.qsID = rs.getInt("qs_id");
            project.name = rs.getString("name");
            project.creator = rs.getString("creator");
            project.created = rs.getDate("created");
            project.description = rs.getString("comments");
            projects.add(project);
        }
        stmt.close();
    }

    public EvProject(SBdb SB2, int qsID) throws SQLException {
        this.SB = SB2;
        if (qsID == 0) {
            this.name = nullProject;
            this.qsID = 0;
            this.description = "Automatically generated project with ID=0";
            return;
        }
        String sql = "SELECT qs_id,name,creator,created,comments FROM " + SB2.DBTableName("QSPROJ") + " WHERE qs_id=" + qsID;
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            this.qsID = rs.getInt("qs_id");
            this.name = rs.getString("name");
            this.creator = rs.getString("creator");
            this.created = rs.getDate("created");
            this.description = rs.getString("comments");
        }
        stmt.close();
    }

    public void addEvent(Sample sample, SBEvent event, char eventType, char discID, String analyst, String comment) throws SBException, SQLException {
        WellEvent wellEvent = new WellEvent(this.SB);
        wellEvent.sample = sample;
        wellEvent.sampID = sample.getSampID();
        wellEvent.sbEvent = event;
        wellEvent.type = eventType;
        wellEvent.modified = new Date();
        wellEvent.comments = comment;
        wellEvent.status = WellEvent.NOTSTORED;
        wellEvent.discID = discID;
        wellEvent.analyst = analyst;
        this.insert(wellEvent);
        wellEvent.store(this.qsID);
        this.setChanged();
    }

    public void deleteEvent(WellEvent wellEvent) throws SQLException {
        wellEvent.delete();
        this.events.remove(wellEvent);
        this.setChanged();
    }

    public void store() throws SQLException, SBException {
        if (this.qsID > 0) {
            throw new SBException("Attempt to create EvProject with existing ID no: " + this.qsID);
        }
        if (this.qsID == 0 && this.name.equals(nullProject)) {
            return;
        }
        this.qsID = this.SB.nextControl("QS_ID");
        if (this.created == null) {
            this.created = new Date();
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (this.creator == null || this.creator.length() == 0) {
            this.creator = this.SB.user.getUsrID();
        }
        String sql = "INSERT INTO " + this.SB.DBTableName("QSPROJ") + " (qs_id,name,creator,created,comments,qspublic) VALUES ( " + this.qsID + "," + util.SB.DBString(this.name) + "," + util.SB.DBString(this.creator) + "," + util.SB.DBString(df.format(this.created)) + "," + util.SB.DBString(this.description) + ",'Y')";
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
    }

    void load(int wellID, List composites) throws SQLException, SBException {
        String sql = "SELECT ev_id,samp_id,ev_type";
        if (this.SB.hasEventExtensions) {
            sql = sql + ",disc_id,analyst,qualifier,comments,source,company,modified";
        }
        sql = sql + " FROM " + this.SB.DBTableName("EVENTS") + " WHERE qs_id=" + this.qsID + " AND samp_id>=" + wellID * 65536 + " AND samp_id < " + (wellID + 1) * 65536;
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            WellEvent event = new WellEvent(this.SB);
            event.qsID = this.qsID;
            event.sbEvent = this.SB.getSBEvent(rs.getInt("ev_id"));
            event.sampID = rs.getInt("samp_id");
            String strg = rs.getString("ev_type");
            event.type = strg != null && strg.length() > 0 ? strg.charAt(0) : (char)'\u0000';
            event.status = WellEvent.STORED;
            if (this.SB.hasEventExtensions) {
                strg = rs.getString("disc_id");
                if (strg != null) {
                    event.discID = strg.charAt(0);
                }
                event.analyst = rs.getString("analyst");
                event.qualifier = rs.getString("qualifier");
                event.comments = rs.getString("comments");
                event.source = rs.getString("source");
                event.company = rs.getString("company");
                event.modified = rs.getDate("modified");
            }
            this.events.add(event);
        }
        sql = "SELECT std_id,depth1,depth2,csu1,csu2,r,g,b,linewidth FROM " + this.SB.DBTableName("QSLOC") + " WHERE qs_id=" + this.qsID + " AND well_id=" + wellID;
        sql = sql + " ORDER BY depth2";
        sql = this.SB.modQuery(sql);
        rs = stmt.executeQuery(sql);
        while (rs.next()) {
            int stdID = rs.getInt("std_id");
            double depth1 = rs.getDouble("depth1");
            double depth2 = rs.getDouble("depth2");
            double csu1 = rs.getDouble("csu1");
            double csu2 = rs.getDouble("csu2");
            int r = rs.getInt("r");
            int g = rs.getInt("g");
            int b = rs.getInt("b");
            Color colour = new Color(r, g, b);
            float lineWidth = rs.getFloat("linewidth");
            QSLOC LOC = new QSLOC(this.SB, stdID, this.qsID, wellID, depth1, depth2, csu1, csu2, colour, lineWidth);
            LOC.status = QSLOC.STORED;
            if (composites != null) {
                LOC.std = CompositeStandard.get(this.SB, LOC.stdID, composites);
            }
            this.LOCs.add(LOC);
        }
        stmt.close();
    }

    void fillSamples(List samples, char units, char sectionType) throws SBException, SQLException {
        Iterator it = this.events.iterator();
        while (it.hasNext()) {
            WellEvent event = (WellEvent)it.next();
            if (event.sample != null || event.sampID == 0) continue;
            event.sample = this.getSample(samples, event.sampID, units, sectionType);
            if (event.sample != null) continue;
            System.out.println("Removing event :" + event + " - null sample");
            it.remove();
        }
    }

    Sample getSample(List samples, int ID, char units, char sectionType) throws SQLException, SBException {
        Sample sample2 = null;
        for (Sample sample2 : samples) {
            if (ID != sample2.getSampID()) continue;
            return sample2;
        }
        sample2 = new Sample(this.SB, ID, sectionType);
        Sample.insert(samples, sample2, units);
        return sample2;
    }

    void sortByDepth() throws SBException {
        boolean swap = true;
        block0: while (swap) {
            swap = false;
            for (int i = 1; i < this.events.size(); ++i) {
                WellEvent event = (WellEvent)this.events.get(i);
                WellEvent prevEvent = (WellEvent)this.events.get(i - 1);
                if (event.sample == null || prevEvent.sample == null) {
                    throw new SBException("Null sample encountered during events sort");
                }
                if (!(event.sample.getDepth('M') < prevEvent.sample.getDepth('M'))) continue;
                this.events.add(i - 1, event);
                this.events.remove(i + 1);
                swap = true;
                continue block0;
            }
        }
    }

    void insert(WellEvent event) throws SBException {
        Iterator it = this.events.iterator();
        int i = 0;
        while (it.hasNext()) {
            WellEvent current = (WellEvent)it.next();
            if (event.sample == null) {
                throw new SBException("Attempt to insert Event with no sample: " + event);
            }
            if (event.sampID == current.sampID && event.sbEvent.getEvID() == current.sbEvent.getEvID() && event.type == current.type && event.sampID > 0 && event.sbEvent.getEvID() > 0) {
                throw new SBException("Attempt to insert duplicate event");
            }
            if (event.sample.getDepth('M') < current.sample.getDepth('M')) {
                event.qsID = this.qsID;
                this.events.add(i, event);
                this.setChanged();
                return;
            }
            ++i;
        }
        event.qsID = this.qsID;
        this.events.add(event);
        this.setChanged();
    }

    void deleteLOC(int wellID) throws SQLException {
        if (wellID > 0) {
            String sql = "DELETE FROM " + this.SB.DBTableName("QSLOC") + " WHERE qs_id=" + this.qsID + " AND well_id=" + wellID;
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(sql);
            stmt.close();
            for (QSLOC loc : this.LOCs) {
                loc.status = QSLOC.NOTSTORED;
            }
        }
    }

    public void store(int wellID) throws SQLException, SBException {
        if (this.events.size() == 0 && this.LOCs.size() == 0) {
            return;
        }
        if (!this.addedToProject) {
            String sql = "SELECT well_id FROM " + this.SB.DBTableName("QSSECT") + " WHERE qs_id=" + this.qsID + " AND well_id=" + wellID;
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                this.addedToProject = true;
            }
            rs.close();
            if (!this.addedToProject) {
                sql = "INSERT INTO " + this.SB.DBTableName("QSSECT") + " (qs_id, well_id) VALUES (" + this.qsID + "," + wellID + ")";
                stmt.executeUpdate(this.SB.modQuery(sql));
            }
        }
        for (WellEvent event : this.events) {
            event.store(this.qsID);
        }
        for (QSLOC loc : this.LOCs) {
            loc.store(wellID, this.qsID);
        }
    }

    int generateEvents(Well well, boolean incCU, boolean incCO, boolean incSC, boolean incOC, String discs, boolean incRW, boolean incCV, CompositeStandard std, boolean useSynonym, int synSch) throws SQLException, SBException {
        well.loadAnalyses();
        HashMap<CompositeStandardEvent, Smpdtl> bases = new HashMap<CompositeStandardEvent, Smpdtl>();
        int nAdded = 0;
        for (Sample s : well.samples) {
            Sample sample = s;
            String type = sample.getType();
            if (!(type.equals("CU") && incCU || type.equals("SC") && incSC || type.equals("CO") && incCO) && (!type.equals("OC") || !incOC)) continue;
            for (Smpdtl sd : sample.analyses) {
                Smpdtl smpdtl = sd;
                if (discs.indexOf(smpdtl.getDiscID()) < 0) continue;
                smpdtl.load(this.SB);
                for (Fssabnd fss : smpdtl.occur) {
                    if (fss.getReworked() && !incRW || fss.getCaved() && !incCV) continue;
                    boolean genTop = false;
                    boolean genBase = false;
                    CompositeStandardEvent topEvent = null;
                    CompositeStandardEvent baseEvent = null;
                    for (Object evo : std.getEvents()) {
                        CompositeStandardEvent evt = (CompositeStandardEvent)evo;
                        Taxon taxon = evt.getEvent().getTaxon();
                        if (taxon == null || !evt.getEvent().isGenerate() || taxon.getSpecID() != fss.getSpecID() && (!useSynonym || taxon != this.SB.getPreferredTerm(synSch, fss.getSpecID()))) continue;
                        if (evt.getEvType() == 'F') {
                            genTop = true;
                            topEvent = evt;
                            continue;
                        }
                        if (evt.getEvType() != 'L') continue;
                        genBase = true;
                        baseEvent = evt;
                    }
                    for (Object oe : this.events) {
                        WellEvent event = (WellEvent)oe;
                        if (event.getEvent().getSpecID() != fss.getSpecID() && (!useSynonym || event.getEvent().getTaxon() == null || event.getEvent().getTaxon() != this.SB.getPreferredTerm(synSch, fss.getSpecID()))) continue;
                        if (event.getCharType() == 'F') {
                            genTop = false;
                            continue;
                        }
                        if (event.getCharType() != 'L') continue;
                        genBase = false;
                    }
                    if (genTop) {
                        this.addEvent(sample, topEvent.getEvent(), 'F', smpdtl.getDiscID(), smpdtl.getAnalyst(), "Generated using: " + std);
                        ++nAdded;
                    }
                    if (!genBase) continue;
                    if (bases.get(baseEvent) != null) {
                        bases.remove(baseEvent);
                    }
                    bases.put(baseEvent, smpdtl);
                }
            }
        }
        Set baseSet = bases.entrySet();
        for (Map.Entry entry : baseSet) {
            Smpdtl smpdtl = (Smpdtl)entry.getValue();
            this.addEvent(smpdtl.getSample(), ((CompositeStandardEvent)entry.getKey()).getEvent(), 'L', smpdtl.getDiscID(), smpdtl.getAnalyst(), "Generated using: " + std);
            ++nAdded;
        }
        return nAdded;
    }
}

