/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import model1_8.AbnScheme;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Sample;
import model1_8.Smpdtl;
import model1_8.TaxaMap;
import model1_8.Taxon;
import util.SB;
import util.SbugsStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fssabnd
implements SbugsStatus {
    SBdb SB;
    private int sampID;
    private int specID;
    private Taxon taxonRef = null;
    private boolean reworked = false;
    private char identType = (char)80;
    private String subjAbund = "";
    private int medium;
    private int coarse;
    private int fine;
    private boolean caved;
    private boolean marker = false;
    private String preservation = "";
    private String colour = "";
    private String comment = "";
    private char form = (char)67;
    public static String[] forms = new String[]{"Entire", "Component", "Broken", "Fragment"};
    private char growth = (char)65;
    public static String[] growths = new String[]{"Adult", "Juvenile"};
    Color status = UNKNOWN;

    public int getSpecID() throws SBException {
        if (this.taxonRef != null && this.taxonRef.getSpecID() != this.specID) {
            throw new SBException("SpecIDs in Fssabnd not equal: " + this.taxonRef + ", " + this.specID + " sampID: " + this.sampID);
        }
        return this.specID;
    }

    public Taxon getTaxon() {
        return this.taxonRef;
    }

    public boolean getReworked() {
        return this.reworked;
    }

    public char getIdentType() {
        return this.identType;
    }

    public int getCounts() {
        return this.coarse + this.medium + this.fine;
    }

    public int getMedium() {
        return this.medium;
    }

    public int getCoarse() {
        return this.coarse;
    }

    public int getFine() {
        return this.fine;
    }

    public boolean getCaved() {
        return this.caved;
    }

    public boolean isMarker() {
        return this.marker;
    }

    public String getPreservation() {
        return this.preservation;
    }

    public String getColour() {
        return this.colour;
    }

    public String getComment() {
        return this.comment;
    }

    public char getForm() {
        return this.form;
    }

    public char getGrowth() {
        return this.growth;
    }

    public Fssabnd(SBdb SB2) throws SBException {
        if (SB2.getDatabase() != null) {
            throw new SBException("Can't construct null Fssabnd ref");
        }
        this.SB = SB2;
        this.reworked = false;
        this.identType = (char)80;
        this.caved = false;
        this.marker = false;
    }

    public Fssabnd(SBdb SB2, int sampID, int specID, Taxon taxon, boolean reworked, char identType, char form, char growth, String subjAbund, int coarse, int medium, int fine, boolean caved, boolean marker, String preservation, String colour, String comment) {
        this.SB = SB2;
        this.sampID = sampID;
        this.specID = specID;
        this.taxonRef = taxon;
        this.reworked = reworked;
        if (identType != '\u0000') {
            this.identType = identType;
        }
        if (form != '\u0000') {
            this.form = form;
        }
        if (growth != '\u0000') {
            this.growth = growth;
        }
        if (subjAbund != null) {
            this.subjAbund = subjAbund;
        }
        this.coarse = coarse;
        this.medium = medium;
        this.fine = fine;
        this.caved = caved;
        this.marker = marker;
        if (preservation != null) {
            this.preservation = preservation;
        }
        if (colour != null) {
            this.colour = colour;
        }
        if (comment != null) {
            this.comment = comment;
        }
    }

    Fssabnd(SBdb SB2, int sampID, char discID, String analyst, Taxon taxon, boolean reworked, char identType, char form, char growth) throws SQLException, SBException {
        this.SB = SB2;
        this.sampID = sampID;
        this.specID = taxon.getSpecID();
        this.taxonRef = taxon;
        this.reworked = reworked;
        this.form = form;
        this.growth = growth;
        Statement stmt = SB2.getDatabase().createStatement();
        String sql = "SELECT ident_type,status,form,growth,subj_abund,coarse,counts,fine,caved,marker,preserv,colour,comments FROM " + SB2.DBTableName("FSSABND") + " WHERE ";
        sql = sql + " samp_id=" + sampID + " AND disc_id='" + discID + "' AND analyst='" + analyst + "' AND spec_id=" + taxon.getSpecID();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        boolean found = false;
        if (rs.next()) {
            String rowgrowth;
            String rowform;
            String rowstatus;
            String rowident_type = rs.getString("ident_type");
            if (rowident_type == null || rowident_type.length() == 0) {
                rowident_type = "P";
            }
            if ((rowstatus = rs.getString("status")) == null || rowstatus.length() == 0) {
                rowstatus = "I";
            }
            if ((rowform = rs.getString("form")) == null || rowform.length() == 0) {
                rowform = "C";
            }
            if ((rowgrowth = rs.getString("growth")) == null || rowgrowth.length() == 0) {
                rowgrowth = "A";
            }
            if (rowident_type.equals("" + identType) && rowstatus.equals(reworked ? "R" : "I") && rowgrowth.equals("" + growth) && rowform.equals("" + form)) {
                found = true;
                String subjAbund = rs.getString("subj_abund");
                if (subjAbund != null) {
                    this.subjAbund = subjAbund;
                }
                this.coarse = rs.getInt("coarse");
                this.medium = rs.getInt("counts");
                this.fine = rs.getInt("fine");
                this.caved = util.SB.getDBChar(rs, "caved") == 'C';
                this.marker = util.SB.getDBChar(rs, "marker") == 'Y';
                this.preservation = rs.getString("preserv");
                this.colour = rs.getString("colour");
                this.comment = rs.getString("comments");
            }
        }
        if (!found) {
            throw new SBException("Cannot re-retrieve Fssabnd entry for: " + this);
        }
    }

    public Fssabnd(SBdb SB2, Smpdtl smpdtl, Taxon taxon, boolean reworked, char identType, char form, char growth, String subjAbund, int coarse, int medium, int fine, boolean caved, boolean marker, String preservation, String colour, String comment) throws SQLException, SBException {
        for (Fssabnd f : smpdtl.occur) {
            if (f.taxonRef != taxon && f.taxonRef.getSpecID() != taxon.getSpecID() || f.identType != identType || f.reworked != reworked || f.form != form || f.growth != growth) continue;
            throw new SBException("Occurrence of: " + taxon + " already exists in sample: " + smpdtl.getSample().toString());
        }
        this.SB = SB2;
        this.sampID = smpdtl.getSample().getSampID();
        this.specID = taxon.getSpecID();
        this.taxonRef = taxon;
        this.reworked = reworked;
        if (identType != '\u0000') {
            this.identType = identType;
        }
        if (form != '\u0000') {
            this.form = form;
        }
        if (growth != '\u0000') {
            this.growth = growth;
        }
        if (subjAbund != null) {
            this.subjAbund = subjAbund;
        }
        this.coarse = coarse;
        this.medium = medium;
        this.fine = fine;
        this.caved = caved;
        this.marker = marker;
        if (preservation != null) {
            this.preservation = preservation;
        }
        if (colour != null) {
            this.colour = colour;
        }
        if (comment != null) {
            this.comment = comment;
        }
        this.store(this.sampID, smpdtl.getDiscID(), smpdtl.getAnalyst());
        smpdtl.insert(this, true);
    }

    void delete(int sampID, char discID, String analyst) throws SQLException, SBException {
        if (this.SB.getDatabase() == null) {
            throw new SBException("Attempt to delete fss with null database");
        }
        String sql = "DELETE FROM " + this.SB.DBTableName("fssabnd") + " WHERE " + "samp_id=" + sampID + " AND " + "disc_id=" + util.SB.DBChar(discID) + " AND " + "analyst=" + util.SB.DBString(analyst) + " AND " + "spec_id=" + this.specID + " AND ";
        sql = this.identType == '?' ? sql + "ident_type='?'" : sql + "(ident_type is null OR ident_type=' ' OR ident_type='P')";
        sql = sql + " AND ";
        sql = !this.reworked ? sql + "(status is null OR status=' ' OR status='I')" : sql + "status='R'";
        sql = sql + " AND ";
        sql = this.form == 'C' || this.form == '\u0000' ? sql + "(form is null OR form=' ' OR form='C')" : sql + "form=" + util.SB.DBChar(this.form);
        sql = sql + " AND ";
        sql = this.growth == 'A' || this.growth == '\u0000' ? sql + "(growth is null OR growth=' ' OR growth='A')" : sql + "growth=" + util.SB.DBChar(this.growth);
        Statement stmt = this.SB.getDatabase().createStatement();
        int nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        if (nRows != 1) {
            throw new SBException("Failed to delete occurrence: " + this);
        }
    }

    void update(char discID, String analyst, boolean reworked, boolean questionable, char form, char growth, boolean caved, boolean marker, int coarse, int medium, int fine, String abund, String preserv, String colour, String comment) throws SQLException, SBException {
        if (this.SB == null) {
            throw new SBException("Attenmpt to update Fssabnd record with null database");
        }
        if (this.sampID == 0) {
            throw new SBException("Attenmpt to update Fssabnd record with null sampID: " + this);
        }
        if (this.specID == 0) {
            throw new SBException("Attenmpt to update Fssabnd record with null specID: " + this);
        }
        String sql = "UPDATE " + this.SB.DBTableName("fssabnd") + " SET ";
        sql = sql + " ident_type=" + (questionable ? "'?'" : "'P'");
        sql = sql + ",status=" + (reworked ? "'R'" : "'I'");
        sql = sql + ",form=" + util.SB.DBChar(form);
        sql = sql + ",growth=" + util.SB.DBChar(growth);
        sql = sql + ",caved=" + (caved ? "'C'" : "''");
        sql = sql + ",coarse=" + coarse;
        sql = sql + ",counts=" + medium;
        sql = sql + ",fine=" + fine;
        sql = sql + ",subj_abund='" + abund + "'";
        sql = sql + ",preserv=" + util.SB.DBString(preserv);
        sql = sql + ",colour=" + util.SB.DBString(colour);
        sql = sql + ",comments=" + util.SB.DBString(comment);
        sql = sql + " WHERE samp_id=" + this.sampID + " AND disc_id='" + discID + "' AND analyst='" + analyst + "' AND spec_id=" + this.specID + " AND ident_type='" + this.identType + "' AND status='" + (this.reworked ? (char)'R' : 'I') + "' AND form='" + this.form + "' AND growth='" + this.growth + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        int nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        if (nRows != 1) {
            throw new SBException("Failed to update occurrence: " + this);
        }
        this.identType = (char)(questionable ? 63 : 80);
        this.reworked = reworked;
        this.form = form;
        this.growth = growth;
        this.caved = caved;
        this.marker = marker;
        this.coarse = coarse;
        this.medium = medium;
        this.fine = fine;
        this.subjAbund = abund;
        this.preservation = preserv;
        this.colour = colour;
        this.comment = comment;
    }

    void setSubjAbund(String subjAbund) {
        this.subjAbund = subjAbund;
    }

    void setReworked(boolean reworked, boolean override) throws SBException {
        if (this.SB != null && !override) {
            throw new SBException("Attempt to set reworked");
        }
        if (reworked != this.reworked) {
            this.reworked = reworked;
        }
    }

    void setCaved(boolean caved, boolean override) throws SBException {
        if (this.SB != null && !override) {
            throw new SBException("Attempt to set caved");
        }
        if (caved != this.caved) {
            this.caved = caved;
        }
    }

    void setIdentType(char identType, boolean override) throws SBException {
        if (this.SB != null && !override) {
            throw new SBException("Attempt to set identType");
        }
        if (this.identType != identType) {
            this.identType = identType;
        }
    }

    public void merge(Fssabnd rhs, AbnScheme abn) throws SBException {
        if (this.reworked != rhs.reworked) {
            throw new SBException("Attempt to merge reworked & non-reworked occurrences: " + this.toString());
        }
        if (this.identType != rhs.identType) {
            throw new SBException("Attempt to merge questionable/non-questionable occurrences: " + this.toString());
        }
        if (this.growth != rhs.growth) {
            throw new SBException("Attempt to merge different growth stage occurrences: " + this.toString());
        }
        if (this.form != rhs.form) {
            throw new SBException("Attempt to merge different form occurrences: " + this.toString());
        }
        if (rhs.caved) {
            this.caved = true;
        }
        if (rhs.marker) {
            this.marker = true;
        }
        this.medium += rhs.medium;
        this.coarse += rhs.coarse;
        this.fine += rhs.fine;
        if (!this.subjAbund.toString().equalsIgnoreCase(rhs.subjAbund.toString())) {
            if (this.subjAbund.length() > 0) {
                if (rhs.subjAbund.length() > 0) {
                    if (abn == null) {
                        if (this.medium == 0) {
                            throw new SBException("Attempt to merge semi-quantitative occurrences with no abundance scheme specified for: " + this.toString());
                        }
                    } else {
                        int abnIndex1 = abn.getIndex(this.subjAbund.toString());
                        int abnIndex2 = abn.getIndex(rhs.subjAbund.toString());
                        if (abnIndex1 >= 0 && abnIndex2 >= 0) {
                            int tempCount = abn.getLowBound(abnIndex1) + abn.getLowBound(abnIndex2);
                            this.subjAbund = abn.getAbr(tempCount);
                        } else if (abnIndex2 >= 0) {
                            this.subjAbund = rhs.subjAbund;
                        }
                    }
                }
            } else {
                this.subjAbund = rhs.subjAbund;
            }
        }
        if (this.subjAbund.equals("+") && this.medium + this.coarse + this.fine > 0) {
            this.subjAbund = "";
        }
        this.preservation = this.preservation != null && this.preservation.length() > 0 ? this.preservation + " " + rhs.preservation : rhs.preservation;
        this.colour = this.colour != null && this.colour.length() > 0 ? this.colour + " " + rhs.colour : rhs.colour;
        this.comment = this.comment != null && this.comment.length() > 0 ? this.comment + " " + rhs.comment : rhs.comment;
    }

    @Override
    public Color getStatus() {
        if (this.status == UNKNOWN) {
            this.status = this.sampID != 0 ? (this.specID != 0 ? PARTSTORED : STORED) : NOTSTORED;
        }
        return this.status;
    }

    public void updateStatus(List occurrences) {
        Iterator it = occurrences.iterator();
        this.status = NOTSTORED;
        while (it.hasNext()) {
            Fssabnd fss = (Fssabnd)it.next();
            if (fss == this || fss.identType != this.identType || fss.taxonRef != this.taxonRef || fss.reworked != this.reworked || fss.growth != this.growth || fss.form != this.form) continue;
            this.status = CONFLICT;
            break;
        }
    }

    void fillTaxon(Hashtable taxa) throws SBException, SQLException {
        if (this.taxonRef == null && this.specID != 0) {
            this.taxonRef = (Taxon)taxa.get("H" + this.specID);
            if (this.taxonRef == null) {
                this.taxonRef = new Taxon(this.SB, this.specID);
                taxa.put("H" + this.specID, this.taxonRef);
            }
        }
    }

    void setTaxon(Taxon taxon) {
        this.specID = taxon.getSpecID();
        this.taxonRef = taxon;
    }

    void fillTaxonList(List taxa) {
        if (this.taxonRef != null && !taxa.contains(this.taxonRef)) {
            taxa.add(this.taxonRef);
        }
    }

    public int getDerivedCount(AbnScheme abn) {
        int total = this.getTotalCount();
        if (total == 0) {
            total = abn.getCount(this.subjAbund.toString());
        }
        return total;
    }

    public int getTotalCount() {
        return this.coarse + this.medium + this.fine;
    }

    public String getSubAbund(AbnScheme abn) {
        if (this.subjAbund.length() > 0) {
            return this.subjAbund.toString();
        }
        return abn.getAbr(this.getTotalCount());
    }

    public String getSubAbund() {
        return this.subjAbund;
    }

    String getAllQualifiers() {
        String qualifierString = "";
        if (this.reworked) {
            qualifierString = qualifierString + "Rw";
        }
        if (this.caved) {
            if (qualifierString.length() > 0) {
                qualifierString = qualifierString + " ";
            }
            qualifierString = qualifierString + "Cv";
        }
        if (this.identType != 'P') {
            if (qualifierString.length() > 0) {
                qualifierString = qualifierString + " ";
            }
            qualifierString = qualifierString + this.identType;
        }
        return qualifierString;
    }

    public void increment(Smpdtl smpdtl, boolean increase) throws SBException, SQLException {
        int factor;
        if (this.sampID == 0) {
            throw new SBException("Attempt to store FSSABND entry with null sampleID, specID=" + this.specID + ",taxon=" + this.taxonRef + ",analyst=" + smpdtl.getAnalyst() + ",discipline=" + smpdtl.getDiscID());
        }
        int n = factor = increase ? 1 : -1;
        if (this.medium + factor <= 0) {
            throw new SBException("Cannot decrement FSSABND entry to zero:  specID=" + this.specID + ",taxon=" + this.taxonRef + ",analyst=" + smpdtl.getAnalyst() + ",discipline=" + smpdtl.getDiscID());
        }
        String sql = "UPDATE " + this.SB.DBTableName("fssabnd") + " SET counts=" + (this.medium + factor) + " WHERE samp_id=" + this.sampID + " AND disc_id='" + smpdtl.getDiscID() + "' AND analyst='" + smpdtl.getAnalyst() + "' AND spec_id=" + this.specID + " AND status='" + (this.reworked ? (char)'R' : 'I') + "' AND ident_type='" + this.identType + "' AND form='" + this.form + "' AND growth='" + this.growth + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        int rowCount = stmt.executeUpdate(this.SB.modQuery(sql));
        if (rowCount != 1) {
            throw new SBException("Cannot increment FSSABND entry: rowCount=" + rowCount + " specID=" + this.specID + ",taxon=" + this.taxonRef + ",analyst=" + smpdtl.getAnalyst() + ",discipline=" + smpdtl.getDiscID());
        }
        this.medium += factor;
        this.status = STORED;
        smpdtl.fssIncrement();
        stmt.close();
    }

    void store(int iSampID, char discID, String analyst) throws SQLException, SBException {
        if (iSampID == 0) {
            throw new SBException("Attempt to store FSSABND entry with null sampleID, specID=" + this.specID + ",taxon=" + this.taxonRef + ",analyst=" + analyst + ",discipline=" + discID);
        }
        this.sampID = iSampID;
        if (this.specID == 0 && this.taxonRef != null) {
            this.specID = this.taxonRef.getSpecID();
        }
        if (this.specID != 0) {
            if (analyst.length() == 0) {
                throw new SBException("Analyst blank while attempting to store occurrence for discipline : " + discID);
            }
            String sql = "INSERT INTO " + this.SB.DBTableName("FSSABND") + " (samp_id,disc_id,analyst,spec_id,status,ident_type,form,growth";
            if (this.subjAbund != null && this.subjAbund.length() > 0) {
                sql = sql + ",subj_abund";
            }
            if (this.medium > 0) {
                sql = sql + ",counts";
            }
            if (this.caved) {
                sql = sql + ",caved";
            }
            if (this.coarse > 0) {
                sql = sql + ",coarse";
            }
            if (this.fine > 0) {
                sql = sql + ",fine";
            }
            if (this.marker) {
                sql = sql + ",marker";
            }
            if (this.preservation != null && this.preservation.length() > 0) {
                sql = sql + ",preserv";
            }
            if (this.colour != null && this.colour.length() > 0) {
                sql = sql + ",colour";
            }
            if (this.comment != null && this.comment.length() > 0) {
                sql = sql + ",comments";
            }
            sql = sql + ") VALUES (" + this.sampID + "," + "'" + discID + "'," + "'" + analyst + "'," + this.specID + ",'" + (this.reworked ? "R" : "I") + "','" + this.identType + "'";
            sql = sql + ",'" + this.form + "'";
            sql = sql + ",'" + this.growth + "'";
            if (this.subjAbund != null && this.subjAbund.length() > 0) {
                sql = sql + ",'" + this.subjAbund + "'";
            }
            if (this.medium > 0) {
                sql = sql + "," + this.medium;
            }
            if (this.caved) {
                sql = sql + ",'C'";
            }
            if (this.coarse > 0) {
                sql = sql + "," + this.coarse;
            }
            if (this.fine > 0) {
                sql = sql + "," + this.fine;
            }
            if (this.marker) {
                sql = sql + ",'Y'";
            }
            if (this.preservation != null && this.preservation.length() > 0) {
                sql = sql + "," + util.SB.DBString(this.preservation);
            }
            if (this.colour != null && this.colour.length() > 0) {
                sql = sql + "," + util.SB.DBString(this.colour);
            }
            if (this.comment != null && this.comment.length() > 0) {
                sql = sql + "," + util.SB.DBString(this.comment);
            }
            sql = sql + ")";
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(this.SB.modQuery(sql));
            this.status = STORED;
            stmt.close();
        }
    }

    void writeSbugs(FileWriter out) throws IOException {
        out.write("T " + this.specID + '\t' + (this.reworked ? (char)'R' : ' ') + (this.identType == '?' ? (char)'?' : ' ') + '\t');
        if (this.subjAbund != null) {
            out.write(this.subjAbund.toString());
        }
        out.write("\t" + this.medium + '\t' + (this.caved ? (char)'C' : ' ') + '\n');
        if (this.preservation != null && this.preservation.length() > 0 || this.colour != null && this.colour.length() > 0 || this.comment != null && this.comment.length() > 0) {
            out.write("A " + this.preservation + '\t' + this.colour + '\t' + this.comment + '\n');
        }
    }

    void writeDEX(FileWriter out, String eol) throws IOException {
        if (this.reworked) {
            out.write("  Qualifier : Reworked" + eol);
        }
        if (this.identType == '?') {
            out.write("  Qualifier : ?" + eol);
        }
        out.write("  Species id : " + (this.taxonRef != null ? this.taxonRef.getSpecID() : this.specID) + eol);
        if (this.subjAbund.length() > 0) {
            out.write("  Abundance : " + this.subjAbund + eol);
        }
        if (this.medium > 0) {
            out.write("  Species count : " + this.medium + eol);
        }
        if (this.coarse > 0) {
            out.write("  Species count coarse : " + this.coarse + eol);
        }
        if (this.fine > 0) {
            out.write("  Species count fine : " + this.fine + eol);
        }
        if (this.caved) {
            out.write("  Flag : Caved" + eol);
        }
        if (this.marker) {
            out.write("  Flag : Marker" + eol);
        }
        if (this.preservation != null && this.preservation.length() > 0) {
            out.write("  Preservation : " + this.preservation + eol);
        }
        if (this.colour != null && this.colour.length() > 0) {
            out.write("  Colour : " + this.colour + eol);
        }
        if (this.comment != null && this.comment.length() > 0) {
            out.write("  Sp Comment : " + this.comment + eol);
        }
        if (this.form != 'C') {
            out.write("  Form : " + Fssabnd.getFormString(this.form) + eol);
        }
        if (this.growth != 'A') {
            out.write("  Growth stage : " + Fssabnd.getGrowthString(this.growth) + eol);
        }
    }

    void writeXML(FileWriter out, int indent, boolean useDonorSpecID) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        if (this.specID != 0 || useDonorSpecID && this.taxonRef != null && this.taxonRef.getDonorID() != 0) {
            out.write(ind + "<TaxonID>" + (useDonorSpecID ? this.taxonRef.getDonorID() : this.specID) + "</TaxonID>\n");
        }
        if (this.taxonRef != null) {
            out.write(ind + "<Taxon>" + util.SB.getXMLstring(this.taxonRef.toString()) + "</Taxon>\n");
            if (this.taxonRef.getAlphaCode() != null && this.taxonRef.getAlphaCode().length() > 0) {
                out.write(ind + "<TaxonAlphacode>" + util.SB.getXMLstring(this.taxonRef.getAlphaCode()) + "</TaxonAlphacode>\n");
            }
        }
        if (this.reworked) {
            out.write(ind + "<Reworked>true</Reworked>\n");
        }
        if (this.identType == '?') {
            out.write(ind + "<Questionable>true</Questionable>\n");
        }
        if (this.subjAbund != null && this.subjAbund.length() > 0) {
            out.write(ind + "<Abundance>" + this.subjAbund + "</Abundance>\n");
        }
        if (this.medium > 0) {
            out.write(ind + "<SpeciesCount>" + this.medium + "</SpeciesCount>\n");
        }
        if (this.coarse > 0) {
            out.write(ind + "<SpeciesCountCoarse>" + this.coarse + "</SpeciesCountCoarse>\n");
        }
        if (this.fine > 0) {
            out.write(ind + "<SpeciesCountFine>" + this.fine + "</SpeciesCountFine>\n");
        }
        if (this.caved) {
            out.write(ind + "<Caved>true</Caved>\n");
        }
        if (this.marker) {
            out.write(ind + "<Marker>true</Marker>\n");
        }
        if (this.preservation != null && this.preservation.length() > 0) {
            out.write(ind + "<Preservation>" + this.preservation + "</Preservation>\n");
        }
        if (this.colour != null && this.colour.length() > 0) {
            out.write(ind + "<Colour>" + this.colour + "</Colour>\n");
        }
        if (this.comment != null && this.comment.length() > 0) {
            out.write(ind + "<Comment>" + this.comment + "</Comment>\n");
        }
        if (this.growth != 'A') {
            out.write(ind + "<GrowthStage>" + Fssabnd.getGrowthString(this.growth) + "</GrowthStage>\n");
        }
        if (this.form != 'C') {
            out.write(ind + "<Form>" + Fssabnd.getGrowthString(this.growth) + "</Form>\n");
        }
    }

    public String toString() {
        String s = new String();
        if (this.taxonRef != null) {
            s = s + this.taxonRef.toString();
        } else if (this.specID != 0) {
            s = s + this.specID;
        }
        if (this.marker) {
            s = s + ", Marker ";
        }
        if (this.reworked) {
            s = s + ", Rw";
        }
        if (this.identType == '?') {
            s = s + ", ?";
        }
        if (this.caved) {
            s = s + ", Caved";
        }
        if (this.subjAbund.length() > 0) {
            s = s + ", " + this.subjAbund.toString();
        }
        if (this.medium != 0) {
            s = s + ", " + this.medium;
        }
        return s;
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    @Override
    public String statusString() {
        if (this.taxonRef != null) {
            return this.taxonRef.toString();
        }
        return "No taxon";
    }

    void parseXML(String chars, String element, Taxon taxon) throws ParseException {
        if (element.compareTo("Reworked") == 0) {
            if (chars.compareTo("false") != 0) {
                this.reworked = true;
            }
        } else if (element.compareTo("Questionable") == 0) {
            if (chars.compareTo("false") != 0) {
                this.identType = (char)63;
            }
        } else if (element.compareTo("Caved") == 0) {
            if (chars.compareTo("false") != 0) {
                this.caved = true;
            }
        } else if (element.compareTo("Marker") == 0) {
            if (chars.compareTo("false") != 0) {
                this.marker = true;
            }
        } else if (element.compareTo("Preservation") == 0) {
            this.preservation = chars;
        } else if (element.compareTo("Colour") == 0) {
            this.colour = chars;
        } else if (element.compareTo("Comment") == 0) {
            this.comment = chars;
        } else if (element.compareTo("SpeciesCountCoarse") == 0) {
            this.coarse = Integer.parseInt(chars);
        } else if (element.compareTo("SpeciesCountFine") == 0) {
            this.fine = Integer.parseInt(chars);
        } else if (element.compareTo("SpeciesCount") == 0) {
            this.medium = Integer.parseInt(chars);
        } else if (element.compareTo("Abundance") == 0) {
            this.subjAbund = this.subjAbund + chars;
        } else if (element.equalsIgnoreCase("Form")) {
            this.form = chars.charAt(0);
        } else if (element.equalsIgnoreCase("Growth")) {
            this.growth = chars.charAt(0);
        } else if (element.compareTo("Abundance") == 0) {
            this.subjAbund = this.subjAbund + chars;
        } else if (element.compareTo("Taxon") == 0) {
            if (taxon != null) {
                taxon.donorString = taxon.donorString + chars;
            }
        } else if (element.compareTo("TaxonAlphacode") == 0) {
            if (taxon != null && taxon.donorString.length() == 0) {
                taxon.donorString = taxon.donorString + chars;
            }
        } else if (element.compareTo("TaxonID") == 0 && taxon != null) {
            taxon.donorID = Integer.parseInt(chars);
        }
    }

    void parseOcc(String buff, AbnScheme abnScheme) {
        try {
            this.medium = Integer.parseInt(buff);
        }
        catch (Exception e) {
            if (buff.equalsIgnoreCase("RW")) {
                this.reworked = true;
                this.subjAbund = abnScheme.getEntry(0);
            }
            if (buff.equalsIgnoreCase("CV")) {
                this.caved = true;
                this.subjAbund = abnScheme.getEntry(0);
            }
            if (buff.equalsIgnoreCase("?")) {
                this.identType = (char)63;
                this.subjAbund = abnScheme.getEntry(0);
            }
            if (buff.startsWith("?")) {
                this.identType = (char)63;
                buff = buff.substring(1).trim();
                this.parseOcc(buff, abnScheme);
            }
            if (buff.toUpperCase().startsWith("RW")) {
                this.reworked = true;
                buff = buff.substring(2).trim();
                this.parseOcc(buff, abnScheme);
            }
            if (buff.toUpperCase().startsWith("CV")) {
                this.caved = true;
                buff = buff.substring(2).trim();
                this.parseOcc(buff, abnScheme);
            }
            if (buff.endsWith("?")) {
                this.identType = (char)63;
                buff = buff.substring(0, buff.length() - 1).trim();
                this.parseOcc(buff, abnScheme);
            }
            if (buff.toUpperCase().endsWith("RW")) {
                this.reworked = true;
                buff = buff.substring(0, buff.length() - 2).trim();
                this.parseOcc(buff, abnScheme);
            }
            if (buff.toUpperCase().endsWith("CV")) {
                this.caved = true;
                buff = buff.substring(0, buff.length() - 2).trim();
                this.parseOcc(buff, abnScheme);
            }
            this.subjAbund = this.subjAbund + buff;
        }
    }

    String getTaxonString() {
        if (this.taxonRef != null) {
            return this.taxonRef.toString();
        }
        return "Unknown taxon name";
    }

    Color getTaxonStatus() {
        if (this.taxonRef == null) {
            return NOTSTORED;
        }
        if (this.taxonRef.getSpecID() == 0) {
            return NOTSTORED;
        }
        return STORED;
    }

    public static String getFormString(char form) {
        switch (form) {
            case 'E': {
                return "Entire";
            }
            default: {
                return "Component";
            }
            case 'B': {
                return "Broken";
            }
            case 'F': 
        }
        return "Fragment";
    }

    public String getFormString() {
        return Fssabnd.getFormString(this.form);
    }

    public static String getGrowthString(char growth) {
        switch (growth) {
            case 'J': {
                return "Juvenile";
            }
        }
        return "Adult";
    }

    public String getGrowthString() {
        return Fssabnd.getGrowthString(this.growth);
    }

    public static int loadAll(SBdb SB2, HashMap<Integer, Sample> samples, TaxaMap taxa) throws SQLException, SBException {
        int nFss = 0;
        String sql = "SELECT samp_id,disc_id,analyst,spec_id,status,ident_type,form,growth,subj_abund,counts,coarse,fine,caved,marker,preserv,colour,comments";
        sql = sql + " FROM " + SB2.DBTableName("FSSABND");
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            Fssabnd fss = new Fssabnd(SB2);
            fss.sampID = rs.getInt("samp_id");
            String analyst = rs.getString("analyst");
            char discID = util.SB.getDBChar(rs, "disc_id");
            fss.specID = rs.getInt("spec_id");
            fss.taxonRef = taxa.get(fss.specID);
            String strg = rs.getString("status");
            if (strg != null && strg.compareToIgnoreCase("R") == 0) {
                fss.reworked = true;
            }
            fss.identType = rs.getString("ident_type").charAt(0);
            strg = rs.getString("form");
            if (strg != null) {
                fss.form = strg.charAt(0);
            }
            if ((strg = rs.getString("growth")) != null) {
                fss.growth = strg.charAt(0);
            }
            fss.subjAbund = (strg = rs.getString("subj_abund")) != null ? strg : "";
            fss.medium = rs.getInt("counts");
            fss.coarse = rs.getInt("coarse");
            fss.fine = rs.getInt("fine");
            strg = rs.getString("caved");
            if (strg != null && (strg.equalsIgnoreCase("C") || strg.equalsIgnoreCase("Y"))) {
                fss.caved = true;
            }
            if ((strg = rs.getString("marker")) != null && strg.compareToIgnoreCase("Y") == 0) {
                fss.marker = true;
            }
            fss.preservation = rs.getString("preserv");
            fss.colour = rs.getString("colour");
            fss.comment = rs.getString("comments");
            fss.status = STORED;
            Sample sample = samples.get(fss.sampID);
            if (sample == null) {
                System.out.println("Sample ID not found for sample: " + fss.sampID + " in Fssabnd::loadAll");
                continue;
            }
            Smpdtl smpdtl = sample.getSmpdtl(discID, analyst);
            if (smpdtl == null) {
                System.out.println("Sample details null for sample ID: " + fss.sampID + ", disc_id: " + discID + ", analyst: " + analyst + "  in Fssabnd::loadAll");
                continue;
            }
            try {
                smpdtl.insert(fss, false);
                ++nFss;
            }
            catch (SBException ex) {
                System.out.println("Error inserting fss record for specID: " + fss.specID + " " + fss.taxonRef + ", sample: " + sample + " ID: " + fss.sampID + ", disc_id: " + discID + ", analyst: " + analyst + "  in Fssabnd::loadAll");
            }
        }
        stmt.close();
        return nFss;
    }
}

