/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import model1_8.GrainSizeDepth;
import model1_8.SBException;
import model1_8.SBdb;
import util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrainSizeList
extends ArrayList<GrainSizeDepth> {
    SBdb SB;
    boolean isDirty = false;
    boolean isLoaded = false;

    @Override
    public boolean add(GrainSizeDepth grainSize) {
        Iterator it = this.iterator();
        int insertPoint = 0;
        int nzD = (int)(grainSize.depth * 100.0);
        boolean ignore = false;
        while (it.hasNext()) {
            GrainSizeDepth compareWith = (GrainSizeDepth)it.next();
            if (compareWith != grainSize) {
                int cD = (int)(compareWith.depth * 100.0);
                if (nzD == cD) {
                    ignore = true;
                }
                if (nzD < cD) break;
                ++insertPoint;
                continue;
            }
            return false;
        }
        if (!ignore) {
            super.add(insertPoint, grainSize);
            this.isDirty = true;
        }
        return true;
    }

    public void load(int wellID) throws SQLException {
        if (!this.isLoaded) {
            this.clear();
            String sql = "SELECT depth, grain_size FROM " + this.SB.DBTableName("sbgs") + "  WHERE well_id=" + wellID;
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                try {
                    double depth = rs.getDouble("depth");
                    double grainSize = rs.getDouble("grain_size");
                    GrainSizeDepth GrainSize = new GrainSizeDepth(depth, grainSize);
                    this.add(GrainSize);
                }
                catch (SBException se) {
                    System.out.println(se.getMessage());
                }
            }
            stmt.close();
            this.isDirty = false;
            this.isLoaded = true;
        }
    }

    public void deleteAll(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("sbgs") + " WHERE well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    @Override
    public void clear() {
        this.isDirty = false;
        this.isLoaded = false;
        super.clear();
    }

    public void store(int wellID) throws SQLException {
        if (this.isDirty) {
            Iterator it = this.iterator();
            this.deleteAll(wellID);
            it = this.iterator();
            String sql = "INSERT INTO " + this.SB.DBTableName("sbgs") + "(well_id,depth,grain_size) VALUES (?,?,?)";
            PreparedStatement stmt = this.SB.getDatabase().prepareStatement(this.SB.modQuery(sql));
            while (it.hasNext()) {
                GrainSizeDepth grainSize = (GrainSizeDepth)it.next();
                if (!(Math.abs(grainSize.depth) > 0.0)) continue;
                stmt.setInt(1, wellID);
                stmt.setDouble(2, grainSize.depth);
                stmt.setDouble(3, grainSize.grainSize);
                stmt.executeUpdate();
            }
            stmt.close();
            this.isDirty = false;
            this.isLoaded = true;
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        if (this.size() > 0) {
            Iterator it = this.iterator();
            out.write("[GrainSize]" + eol);
            while (it.hasNext()) {
                GrainSizeDepth GrainSize = (GrainSizeDepth)it.next();
                out.write("Depth/GrainSize = " + util.SB.getDepthString(GrainSize.depth, units, 2).trim() + " : " + util.SB.floatString(GrainSize.grainSize, 4) + eol);
            }
            out.write(eol);
        }
    }
}

