/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import model1_8.IGDInterval;
import model1_8.SBException;
import model1_8.SBdb;
import util.SB;

class IGDHdr {
    private SBdb SB;
    int igdType;
    String source;
    Date modified;
    String authorised;
    String comments;

    IGDHdr(SBdb SB2) {
        this.SB = SB2;
    }

    void store(int interpID, int wellID) throws SQLException, SBException {
        if (this.igdType == 0) {
            throw new SBException("Attempt to store IGD Header for null igd type");
        }
        String sql = "DELETE FROM " + this.SB.DBTableName("IGD_HDR") + " WHERE well_id=" + wellID + " AND " + IGDInterval.interpString(interpID, null) + " AND igd_type=" + this.igdType;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        this.modified = new Date();
        sql = "INSERT INTO " + this.SB.DBTableName("IGD_HDR") + " (well_id";
        if (interpID > 0) {
            sql = sql + ",interp_id";
        }
        sql = sql + ",igd_type,source,modified,authorised,comments) VALUES (" + wellID;
        if (interpID > 0) {
            sql = sql + "," + interpID;
        }
        sql = sql + "," + this.igdType + "," + util.SB.DBString(this.source) + ",'" + df.format(this.modified) + "'," + util.SB.DBString(this.authorised) + "," + util.SB.DBString(this.comments) + ")";
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    void load(int interpID, int wellID) throws SQLException, SBException {
        if (this.igdType == 0) {
            throw new SBException("Attempt to load IGD Header for null igd type");
        }
        String sql = "SELECT source,modified,authorised,comments FROM " + this.SB.DBTableName("IGD_HDR") + " WHERE well_id=" + wellID + " AND " + IGDInterval.interpString(interpID, null) + " AND igd_type=" + this.igdType;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            this.source = rs.getString("source");
            this.modified = rs.getDate("modified");
            this.authorised = rs.getString("authorised");
            this.comments = rs.getString("comments");
        }
        stmt.close();
    }
}

