/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Sample;
import util.SB;
import util.SbugsStatus;

public class IGDInterval
implements SbugsStatus {
    SBdb SB;
    public static final String[] igdTypes = new String[]{"Lithostratigraphy", "Chronostratigraphy", "Biozone Panel 1", "Biozone Panel 2", "Biozone Panel 3", "Biozone Panel 4", "Sequence", "Interpreted Lithology", "Lithology qualifiers", "Palaeoenvironment", "Biostratigraphic Comments"};
    static final String[] IGDIntervalTypes = new String[]{igdTypes[0], igdTypes[1], igdTypes[2], igdTypes[3], igdTypes[4], igdTypes[5], igdTypes[6]};
    public static final int IGD_LITHOSTRAT = 2;
    public static final int IGD_CHRONOSTRAT = 3;
    public static final int IGD_BIOZONE = 4;
    public static final int IGD_MBIOZONE = 41;
    public static final int IGD_NBIOZONE = 42;
    public static final int IGD_PBIOZONE = 43;
    public static final int IGD_ZBIOZONE = 44;
    public static final int IGD_SEQUENCE = 10;
    public static final int IGD_INTLITHOLOGY = 12;
    public static final int IGD_QUALLITHOLOGY = 13;
    public static final int IGD_ENVIRONMENT = 5;
    public static final int IGD_ALLBSCOMMENTS = 19;
    public static final int IGD_EVENT = 20;
    int igdType;
    Sample topSample = null;
    Sample baseSample = null;
    int topID = 0;
    int baseID = 0;
    String conflictReason;
    Color status = UNKNOWN;
    Date modified;
    String modifier;

    public int getIGDType() {
        return this.igdType;
    }

    public Sample getTopSample() {
        return this.topSample;
    }

    public Sample getBaseSample() {
        return this.baseSample;
    }

    public int getTopID() {
        return this.topID;
    }

    public int getBaseID() {
        return this.baseID;
    }

    public Date getModified() {
        return this.modified;
    }

    public String getModifier() {
        return this.modifier;
    }

    public IGDInterval(SBdb SB2) {
        this.SB = SB2;
        if (SB2.user != null) {
            this.modifier = SB2.user.getUsrID();
        }
    }

    public IGDInterval(IGDInterval i) {
        if (i == null) {
            return;
        }
        this.igdType = i.igdType;
        this.topSample = i.topSample;
        this.baseSample = i.baseSample;
        this.topID = i.topID;
        this.baseID = i.baseID;
        this.modified = i.modified;
        this.modifier = i.modifier;
    }

    public Color getStatus() {
        return this.status;
    }

    public static int dType2IGDtype(int dType) throws SBException {
        switch (dType) {
            case 9: {
                return 2;
            }
            case 10: {
                return 3;
            }
            case 12: {
                return 41;
            }
            case 13: {
                return 42;
            }
            case 14: {
                return 43;
            }
            case 15: {
                return 44;
            }
            case 11: {
                return 10;
            }
            case 16: {
                return 5;
            }
        }
        throw new SBException("Can't translate data type '" + dType + "' into IGDtype");
    }

    static int igdType2dType(int igdType) throws SBException {
        switch (igdType) {
            case 2: {
                return 9;
            }
            case 3: {
                return 10;
            }
            case 41: {
                return 12;
            }
            case 42: {
                return 13;
            }
            case 43: {
                return 14;
            }
            case 44: {
                return 15;
            }
            case 10: {
                return 11;
            }
            case 5: {
                return 16;
            }
        }
        throw new SBException("Can't translate igd type '" + igdType + "' into Data type");
    }

    public static int getIGDType(String type) {
        if (type.compareToIgnoreCase("Lithostratigraphy") == 0) {
            return 2;
        }
        if (type.compareToIgnoreCase("Chronostratigraphy") == 0) {
            return 3;
        }
        if (type.compareToIgnoreCase("Biozone") == 0) {
            return 4;
        }
        if (type.compareToIgnoreCase("Biozone Panel 1") == 0) {
            return 41;
        }
        if (type.compareToIgnoreCase("Biozone Panel 2") == 0) {
            return 42;
        }
        if (type.compareToIgnoreCase("Biozone Panel 3") == 0) {
            return 43;
        }
        if (type.compareToIgnoreCase("Biozone Panel 4") == 0) {
            return 44;
        }
        if (type.compareToIgnoreCase("Sequence") == 0) {
            return 10;
        }
        if (type.compareToIgnoreCase("Palaeoenvironment") == 0) {
            return 5;
        }
        if (type.equalsIgnoreCase(SBdb.getDiscAdj('M') + " Biozone")) {
            return 41;
        }
        if (type.equalsIgnoreCase(SBdb.getDiscAdj('N') + " Biozone")) {
            return 42;
        }
        if (type.equalsIgnoreCase(SBdb.getDiscAdj('P') + " Biozone")) {
            return 43;
        }
        if (type.equalsIgnoreCase(SBdb.getDiscAdj('A') + " Biozone")) {
            return 44;
        }
        return 0;
    }

    public static boolean isBiozoneType(int igdType) {
        switch (igdType) {
            case 4: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return true;
            }
        }
        return false;
    }

    public static String getIGDTypeName(int igdType) {
        switch (igdType) {
            case 41: {
                return SBdb.getDiscAdj('M') + " Biozone";
            }
            case 42: {
                return SBdb.getDiscAdj('N') + " Biozone";
            }
            case 43: {
                return SBdb.getDiscAdj('P') + " Biozone";
            }
            case 44: {
                return SBdb.getDiscAdj('A') + " Biozone";
            }
        }
        return IGDInterval.getIGDName(igdType);
    }

    public static String getIGDName(int igdType) {
        switch (igdType) {
            case 2: {
                return "Lithostratigraphy";
            }
            case 3: {
                return "Chronostratigraphy";
            }
            case 4: {
                return "Biozone";
            }
            case 41: {
                return "Biozone Panel 1";
            }
            case 42: {
                return "Biozone Panel 2";
            }
            case 43: {
                return "Biozone Panel 3";
            }
            case 44: {
                return "Biozone Panel 4";
            }
            case 10: {
                return "Sequence";
            }
            case 5: {
                return "Palaeoenvironment";
            }
            case 19: {
                return "Biostratigraphic Comments";
            }
        }
        return "Attempt to return string for IGD type : " + igdType;
    }

    static String interpString(int interpID, String columnAlias) {
        columnAlias = columnAlias == null ? "" : columnAlias + ".";
        if (interpID != 0) {
            return columnAlias + "interp_id=" + interpID;
        }
        return "(" + columnAlias + "interp_id=0 OR " + columnAlias + "interp_id is null)";
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    public String statusString() {
        return this.toString();
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException, SBException {
        out.write("[INTERVAL " + util.SB.getDepthString(this.topSample.getDepth('M'), units, 2).trim() + " - " + util.SB.getDepthString(this.baseSample.getDepth('M'), units, 2).trim() + "]" + eol);
    }

    public boolean checkDepthBracketing(int cTD, int cBD, int nzTD, int nzBD) {
        if (nzTD == nzBD) {
            if (nzTD > cTD && nzTD < cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New zone depth lies inside existing data";
                return false;
            }
            if (nzTD == cTD && nzTD == cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New zone depths same as existing data";
                return false;
            }
        } else {
            if (nzTD < cTD && nzBD > cTD) {
                this.status = CONFLICT;
                this.conflictReason = "New zone depth overlaps existing data";
                return false;
            }
            if (nzTD < cBD && nzBD > cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New zone depth overlaps existing data";
                return false;
            }
            if (nzTD > cTD && nzBD < cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New zone depth is overlapped by existing data";
                return false;
            }
            if (nzTD < cTD && nzBD > cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New zone depth overlaps existing data";
                return false;
            }
            if (nzTD == cTD && nzBD == cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New zone depth is the same as existing data";
                return false;
            }
        }
        return true;
    }
}

