/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import model1_8.EnvScheme;
import model1_8.IGDInterval;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Sample;
import util.SB;

public class IGDIntervalEnv
extends IGDInterval {
    private int schID = 0;
    int donorSchID = 0;
    private EnvScheme scheme = null;
    private int up;
    private int ud;
    private int lp;
    private int ld;
    private int qual;

    public int getSchID() {
        return this.schID;
    }

    public EnvScheme getScheme() {
        return this.scheme;
    }

    public int getUp() {
        return this.up;
    }

    public int getUd() {
        return this.ud;
    }

    public int getLd() {
        return this.ld;
    }

    public int getLp() {
        return this.lp;
    }

    public int getQual() {
        return this.qual;
    }

    IGDIntervalEnv(SBdb SB2) {
        super(SB2);
    }

    public IGDIntervalEnv(SBdb SB2, Sample topSample, Sample baseSample, EnvScheme scheme, int up, int ud, int lp, int ld, int qual, String modifier, Date modified) throws SBException {
        super(SB2);
        if (topSample == null) {
            throw new SBException("Null top Sample in Environment interval");
        }
        this.topSample = topSample;
        this.topID = topSample.getSampID();
        if (baseSample == null) {
            throw new SBException("Null base Sample in Environment interval");
        }
        this.baseSample = baseSample;
        this.baseID = baseSample.getSampID();
        this.scheme = scheme;
        if (scheme != null) {
            this.schID = scheme.getID();
        }
        this.up = up;
        this.ud = ud;
        this.lp = lp;
        this.ld = ld;
        this.qual = qual;
        this.modifier = modifier;
        this.modified = modified;
    }

    public IGDIntervalEnv(IGDIntervalEnv i) {
        super(i);
        if (i == null) {
            return;
        }
        this.up = i.up;
        this.ud = i.ud;
        this.lp = i.lp;
        this.ld = i.ld;
        this.qual = i.qual;
        this.schID = i.schID;
        this.scheme = i.scheme;
        this.donorSchID = i.donorSchID;
    }

    public void store(int interpID) throws SQLException {
        if (this.schID == 0 && this.scheme.getID() != 0) {
            this.schID = this.scheme.getID();
        }
        if (this.status == NOTSTORED && this.topSample != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            if (this.modified == null) {
                this.modified = new Date();
            }
            if (this.modifier == null || this.modifier.length() == 0) {
                this.modifier = this.SB.user.getUsrID();
            }
            String sql = "INSERT INTO " + this.SB.DBTableName("IGD_ENV") + " (top_id,base_id,interp_id,sch_id,up,ud,lp,ld,qual,modified,modifier) VALUES (" + this.topSample.getSampID() + "," + (this.baseSample == null ? "0" : String.valueOf(this.baseSample.getSampID())) + "," + interpID + "," + this.schID + "," + this.up + "," + this.ud + "," + this.lp + "," + this.ld + "," + this.qual + ",";
            sql = sql + "'" + df.format(this.modified) + "'," + util.SB.DBString(this.modifier) + ")";
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(this.SB.modQuery(sql));
            stmt.close();
            this.status = STORED;
        } else if (this.status == PARTSTORED) {
            JOptionPane.showMessageDialog(null, "Attempt to update IGDEnv");
        }
    }

    void delete(int interpID) throws SQLException, SBException {
        String sql = "DELETE FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE top_id=" + this.topID + " AND base_id=" + this.baseID + " AND " + IGDIntervalEnv.interpString(interpID, null);
        Statement stmt = this.SB.getDatabase().createStatement();
        int nDel = stmt.executeUpdate(this.SB.modQuery(sql));
        if (nDel == 0) {
            throw new SBException("Cannot delete IGD_ENV item: " + this.toString() + ". Top ID=" + this.topID);
        }
        stmt.close();
    }

    public String toString() {
        if (this.scheme == null) {
            return "" + this.up + "," + this.ud + "," + this.lp + "," + this.ld;
        }
        String strg = this.scheme.getTerm(this.up);
        if (this.up != this.ud) {
            strg = strg + "/" + this.scheme.getTerm(this.ud);
        }
        if (this.lp != this.up) {
            strg = strg + " - " + this.scheme.getTerm(this.lp);
        }
        if (this.ld != this.lp) {
            strg = strg + "/" + this.scheme.getTerm(this.ld);
        }
        return strg;
    }

    void updateStatus(List igdList) throws SQLException, SBException {
        if (this.topSample != null) {
            this.topID = this.topSample.getSampID();
        }
        if (this.baseSample != null) {
            this.baseID = this.baseSample.getSampID();
        }
        this.status = NOTSTORED;
        this.conflictReason = "";
        int nzTD = (int)(100.0 * this.topSample.getDepth('M'));
        int nzBD = (int)(100.0 * this.baseSample.getDepth('M'));
        for (IGDIntervalEnv zone : igdList) {
            int cBD;
            if (zone == this) continue;
            if (this.topID != 0 && this.topID == zone.topID && this.baseID != 0 && this.baseID == zone.baseID) {
                this.status = STORED;
                if (this.up != zone.up) {
                    this.status = CONFLICT;
                    this.conflictReason = "Upper proxial not same as existing data";
                }
                if (this.ud != zone.ud) {
                    this.status = CONFLICT;
                    this.conflictReason = "Upper distal not same as existing data";
                }
                if (this.lp != zone.lp) {
                    this.status = CONFLICT;
                    this.conflictReason = "Lower proxial not same as existing data";
                }
                if (this.ld != zone.ld) {
                    this.status = CONFLICT;
                    this.conflictReason = "Lower distal not same as existing data";
                }
                if (this.qual != zone.qual) {
                    this.status = CONFLICT;
                    this.conflictReason = "Qualifier not same as existing data: " + this.qual + ", existing: " + zone.qual;
                }
                if (this.status == CONFLICT) break;
                this.modified = zone.modified;
                this.modifier = zone.modifier;
                break;
            }
            int cTD = (int)(100.0 * zone.topSample.getDepth('M'));
            if (this.checkDepthBracketing(cTD, cBD = (int)(100.0 * zone.baseSample.getDepth('M')), nzTD, nzBD)) continue;
            break;
        }
    }

    int getAnySchID() {
        if (this.schID > 0) {
            return this.schID;
        }
        return this.donorSchID;
    }

    void writeDEX(FileWriter out, String eol, char units, SimpleDateFormat df) throws IOException, SBException {
        out.write("[INTERVAL " + this.topSample.getDepth(units) + " - " + this.baseSample.getDepth(units) + "]" + eol);
        out.write(IGDInterval.getIGDTypeName(5) + " = " + this.toString() + eol);
        if (this.getAnySchID() > 0) {
            out.write("Environment scheme ID : " + this.getSchID() + eol);
        }
        out.write("Top sample : " + this.topSample.toString() + eol);
        out.write("Base sample : " + this.baseSample.toString() + eol);
        out.write("Top sample ID : " + this.topSample.getID() + eol);
        out.write("Base sample ID : " + this.baseSample.getID() + eol);
        out.write("Upper proximal unit : " + this.scheme.getTerm(this.up) + eol);
        out.write("Upper distal unit : " + this.scheme.getTerm(this.ud) + eol);
        out.write("Lower proximal unit : " + this.scheme.getTerm(this.lp) + eol);
        out.write("Lower distal unit : " + this.scheme.getTerm(this.ld) + eol);
        if (this.qual > 0) {
            out.write("Environment qualifier : " + this.scheme.getTerm(this.qual) + eol);
        }
        if (this.modified != null) {
            out.write("Modified = " + df.format(this.modified) + eol);
        }
        if (this.modifier != null && this.modifier.length() > 0) {
            out.write("Modifier = " + this.modifier + eol);
        }
        out.write(eol);
    }
}

