/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import model1_8.IGDIntervalZone;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Sample;
import model1_8.Well;
import util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGDIntervalSeq
extends IGDIntervalZone {
    private boolean LST;
    private boolean TST;
    private boolean HST;
    private String lstInformal;
    private String tstInformal;
    private String hstInformal;
    private Sample tsSample;
    private Sample mfsSample;
    private int tsID;
    private int mfsID;

    public boolean getLST() {
        return this.LST;
    }

    public boolean getTST() {
        return this.TST;
    }

    public boolean getHST() {
        return this.HST;
    }

    public String getLstinformal() {
        return this.lstInformal;
    }

    public String getTstinformal() {
        return this.tstInformal;
    }

    public String getHstinformal() {
        return this.hstInformal;
    }

    public Sample getTsSample() {
        return this.tsSample;
    }

    public Sample getMfsSample() {
        return this.mfsSample;
    }

    public int getTsID() {
        return this.tsID;
    }

    public int getMfsID() {
        return this.mfsID;
    }

    public IGDIntervalSeq(SBdb SB2, Well well, int topID, int baseID, String topAnalyst, String baseAnalyst, int topBnd, int baseBnd, int plotPos, int schID, int uppZone, String uppInf, int lowZone, String lowInf, boolean qUzone, boolean qLzone, String modifier, Date modified) throws SQLException, SBException {
        super(SB2, 10, well, topID, baseID, "", "", topBnd, baseBnd, plotPos, schID, uppZone, uppInf, lowZone, lowInf, qUzone, qLzone, modifier, modified);
    }

    public IGDIntervalSeq(SBdb SB2, Well well, int topID, int baseID, String topAnalyst, String baseAnalyst, int topBnd, int baseBnd, int plotPos, int schID, int uppZone, String uppInf, int lowZone, String lowInf, boolean qUzone, boolean qLzone, boolean LST, boolean TST, boolean HST, String lstInformal, String tstInformal, String hstInformal, Sample mfsSample, Sample tsSample, String modifier, Date modified) throws SQLException, SBException {
        super(SB2, 10, well, topID, baseID, "", "", topBnd, baseBnd, plotPos, schID, uppZone, uppInf, lowZone, lowInf, qUzone, qLzone, modifier, modified);
        this.LST = LST;
        this.TST = TST;
        this.HST = HST;
        this.lstInformal = lstInformal;
        this.tstInformal = tstInformal;
        this.hstInformal = hstInformal;
        if (tsSample != null) {
            this.tsID = tsSample.getID();
            this.tsSample = tsSample;
        }
        if (mfsSample != null) {
            this.mfsID = mfsSample.getID();
            this.mfsSample = mfsSample;
        }
    }

    void setTract(int tsID, int mfsID, boolean LST, boolean TST, boolean HST, String lstInformal, String tstInformal, String hstInformal) {
        this.tsID = tsID;
        this.mfsID = mfsID;
        this.LST = LST;
        this.TST = TST;
        this.HST = HST;
        this.lstInformal = lstInformal;
        this.tstInformal = tstInformal;
        this.hstInformal = hstInformal;
    }

    public IGDIntervalSeq(IGDIntervalZone zone) {
        super(zone);
    }

    public IGDIntervalSeq(IGDIntervalSeq zone) {
        super(zone);
        if (zone != null) {
            this.LST = zone.LST;
            this.lstInformal = zone.lstInformal;
            this.TST = zone.TST;
            this.tstInformal = zone.tstInformal;
            this.HST = zone.HST;
            this.hstInformal = zone.hstInformal;
            this.tsID = zone.tsID;
            this.tsSample = zone.tsSample;
            this.mfsID = zone.mfsID;
            this.mfsSample = zone.mfsSample;
        }
    }

    @Override
    public void store(int interpID) throws SQLException {
        if (this.status == NOTSTORED) {
            if (this.LST || this.TST || this.HST) {
                String sql = "INSERT INTO " + this.SB.DBTableName("SQTRACT") + " (top_id,base_id,interp_id,plot_pos,lst,lst_inf,tst,tst_inf,hst,hst_inf,ts_id,mfs_id) VALUES (" + this.topSample.getSampID() + "," + this.baseSample.getSampID() + "," + interpID + ",1" + ",'" + (this.LST ? (char)'Y' : 'N') + "'," + util.SB.DBString(this.lstInformal) + ",'" + (this.TST ? (char)'Y' : 'N') + "'," + util.SB.DBString(this.tstInformal) + ",'" + (this.HST ? (char)'Y' : 'N') + "'," + util.SB.DBString(this.hstInformal) + "," + (this.tsSample != null ? this.tsSample.getSampID() : 0) + "," + (this.mfsSample != null ? this.mfsSample.getSampID() : 0) + ")";
                Statement stmt = this.SB.getDatabase().createStatement();
                stmt.executeUpdate(this.SB.modQuery(sql));
                stmt.close();
            }
            super.store(interpID);
        }
    }

    @Override
    void delete(int interpID) throws SQLException, SBException {
        String sql = "DELETE FROM " + this.SB.DBTableName("SQTRACT") + " WHERE top_id=" + this.topID + " AND base_id=" + this.baseID + " AND " + IGDIntervalSeq.interpString(interpID, null);
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        super.delete(interpID);
    }

    void writeDEX(FileWriter out, String eol, char units, List igdSchemes, SimpleDateFormat df) throws IOException, SBException {
        super.writeDEX(out, eol, units, null, igdSchemes, df);
        if (this.HST || this.TST || this.LST) {
            if (this.HST) {
                out.write("  Highstand Tract : " + this.hstInformal + eol);
            }
            if (this.mfsID > 0) {
                out.write("  Maximum Flooding Surface : " + this.mfsSample.toString() + eol);
                out.write("  Maximum Flooding Surface ID : " + this.mfsID + eol);
            }
            if (this.TST) {
                out.write("  Transgressive Tract : " + this.tstInformal + eol);
            }
            if (this.tsID > 0) {
                out.write("  Transgressive Surface : " + this.tsSample + eol);
                out.write("  Transgressive Surface ID : " + this.tsID + eol);
            }
            if (this.LST) {
                out.write("  Lowstand Tract : " + this.lstInformal + eol);
            }
        }
    }

    static int loadAll(SBdb SB2, HashMap<String, IGDIntervalSeq> sequences) throws SQLException, SBException {
        String sql = "SELECT interp_id,top_id,base_id,plot_pos,lst,lst_inf,tst,tst_inf,hst,hst_inf,ts_id,mfs_id FROM " + SB2.DBTableName("SQTRACT");
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        int n = 0;
        while (rs.next()) {
            int interpID = rs.getInt("interp_id");
            int topID = rs.getInt("top_id");
            int baseID = rs.getInt("base_id");
            IGDIntervalSeq zone = sequences.get("" + interpID + " " + topID + " " + baseID);
            if (zone != null) {
                String strg = rs.getString("lst");
                if (strg != null && strg.charAt(0) == 'Y') {
                    zone.LST = true;
                }
                zone.lstInformal = rs.getString("lst_inf");
                strg = rs.getString("tst");
                if (strg != null && strg.charAt(0) == 'Y') {
                    zone.TST = true;
                }
                zone.tstInformal = rs.getString("tst_inf");
                strg = rs.getString("hst");
                if (strg != null && strg.charAt(0) == 'Y') {
                    zone.HST = true;
                }
                zone.hstInformal = rs.getString("hst_inf");
                zone.tsID = rs.getInt("ts_id");
                zone.mfsID = rs.getInt("mfs_id");
                ++n;
                continue;
            }
            System.out.println("Cannot find sequence interval for tract interpID: " + interpID + ", topID: " + topID + ", baseID: " + baseID);
        }
        stmt.close();
        return n;
    }
}

