/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import model1_8.IGDInterval;
import model1_8.IGDIntervalSeq;
import model1_8.IGDScheme;
import model1_8.IGDUnit;
import model1_8.InterpHdr;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Sample;
import model1_8.Well;
import model1_8.WellInterp;
import util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGDIntervalZone
extends IGDInterval {
    public static final int POSS = 1;
    public static final int PROB = 2;
    public static final int CONF = 3;
    public static final int UNCF = 4;
    public static final int QUNCF = 5;
    public static final int FAULT = 6;
    public static final int QFAULT = 7;
    public static final int INHERITED = 8;
    public static final String[] bnds = new String[]{"Possible", "Probable", "Confident", "Unconformable", "?Unconformable", "Fault", "?Fault"};
    private int topBnd = 2;
    private int baseBnd = 2;
    private int plotPos = 1;
    private int schID = 0;
    int donorSchID = 0;
    private boolean qUzone = false;
    private int uppZone = 0;
    protected int donorUppZone = 0;
    private String uppInf = "";
    private String sep = "-";
    private boolean qLzone = false;
    private int lowZone = 0;
    int donorLowZone = 0;
    private String lowInf = "";
    private String topAnalyst = "";
    private String baseAnalyst = "";

    public int getPlotPos() {
        return this.plotPos;
    }

    public int getSchID() {
        return this.schID;
    }

    public boolean getQUzone() {
        return this.qUzone;
    }

    public boolean getQLzone() {
        return this.qLzone;
    }

    public int getUppZone() {
        return this.uppZone;
    }

    public int getLowZone() {
        return this.lowZone;
    }

    public String getUppInf() {
        return this.uppInf;
    }

    public String getLowInf() {
        return this.lowInf;
    }

    public String getTopAnalyst() {
        return this.topAnalyst;
    }

    public String getBaseAnalyst() {
        return this.baseAnalyst;
    }

    public IGDIntervalZone(SBdb SB2) {
        super(SB2);
        this.SB = SB2;
    }

    public IGDIntervalZone(IGDIntervalZone i) {
        super(i);
        if (i == null) {
            return;
        }
        this.SB = i.SB;
        this.topBnd = i.topBnd;
        this.baseBnd = i.baseBnd;
        this.topAnalyst = i.topAnalyst;
        this.baseAnalyst = i.baseAnalyst;
        this.plotPos = i.plotPos;
        this.schID = i.schID;
        this.donorSchID = i.donorSchID;
        this.qUzone = i.qUzone;
        this.uppZone = i.uppZone;
        this.donorUppZone = i.donorUppZone;
        this.uppInf = i.uppInf;
        this.sep = i.sep;
        this.qLzone = i.qLzone;
        this.lowZone = i.lowZone;
        this.donorLowZone = i.donorLowZone;
        this.lowInf = i.lowInf;
    }

    IGDIntervalZone(SBdb SB2, int igdType, Well well, int topID, int baseID, String topAnalyst, String baseAnalyst, int topBnd, int baseBnd, int plotPos, int schID, int uppZone, String uppInf, int lowZone, String lowInf, boolean qUzone, boolean qLzone, String modifier, java.util.Date modified) throws SQLException, SBException {
        super(SB2);
        this.igdType = igdType;
        this.topID = topID;
        this.topSample = well.getSample(topID);
        if (this.topSample == null) {
            this.topSample = new Sample(SB2, topID, well.getType());
            Sample.insert(well.samples, this.topSample, well.getWellUnits());
        }
        this.baseID = baseID;
        this.baseSample = well.getSample(baseID);
        if (this.baseSample == null) {
            this.baseSample = new Sample(SB2, baseID, well.getType());
            Sample.insert(well.samples, this.baseSample, well.getWellUnits());
        }
        this.topAnalyst = topAnalyst == null ? "" : topAnalyst;
        this.baseAnalyst = baseAnalyst == null ? "" : baseAnalyst;
        this.topBnd = topBnd;
        this.baseBnd = baseBnd;
        this.plotPos = plotPos;
        this.schID = schID;
        this.uppZone = uppZone;
        this.lowZone = lowZone;
        this.uppInf = uppInf;
        this.lowInf = lowInf;
        this.qUzone = qUzone;
        this.qLzone = qLzone;
        this.modifier = modifier;
        this.modified = modified;
        if (lowInf == null) {
            if (lowZone == uppZone) {
                lowZone = 0;
            }
        } else if (lowInf.equals(uppInf)) {
            lowInf = "";
            if (lowZone == uppZone) {
                lowZone = 0;
            }
        }
        this.status = STORED;
    }

    public String getTopBnd() {
        return IGDIntervalZone.getBoundary(this.topBnd);
    }

    public int getTopBndID() {
        return this.topBnd;
    }

    public int getBaseBndID() {
        return this.baseBnd;
    }

    public String getBaseBnd() {
        return IGDIntervalZone.getBoundary(this.baseBnd);
    }

    static int getBoundaryTypeFromString(String bnd) {
        for (int i = 0; i < bnds.length; ++i) {
            if (!bnd.equalsIgnoreCase(bnds[i])) continue;
            return i + 1;
        }
        return 2;
    }

    static int getBoundaryTypeFromAbr(String bnd) {
        if ((bnd = bnd.toUpperCase()).compareTo("POSS") == 0) {
            return 1;
        }
        if (bnd.compareTo("PROB") == 0) {
            return 2;
        }
        if (bnd.compareTo("CONF") == 0) {
            return 3;
        }
        if (bnd.compareTo("UNCF") == 0) {
            return 4;
        }
        if (bnd.compareTo("QUNC") == 0) {
            return 5;
        }
        if (bnd.compareTo("FAULT") == 0) {
            return 6;
        }
        if (bnd.compareTo("QFAULT") == 0) {
            return 7;
        }
        return 3;
    }

    static String getBoundary(int bnd) {
        if (--bnd >= 0 && bnd < bnds.length) {
            return bnds[bnd];
        }
        return "Unknown";
    }

    public static int getNHier(int igdType, boolean extendedSet) {
        switch (igdType) {
            case 3: {
                if (extendedSet) {
                    return 8;
                }
                return 2;
            }
            case 2: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return 4;
            }
        }
        return 1;
    }

    public static int getHierNumber(int igdType, String hier, boolean extendedSet) {
        switch (igdType) {
            case 3: {
                if (extendedSet) {
                    if (hier.equalsIgnoreCase("Eon")) {
                        return 1;
                    }
                    if (hier.equalsIgnoreCase("Era")) {
                        return 2;
                    }
                    if (hier.equalsIgnoreCase("Period")) {
                        return 3;
                    }
                    if (hier.equalsIgnoreCase("Sub Period")) {
                        return 4;
                    }
                    if (hier.equalsIgnoreCase("Epoch")) {
                        return 5;
                    }
                    if (hier.equalsIgnoreCase("Sub Epoch")) {
                        return 6;
                    }
                    if (hier.equalsIgnoreCase("Age")) {
                        return 7;
                    }
                    if (hier.equalsIgnoreCase("Sub Age")) {
                        return 8;
                    }
                    return 0;
                }
                if (hier.equalsIgnoreCase("Period/Epoch")) {
                    return 1;
                }
                if (hier.equalsIgnoreCase("Age")) {
                    return 2;
                }
                return 0;
            }
            case 2: {
                if (hier.equalsIgnoreCase("Group")) {
                    return 1;
                }
                if (hier.equalsIgnoreCase("Formation")) {
                    return 2;
                }
                if (hier.equalsIgnoreCase("Member")) {
                    return 3;
                }
                if (!hier.equalsIgnoreCase("Bed")) break;
                return 4;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                if (hier.equalsIgnoreCase("Scheme")) {
                    return 1;
                }
                if (hier.equalsIgnoreCase("Super Zone")) {
                    return 2;
                }
                if (hier.equalsIgnoreCase("Zone")) {
                    return 3;
                }
                if (!hier.equalsIgnoreCase("Sub Zone")) break;
                return 4;
            }
            case 10: {
                return 1;
            }
        }
        return 0;
    }

    public static String getHierName(int igdType, int hier, boolean extendedSet) {
        switch (igdType) {
            case 3: {
                if (extendedSet) {
                    switch (hier) {
                        case 1: {
                            return "Eon";
                        }
                        case 2: {
                            return "Era";
                        }
                        case 3: {
                            return "Period";
                        }
                        case 4: {
                            return "Sub Period";
                        }
                        case 5: {
                            return "Epoch";
                        }
                        case 6: {
                            return "Sub Epoch";
                        }
                        case 7: {
                            return "Age";
                        }
                        case 8: {
                            return "Sub Age";
                        }
                    }
                    break;
                }
                switch (hier) {
                    case 1: {
                        return "Period/Epoch";
                    }
                    case 2: {
                        return "Age";
                    }
                }
                break;
            }
            case 2: {
                switch (hier) {
                    case 1: {
                        return "Group";
                    }
                    case 2: {
                        return "Formation";
                    }
                    case 3: {
                        return "Member";
                    }
                    case 4: {
                        return "Bed";
                    }
                }
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                switch (hier) {
                    case 1: {
                        return "Scheme";
                    }
                    case 2: {
                        return "Super Zone";
                    }
                    case 3: {
                        return "Zone";
                    }
                    case 4: {
                        return "Sub Zone";
                    }
                }
                break;
            }
            case 10: {
                return "Sequence";
            }
        }
        return "";
    }

    void setBase(Sample sample, int bnd, String analyst) {
        this.baseSample = sample;
        this.baseID = this.baseSample.getSampID();
        this.baseBnd = bnd;
        this.baseAnalyst = analyst;
    }

    void setTop(Sample sample, int bnd, String analyst) {
        this.topSample = sample;
        this.topBnd = bnd;
        this.topID = this.topSample.getSampID();
        this.topAnalyst = analyst;
    }

    void store(int interpID) throws SQLException {
        if (this.status == NOTSTORED && this.topSample != null) {
            if (this.modified == null) {
                this.modified = new java.util.Date();
            }
            if (this.modifier == null) {
                this.modifier = this.SB.user.getUsrID();
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String sql = "INSERT INTO " + this.SB.DBTableName("IGD") + " (igd_type,top_id,base_id,interp_id,top_bnd,base_bnd,plot_pos,sch_id,q_uzone,upp_zone,upp_inf,q_lzone" + (this.lowZone != this.uppZone ? ",low_zone" : "") + (this.lowInf == null || this.lowInf.equals(this.uppInf) ? "" : ",low_inf") + (this.SB.hasIGDSep ? ",sep" : "") + (this.topAnalyst != null && this.topAnalyst.length() > 0 ? ",top_analy" : "") + (this.baseAnalyst != null && this.baseAnalyst.length() > 0 ? ",base_analy" : "") + ",modified,modifier" + " ) VALUES (" + this.igdType + "," + this.topSample.getSampID() + "," + (this.baseSample == null ? "0" : String.valueOf(this.baseSample.getSampID())) + "," + interpID + "," + this.topBnd + "," + this.baseBnd + "," + this.plotPos + "," + this.schID + "," + (this.qUzone ? "'Y'," : "'N',") + this.uppZone + "," + util.SB.DBString(this.uppInf) + "," + (this.qLzone && this.lowInf != null && !this.lowInf.equals(this.uppInf) ? "'Y'," : "'N',");
            if (this.lowZone != this.uppZone) {
                sql = sql + this.lowZone + ",";
            }
            if (this.lowInf != null && !this.lowInf.equals(this.uppInf)) {
                sql = sql + util.SB.DBString(this.lowInf) + ",";
            }
            if (this.SB.hasIGDSep) {
                sql = sql + "'" + this.sep + "',";
            }
            if (this.topAnalyst != null && this.topAnalyst.length() > 0) {
                sql = sql + util.SB.DBString(this.topAnalyst) + ",";
            }
            if (this.baseAnalyst != null && this.baseAnalyst.length() > 0) {
                sql = sql + util.SB.DBString(this.baseAnalyst) + ",";
            }
            sql = sql + "'" + df.format(this.modified) + "'," + util.SB.DBString(this.modifier);
            sql = sql + ")";
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(this.SB.modQuery(sql));
            stmt.close();
            this.status = STORED;
        } else if (this.status == PARTSTORED) {
            JOptionPane.showMessageDialog(null, "Attempt to update IGDzone");
        }
    }

    void delete(int interpID) throws SQLException, SBException {
        String sql = "DELETE FROM " + this.SB.DBTableName("IGD") + " WHERE igd_type=" + this.igdType + " AND plot_pos=" + this.plotPos + " AND top_id=" + this.topID + " AND base_id=" + this.baseID + " AND " + IGDIntervalZone.interpString(interpID, null);
        Statement stmt = this.SB.getDatabase().createStatement();
        int nDel = stmt.executeUpdate(this.SB.modQuery(sql));
        if (nDel == 0) {
            throw new SBException("Cannot delete IGD item: " + this.toString() + ". Top ID=" + this.topID);
        }
        stmt.close();
    }

    public String toString() {
        String strg = (this.qUzone ? "?" : "") + this.uppInf;
        if (this.lowInf != null && this.lowInf.length() > 0 && !this.lowInf.equalsIgnoreCase(this.uppInf)) {
            strg = strg + " " + (this.sep != null ? this.sep : "-") + " " + (this.qLzone ? "?" : "") + this.lowInf;
        }
        return strg;
    }

    void updateStatus(List igdList) throws SQLException, SBException {
        if (this.topSample != null) {
            this.topID = this.topSample.getSampID();
        }
        if (this.baseSample != null) {
            this.baseID = this.baseSample.getSampID();
        }
        this.status = NOTSTORED;
        this.conflictReason = "";
        int nzTD = (int)Math.round(100.0 * this.topSample.getDepth('M'));
        int nzBD = (int)Math.round(100.0 * this.baseSample.getDepth('M'));
        for (IGDIntervalZone zone : igdList) {
            int cBD;
            if (zone == this) continue;
            if (this.topID != 0 && this.topID == zone.topID && this.baseID != 0 && this.baseID == zone.baseID && this.plotPos == zone.plotPos) {
                this.status = STORED;
                if (this.topBnd != zone.topBnd) {
                    this.status = CONFLICT;
                    this.conflictReason = "Top boundary not same as existing data";
                }
                if (this.baseBnd != zone.baseBnd) {
                    this.status = CONFLICT;
                    this.conflictReason = "Base boundary not same as existing data";
                }
                if (!this.uppInf.equalsIgnoreCase(zone.uppInf)) {
                    this.status = CONFLICT;
                    this.conflictReason = "Upper informal name not same as existing data";
                } else if (this.uppZone == 0 && zone.uppZone != 0) {
                    this.uppZone = zone.uppZone;
                    this.schID = zone.schID;
                }
                if (this.lowInf == null) {
                    this.lowInf = "";
                }
                if (zone.lowInf == null) {
                    zone.lowInf = "";
                }
                if (!this.lowInf.equalsIgnoreCase(zone.lowInf) && !this.lowInf.equals(this.uppInf)) {
                    this.status = CONFLICT;
                    this.conflictReason = "Lower informal name not same as existing data";
                } else if (this.lowZone == 0 && zone.lowZone != 0) {
                    this.lowZone = zone.lowZone;
                    this.schID = zone.schID;
                }
                if (this.sep == null || this.sep.length() == 0) {
                    this.sep = "-";
                }
                if (zone.sep == null || zone.sep.length() == 0) {
                    zone.sep = "-";
                }
                if (!this.sep.equals(zone.sep)) {
                    this.status = CONFLICT;
                    this.conflictReason = "Zone separator not same as existing data";
                }
                if (this.qUzone != zone.qUzone) {
                    this.status = CONFLICT;
                    this.conflictReason = "Upper informal 'questionable' not same as existing data";
                }
                if (this.qLzone != zone.qLzone) {
                    this.status = CONFLICT;
                    this.conflictReason = "Lower informal 'questionable' not same as existing data";
                }
                if (!this.topAnalyst.equals(zone.topAnalyst)) {
                    this.status = CONFLICT;
                    this.conflictReason = "Top sample analyst not same as existing data";
                }
                if (!this.baseAnalyst.equals(zone.baseAnalyst)) {
                    this.status = CONFLICT;
                    this.conflictReason = "Base sample analyst not same as existing data";
                }
                if (this.status == CONFLICT) break;
                this.modified = zone.modified;
                this.modifier = zone.modifier;
                break;
            }
            if (this.plotPos != zone.plotPos) continue;
            int cTD = (int)Math.round(100.0 * zone.topSample.getDepth('M'));
            if (!this.checkDepthBracketing(cTD, cBD = (int)Math.round(100.0 * zone.baseSample.getDepth('M')), nzTD, nzBD)) break;
            float diff = Math.abs(cBD - nzTD);
            if ((double)diff < 1.0E-4 && zone.baseBnd != this.topBnd) {
                this.status = CONFLICT;
                this.conflictReason = "New zone top boundary type conflicts with base of existing data";
                break;
            }
            diff = Math.abs(cTD - nzBD);
            if ((double)diff < 1.0E-4 && zone.topBnd != this.baseBnd) {
                this.status = CONFLICT;
                this.conflictReason = "New zone base boundary type conflicts with top of existing data";
            }
            if (this.status != CONFLICT) continue;
            break;
        }
    }

    public String getLinkString() {
        String linkString;
        String string = linkString = this.uppZone == 0 ? "No" : "Yes";
        if (this.lowZone != 0 && this.lowZone != this.uppZone) {
            linkString = linkString + (this.lowZone == 0 ? "/No" : "/Yes");
        }
        while (linkString.length() < 30) {
            linkString = linkString + ' ';
        }
        linkString = linkString + "(sch=" + this.schID + ")";
        return linkString;
    }

    void writeDEX(FileWriter out, String eol, char units, String[] bzTitle, List igdSchemes, SimpleDateFormat df) throws IOException, SBException {
        IGDUnit unit;
        super.writeDEX(out, eol, units);
        if (IGDIntervalZone.isBiozoneType(this.igdType)) {
            out.write("Type = Biozone" + eol);
            out.write("Biozone data = ");
            if (bzTitle[this.igdType - 41].length() > 0) {
                out.write(bzTitle[this.igdType - 41] + eol);
            } else {
                out.write("Biozone panel " + (this.igdType - 40) + eol);
            }
        } else {
            out.write("Type = " + IGDIntervalZone.getIGDTypeName(this.igdType) + eol);
        }
        out.write(IGDIntervalZone.getHierName(this.igdType, this.plotPos, false) + " = " + this.toString() + eol);
        IGDScheme scheme = null;
        if (this.getSchID() > 0) {
            Iterator it = igdSchemes.iterator();
            while (it.hasNext() && (scheme = (IGDScheme)it.next()).getSchID() != this.getSchID()) {
                scheme = null;
            }
            if (scheme != null) {
                out.write("  Scheme ID : " + this.getSchID() + eol);
            }
        }
        out.write("  Top sample : " + this.topSample.toString() + eol);
        out.write("  Base sample : " + this.baseSample.toString() + eol);
        out.write("  Top sample ID : " + this.topSample.getID() + eol);
        out.write("  Base sample ID : " + this.baseSample.getID() + eol);
        if (this.topAnalyst.length() > 0) {
            out.write("  Top analyst : " + this.topAnalyst + eol);
        }
        if (this.baseAnalyst.length() > 0) {
            out.write("  Base analyst : " + this.baseAnalyst + eol);
        }
        if (this.sep != null && this.sep.length() > 0) {
            out.write("  Separator : " + this.sep + eol);
        }
        boolean writeInformal = true;
        if (this.getUppZone() > 0 && scheme != null) {
            out.write("  Upper dictionary ID : " + this.getUppZone() + eol);
            unit = scheme.findUnit(this.uppZone);
            if (unit == null) {
                unit = scheme.findDonorUnit(this.donorUppZone);
            }
            if (unit != null && !this.uppInf.equals(unit.getName())) {
                out.write("  Upper informal unit : " + this.uppInf + eol);
                out.write("  Upper unit : " + unit.getName() + eol);
                writeInformal = false;
            }
        }
        if (writeInformal) {
            out.write("  Upper unit : " + this.uppInf + eol);
        }
        writeInformal = true;
        if (this.getLowZone() > 0 && scheme != null) {
            out.write("  Lower dictionary ID : " + this.getLowZone() + eol);
            unit = scheme.findUnit(this.lowZone);
            if (unit == null) {
                unit = scheme.findDonorUnit(this.donorLowZone);
            }
            if (unit != null && this.lowInf != null && !this.lowInf.equals(unit.getName())) {
                out.write("  Lower informal unit : " + this.lowInf + eol);
                out.write("  Lower unit : " + unit.getName() + eol);
                writeInformal = false;
            }
        }
        if (writeInformal && this.lowInf != null && this.lowInf.length() > 0) {
            out.write("  Lower unit : " + this.lowInf + eol);
        }
        out.write("  Upper boundary : " + IGDIntervalZone.getBoundary(this.topBnd) + eol);
        out.write("  Lower boundary : " + IGDIntervalZone.getBoundary(this.baseBnd) + eol);
        out.write("  Upper questionable : " + (this.qUzone ? "Yes" : "No") + eol);
        out.write("  Lower questionable : " + (this.qLzone ? "Yes" : "No") + eol);
        if (this.modified != null) {
            out.write("Modified = " + df.format(this.modified) + eol);
        }
        if (this.modifier != null && this.modifier.length() > 0) {
            out.write("Modifier = " + this.modifier + eol);
        }
    }

    static int loadAll(SBdb SB2, HashMap<Integer, Well> wells, HashMap<Integer, InterpHdr> interps) throws SQLException, SBException {
        int nInt = 0;
        String sql = "SELECT igd_type,interp_id,top_id,base_id,top_analy,base_analy,top_bnd,base_bnd,plot_pos,sch_id,q_uzone,upp_zone,upp_inf,q_lzone,low_zone,low_inf" + (SB2.hasIGDSep ? ",sep" : "") + ",modifier,modified FROM " + SB2.DBTableName("IGD");
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        HashMap<String, IGDIntervalSeq> sequences = new HashMap<String, IGDIntervalSeq>();
        IGDInterval zone = null;
        while (rs.next()) {
            int igdType = rs.getInt("igd_type");
            int interpID = rs.getInt("interp_id");
            int topID = rs.getInt("top_id");
            int baseID = rs.getInt("base_id");
            String topAnalyst = rs.getString("top_analy");
            String baseAnalyst = rs.getString("base_analy");
            int topBnd = rs.getInt("top_bnd");
            int baseBnd = rs.getInt("base_bnd");
            int plotPos = rs.getInt("plot_pos");
            int schID = rs.getInt("sch_id");
            String strg = rs.getString("q_uzone");
            boolean qUzone = strg != null && strg.charAt(0) == 'Y';
            int uppZone = rs.getInt("upp_zone");
            if (uppZone < 0) {
                uppZone = 0;
            }
            String uppInf = rs.getString("upp_inf");
            strg = rs.getString("q_lzone");
            boolean qLzone = strg != null && strg.charAt(0) == 'Y';
            int lowZone = rs.getInt("low_zone");
            if (lowZone < 0) {
                lowZone = 0;
            }
            String lowInf = rs.getString("low_inf");
            String sep = "-";
            if (SB2.hasIGDSep && (sep = rs.getString("sep")) == null) {
                sep = "-";
            }
            String modifier = rs.getString("modifier");
            Date modified = rs.getDate("modified");
            int wellID = zone.getTopID() / 65536;
            Well well = wells.get(wellID);
            if (well == null) {
                System.out.println("Well null for wellID: " + wellID + " In IGDIntervalZone.loadAll. Sampid: " + ((IGDIntervalZone)zone).topID);
                continue;
            }
            zone = igdType == 10 ? new IGDIntervalSeq(SB2, well, topID, baseID, topAnalyst, baseAnalyst, topBnd, baseBnd, plotPos, schID, uppZone, uppInf, lowZone, lowInf, qUzone, qLzone, modifier, modified) : new IGDIntervalZone(SB2, igdType, well, topID, baseID, topAnalyst, baseAnalyst, topBnd, baseBnd, plotPos, schID, uppZone, uppInf, lowZone, lowInf, qUzone, qLzone, modifier, modified);
            ((IGDIntervalZone)zone).status = STORED;
            WellInterp interp = well.getAddInterp(interpID, interps);
            if (interp == null) {
                System.out.println("Interp null for wellID: " + wellID + ", interp_id: " + interpID + " In IGDIntervalZone.loadAll. Sampid: " + ((IGDIntervalZone)zone).topID);
                continue;
            }
            ((IGDIntervalZone)zone).topSample = well.getSample(((IGDIntervalZone)zone).topID);
            ((IGDIntervalZone)zone).baseSample = well.getSample(((IGDIntervalZone)zone).baseID);
            interp.insertZone((IGDIntervalZone)zone);
            ++nInt;
            if (igdType != 10) continue;
            sequences.put("" + interpID + " " + ((IGDIntervalZone)zone).topID + " " + ((IGDIntervalZone)zone).baseID, (IGDIntervalSeq)zone);
        }
        System.out.println("Loaded " + IGDIntervalSeq.loadAll(SB2, sequences) + " sequence tracts.");
        stmt.close();
        return nInt;
    }

    public boolean isQUzone() {
        return this.qUzone;
    }

    public String getSep() {
        return this.sep;
    }

    public boolean isQLzone() {
        return this.qLzone;
    }
}

