/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model1_8.IGDInterval;
import model1_8.IGDIntervalSeq;
import model1_8.IGDIntervalZone;
import model1_8.IGDUnit;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Well;
import model1_8.WellInterp;
import util.SB;
import util.SbugsStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGDScheme
extends Observable
implements SbugsStatus,
Comparable {
    SBdb SB = null;
    int schID = 0;
    int donorSchID = 0;
    private int igdType;
    String name = "";
    private java.util.Date created;
    private String creator = "";
    List<IGDUnit> units = new LinkedList<IGDUnit>();
    boolean unitsLoaded = false;
    Color status = UNKNOWN;

    public IGDScheme() {
    }

    public void setIGDType(int igdType) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set IGD scheme type for existing scheme");
        }
        this.igdType = igdType;
    }

    IGDScheme(SBdb SB2) {
        this.SB = SB2;
    }

    public IGDScheme(IGDScheme rhs) {
        this.schID = rhs.schID;
        this.igdType = rhs.igdType;
        this.created = rhs.created;
        this.creator = rhs.creator;
        this.name = rhs.name;
        for (IGDUnit unit : rhs.units) {
            this.units.add(new IGDUnit(unit));
        }
        this.unitsLoaded = true;
    }

    public int getID() {
        return this.schID;
    }

    public int compareTo(Object rhs) {
        if (this.name != null && rhs != null) {
            if (rhs.toString() == null) {
                System.out.println("Comparing: " + this.name + " with : " + rhs + " to string: " + rhs.toString());
            } else {
                return this.name.compareTo(rhs.toString());
            }
        }
        return -1;
    }

    int getSchID() {
        if (this.schID > 0) {
            return this.schID;
        }
        return this.donorSchID;
    }

    public List<IGDUnit> getUnits() {
        return this.units;
    }

    public void insertUnit(IGDUnit unit, boolean checkName) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to insert unit into scheme");
        }
        boolean added = false;
        for (IGDUnit u : this.units) {
            if (!(unit.getUage() <= u.getUage()) || unit.getHier() > u.getHier()) continue;
            this.units.add(this.units.indexOf(u), unit);
            added = true;
            break;
        }
        if (!added) {
            this.units.add(unit);
        }
    }

    public double getMinAge() throws SQLException, SBException {
        if (!this.unitsLoaded) {
            this.loadUnits();
        }
        double minAge = 99999.0;
        boolean assigned = false;
        for (IGDUnit unit : this.units) {
            if (!(unit.getUage() < minAge)) continue;
            minAge = unit.getUage();
            assigned = true;
        }
        if (assigned) {
            return minAge;
        }
        return 0.0;
    }

    public double getMaxAge() throws SQLException, SBException {
        if (!this.unitsLoaded) {
            this.loadUnits();
        }
        double maxAge = 0.0;
        boolean assigned = false;
        for (IGDUnit unit : this.units) {
            if (!(unit.getLage() > maxAge)) continue;
            maxAge = unit.getLage();
            assigned = true;
        }
        if (assigned) {
            return maxAge;
        }
        return 500.0;
    }

    public SBdb getDatabase() {
        return this.SB;
    }

    int checkUnitUnique(IGDUnit unit) throws SBException {
        IGDUnit tmp;
        for (int i = 0; i < this.units.size(); ++i) {
            tmp = this.units.get(i);
            if (unit.getName().compareToIgnoreCase(tmp.getName()) != 0) continue;
            throw new SBException("Unit: '" + tmp.getName() + "' already exists in scheme");
        }
        int insertionPoint = -1;
        for (int i = 0; i < this.units.size(); ++i) {
            tmp = this.units.get(i);
            if (tmp.getUage() > unit.getUage()) {
                insertionPoint = i;
                break;
            }
            if (tmp.getUage() == unit.getUage() && tmp.getHier() > unit.getHier()) {
                insertionPoint = i;
                break;
            }
            if (tmp.getUage() != unit.getUage() || tmp.getHier() != unit.getHier() || !(tmp.getLage() > unit.getLage())) continue;
            insertionPoint = i;
            break;
        }
        if (insertionPoint < 0) {
            insertionPoint = this.units.size();
        }
        return insertionPoint;
    }

    int insertUnit(IGDUnit unit) throws SBException {
        int insertionPoint = this.checkUnitUnique(unit);
        this.units.add(insertionPoint, unit);
        return insertionPoint;
    }

    int addUnit(IGDUnit unit) throws SBException, SQLException, Exception {
        this.checkUnitUnique(unit);
        Statement stmt = this.SB.getDatabase().createStatement();
        unit.setSchID(this.schID);
        unit.store(this.SB, stmt, util.SB.DBdf, this.igdType);
        unit.status = IGDUnit.STORED;
        this.setChanged();
        return this.insertUnit(unit);
    }

    public IGDUnit addUnit(int hier, String name, String abr, double u_age, double l_age, Color colour) throws SBException, SQLException, Exception {
        IGDUnit unit = new IGDUnit(this.schID, 0, hier, name, abr, u_age, l_age, colour, new java.util.Date(), this.SB.getUser().getUsrID(), this.SB);
        this.addUnit(unit);
        return unit;
    }

    public void deleteUnit(IGDUnit unit) throws SQLException {
        unit.delete();
        this.units.remove(unit);
        this.setChanged();
    }

    public IGDUnit updateUnit(IGDUnit unit, int hier, String name, String abr, double u_age, double l_age, Color colour) throws SBException, SQLException, Exception {
        if (!unit.getName().equals(name) && this.findUnit(name) != null) {
            throw new SBException("Cannot update unit: new name already exists in scheme");
        }
        unit.update(this.SB.getDatabase().createStatement(), util.SB.DBdf, hier, name, abr, u_age, l_age, colour);
        this.units.remove(unit);
        this.insertUnit(unit);
        return unit;
    }

    IGDUnit findUnit(String unitName) throws SBException {
        if (!this.unitsLoaded) {
            throw new SBException("Attempt to find unit in scheme: " + this.name + " when units not loaded");
        }
        for (int i = 0; i < this.units.size(); ++i) {
            IGDUnit unit = this.units.get(i);
            if (unit.getName().compareToIgnoreCase(unitName) != 0) continue;
            return unit;
        }
        return null;
    }

    public IGDUnit findUnit(int unitID) throws SBException {
        if (!this.unitsLoaded) {
            throw new SBException("Attempt to find unit in scheme: " + this.name + " when units not loaded");
        }
        if (unitID == 0) {
            return null;
        }
        for (int i = 0; i < this.units.size(); ++i) {
            IGDUnit unit = this.units.get(i);
            if (unit.getIgdID() != unitID) continue;
            return unit;
        }
        return null;
    }

    IGDUnit findDonorUnit(int donorID) {
        if (donorID == 0) {
            return null;
        }
        for (int i = 0; i < this.units.size(); ++i) {
            IGDUnit unit = this.units.get(i);
            if (unit.donorID != donorID) continue;
            return unit;
        }
        return null;
    }

    void updateUnit(String existingName, IGDUnit unit) throws SBException, SQLException {
        if (unit.getIgdID() != 0) {
            Statement stmt = this.SB.getDatabase().createStatement();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String sql = "UPDATE " + this.SB.DBTableName("igd_dict") + " set name='" + unit.getName() + "',abr='" + unit.getAbr() + "',u_age=" + unit.getUage() + ",l_age=" + unit.getLage() + ",hier=" + unit.getHier() + ",red=" + unit.getColour().getRed() + ",green=" + unit.getColour().getGreen() + ",blue=" + unit.getColour().getBlue() + ",created='" + df.format(new java.util.Date()) + "',creator='" + this.SB.user.getUsrID() + "'" + " WHERE sch_id=" + this.schID + " AND name='" + existingName + "'";
            stmt.executeUpdate(this.SB.modQuery(sql));
            unit.status = IGDUnit.STORED;
        }
        for (int i = 0; i < this.units.size(); ++i) {
            IGDUnit tmp = this.units.get(i);
            if (existingName.compareToIgnoreCase(tmp.getName()) != 0) continue;
            this.units.remove(tmp);
            this.units.add(i, unit);
            return;
        }
        throw new SBException("Unit does not exist in scheme");
    }

    @Override
    public Color getStatus() {
        if (this.status == UNKNOWN && this.name.length() > 0) {
            this.status = this.schID != 0 ? STORED : NOTSTORED;
        }
        return this.status;
    }

    public void unloadUnits() {
        this.unitsLoaded = false;
        this.units.clear();
    }

    public void loadUnits() throws SQLException, SBException {
        if (this.unitsLoaded) {
            return;
        }
        this.unitsLoaded = true;
        String sql = "SELECT igd_id,hier,name,abr,qu,u_age,ql,l_age,red,green,blue,created,creator FROM " + this.SB.DBTableName("IGD_DICT") + " WHERE sch_id=" + this.schID + " ORDER BY u_age,hier,l_age";
        ResultSet rs = this.SB.getDatabase().createStatement().executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            int igdID = rs.getInt("igd_id");
            int hier = rs.getInt("hier");
            if (this.igdType == 10 && hier == 0) {
                hier = 1;
            }
            String name = rs.getString("name");
            String abr = rs.getString("abr");
            double u_age = rs.getDouble("u_age");
            double l_age = rs.getDouble("l_age");
            Color colour = new Color(rs.getInt("red"), rs.getInt("green"), rs.getInt("blue"));
            if (colour.equals(Color.BLACK)) {
                colour = Color.WHITE;
            }
            Timestamp created = rs.getTimestamp("created");
            String creator = rs.getString("creator");
            int insertPoint = 0;
            try {
                IGDUnit unit = new IGDUnit(this.schID, igdID, hier, name, abr, u_age, l_age, colour, created, creator, this.SB);
                insertPoint = this.insertUnit(unit);
            }
            catch (SBException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    public boolean checkDeletedUnits(IGDScheme rhs) throws SQLException, SBException {
        Statement stmt = this.SB.getDatabase().createStatement();
        for (IGDUnit unit : this.units) {
            String sql;
            ResultSet rs;
            if (rhs.findUnit(unit.getID()) != null || !(rs = stmt.executeQuery(this.SB.modQuery(sql = "SELECT top_id FROM " + this.SB.DBTableName("IGD") + " WHERE upp_zone=" + unit.getID() + " OR low_zone=" + unit.getID()))).next()) continue;
            stmt.close();
            return false;
        }
        return true;
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    @Override
    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.name;
    }

    public static List getSchemes(SBdb SB2, int igdType, boolean allBiozones) throws SQLException {
        LinkedList<IGDScheme> schemes = new LinkedList<IGDScheme>();
        String sql = "SELECT sch_id,igd_type,name,created,creator FROM " + SB2.DBTableName("IGD_SCH");
        if (igdType > 0) {
            sql = sql + " WHERE ";
            sql = allBiozones && IGDInterval.isBiozoneType(igdType) ? sql + "igd_type >= 41 AND igd_type <=44" : sql + "igd_type=" + igdType;
        }
        sql = sql + " ORDER BY name";
        ResultSet rs = SB2.getDatabase().createStatement().executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            boolean i = false;
            IGDScheme scheme = new IGDScheme(SB2);
            scheme.schID = rs.getInt("sch_id");
            scheme.igdType = rs.getInt("igd_type");
            scheme.name = rs.getString("name");
            if (scheme.name == null) {
                scheme.name = "No name, ID=" + scheme.schID;
            }
            scheme.created = rs.getDate("created");
            scheme.creator = rs.getString("creator");
            schemes.add(scheme);
        }
        return schemes;
    }

    IGDScheme(int schID) throws SQLException, SBException {
        String sql = "SELECT name,igd_type,created,creator FROM " + this.SB.DBTableName("IGD_SCH") + " WHERE sch_id=" + schID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (!rs.next()) {
            stmt.close();
            throw new SBException("IGD Scheme, ID=" + schID + ", not found in database");
        }
        this.name = rs.getString("name");
        this.igdType = rs.getInt("igd_type");
        this.schID = schID;
        this.created = rs.getDate("created");
        this.creator = rs.getString("creator");
        stmt.close();
    }

    boolean update() throws SQLException, SBException {
        String sql;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql = "SELECT name from " + this.SB.DBTableName("IGD_SCH") + " WHERE ucase(name)='" + this.name + "'" + " AND igd_type=" + this.igdType + " AND sch_id <> " + this.schID));
        if (rs.next()) {
            rs.close();
            stmt.close();
            return false;
        }
        rs.close();
        sql = "UPDATE " + this.SB.DBTableName("IGD_SCH") + " SET name='" + this.name + "' WHERE sch_id=" + this.schID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        this.status = STORED;
        stmt.close();
        this.SB.getDatabase().commit();
        return true;
    }

    public void update(IGDScheme rhs) throws SQLException, SBException {
        IGDUnit newUnit;
        String sql;
        Statement stmt = this.SB.getDatabase().createStatement();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (!rhs.name.equals(this.name)) {
            sql = "UPDATE " + this.SB.DBTableName("IGD_SCH") + " set name=" + util.SB.DBString(this.name) + " WHERE sch_id=" + this.schID;
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        for (IGDUnit unit : this.units) {
            newUnit = rhs.findUnit(unit.getID());
            if (newUnit != null) continue;
            sql = "UPDATE " + this.SB.DBTableName("IGD") + " set upp_zone=0 WHERE upp_zone=" + unit.getID();
            stmt.executeUpdate(this.SB.modQuery(sql));
            sql = "UPDATE " + this.SB.DBTableName("IGD") + " set low_zone=0 WHERE low_zone=" + unit.getID();
            stmt.executeUpdate(this.SB.modQuery(sql));
            String string = "DELETE FROM " + this.SB.DBTableName("IGD_DICT") + " WHERE igd_id=" + unit.getID();
        }
        for (IGDUnit unit : this.units) {
            newUnit = rhs.findUnit(unit.getID());
            if (newUnit == null) continue;
            unit.update(newUnit, stmt, df);
        }
        for (IGDUnit unit : rhs.units) {
            if (unit.getID() != 0) continue;
            unit.setSchID(this.schID);
            unit.store(this.SB, stmt, util.SB.df, this.igdType);
            this.insertUnit(unit);
        }
        Iterator<IGDUnit> it = this.units.iterator();
        while (it.hasNext()) {
            IGDUnit unit;
            unit = it.next();
            if (rhs.findUnit(unit.getID()) != null) continue;
            it.remove();
        }
        for (IGDUnit unit : this.units) {
            IGDUnit newUnit2 = rhs.findUnit(unit.getID());
            if (newUnit2 == null) continue;
            unit.copy(newUnit2);
        }
        this.name = rhs.name;
        this.setChanged();
        stmt.close();
    }

    public int getNoccs() throws SQLException {
        String sql = "SELECT count(sch_id) as nOcc FROM " + this.SB.DBTableName("IGD") + " WHERE sch_id=" + this.schID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        int nOccs = 0;
        if (rs.next()) {
            nOccs = rs.getInt("nOcc");
        }
        return nOccs;
    }

    public List getOccs() throws SQLException, SBException {
        String sql = "SELECT DISTINCT v.well_id,w.well_name,v.code FROM " + this.SB.DBTableName("IGD") + " i," + this.SB.DBTableName("VERSION") + " v," + this.SB.DBTableName("WELLS") + " w" + " WHERE i.sch_id=" + this.schID + " AND floor(i.top_id/65536)=v.well_id AND v.code=w.well_code ORDER BY well_name";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        ArrayList<Well> occs = new ArrayList<Well>();
        while (rs.next()) {
            occs.add(new Well(this.SB, rs.getInt("well_id"), false, false, null));
        }
        stmt.close();
        return occs;
    }

    public List getWellInterps(Well well) throws SQLException, SBException {
        String sql = "SELECT DISTINCT i.interp_id FROM " + this.SB.DBTableName("IGD") + " i" + " WHERE i.sch_id=" + this.schID + " AND floor(i.top_id/65536)=" + well.wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        ArrayList<WellInterp> occs = new ArrayList<WellInterp>();
        boolean hasDefaultInterp = false;
        while (rs.next()) {
            int interpID = rs.getInt("interp_id");
            if (interpID <= 0 && hasDefaultInterp) continue;
            occs.add(new WellInterp(this.SB, interpID, this.SB.interpHdrs, well.getType()));
            if (interpID != 0) continue;
            hasDefaultInterp = true;
        }
        stmt.close();
        return occs;
    }

    public List getZones(Well well, WellInterp interp) throws SQLException, SBException {
        ArrayList<IGDIntervalSeq> occs = new ArrayList<IGDIntervalSeq>();
        String sql = "SELECT igd_type,top_id,base_id,top_analy,base_analy,top_bnd,base_bnd,plot_pos,sch_id,q_uzone,upp_zone,upp_inf,q_lzone,low_zone,low_inf" + (this.SB.hasIGDSep ? ",sep" : "") + ",modifier,modified FROM " + this.SB.DBTableName("IGD") + " WHERE " + IGDInterval.interpString(interp.interpID, null) + " AND top_id >=" + well.wellID * 65536 + " AND top_id < " + (well.wellID + 1) * 65536 + " AND sch_id=" + this.schID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            int igdType = rs.getInt("igd_type");
            int topID = rs.getInt("top_id");
            int baseID = rs.getInt("base_id");
            String topAnalyst = rs.getString("top_analy");
            String baseAnalyst = rs.getString("base_analy");
            int topBnd = rs.getInt("top_bnd");
            int baseBnd = rs.getInt("base_bnd");
            int plotPos = rs.getInt("plot_pos");
            int schID = rs.getInt("sch_id");
            String strg = rs.getString("q_uzone");
            boolean qUzone = strg != null && strg.charAt(0) == 'Y';
            int uppZone = rs.getInt("upp_zone");
            if (uppZone < 0) {
                uppZone = 0;
            }
            String uppInf = rs.getString("upp_inf");
            strg = rs.getString("q_lzone");
            boolean qLzone = strg != null && strg.charAt(0) == 'Y';
            int lowZone = rs.getInt("low_zone");
            if (lowZone < 0) {
                lowZone = 0;
            }
            String lowInf = rs.getString("low_inf");
            String sep = "-";
            if (this.SB.hasIGDSep && (sep = rs.getString("sep")) == null) {
                sep = "-";
            }
            String modifier = rs.getString("modifier");
            Date modified = rs.getDate("modified");
            IGDIntervalZone zone = igdType == 10 ? new IGDIntervalSeq(this.SB, well, topID, baseID, topAnalyst, baseAnalyst, topBnd, baseBnd, plotPos, schID, uppZone, uppInf, lowZone, lowInf, qUzone, qLzone, modifier, modified) : new IGDIntervalZone(this.SB, igdType, well, topID, baseID, topAnalyst, baseAnalyst, topBnd, baseBnd, plotPos, schID, uppZone, uppInf, lowZone, lowInf, qUzone, qLzone, modifier, modified);
            occs.add((IGDIntervalSeq)zone);
        }
        stmt.close();
        return occs;
    }

    boolean store(SBdb SB2) throws SQLException, SBException {
        this.checkSchemeUnits();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Statement stmt = SB2.getDatabase().createStatement();
        if (this.schID != 0) {
            if (!this.update()) {
                return false;
            }
            for (IGDUnit unit : this.units) {
                if (unit.status == IGDUnit.NOTSTORED) {
                    unit.setSchID(this.schID);
                    unit.store(SB2, stmt, df, this.igdType);
                    continue;
                }
                if (unit.status != IGDUnit.PARTSTORED) continue;
                unit.update(SB2, stmt, df);
            }
            this.status = STORED;
            stmt.close();
            SB2.getDatabase().commit();
            return true;
        }
        String sql = "SELECT name from " + SB2.DBTableName("IGD_SCH") + " WHERE ucase(name)='" + this.name + "' AND igd_type=" + this.igdType;
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            rs.close();
            stmt.close();
            return false;
        }
        rs.close();
        this.schID = SB2.nextControl("IGD_SCH");
        this.created = new java.util.Date();
        this.creator = SB2.user.getUsrID();
        sql = "INSERT INTO " + SB2.DBTableName("IGD_SCH") + " (sch_id,name,igd_type,created,creator) VALUES (" + this.schID + ",'" + this.name + "'," + this.igdType + ",'" + df.format(this.getCreated()) + "','" + this.getCreator() + "')";
        stmt.executeUpdate(SB2.modQuery(sql));
        for (IGDUnit unit : this.units) {
            unit.setSchID(this.schID);
            unit.store(SB2, stmt, df, this.igdType);
        }
        this.status = STORED;
        this.SB = SB2;
        this.unitsLoaded = true;
        stmt.close();
        return true;
    }

    public void setName(String name) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set name");
        }
        this.name = name;
    }

    public void checkSchemeUnits() throws SBException {
        for (IGDUnit unit : this.units) {
            if (unit.getName() == null || unit.getName().length() == 0) {
                throw new SBException("Unit name blank at age: " + unit.getUage());
            }
            if (unit.getUage() > unit.getLage()) {
                throw new SBException("Youngest age is greater than oldest age for unit : " + unit.getName() + ". Scheme: " + this);
            }
            for (IGDUnit unit2 : this.units) {
                if (unit == unit2) continue;
                if (unit.getName().equalsIgnoreCase(unit2.getName())) {
                    throw new SBException("Duplicate unit name: " + unit.getName());
                }
                if (unit.getAbr() != null && unit.getAbr().length() > 0 && unit.getAbr().equalsIgnoreCase(unit2.getAbr())) {
                    throw new SBException("Duplicate unit abbreviation: " + unit.getAbr() + " in scheme: " + this.name);
                }
                if (unit.getHier() != unit2.getHier() || !(unit.getUage() < unit2.getUage()) || !(unit.getLage() > unit2.getUage())) continue;
                throw new SBException("Unit : '" + unit.getName() + "' overlaps unit : '" + unit2.getName() + "' (check unit type). Scheme name: " + this.name);
            }
        }
    }

    void deleteUnits() throws SQLException {
        if (this.schID > 0) {
            String sql = "DELETE FROM " + this.SB.DBTableName("IGD") + " WHERE sch_id=" + this.schID;
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(this.SB.modQuery(sql));
            stmt.close();
        }
    }

    void delete() throws SQLException {
        if (this.schID > 0) {
            String sql = "DELETE FROM " + this.SB.DBTableName("IGD_DICT") + " WHERE sch_id=" + this.schID;
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(this.SB.modQuery(sql));
            sql = "DELETE FROM " + this.SB.DBTableName("IGD_SCH") + " WHERE sch_id=" + this.schID;
            stmt.executeUpdate(this.SB.modQuery(sql));
            stmt.close();
        }
        this.setChanged();
    }

    void writeDEX(FileWriter out, String eol) throws IOException {
        out.write("[" + IGDInterval.getIGDTypeName(this.igdType) + " Scheme]" + eol);
        out.write("Scheme name = " + this.name + eol);
        boolean useDonor = this.schID == 0;
        out.write("Scheme ID : " + (useDonor ? this.donorSchID : this.schID) + eol);
        out.write("Number of units : " + this.units.size() + eol);
        out.write(eol);
        Iterator<IGDUnit> it = this.units.iterator();
        while (it.hasNext()) {
            it.next().writeDEX(out, eol, this.igdType, useDonor);
        }
        out.write(eol);
    }

    static void fixDictIGDtype(SBdb SB2) throws SQLException {
        String sql = "SELECT DISTINCT s.sch_id, s.igd_type FROM " + SB2.DBTableName("IGD_SCH") + " s, " + SB2.DBTableName("IGD_DICT") + " d WHERE d.sch_id=s.sch_id AND (d.igd_type is null OR d.igd_type=0)";
        Statement stmt = SB2.getDatabase().createStatement();
        Statement stmt2 = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int schID = rs.getInt("sch_id");
            int igdType = rs.getInt("igd_type");
            sql = "UPDATE " + SB2.DBTableName("IGD_DICT") + " SET igd_type=" + igdType + " WHERE sch_id=" + schID + " AND (igd_type is null OR igd_type=0)";
            stmt2.executeUpdate(SB2.modQuery(sql));
        }
        rs.close();
    }

    public int getIGDType() {
        return this.igdType;
    }

    public java.util.Date getCreated() {
        return this.created;
    }

    public String getCreator() {
        return this.creator;
    }
}

