/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import model1_8.IGDIntervalZone;
import model1_8.SBException;
import model1_8.SBdb;
import util.SB;
import util.SbugsStatus;

public class IGDUnit
implements SbugsStatus {
    private SBdb SB;
    private int schID = 0;
    private int igdID = 0;
    int donorID = 0;
    int donorSchID = 0;
    private int hier = 0;
    private String name = "";
    private String abr = "";
    private boolean qu = false;
    private double u_age = 0.0;
    private boolean ql = false;
    private double l_age = 0.0;
    private Date created;
    private String creator = "";
    Color status = UNKNOWN;
    private Color colour = Color.WHITE;

    public IGDUnit() {
    }

    IGDUnit(SBdb SB2) {
        this.SB = SB2;
    }

    public int getSchID() {
        return this.schID;
    }

    public int getID() {
        return this.getIgdID();
    }

    public int getHier() {
        return this.hier;
    }

    public void setHier(int hier) throws SBException {
        if (this.SB != null) {
            throw new SBException("Cannot assign to IGDUnit in database");
        }
        this.hier = hier;
    }

    public String getAbr() {
        return this.abr;
    }

    public void setAbr(String abr) throws SBException {
        if (this.SB != null) {
            throw new SBException("Cannot assign to IGDUnit in database");
        }
        this.abr = abr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws SBException {
        if (this.SB != null) {
            throw new SBException("Cannot assign to IGDUnit in database");
        }
        this.name = name;
    }

    public boolean getQu() {
        return this.isQu();
    }

    public boolean getQl() {
        return this.isQl();
    }

    public double getUage() {
        return this.u_age;
    }

    public void setUage(double uAge) throws SBException {
        if (this.SB != null) {
            throw new SBException("Cannot assign to IGDUnit in database");
        }
        this.u_age = uAge;
    }

    public double getLage() {
        return this.l_age;
    }

    public void setLage(double lAge) throws SBException {
        if (this.SB != null) {
            throw new SBException("Cannot assign to IGDUnit in database");
        }
        this.l_age = lAge;
    }

    public void setLageSpecial(double lAge) throws SBException {
        this.l_age = lAge;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getCreator() {
        return this.creator;
    }

    IGDUnit(int schID, int igdID, int hier, String name, String abr, double u_age, double l_age, Color colour, Date created, String creator, SBdb SB2) {
        this.schID = schID;
        this.igdID = igdID;
        this.hier = hier;
        this.name = name;
        this.abr = abr;
        this.u_age = u_age;
        this.l_age = l_age;
        this.colour = colour;
        this.created = created;
        this.creator = creator;
        this.SB = SB2;
    }

    public IGDUnit(IGDUnit rhs) {
        this.setSchID(rhs.getSchID());
        this.igdID = rhs.getIgdID();
        this.donorID = rhs.donorID;
        this.hier = rhs.getHier();
        this.name = rhs.getName();
        this.abr = rhs.getAbr();
        this.qu = rhs.isQu();
        this.u_age = rhs.getUage();
        this.ql = rhs.isQl();
        this.l_age = rhs.getLage();
        this.created = rhs.getCreated();
        this.creator = rhs.getCreator();
        this.status = rhs.status;
        this.colour = rhs.colour;
    }

    void copy(IGDUnit rhs) {
        this.setSchID(rhs.getSchID());
        this.igdID = rhs.getIgdID();
        this.donorID = rhs.donorID;
        this.hier = rhs.getHier();
        this.name = rhs.getName();
        this.abr = rhs.getAbr();
        this.qu = rhs.isQu();
        this.u_age = rhs.getUage();
        this.ql = rhs.isQl();
        this.l_age = rhs.getLage();
        this.created = rhs.getCreated();
        this.creator = rhs.getCreator();
        this.status = rhs.status;
        this.colour = rhs.colour;
    }

    public IGDUnit(SBdb SB2, int igdID) throws SQLException {
        this.SB = SB2;
        Statement stmt = SB2.getDatabase().createStatement();
        String sql = "SELECT sch_id,hier,name,abr,qu,u_age,ql,l_age,red,green,blue,created,creator FROM " + SB2.DBTableName("IGD_DICT") + " WHERE igd_id=" + igdID;
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            this.igdID = igdID;
            this.setSchID(rs.getInt("sch_id"));
            this.hier = rs.getInt("hier");
            this.name = rs.getString("name");
            this.abr = rs.getString("abr");
            this.u_age = rs.getDouble("u_age");
            this.l_age = rs.getDouble("l_age");
            this.colour = new Color(rs.getInt("red"), rs.getInt("green"), rs.getInt("blue"));
            if (this.colour.equals(Color.BLACK)) {
                this.colour = Color.WHITE;
            }
            this.created = rs.getTimestamp("created");
            this.creator = rs.getString("creator");
            this.status = STORED;
        }
        stmt.close();
    }

    public Color getStatus() {
        if (this.status == UNKNOWN && this.getSchID() != 0) {
            this.status = this.getIgdID() != 0 ? STORED : NOTSTORED;
        }
        return this.status;
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.getName();
    }

    public int getNoccs() throws SQLException {
        String sql;
        int count = 0;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql = "SELECT count(top_id) AS nOccs FROM " + this.SB.DBTableName("IGD") + " WHERE upp_zone=" + this.igdID + " OR low_zone=" + this.igdID));
        if (rs.next()) {
            count = rs.getInt("nOccs");
        }
        return count;
    }

    void update(IGDUnit rhs, Statement stmt, SimpleDateFormat df) throws SQLException, SBException {
        boolean needsUpdate = false;
        if (this.igdID != rhs.igdID) {
            throw new SBException("Attempt to update Unit: " + this.igdID + " with unit: " + rhs.igdID);
        }
        if (!this.name.equals(rhs.name)) {
            needsUpdate = true;
        }
        if (this.abr == null) {
            this.abr = "";
        }
        if (!this.abr.equals(rhs.abr)) {
            needsUpdate = true;
        }
        if (this.u_age != rhs.u_age) {
            needsUpdate = true;
        }
        if (this.l_age != rhs.l_age) {
            needsUpdate = true;
        }
        if (this.colour != rhs.colour) {
            needsUpdate = true;
        }
        if (needsUpdate) {
            rhs.update(this.SB, stmt, df);
        }
    }

    void update(SBdb SB2, Statement stmt, SimpleDateFormat df) throws SQLException {
        if (df == null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
        }
        if (this.getIgdID() != 0) {
            String sql = "UPDATE " + SB2.DBTableName("igd_dict") + " set name=" + util.SB.DBString(this.getName()) + ",abr='" + this.getAbr() + "',u_age=" + this.getUage() + ",l_age=" + this.getLage() + ",hier=" + this.getHier() + ",red=" + this.colour.getRed() + ",green=" + this.colour.getGreen() + ",blue=" + this.colour.getBlue() + ",created='" + df.format(new Date()) + "',creator='" + SB2.user.getUsrID() + "'" + " WHERE sch_id=" + this.schID + " AND igd_id=" + this.igdID;
            stmt.executeUpdate(SB2.modQuery(sql));
            this.created = new Date();
            this.creator = SB2.user.getUsrID();
            this.status = STORED;
        }
    }

    void update(Statement stmt, SimpleDateFormat df, int hier, String name, String abr, double u_age, double l_age, Color colour) throws SQLException {
        if (df == null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
        }
        if (this.igdID != 0) {
            String sql = "UPDATE " + this.SB.DBTableName("igd_dict") + " set name=" + util.SB.DBString(name) + ",abr='" + abr + "',u_age=" + u_age + ",l_age=" + l_age + ",hier=" + hier + ",red=" + colour.getRed() + ",green=" + colour.getGreen() + ",blue=" + colour.getBlue() + ",created='" + df.format(new Date()) + "',creator='" + this.SB.user.getUsrID() + "'" + " WHERE sch_id=" + this.schID + " AND igd_id=" + this.igdID;
            stmt.executeUpdate(this.SB.modQuery(sql));
            this.status = STORED;
            this.hier = hier;
            this.name = name;
            this.u_age = u_age;
            this.l_age = l_age;
            this.abr = abr;
            this.colour = colour;
        }
    }

    void delete() throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.SB.DBTableName("IGD_DICT") + " WHERE igd_id=" + this.igdID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("IGD") + " SET upp_zone=0 WHERE upp_zone=" + this.igdID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("IGD") + " SET low_zone=0 WHERE low_zone=" + this.igdID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    public void store(SBdb SB2, Statement stmt, SimpleDateFormat df, int igdType) throws SQLException, SBException {
        if (this.igdID != 0) {
            throw new SBException("Attempt to update IGD Unit");
        }
        if (this.schID == 0) {
            throw new SBException("Cannot store IGD unit when Scheme ID is zero");
        }
        if (this.hier == 0) {
            throw new SBException("Cannot store IGD unit: '" + this.name + "'. Hierarchy level is zero. Scheme ID: " + this.schID);
        }
        if (this.abr != null && this.abr.length() > 5) {
            this.abr = this.abr.substring(0, 5);
        }
        if (this.abr != null) {
            this.abr = this.abr.toUpperCase();
        }
        this.igdID = SB2.nextControl("IGD_ID");
        this.created = new Date();
        if (this.creator == null || this.creator.length() == 0) {
            this.creator = SB2.user.getUsrID();
        }
        String sql = "INSERT INTO " + SB2.DBTableName("IGD_DICT") + " (igd_id,sch_id,igd_type,hier,name,abr,qu,u_age,ql,l_age,red,green,blue,created,creator) VALUES (" + this.igdID + "," + this.schID + "," + igdType + "," + this.hier + "," + util.SB.DBString(this.name) + ",'" + this.abr + "','" + (this.qu ? (char)'Y' : 'N') + "'," + this.u_age + ",'" + (this.ql ? (char)'Y' : 'N') + "'," + this.l_age + "," + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + "," + "'" + df.format(this.created) + "','" + this.creator + "')";
        stmt.executeUpdate(SB2.modQuery(sql));
        this.SB = SB2;
        this.status = STORED;
    }

    void writeDEX(FileWriter out, String eol, int igdType, boolean useDonor) throws IOException {
        out.write("Unit = " + this.getName() + eol);
        if (this.getAbr() != null) {
            out.write("  Abbreviation : " + this.getAbr() + eol);
        }
        out.write("  Type = " + IGDIntervalZone.getHierName(igdType, this.getHier(), true) + eol);
        out.write("  Youngest : " + this.getUage() + eol);
        out.write("  Oldest : " + this.getLage() + eol);
        out.write("  Dictionary ID : " + (useDonor ? this.donorID : this.getIgdID()) + eol);
        if (this.colour != Color.WHITE) {
            out.write("  Colour : " + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + eol);
        }
    }

    public void setSchID(int schID) {
        this.schID = schID;
    }

    public int getIgdID() {
        return this.igdID;
    }

    public boolean isQu() {
        return this.qu;
    }

    public boolean isQl() {
        return this.ql;
    }

    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color colour) throws SBException {
        if (this.SB != null) {
            throw new SBException("Cannot assign to IGDUnit in database");
        }
        this.colour = colour;
    }
}

