/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Vector;
import model1_8.IGDInterval;
import model1_8.SBException;
import model1_8.SBdb;
import util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpHdr
extends Observable
implements Comparable {
    public static String defaultText = "Default Version";
    SBdb SB;
    private int interpID;
    private String description;
    private String creator;
    private Date created;

    public int getInterpID() {
        return this.interpID;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCreator() {
        return this.creator;
    }

    public Date getCreated() {
        return this.created;
    }

    public InterpHdr(SBdb Sb, int interpID, String description, Date created, String creator) {
        this.SB = Sb;
        this.interpID = interpID;
        this.description = description;
        this.created = created;
        this.creator = creator;
    }

    public InterpHdr(SBdb SB2, int ID) throws SQLException {
        this.SB = SB2;
        if (ID > 0) {
            String sql = "SELECT descrip,created,creator FROM " + SB2.DBTableName("INTERP") + " WHERE interp_id=" + ID;
            ResultSet rs = SB2.getDatabase().createStatement().executeQuery(SB2.modQuery(sql));
            if (rs.next()) {
                this.interpID = ID;
                this.description = rs.getString("descrip");
                this.created = rs.getDate("created");
                this.creator = rs.getString("creator");
            }
        } else {
            this.description = defaultText;
            this.interpID = 0;
        }
    }

    public InterpHdr(SBdb model, String description, char sectionType) throws SQLException {
        this.description = description;
        this.SB = model;
        String sql = "SELECT interp_id,created,creator FROM " + model.DBTableName("INTERP") + " WHERE descrip=" + util.SB.DBString(description);
        Statement stmt = model.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(model.modQuery(sql));
        if (rs.next()) {
            this.interpID = rs.getInt("interp_id");
            this.created = rs.getDate("created");
            this.creator = rs.getString("creator");
        } else {
            this.interpID = 0;
        }
        rs.close();
        stmt.close();
    }

    public String toString() {
        return this.description;
    }

    public int hashCode() {
        return this.interpID;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        InterpHdr rhs = (InterpHdr)o;
        return this.interpID == rhs.interpID && this.description.equals(rhs.description);
    }

    public InterpHdr(SBdb SB2, String description) throws SBException, SQLException {
        this.description = description;
        this.SB = SB2;
        this.create(false);
        SB2.interpHdrs.put(this.interpID, this);
    }

    public boolean setDescription(String description) throws SBException, SQLException {
        if (description.equals(this.description)) {
            return false;
        }
        List<InterpHdr> c = this.SB.getInterps();
        for (Object e : c) {
            InterpHdr h = (InterpHdr)e;
            if (!h.description.equals(description)) continue;
            throw new SBException("Version already exists (ID=" + h.interpID);
        }
        this.update(description);
        this.setChanged();
        return true;
    }

    public List findWells() throws SQLException {
        String item;
        LinkedList wellLlist = new LinkedList();
        String sql = "SELECT DISTINCT w.well_name,v.code FROM " + this.SB.DBTableName("IGD") + " i," + this.SB.DBTableName("WELLS") + " w," + this.SB.DBTableName("VERSION") + " v " + " WHERE INT(i.top_id/" + 65536 + ")=v.well_id AND " + IGDInterval.interpString(this.interpID, "i") + " AND v.code=w.well_code ORDER BY well_name";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        Vector<String> wellList = new Vector<String>();
        while (rs.next()) {
            item = rs.getString("well_name") + " (" + rs.getString("code") + ")" + " - Zones";
            wellList.add(item);
        }
        rs.close();
        sql = "SELECT DISTINCT w.well_name,v.code FROM " + this.SB.DBTableName("IGD_ENV") + " i," + this.SB.DBTableName("WELLS") + " w," + this.SB.DBTableName("VERSION") + " v " + " WHERE INT(i.top_id/" + 65536 + ")=v.well_id AND " + IGDInterval.interpString(this.interpID, "i") + " AND v.code=w.well_code ORDER BY well_name";
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            item = rs.getString("well_name") + " (" + rs.getString("code") + ")" + " - Palaeonvironments";
            wellList.add(item);
        }
        rs.close();
        sql = "SELECT DISTINCT w.well_name,v.code FROM " + this.SB.DBTableName("BCMMNTS") + " i," + this.SB.DBTableName("WELLS") + " w," + this.SB.DBTableName("VERSION") + " v " + " WHERE INT(i.usamp_id/" + 65536 + ")=v.well_id AND " + IGDInterval.interpString(this.interpID, "i") + " AND v.code=w.well_code ORDER BY well_name";
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            item = rs.getString("well_name") + " (" + rs.getString("code") + ")" + " - " + " Comments";
            wellList.add(item);
        }
        rs.close();
        stmt.close();
        return wellList;
    }

    public void delete() throws SQLException, SBException {
        if (this.interpID == 0) {
            throw new SBException("You cannot delete the default version");
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.SB.DBTableName("IGD") + " WHERE interp_id=" + this.interpID;
        int nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted IGD intervals: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("SQTRACT") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted SQTracts: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("SBSSR") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted Sample ages: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted Env intervals: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted comments: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("IGD_HDR") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted headers: " + nRows);
        sql = "DELETE FROM " + this.SB.DBTableName("SBCHCLIN") + " WHERE interp_id=" + this.interpID;
        nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        System.out.println("Deleted correlation lines: " + nRows);
        if (this.SB.hasEventExtensions) {
            sql = "DELETE FROM " + this.SB.DBTableName("EVENTS") + " WHERE qs_id=" + this.interpID;
            nRows = stmt.executeUpdate(this.SB.modQuery(sql));
            System.out.println("Deleted QS events: " + nRows);
            sql = "DELETE FROM " + this.SB.DBTableName("QSLOC") + " WHERE qs_id=" + this.interpID;
            nRows = stmt.executeUpdate(this.SB.modQuery(sql));
            System.out.println("Deleted QS LOCs: " + nRows);
            sql = "DELETE FROM " + this.SB.DBTableName("QSSECT") + " WHERE qs_id=" + this.interpID;
            nRows = stmt.executeUpdate(this.SB.modQuery(sql));
            System.out.println("Deleted QS sections: " + nRows);
            sql = "DELETE FROM " + this.SB.DBTableName("QSPROJ") + " WHERE qs_id=" + this.interpID;
            nRows = stmt.executeUpdate(this.SB.modQuery(sql));
            System.out.println("Deleted QS project: " + nRows);
        }
        sql = "DELETE FROM " + this.SB.DBTableName("INTERP") + " WHERE interp_id=" + this.interpID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.SB.removeInterp(this);
    }

    public void create(boolean refreshUser) throws SBException, SQLException {
        String sql = "SELECT interp_id FROM " + this.SB.DBTableName("INTERP") + " WHERE ucase(descrip)=" + util.SB.DBString(this.description.toUpperCase());
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            int interpID = rs.getInt("interp_id");
            throw new SBException("A version of the name '" + this.description + "' already exists: ID number " + interpID);
        }
        this.interpID = this.SB.nextControl("INTERP");
        if (refreshUser || this.created == null) {
            this.created = new Date();
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (refreshUser || this.creator == null || this.creator.length() == 0) {
            this.creator = this.SB.user.getUsrID();
        }
        sql = "INSERT INTO " + this.SB.DBTableName("INTERP") + " (interp_id,descrip,created,creator) VALUES (" + this.interpID + "," + util.SB.DBString(this.description) + ",'" + df.format(this.created) + "','" + this.creator + "')";
        stmt.executeUpdate(this.SB.modQuery(sql));
        if (this.SB.hasEventExtensions) {
            int qsID = this.SB.nextControl("QS_ID");
            if (qsID <= this.interpID) {
                sql = "INSERT INTO " + this.SB.DBTableName("QSPROJ") + " (qs_id,name,created,creator,qspublic) VALUES (" + this.interpID + "," + util.SB.DBString(this.description) + ",'" + df.format(this.created) + "','" + this.creator + "','Y')";
                stmt.executeUpdate(this.SB.modQuery(sql));
            }
            if (qsID < this.interpID) {
                sql = "UPDATE " + this.SB.DBTableName("CONTROL") + " SET CONVAL=" + this.interpID + " WHERE NAME='QS_ID'";
                stmt.executeUpdate(this.SB.modQuery(sql));
            }
            if (qsID > this.interpID) {
                throw new SBException("Cannot add new version: QSPROJ out of step - you need to delete projects and reset CONTROL manually");
            }
        }
        stmt.close();
        this.SB.getDatabase().commit();
    }

    void update(String description) throws SBException, SQLException {
        String sql = "UPDATE " + this.SB.DBTableName("INTERP") + " SET descrip='" + description + "'" + " WHERE interp_id=" + this.interpID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        if (this.SB.hasEventExtensions) {
            sql = "UPDATE " + this.SB.DBTableName("QSPROJ") + " SET name='" + description + "'" + " WHERE qs_id=" + this.interpID;
        }
        stmt.close();
        this.description = description;
        this.SB.getDatabase().commit();
    }

    public int compareTo(Object rhs) {
        return this.description.compareTo(((InterpHdr)rhs).description);
    }

    public static void loadAll(SBdb SB2, HashMap<Integer, InterpHdr> interps) throws SQLException {
        interps.put(0, new InterpHdr(SB2, 0));
        String sql = "SELECT interp_id,descrip,created,creator FROM " + SB2.DBTableName("INTERP");
        ResultSet rs = SB2.getDatabase().createStatement().executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int interpID = rs.getInt("interp_id");
            String description = rs.getString("descrip");
            java.sql.Date created = rs.getDate("created");
            String creator = rs.getString("creator");
            InterpHdr interp = new InterpHdr(SB2, interpID, description, created, creator);
            interps.put(interp.getInterpID(), interp);
        }
    }
}

