/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.sql.ResultSet;
import java.sql.SQLException;
import model1_8.SBdb;
import util.SB;

public class Licence {
    SBdb SB;
    String company;
    String location;
    int code;
    String ecode;

    public Licence(SBdb SB2) throws SQLException {
        this.SB = SB2;
        String sql = "SELECT company,location,code FROM " + SB2.DBTableName("licence");
        ResultSet rs = SB2.getDatabase().createStatement().executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            this.company = rs.getString("company");
            this.location = rs.getString("location");
            this.code = rs.getInt("code");
        }
    }

    public boolean isEvaluation() {
        return this.company.equals("StrataBugs") && this.location.equals("Evaluation");
    }

    public boolean isStrataData() {
        return this.company.startsWith("StrataData");
    }

    public String toString() {
        return this.company + ", " + this.location;
    }

    public String getCompany() {
        return this.company;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean hasOption(String option) {
        if (this.isEvaluation()) {
            return true;
        }
        SBdb.DBType cfr_ignored_0 = this.SB.dbType;
        if (this.SB.dbType == SBdb.DBType.ORACLE) {
            return true;
        }
        String licencedOption = SBdb.getJregOption(option);
        if (licencedOption == null || licencedOption.startsWith("Error")) {
            return false;
        }
        licencedOption = util.SB.crypt(false, this.company, licencedOption);
        if (this.company.length() < licencedOption.length()) {
            licencedOption = licencedOption.substring(0, this.company.length());
        }
        return option.startsWith(licencedOption);
    }
}

