/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import model1_8.Lithology;
import model1_8.SBException;
import model1_8.SBdb;
import util.SB;
import util.SbugsStatus;

public class LithInterval
implements SbugsStatus {
    SBdb SB;
    double topDepth = 0.0;
    double baseDepth = 0.0;
    int lithCode = 0;
    Lithology desc = null;
    Color status = UNKNOWN;

    public Color getStatus() {
        return this.status;
    }

    public LithInterval(SBdb SB2) {
        this.SB = SB2;
        this.status = UNKNOWN;
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        if (this.desc != null) {
            return this.desc.getDescr();
        }
        return String.valueOf(this.lithCode);
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        out.write("[INTERVAL " + util.SB.getDepthString(this.topDepth, units, 2).trim() + " - " + util.SB.getDepthString(this.baseDepth, units, 2).trim() + "]" + eol);
        out.write("Interval Lithology = " + this.toString() + eol);
        out.write("  Top depth : " + util.SB.getDepthString(this.topDepth, units, 2).trim() + eol);
        out.write("  Base depth : " + util.SB.getDepthString(this.baseDepth, units, 2).trim() + eol);
        out.write("  Dictionary ID : " + this.lithCode + eol);
        out.write(eol);
    }

    public void store(int wellID) throws SQLException {
        if (this.lithCode > 0 && this.status == NOTSTORED) {
            String sql = "INSERT INTO " + this.SB.DBTableName("SBILITH") + " (well_Id,top_depth,base_depth,lith_id) VALUES (" + wellID + "," + this.topDepth + "," + this.baseDepth + "," + this.lithCode + ")";
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(this.SB.modQuery(sql));
            stmt.close();
            this.status = STORED;
        }
    }

    public void delete(int wellID) throws SQLException, SBException {
        if (wellID == 0) {
            throw new SBException("Attempt to delete null lithology interval from well");
        }
        String sql = "DELETE FROM " + this.SB.DBTableName("SBILITH") + " WHERE well_id=" + wellID + " AND top_depth >=" + (this.topDepth - 0.003048) + " AND top_depth <=" + (this.topDepth + 0.003048);
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.status = NOTSTORED;
    }

    public static void deleteAll(SBdb SB2, int wellID) throws SQLException, SBException {
        if (wellID == 0) {
            throw new SBException("Attempt to delete null lithology interval from well");
        }
        String sql = "DELETE FROM " + SB2.DBTableName("SBILITH") + " WHERE well_id=" + wellID;
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
    }

    public void updateStatus(Vector oldData, boolean oldDataStored) {
        Enumeration en = oldData.elements();
        int nzTD = (int)(this.topDepth * 100.0);
        int nzBD = (int)(this.baseDepth * 100.0);
        this.status = NOTSTORED;
        boolean selfIncluded = false;
        while (en.hasMoreElements()) {
            LithInterval lithInt = (LithInterval)en.nextElement();
            if (lithInt != this) {
                int cTD = (int)(lithInt.topDepth * 100.0);
                int cBD = (int)(lithInt.baseDepth * 100.0);
                if (cTD == nzTD && cBD == nzBD) {
                    if (oldDataStored) {
                        this.status = STORED;
                    }
                    if (this.lithCode == lithInt.lithCode && !selfIncluded) break;
                    this.status = CONFLICT;
                    break;
                }
                if (nzTD == nzBD) {
                    if (nzTD > cTD && nzTD < cBD) {
                        this.status = CONFLICT;
                    }
                    if (nzTD == cTD && nzTD == cBD) {
                        this.status = CONFLICT;
                    }
                } else {
                    if (nzTD < cTD && nzBD > cTD) {
                        this.status = CONFLICT;
                    }
                    if (nzTD < cBD && nzBD > cBD) {
                        this.status = CONFLICT;
                    }
                    if (nzTD > cTD && nzBD < cBD) {
                        this.status = CONFLICT;
                    }
                    if (nzTD < cTD && nzBD > cBD) {
                        this.status = CONFLICT;
                    }
                }
                if (this.status != CONFLICT) continue;
                break;
            }
            selfIncluded = true;
        }
    }
}

