/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import model1_8.LithInterval;
import model1_8.SBException;
import model1_8.SBdb;
import util.SB;

public class LithQualifier
extends LithInterval {
    char qType = (char)81;
    char alignment = (char)76;
    float xPlotPos;

    public LithQualifier(SBdb SB) {
        super(SB);
    }

    public void store(int wellID) throws SQLException {
        if (this.lithCode > 0 && this.status == NOTSTORED) {
            String sql = "INSERT INTO " + this.SB.DBTableName("SBQLITH") + " (well_id,type,top_depth,base_depth,alignment,plotpos,lith_id) VALUES (" + wellID + ",'" + this.qType + "'," + this.topDepth + "," + this.baseDepth + ",'" + this.alignment + "'," + this.xPlotPos + "," + this.lithCode + ")";
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(this.SB.modQuery(sql));
            stmt.close();
            this.status = STORED;
        }
    }

    public static void deleteAll(SBdb SB, int wellID) throws SQLException, SBException {
        if (wellID == 0) {
            throw new SBException("Attempt to delete null lithology qualifers from well");
        }
        String sql = "DELETE FROM " + SB.DBTableName("SBQLITH") + " WHERE well_id=" + wellID;
        Statement stmt = SB.getDatabase().createStatement();
        stmt.executeUpdate(SB.modQuery(sql));
        stmt.close();
    }

    public void delete(int wellID) throws SQLException, SBException {
        if (wellID == 0) {
            throw new SBException("Attempt to delete null lithology qualifier from well");
        }
        String sql = "DELETE FROM " + this.SB.DBTableName("SBQLITH") + " WHERE well_id=" + wellID + " AND top_depth >=" + (this.topDepth - 0.003048) + " AND top_depth <=" + (this.topDepth + 0.003048) + " AND type='" + this.qType + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.status = NOTSTORED;
    }

    public void updateStatus(Vector oldData, boolean oldDataStored) {
        Enumeration en = oldData.elements();
        int nzTD = (int)(this.topDepth * 100.0);
        int nzBD = (int)(this.baseDepth * 100.0);
        this.status = NOTSTORED;
        while (en.hasMoreElements()) {
            int cTD;
            LithQualifier lithQual = (LithQualifier)en.nextElement();
            if (lithQual == this || (cTD = (int)(lithQual.topDepth * 100.0)) != nzTD || this.qType != lithQual.qType) continue;
            if (oldDataStored) {
                this.status = STORED;
            }
            if (this.lithCode == lithQual.lithCode) break;
            this.status = CONFLICT;
            break;
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        out.write("[INTERVAL " + util.SB.getDepthString(this.topDepth, units, 2) + " - " + util.SB.getDepthString(this.baseDepth, units, 2) + "]" + eol);
        out.write("Lithology ");
        switch (this.qType) {
            case 'A': {
                out.write("Accessory");
                break;
            }
            case 'S': {
                out.write("Stringer");
                break;
            }
            case 'Q': {
                out.write("Qualifier");
            }
        }
        out.write(" = " + this + eol);
        out.write("  Top depth : " + util.SB.getDepthString(this.topDepth, units, 2) + eol);
        out.write("  Base depth : " + util.SB.getDepthString(this.baseDepth, units, 2) + eol);
        out.write("  Dictionary ID : " + this.lithCode + eol);
        if (this.qType == 'A' || this.qType == 'Q') {
            out.write("  Plot position : " + this.xPlotPos + eol);
        }
        if (this.qType == 'S') {
            out.write("  Alignment : ");
            if (this.alignment == 'L') {
                out.write("Left");
            } else {
                out.write("Right");
            }
            out.write(eol);
            out.write("  Width : " + this.xPlotPos + eol);
        }
        out.write(eol);
    }
}

