/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import model1_8.LithScheme;
import model1_8.Lithology;
import model1_8.SBException;
import model1_8.SBdb;

public class Lithdesc {
    SBdb SB;
    Vector<Lithology> lithologies = new Vector();
    List<LithScheme> schemes = new ArrayList<LithScheme>();
    LithScheme currentScheme = null;
    List<Lithology> stringers = new ArrayList<Lithology>();
    List<Lithology> qualifiers = new ArrayList<Lithology>();
    List<Lithology> accessories = new ArrayList<Lithology>();
    int trnLoaded = 0;

    public Lithdesc(SBdb SB2, boolean extendedSet) throws SQLException {
        this.SB = SB2;
        String sql = "SELECT lithcode,lithdescr,lithabr,lithcmp";
        if (SB2.hasLithGS) {
            sql = sql + ",grain_size";
        }
        sql = sql + " FROM " + SB2.DBTableName("LITHDESC");
        if (!extendedSet) {
            sql = sql + " WHERE lithcode > 999 ";
        }
        sql = sql + " ORDER BY lithcode";
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            int lithID = rs.getInt("lithcode");
            String descr = rs.getString("lithdescr");
            String abr = rs.getString("lithabr");
            char cmp = rs.getString("lithcmp").charAt(0);
            float grainSize = 0.0f;
            if (SB2.hasLithGS) {
                grainSize = rs.getFloat("grain_size");
            }
            Lithology lithology = new Lithology(SB2, lithID, descr, abr, cmp, grainSize);
            this.lithologies.add(lithology);
            switch (lithology.getCmp()) {
                case 'A': {
                    this.accessories.add(lithology);
                    break;
                }
                case 'S': {
                    this.stringers.add(lithology);
                    break;
                }
                case 'Q': 
                case 'Y': {
                    this.qualifiers.add(lithology);
                    break;
                }
            }
        }
        sql = "SELECT lthsch_id, descr FROM " + SB2.DBTableName("SBLTHSCH");
        rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            LithScheme scheme = new LithScheme();
            scheme.ID = rs.getInt("lthsch_id");
            scheme.descr = rs.getString("descr");
            this.schemes.add(scheme);
            if (!scheme.descr.equalsIgnoreCase("All")) continue;
            this.currentScheme = scheme;
        }
        sql = "SELECT lthsch_id, lith_id FROM " + SB2.DBTableName("SBLTHMBR");
        rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int schemeID = rs.getInt("lthsch_id");
            int lithID = rs.getInt("lith_id");
            Iterator<LithScheme> it = this.schemes.iterator();
            LithScheme scheme = null;
            while (it.hasNext()) {
                scheme = it.next();
                if (scheme.ID != schemeID) continue;
            }
            if (scheme == null) continue;
            Enumeration<Lithology> en = this.lithologies.elements();
            while (en.hasMoreElements()) {
                Lithology lith = en.nextElement();
                if (lith.getLithID() != lithID) continue;
                scheme.lithologies.add(lith);
            }
        }
    }

    public Lithology getLithologyFromDescription(String descr) {
        for (int i = 0; i < this.lithologies.size(); ++i) {
            Lithology lith = this.lithologies.elementAt(i);
            if (lith.getDescr().compareToIgnoreCase(descr) != 0) continue;
            return lith;
        }
        return null;
    }

    public void loadTrn(int schID) throws SQLException {
        if (schID == this.trnLoaded) {
            return;
        }
        this.clearTrn();
        String sql = "SELECT lithcode,descr,impcode FROM " + this.SB.DBTableName("SBLTHTRN");
        if (this.SB.hasLthTrnSch) {
            sql = sql + " WHERE sch_id=" + schID;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            Lithology lith;
            int lithID = rs.getInt("lithcode");
            String trnDescr = rs.getString("descr");
            if (trnDescr != null) {
                trnDescr = trnDescr.trim();
            }
            int trnID = rs.getInt("impcode");
            Enumeration<Lithology> en = this.lithologies.elements();
            boolean matchFound = false;
            while (en.hasMoreElements()) {
                lith = en.nextElement();
                if (trnID > 0) {
                    if (lith.getLithID() != lithID || lith.getTrnID() != 0 && lith.getTrnID() != trnID) continue;
                    matchFound = true;
                    lith.trnDescr = trnDescr;
                    lith.trnID = trnID;
                    break;
                }
                if (lith.getLithID() != lithID || !lith.getTrnDescr().equals(trnDescr)) continue;
                matchFound = true;
                lith.trnDescr = trnDescr;
                lith.trnID = trnID;
            }
            if (matchFound) continue;
            lith = new Lithology(lithID);
            lith.trnDescr = trnDescr;
            lith.trnID = trnID;
            this.lithologies.add(lith);
        }
        rs.close();
        stmt.close();
        this.trnLoaded = schID;
    }

    void clearTrn() {
        Enumeration<Lithology> en = this.lithologies.elements();
        while (en.hasMoreElements()) {
            Lithology lith = en.nextElement();
            lith.trnDescr = "";
            lith.trnID = 0;
        }
    }

    public Lithology getTrn(int trnID) throws SQLException, SBException {
        if (trnID <= 0) {
            return null;
        }
        if (this.trnLoaded == 0) {
            throw new SBException("Lithology matches not loaded in Lithdesc.getTrn");
        }
        Lithology lith = null;
        Enumeration<Lithology> en = this.lithologies.elements();
        while (en.hasMoreElements()) {
            lith = en.nextElement();
            if (lith.getTrnID() != trnID) continue;
            return lith;
        }
        return null;
    }

    public Lithology getTrn(String trnDescr) throws SQLException, SBException {
        if (trnDescr == null || trnDescr.trim().length() == 0) {
            return null;
        }
        if (this.trnLoaded == 0) {
            throw new SBException("Lithology matches not loaded in Lithdesc.getTrn");
        }
        Lithology lith = null;
        Enumeration<Lithology> en = this.lithologies.elements();
        while (en.hasMoreElements()) {
            lith = en.nextElement();
            if (!lith.getTrnDescr().equalsIgnoreCase(trnDescr.trim())) continue;
            return lith;
        }
        System.out.println("No Match for " + trnDescr);
        return null;
    }

    public Lithology getLithology(int lithCode) {
        Lithology lith = null;
        Enumeration<Lithology> en = this.lithologies.elements();
        while (en.hasMoreElements()) {
            lith = en.nextElement();
            if (lith.getLithID() != lithCode) continue;
            return lith;
        }
        return null;
    }

    public void storeGrainSize() throws SQLException {
        if (!this.SB.hasLithGS) {
            return;
        }
        String sql = "UPDATE " + this.SB.DBTableName("lithdesc") + " SET grain_size=? WHERE lithcode=?";
        PreparedStatement pStmt = this.SB.getDatabase().prepareStatement(this.SB.modQuery(sql));
        for (Lithology lithology : this.lithologies) {
            System.out.println("Saving lithology: " + lithology);
            pStmt.setFloat(1, lithology.getGrainSize());
            pStmt.setInt(2, lithology.getLithID());
            pStmt.execute();
        }
        pStmt.close();
    }
}

