/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.SeismicMarker;

public class Markers
extends Observable {
    private SBdb SB;
    private ArrayList<SeismicMarker> list = new ArrayList();

    public Markers(SBdb SB2) {
        this.SB = SB2;
    }

    void clear() {
        this.list.clear();
    }

    public SeismicMarker get(int i) {
        return this.list.get(i);
    }

    public int getSize() {
        return this.list.size();
    }

    public boolean add(SeismicMarker seismicMarker) throws SBException {
        this.list.add(this.checkOverlap(seismicMarker), seismicMarker);
        this.setChanged();
        return true;
    }

    public int checkOverlap(SeismicMarker marker) throws SBException {
        Iterator<SeismicMarker> it = this.list.iterator();
        int insertPoint = 0;
        int nzD = (int)(marker.getDepth() * 100.0);
        while (it.hasNext()) {
            SeismicMarker compareWith = it.next();
            if (compareWith == marker || !marker.getColour().equals(compareWith.getColour())) continue;
            throw new SBException("Seismic marker already exists: " + marker.toString() + "/" + compareWith);
        }
        for (SeismicMarker compareWith : this.list) {
            if (compareWith != marker) {
                int cD = (int)(compareWith.getDepth() * 100.0);
                if (nzD == cD) {
                    throw new SBException("Seismic marker depth already exists: " + marker.toString());
                }
                if (nzD < cD) break;
                ++insertPoint;
                continue;
            }
            return -1;
        }
        return insertPoint;
    }

    public void load(String wellCode) throws SQLException, SBException {
        String sql = "SELECT depth, colour FROM " + this.SB.DBTableName("WELLSMARK") + " WHERE well_code='" + wellCode + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            double depth = rs.getDouble("depth");
            String colour = rs.getString("colour");
            SeismicMarker seismicMarker = new SeismicMarker(depth, colour);
            seismicMarker.status = SeismicMarker.STORED;
            try {
                this.add(seismicMarker);
            }
            catch (SBException e) {
                System.out.println("Error adding marker: " + e.getMessage());
            }
        }
        stmt.close();
    }

    public void deleteAll(String wellCode) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("WELLSMARK") + " WHERE well_code='" + wellCode + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.setChanged();
    }

    public void delete(String wellCode, SeismicMarker marker) throws SQLException, SBException {
        String sql = "DELETE FROM " + this.SB.DBTableName("WELLSMARK") + " WHERE well_code='" + wellCode + "'" + " AND depth > " + (marker.getDepth() - 0.01) + " AND depth < " + (marker.getDepth() + 0.01);
        Statement stmt = this.SB.getDatabase().createStatement();
        int nRows = stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        if (nRows < 1) {
            throw new SBException("Failed to delete seismic marker at depth: " + marker.getDepth());
        }
        this.list.remove(marker);
        this.setChanged();
    }

    public void store(String wellCode) throws SQLException {
        Iterator<SeismicMarker> it = this.list.iterator();
        boolean refresh = false;
        while (it.hasNext()) {
            if (it.next().status != SeismicMarker.NOTSTORED) continue;
            refresh = true;
            break;
        }
        if (!refresh) {
            return;
        }
        this.deleteAll(wellCode);
        it = this.list.iterator();
        while (it.hasNext()) {
            it.next().store(this.SB, wellCode);
        }
    }

    void setIntervalStatus(Color status) {
        Iterator<SeismicMarker> it = this.list.iterator();
        while (it.hasNext()) {
            it.next().status = status;
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        Iterator<SeismicMarker> it = this.list.iterator();
        while (it.hasNext()) {
            it.next().writeDEX(out, eol, units);
        }
    }
}

