/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model1_8.AbnScheme;
import model1_8.CoOccurrence;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Sample;
import model1_8.Smpdtl;
import model1_8.Taxon;
import model1_8.Well;
import util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
extends Observable {
    private int ID = 0;
    private String name = "<default>";
    private List<Well> wells = null;

    public Project(SBdb SB2, String name) throws SQLException, SBException {
        Statement stmt = SB2.getDatabase().createStatement();
        this.ID = SB2.nextControl("WELLIST");
        String sql = "INSERT INTO " + SB2.DBTableName("SBWLLST") + " (id, name) VALUES (" + this.ID + "," + SB.DBString(name) + ")";
        stmt.executeUpdate(SB2.modQuery(sql));
        this.name = name;
        stmt.close();
    }

    public Project(SBdb SB2, int ID, boolean load) throws SQLException, SBException {
        if (ID > 0) {
            String sql = "SELECT name FROM " + SB2.DBTableName("SBWLLST") + " WHERE id=" + ID;
            Statement stmt = SB2.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
            if (rs.next()) {
                this.name = rs.getString("name").trim();
                this.ID = ID;
            }
            rs.close();
            if (load) {
                this.loadWells(SB2, stmt);
            }
            stmt.close();
        }
    }

    public String getName() {
        return this.name;
    }

    public void update(SBdb SB2, String name) throws SQLException {
        Statement stmt = SB2.getDatabase().createStatement();
        String sql = "UPDATE " + SB2.DBTableName("SBWLLST") + " SET name=" + SB.DBString(name) + " WHERE id=" + this.ID;
        stmt.executeUpdate(SB2.modQuery(sql));
        this.name = name;
        stmt.close();
        this.setChanged();
    }

    public Iterator<Well> getWellIterator() {
        if (this.wells == null) {
            this.wells = new LinkedList<Well>();
        }
        return this.wells.iterator();
    }

    void mergeOcc(SBdb db, CoOccurrence coOcc) throws SQLException, SBException {
        Sample sample;
        Well well = null;
        boolean loaded = true;
        if (!this.contains(coOcc.getWellID())) {
            well = this.getWell(db, coOcc.getWellID());
            loaded = false;
        } else {
            well = this.getWell(db, coOcc.getWellID());
        }
        well.fillAbnScheme(db.getAbnSchemes(), coOcc.discID, true);
        AbnScheme abn = db.getAbnScheme(well, coOcc.discID, true);
        if (abn == null) {
            abn = db.getDefaultAbnScheme();
        }
        coOcc.target.merge(coOcc.donor, abn);
        coOcc.donor.delete(coOcc.sampID, coOcc.discID, coOcc.analyst);
        coOcc.target.delete(coOcc.sampID, coOcc.discID, coOcc.analyst);
        coOcc.target.store(coOcc.sampID, coOcc.discID, coOcc.analyst);
        if (loaded && (sample = well.getSample(coOcc.sampID)) != null) {
            Smpdtl smpdtl = sample.getSmpdtl(coOcc.discID, coOcc.analyst);
            smpdtl.replaceOcc(coOcc.target);
            smpdtl.removeOcc(coOcc.donor);
            smpdtl.notifyObservers();
        }
    }

    void updateTaxonRef(Taxon donor, Taxon target) throws SBException {
        if (this.wells == null) {
            return;
        }
        for (Well w : this.wells) {
            w.updateTaxonRef(donor, target);
        }
    }

    public int getSize() {
        return this.wells.size();
    }

    public int getID() {
        return this.ID;
    }

    public String toString() {
        return this.name;
    }

    public void loadWells(SBdb SB2, Statement stmt) throws SQLException, SBException {
        if (this.wells == null) {
            this.wells = new LinkedList<Well>();
            if (this.ID > 0) {
                String sql = "SELECT well_id FROM " + SB2.DBTableName("SBWLMB") + " WHERE id=" + this.ID;
                boolean createdStatement = false;
                if (stmt == null) {
                    stmt = SB2.getDatabase().createStatement();
                    createdStatement = true;
                }
                ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
                while (rs.next()) {
                    this.addWell(SB2.getAddWell(rs.getInt("well_id")));
                }
                rs.close();
                if (createdStatement) {
                    stmt.close();
                }
            }
        }
    }

    public Well getWell(SBdb SB2, int wellID) throws SQLException, SBException {
        if (this.wells == null && this.ID == 0) {
            this.wells = new LinkedList<Well>();
        }
        for (Well well : this.wells) {
            if (well.wellID != wellID) continue;
            return well;
        }
        if (this.ID == 0) {
            Well well = new Well(SB2, wellID);
            this.addWell(well);
            this.setChanged();
            return well;
        }
        return null;
    }

    public void remove(SBdb SB2, Well well) throws SQLException, SBException {
        if (this.wells == null) {
            throw new SBException("Attempt to remove well from project when project not loaded");
        }
        if (this.wells.contains(well)) {
            Statement stmt = SB2.getDatabase().createStatement();
            String sql = "DELETE FROM " + SB2.DBTableName("SBWLMB") + " WHERE ID=" + this.ID + " AND WELL_ID=" + well.wellID;
            stmt.executeUpdate(SB2.modQuery(sql));
            stmt.close();
            this.wells.remove(well);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void addWell(SBdb SB2, Well well) throws SQLException {
        if (this.wells == null) {
            this.wells = new LinkedList<Well>();
        }
        if (!this.wells.contains(well)) {
            if (this.ID > 0) {
                Statement stmt = SB2.getDatabase().createStatement();
                String sql = "INSERT INTO " + SB2.DBTableName("SBWLMB") + " (ID,well_id) VALUES (" + this.ID + "," + well.wellID + ")";
                stmt.executeUpdate(SB2.modQuery(sql));
                stmt.close();
            }
            this.wells.add(well);
            this.setChanged();
        }
    }

    public void addWells(SBdb SB2, List<Well> wells) throws SQLException {
        if (wells == null && this.ID == 0) {
            wells = new LinkedList<Well>();
        }
        for (Well w : wells) {
            this.addWell(SB2, w);
        }
        this.notifyObservers();
    }

    void addWell(Well well) {
        if (this.wells == null) {
            this.wells = new LinkedList<Well>();
        }
        if (!this.wells.contains(well)) {
            int insertPoint = 0;
            for (Well w : this.wells) {
                if (w.toString().compareToIgnoreCase(well.toString()) > 0) break;
                ++insertPoint;
            }
            this.wells.add(insertPoint, well);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean removeWell(SBdb SB2, Well well) throws SQLException {
        if (this.wells == null) {
            return false;
        }
        if (this.wells.contains(well)) {
            if (this.ID > 0) {
                Statement stmt = SB2.getDatabase().createStatement();
                String sql = "DELETE FROM " + SB2.DBTableName("SBWLMB") + " WHERE ID=" + this.ID + " AND well_id=" + well.wellID;
                stmt.executeUpdate(SB2.modQuery(sql));
                stmt.close();
            }
            this.wells.remove(well);
            this.setChanged();
            return true;
        }
        return false;
    }

    public boolean contains(Well well) {
        return this.wells.contains(well);
    }

    public boolean contains(int wellID) {
        if (this.wells != null) {
            for (Well well : this.wells) {
                if (well.wellID != wellID) continue;
                return true;
            }
        }
        return false;
    }

    public void store(SBdb SB2) throws SQLException, SBException {
        String sql;
        if (this.name == null || this.name.length() == 0) {
            throw new SBException("Attempt to store well list with no name");
        }
        if (this.wells.size() == 0) {
            throw new SBException("No Database wells in well list");
        }
        Statement stmt = SB2.getDatabase().createStatement();
        if (this.ID > 0) {
            sql = "DELETE FROM " + SB2.DBTableName("SBWLMB") + " WHERE id=" + this.ID;
            stmt.executeUpdate(SB2.modQuery(sql));
        } else {
            this.ID = SB2.nextControl("WELLIST");
            sql = "INSERT INTO " + SB2.DBTableName("SBWLLST") + " (ID,name) VALUES (" + this.ID + "," + SB.DBString(this.name) + ")";
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        Iterator<Well> it = this.wells.iterator();
        while (it.hasNext()) {
            sql = "INSERT INTO " + SB2.DBTableName("SBWLMB") + " (ID,well_id) VALUES (" + this.ID + "," + it.next() + ")";
            stmt.executeUpdate(SB2.modQuery(sql));
        }
        stmt.close();
    }

    public static void delete(SBdb SB2, String name) throws SQLException {
        int ID = 0;
        String sql = "SELECT id FROM " + SB2.DBTableName("SBWLLST") + " WHERE name='" + name + "'";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            ID = rs.getInt("id");
        }
        rs.close();
        if (ID > 0) {
            sql = "DELETE FROM " + SB2.DBTableName("SBWLLST") + " WHERE id=" + ID;
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "DELETE FROM " + SB2.DBTableName("SBWLMB") + " WHERE id=" + ID;
            stmt.executeUpdate(SB2.modQuery(sql));
        }
    }
}

