/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import model1_8.Project;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Well;

public class ProjectList
extends Observable {
    SBdb SB;
    private List<Project> projects = new LinkedList<Project>();

    public ProjectList(SBdb db) throws SQLException, SBException {
        this.SB = db;
        this.projects.add(new Project(this.SB, 0, false));
        String sql = "SELECT id,name FROM " + this.SB.DBTableName("SBWLLST") + " ORDER BY name";
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            int ID = rs.getInt("id");
            Project list = new Project(this.SB, ID, false);
            this.projects.add(list);
        }
        rs.close();
        stmt.close();
    }

    public void removeWell(Well well) throws SQLException {
        for (Project p : this.projects) {
            if (!p.removeWell(this.SB, well)) continue;
            p.notifyObservers();
        }
    }

    public void delete(Project project) throws SQLException, SBException {
        if (project.getID() == 0) {
            throw new SBException("Cannot delete default project (ID=0)");
        }
        for (Project p : this.projects) {
            if (p != project) continue;
            this.projects.remove(p);
            break;
        }
        Project.delete(this.SB, project.getName());
        this.setChanged();
    }

    Project getProject(int ID) throws SQLException, SBException {
        Project project = null;
        if (ID == 0) {
            project = this.projects.get(0);
        } else {
            for (Project p : this.projects) {
                if (p.getID() != ID) continue;
                project = p;
                break;
            }
        }
        if (project == null) {
            project = new Project(this.SB, ID, true);
        }
        return project;
    }

    public Project getProject(String name) throws SQLException, SBException {
        Object project = null;
        for (Project p : this.projects) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return p;
        }
        return null;
    }

    public void add(String name) throws SQLException, SBException {
        if (this.getProject(name) != null) {
            throw new SBException("Project to be added already exists");
        }
        Project project = new Project(this.SB, name);
        int insertPoint = 0;
        for (Project p : this.projects) {
            if (p.getName().compareToIgnoreCase(name) > 0) break;
            ++insertPoint;
        }
        this.projects.add(insertPoint, project);
        this.setChanged();
    }

    public void loadList(DefaultListModel model, boolean includeDefault) {
        for (Project p : this.projects) {
            if (p.getID() <= 0 && !includeDefault) continue;
            model.addElement(p);
        }
    }

    public void loadCombo(DefaultComboBoxModel model, boolean includeDefault) {
        for (Project p : this.projects) {
            if (p.getID() <= 0 && !includeDefault) continue;
            model.addElement(p);
        }
    }
}

