/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.List;
import model1_8.CompositeStandard;
import model1_8.SBException;
import model1_8.SBdb;
import util.SB;
import util.SbugsStatus;

public class QSLOC
implements SbugsStatus {
    SBdb SB;
    Color status = UNKNOWN;
    String conflictReason;
    int stdID;
    int qsID;
    int wellID;
    CompositeStandard std;
    private double depth1;
    private double depth2;
    private double csu1;
    private double csu2;
    private Color colour = Color.BLACK;
    private float lineWidth = 0.5f;

    public QSLOC(SBdb SB2) {
        this.SB = SB2;
    }

    QSLOC(SBdb SB2, int stdID, int qsID, int wellID, double depth1, double depth2, double csu1, double csu2, Color colour, float lineWidth) {
        this.SB = SB2;
        this.stdID = stdID;
        this.qsID = qsID;
        this.wellID = wellID;
        this.depth1 = depth1;
        this.depth2 = depth2;
        this.csu1 = csu1;
        this.csu2 = csu2;
        this.colour = colour;
        this.lineWidth = lineWidth;
    }

    QSLOC(SBdb SB2, CompositeStandard std, double depth1, double depth2, double csu1, double csu2) {
        this.SB = SB2;
        this.std = std;
        this.stdID = std.getStdID();
        this.depth1 = depth1;
        this.depth2 = depth2;
        this.csu1 = csu1;
        this.csu2 = csu2;
        this.status = NOTSTORED;
    }

    public QSLOC(QSLOC rhs) {
        this.status = rhs.status;
        this.conflictReason = rhs.conflictReason;
        this.stdID = rhs.stdID;
        this.qsID = rhs.qsID;
        this.wellID = rhs.wellID;
        this.std = rhs.std;
        this.depth1 = rhs.depth1;
        this.depth2 = rhs.depth2;
        this.csu1 = rhs.csu1;
        this.csu2 = rhs.csu2;
        this.colour = rhs.colour;
        this.lineWidth = rhs.lineWidth;
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    public String statusString() {
        return this.toString();
    }

    public boolean isUnconformity() {
        return Math.abs(this.depth2 - this.depth1) < 1.0E-4;
    }

    public String toString() {
        String strg = "";
        if (this.std != null) {
            strg = strg + this.std.getName() + ": ";
        }
        strg = strg + this.depth1 + "," + this.depth2 + "," + this.csu1 + "," + this.csu2;
        return strg;
    }

    public Color getStatus() {
        return this.status;
    }

    public void store(int wellID, int qsID) throws SBException, SQLException {
        this.wellID = wellID;
        this.qsID = qsID;
        if (this.status == NOTSTORED) {
            String sql = "INSERT INTO " + this.SB.DBTableName("QSLOC") + " (well_id,qs_id,std_id,depth1,depth2,csu1,csu2,r,g,b,linewidth) VALUES (" + wellID + "," + qsID + "," + this.stdID + "," + this.depth1 + "," + this.depth2 + "," + this.csu1 + "," + this.csu2 + "," + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + "," + this.lineWidth + ")";
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(this.SB.modQuery(sql));
            stmt.close();
            this.status = STORED;
        } else if (this.status == PARTSTORED) {
            throw new SBException("Attempt to update QSLOC");
        }
    }

    void delete() throws SBException, SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("QSLOC") + " WHERE qs_id=" + this.qsID + " AND std_id=" + this.stdID + " AND (depth1 >=" + (this.depth1 - 0.01) + " AND depth1 <= " + (this.depth1 + 0.01) + ")" + " AND (depth2 >=" + (this.depth2 - 0.01) + " AND depth2 <= " + (this.depth2 + 0.01) + ")";
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        this.status = UNKNOWN;
    }

    public void setPoint1(double x, double y) throws SQLException {
        String sql = "UPDATE " + this.SB.DBTableName("QSLOC") + " SET depth1=" + y + ", csu1=" + x + " WHERE qs_id=" + this.qsID + " AND std_id=" + this.stdID + " AND (depth1 >=" + (this.depth1 - 0.01) + " AND depth1 <= " + (this.depth1 + 0.01) + ")" + " AND (depth2 >=" + (this.depth2 - 0.01) + " AND depth2 <= " + (this.depth2 + 0.01) + ")";
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        this.csu1 = x;
        this.depth1 = y;
    }

    public void setPoint2(double x, double y) throws SQLException {
        String sql = "UPDATE " + this.SB.DBTableName("QSLOC") + " SET depth2=" + y + ", csu2=" + x + " WHERE qs_id=" + this.qsID + " AND std_id=" + this.stdID + " AND (depth1 >=" + (this.depth1 - 0.01) + " AND depth1 <= " + (this.depth1 + 0.01) + ")" + " AND (depth2 >=" + (this.depth2 - 0.01) + " AND depth2 <= " + (this.depth2 + 0.01) + ")";
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        this.csu2 = x;
        this.depth2 = y;
    }

    void updateStatus(List LOCs) throws SQLException {
    }

    public void writeDEX(FileWriter out, DecimalFormat nFormat, String eol, char units, String wellName) throws IOException {
        out.write("[LOC]" + eol);
        out.write("Well = " + wellName + eol);
        out.write("Composite standard = " + this.std.getName() + eol);
        out.write("Depth 1 = " + util.SB.getDepthString(this.depth1, units, 3) + eol);
        out.write("Depth 2 = " + util.SB.getDepthString(this.depth1, units, 3) + eol);
        out.write("CSU 1 = " + nFormat.format(this.csu1) + eol);
        out.write("CSU 2 = " + nFormat.format(this.csu2) + eol);
        out.write("Line width = " + this.lineWidth + eol);
        out.write("Colour = " + this.colour.getRed() + ',' + this.colour.getGreen() + ',' + this.colour.getBlue() + eol);
        out.write(eol);
    }

    public boolean checkDepthBracketing(int cTD, int cBD, int nzTD, int nzBD) {
        if (nzTD == nzBD) {
            if (nzTD > cTD && nzTD < cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC lies inside existing data";
                return false;
            }
            if (nzTD == cTD && nzTD == cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depths same as existing data";
                return false;
            }
        } else {
            if (nzTD < cTD && nzBD > cTD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depths overlap existing data";
                return false;
            }
            if (nzTD < cBD && nzBD > cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depth overlap existing data";
                return false;
            }
            if (nzTD > cTD && nzBD < cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depths are overlapped by existing data";
                return false;
            }
            if (nzTD < cTD && nzBD > cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depths overlap existing data";
                return false;
            }
            if (nzTD == cTD && nzBD == cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depths are the same as existing data";
                return false;
            }
        }
        return true;
    }

    public double getDepth1() {
        return this.depth1;
    }

    public double getDepth2() {
        return this.depth2;
    }

    public double getCsu1() {
        return this.csu1;
    }

    public double getCsu2() {
        return this.csu2;
    }

    public Color getColour() {
        return this.colour;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }
}

