/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Sample;
import model1_8.Taxon;
import model1_8.Well;
import util.SB;
import util.SbugsStatus;

public class SBEvent
implements SbugsStatus,
Comparable {
    SBdb SB;
    private int evID = 0;
    int donorID = 0;
    private int specID = 0;
    private String name = "";
    private boolean isSingle = false;
    private boolean generate = false;
    Color status = UNKNOWN;
    private Date created;
    private String creator;
    private char evExtent;
    private String evDesc;
    private Taxon taxon = null;

    public SBEvent(SBdb SB2) {
        this.SB = SB2;
    }

    public SBEvent(SBEvent rhs) {
        this.SB = rhs.SB;
        this.evID = rhs.evID;
        this.donorID = rhs.donorID;
        this.specID = rhs.specID;
        this.name = rhs.name;
        this.isSingle = rhs.isSingle;
        this.generate = rhs.generate;
        this.status = rhs.status;
        this.created = rhs.created;
        this.creator = rhs.creator;
        this.evExtent = rhs.evExtent;
        this.evDesc = rhs.evDesc;
        this.taxon = rhs.taxon;
    }

    public void writeDEX(FileWriter out, String eol, SimpleDateFormat df, boolean includeCompositeInfo) throws IOException {
        out.write("Event = " + this.toString() + eol);
        out.write("   ID : " + this.evID + eol);
        if (this.specID > 0) {
            out.write("   Species id : " + this.specID + eol);
        }
        out.write("   Paired : " + (this.isSingle ? "false" : "true") + eol);
        if (this.generate) {
            out.write("   Use as top or base : true" + eol);
        }
        if (this.evExtent != ' ' && this.evExtent > '\u0000') {
            out.write("   Extent : " + this.evExtent + eol);
        }
        if (this.evDesc != null && this.evDesc.length() > 0) {
            out.write("   Description : " + this.evDesc + eol);
        }
        out.write("   Created : " + df.format(this.created) + eol);
        out.write("   Creator : " + this.creator + eol);
        out.write(eol);
    }

    public SBEvent(String name) throws SQLException {
        this.name = name.trim();
        this.status = NOTSTORED;
        this.lookup(name);
    }

    public static void loadAll(SBdb SB2, List list) throws SQLException {
        String sql = "SELECT ev_id,name,spec_id,ev_type,generate,creator,created";
        if (SB2.hasEventExtensions) {
            sql = sql + ",ev_extent,ev_desc";
        }
        sql = sql + " FROM " + SB2.DBTableName("EVENTDIC");
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            SBEvent event = new SBEvent(SB2);
            event.evID = rs.getInt("ev_id");
            event.name = rs.getString("name").trim();
            event.specID = rs.getInt("spec_id");
            String strg = rs.getString("ev_type").trim();
            if (strg.length() > 0 && strg.charAt(0) == 'S') {
                event.isSingle = true;
            }
            if ((strg = rs.getString("generate")) != null && (strg = strg.trim()).length() > 0 && strg.charAt(0) == 'Y') {
                event.generate = true;
            }
            event.creator = rs.getString("creator");
            event.created = rs.getTimestamp("created");
            if (SB2.hasEventExtensions) {
                event.evExtent = util.SB.getDBChar(rs, "ev_extent");
                event.evDesc = rs.getString("ev_desc");
            }
            event.status = STORED;
            list.add(event);
        }
        stmt.close();
    }

    public SBEvent(SBdb SB2, int id) throws SQLException {
        this.SB = SB2;
        String sql = "SELECT name,spec_id,ev_type,generate,creator,created";
        if (SB2.hasEventExtensions) {
            sql = sql + ",ev_extent,ev_desc";
        }
        sql = sql + " FROM " + SB2.DBTableName("EVENTDIC") + " WHERE ev_id=" + id;
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        if (rs.next()) {
            this.evID = id;
            this.name = rs.getString("name").trim();
            this.specID = rs.getInt("spec_id");
            String strg = rs.getString("ev_type").trim();
            if (strg.length() > 0 && strg.charAt(0) == 'S') {
                this.isSingle = true;
            }
            if ((strg = rs.getString("generate")) != null && (strg = strg.trim()).length() > 0 && strg.charAt(0) == 'Y') {
                this.generate = true;
            }
            this.creator = rs.getString("creator");
            this.created = rs.getTimestamp("created");
            if (SB2.hasEventExtensions) {
                this.evExtent = util.SB.getDBChar(rs, "ev_extent");
                this.evDesc = rs.getString("ev_desc");
            }
            this.status = STORED;
        }
        stmt.close();
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.name;
    }

    public Color getStatus() {
        return this.status;
    }

    void updateName(String name) throws SQLException {
        String sql = "UPDATE " + this.SB.DBTableName("EVENTDIC") + " SET name=" + util.SB.DBString(name);
        sql = sql + " WHERE ev_id=" + this.evID;
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.name = name;
    }

    public void store() throws SBException, SQLException {
        if (this.specID == 0 && this.taxon != null) {
            this.specID = this.taxon.getSpecID();
        }
        if (this.evID != 0 && (this.status == NOTSTORED || this.status == PARTSTORED)) {
            String sql = "UPDATE " + this.SB.DBTableName("EVENTDIC") + " SET spec_id=" + this.specID + ",name=" + util.SB.DBString(this.name) + ",ev_type=" + (this.isSingle ? "'S'" : "'R'") + ",generate=" + (this.generate ? "'Y'" : "'N'");
            if (this.SB.hasEventExtensions) {
                sql = sql + ",ev_extent=" + util.SB.DBChar(this.evExtent) + ",ev_desc=" + util.SB.DBString(this.evDesc);
            }
            sql = sql + " WHERE ev_id=" + this.evID;
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(this.SB.modQuery(sql));
            stmt.close();
            this.status = STORED;
            return;
        }
        if (this.evID != 0) {
            return;
        }
        if (this.status == NOTSTORED) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            this.evID = this.SB.nextControl("EV_ID");
            String sql = "INSERT INTO " + this.SB.DBTableName("EVENTDIC") + " (ev_id,spec_id,name,ev_type,generate,creator,created";
            if (this.SB.hasEventExtensions) {
                sql = sql + ",ev_extent,ev_desc";
            }
            this.created = new Date();
            this.creator = this.SB.user.getUsrID();
            sql = sql + ") VALUES (" + this.evID + "," + this.specID + "," + util.SB.DBString(this.name.trim()) + "," + (this.isSingle ? "'S'" : "'R'") + "," + (this.generate ? "'Y'" : "'N'") + "," + util.SB.DBString(this.creator) + "," + util.SB.DBString(df.format(this.created));
            if (this.SB.hasEventExtensions) {
                sql = sql + "," + util.SB.DBChar(this.evExtent) + "," + util.SB.DBString(this.evDesc);
            }
            sql = sql + ")";
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(this.SB.modQuery(sql));
            stmt.close();
            this.status = STORED;
        }
    }

    void lookup(String name) throws SQLException {
        if (this.evID != 0) {
            this.status = STORED;
            return;
        }
        String sql = "SELECT ev_id,spec_id,ev_type,generate,creator,created";
        if (this.SB.hasEventExtensions) {
            sql = sql + ",ev_extent,ev_desc";
        }
        sql = sql + " FROM " + this.SB.DBTableName("EVENTDIC") + " WHERE ucase(name)=" + util.SB.DBString(name.trim().toUpperCase());
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            this.evID = rs.getInt("ev_id");
            this.name = name.trim();
            this.specID = rs.getInt("spec_id");
            String strg = rs.getString("ev_type").trim();
            if (strg.length() > 0 && strg.charAt(0) == 'S') {
                this.isSingle = true;
            }
            if ((strg = rs.getString("generate")) != null && (strg = strg.trim()).length() > 0 && strg.charAt(0) == 'Y') {
                this.generate = true;
            }
            this.creator = rs.getString("creator");
            this.created = rs.getTimestamp("created");
            if (this.SB.hasEventExtensions) {
                this.evExtent = util.SB.getDBChar(rs, "ev_extent");
                this.evDesc = rs.getString("ev_desc");
            }
            this.status = STORED;
        }
        stmt.close();
    }

    void fillSpecies(Hashtable taxa) throws SQLException, SBException {
        if (this.specID > 0 && this.taxon == null) {
            this.taxon = (Taxon)taxa.get("H" + this.specID);
            if (this.taxon == null) {
                this.taxon = new Taxon(this.SB, this.specID);
                taxa.put("H" + this.specID, this.taxon);
            }
        }
    }

    void setTaxon(Taxon taxon) {
        if (taxon != null && this.specID == taxon.getSpecID()) {
            this.taxon = taxon;
        }
    }

    public int getSingleUpdates(boolean changeToSingle) throws SQLException {
        int count = 0;
        if (!this.isSingle && changeToSingle) {
            String sql = "SELECT count(ev_id) as nOcc FROM " + this.SB.DBTableName("EVENTS") + " WHERE ev_id=" + this.evID + " AND ev_type='L'";
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            if (rs.next()) {
                count = rs.getInt("nOcc");
            }
            stmt.close();
        }
        return count;
    }

    public void updateSingle(boolean changeToSingle) throws SQLException {
        String sql;
        if (this.isSingle && changeToSingle) {
            return;
        }
        if (!this.isSingle && !changeToSingle) {
            return;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        if (changeToSingle) {
            sql = "DELETE FROM " + this.SB.DBTableName("EVENTS") + " WHERE ev_id=" + this.evID + " AND ev_type='L'";
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        sql = "UPDATE " + this.SB.DBTableName("EVENTS") + " SET ev_type='" + (changeToSingle ? " " : "F") + "' WHERE ev_id=" + this.evID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("EVENTDIC") + " SET ev_type='" + (changeToSingle ? "S" : "R") + "' WHERE ev_id=" + this.evID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("CMPSTDEV") + " SET ev_type='" + (changeToSingle ? " " : "F") + "' WHERE ev_id=" + this.evID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.isSingle = changeToSingle;
        this.SB.getDatabase().commit();
    }

    public void checkGenerateUnique() throws SBException, SQLException {
        if (this.specID == 0) {
            return;
        }
        if (!this.generate) {
            return;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "SELECT name FROM " + this.SB.DBTableName("EVENTDIC") + " WHERE ev_id <> " + this.evID + " AND spec_id=" + this.specID + " AND generate='Y'";
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        boolean alreadyExists = false;
        String existingName = "";
        if (rs.next()) {
            existingName = rs.getString("name").trim();
            alreadyExists = true;
        }
        stmt.close();
        if (alreadyExists) {
            throw new SBException("Cannot set 'generate' attribute, currently set for event: " + existingName);
        }
    }

    public void delete() throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.SB.DBTableName("EVENTS") + " WHERE ev_id=" + this.evID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("EVENTDIC") + " WHERE ev_id=" + this.evID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("CMPSTDEV") + " WHERE ev_id=" + this.evID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    public void merge(SBEvent target, char sectionType) throws SQLException, SBException {
        ResultSet rs2;
        Statement stmt = this.SB.getDatabase().createStatement();
        Statement stmt2 = this.SB.getDatabase().createStatement();
        String sql = "SELECT floor(samp_id/65536) as well_id,ev_type,qs_id FROM " + this.SB.DBTableName("EVENTS") + " WHERE ev_id=" + this.evID;
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            String eventOccType = rs.getString("ev_type");
            int qsID = rs.getInt("qs_id");
            sql = "SELECT samp_id FROM " + this.SB.DBTableName("EVENTS") + " WHERE ev_id=" + target.evID + " AND ev_type='" + eventOccType + "' AND qs_id=" + qsID + " AND samp_id >=" + wellID * 65536 + " AND samp_id < " + (wellID + 1) * 65536;
            rs2 = stmt2.executeQuery(this.SB.modQuery(sql));
            if (!rs2.next()) continue;
            Sample sample = new Sample(this.SB, rs2.getInt("samp_id"), sectionType);
            String wellName = Well.getName(this.SB, wellID);
            String project = SBEvent.getProjectName(this.SB, qsID);
            stmt2.close();
            stmt.close();
            throw new SBException("Cannot merge events: replacement occurs in same section and project as event, in sample: " + sample + ", Section: " + wellName + ", Project: " + project);
        }
        sql = "UPDATE " + this.SB.DBTableName("EVENTS") + " SET ev_id=" + target.evID + " WHERE ev_id=" + this.evID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        Statement stmtUpdate = this.SB.getDatabase().createStatement(1003, 1008);
        sql = "SELECT std_id,ev_type,csu FROM " + this.SB.DBTableName("CMPSTDEV") + " WHERE ev_id=" + this.evID;
        rs = stmtUpdate.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            int stdID = rs.getInt("std_id");
            String stdOccType = rs.getString("ev_type");
            sql = "SELECT std_id,ev_type,csu FROM " + this.SB.DBTableName("CMPSTDEV") + " WHERE ev_id=" + target.evID + " AND std_id=" + stdID + " AND ev_type='" + stdOccType + "'";
            rs2 = stmt2.executeQuery(this.SB.modQuery(sql));
            if (!rs2.next()) continue;
            rs.deleteRow();
        }
        sql = "UPDATE " + this.SB.DBTableName("CMPSTDEV") + " SET ev_id=" + target.evID + " WHERE ev_id=" + this.evID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("EVENTDIC") + " WHERE ev_id=" + this.evID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt2.close();
        stmt.close();
        stmtUpdate.close();
    }

    static String getProjectName(SBdb SB2, int qsID) throws SQLException {
        String sql;
        String name = "<no name>";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql = "SELECT name FROM " + SB2.DBTableName("QSPROJ") + " WHERE qs_id=" + qsID));
        if (rs.next()) {
            name = rs.getString("name");
        }
        return name;
    }

    static void createExtensions(SBdb SB2) throws SQLException {
        String sql;
        if (SB2.hasEventExtensions) {
            return;
        }
        Statement stmt = SB2.getDatabase().createStatement();
        SBdb.DBType cfr_ignored_0 = SB2.dbType;
        if (SB2.dbType == SBdb.DBType.ORACLE) {
            sql = "ALTER TABLE " + SB2.DBTableName("EVENTDIC") + " ADD (" + " EV_EXTENT varchar2(1), EV_DESC varchar2(240))";
        } else {
            sql = "ALTER TABLE " + SB2.DBTableName("EVENTDIC") + " ADD column " + " EV_EXTENT text(1)";
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "ALTER TABLE " + SB2.DBTableName("EVENTDIC") + " ADD column " + " EV_DESC text(240)";
        }
        stmt.executeUpdate(SB2.modQuery(sql));
        SBdb.DBType cfr_ignored_1 = SB2.dbType;
        if (SB2.dbType == SBdb.DBType.ORACLE) {
            sql = "ALTER TABLE " + SB2.DBTableName("EVENTS") + " ADD (" + "DISC_ID varchar2(1),ANALYST varchar2(5),QUALIFIER varchar2(16),COMMENTS\tvarchar2(240),SOURCE varchar2(5),COMPANY varchar2(20),MODIFIED date)";
        } else {
            sql = "ALTER TABLE " + SB2.DBTableName("EVENTS") + " ADD " + "Column DISC_ID Text(1)";
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "ALTER TABLE " + SB2.DBTableName("EVENTS") + " ADD " + "Column ANALYST Text(5)";
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "ALTER TABLE " + SB2.DBTableName("EVENTS") + " ADD " + "Column QUALIFIER Text(16)";
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "ALTER TABLE " + SB2.DBTableName("EVENTS") + " ADD " + "Column COMMENTS Text(240)";
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "ALTER TABLE " + SB2.DBTableName("EVENTS") + " ADD " + "Column SOURCE Text(5)";
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "ALTER TABLE " + SB2.DBTableName("EVENTS") + " ADD " + "Column COMPANY Text(20)";
            stmt.executeUpdate(SB2.modQuery(sql));
            sql = "ALTER TABLE " + SB2.DBTableName("EVENTS") + " ADD " + "Column MODIFIED Date";
        }
        stmt.executeUpdate(SB2.modQuery(sql));
        SB2.hasEventExtensions = true;
    }

    public int compareTo(Object rhs) {
        return this.compareTo((SBEvent)rhs);
    }

    public int compareTo(SBEvent rhs) {
        if (this.taxon != null && rhs.taxon != null) {
            return this.taxon.compareTo(rhs.taxon);
        }
        return this.name.compareTo(rhs.name);
    }

    public int getEvID() {
        return this.evID;
    }

    public int getSpecID() {
        return this.specID;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public boolean isGenerate() {
        return this.generate;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getCreator() {
        return this.creator;
    }

    public char getEvExtent() {
        return this.evExtent;
    }

    public String getEvDesc() {
        return this.evDesc;
    }

    public Taxon getTaxon() {
        return this.taxon;
    }
}

