/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import model1_8.AbnScheme;
import model1_8.Biocom;
import model1_8.Categories;
import model1_8.CoOccurrence;
import model1_8.Column;
import model1_8.CompositeStandard;
import model1_8.EnvScheme;
import model1_8.EvProject;
import model1_8.Fssabnd;
import model1_8.IGDIntervalZone;
import model1_8.IGDScheme;
import model1_8.InterpHdr;
import model1_8.Lastval;
import model1_8.Licence;
import model1_8.Lithdesc;
import model1_8.Lithology;
import model1_8.Project;
import model1_8.ProjectList;
import model1_8.SBEvent;
import model1_8.SBException;
import model1_8.Sample;
import model1_8.Smpdtl;
import model1_8.SynonymScheme;
import model1_8.TaxaMap;
import model1_8.Taxon;
import model1_8.TxGroup;
import model1_8.TxGroupSet;
import model1_8.Userdef;
import model1_8.Well;
import model1_8.WellInterp;
import util.ProgressBarMonitor;
import util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBdb
extends Observable {
    String DSN;
    private Connection connection = null;
    private DatabaseMetaData meta = null;
    private String tablePrefix = "";
    public static final String version = "v1.8";
    DBType dbType;
    private boolean emptyConnection;
    Userdef user = null;
    public Licence licence = null;
    static boolean preserveAudit = false;
    boolean hasSynonymSchemes = true;
    boolean hasAlphaCode = true;
    public static final char[] discArr = new char[]{'M', 'N', 'P', 'A'};
    public static final String[] discNounString = new String[]{"Micropalaeontology", "Nannopalaeontology", "Palynology", "Macropalaeontology"};
    public static final int MAXDIS = 4;
    boolean[] hasWeightSplits = new boolean[]{true, true, true, true};
    boolean[] hasFssSplits = new boolean[]{true, true, true, true};
    boolean hasAnalystHeader = false;
    boolean hasTVD = false;
    boolean hasOcs = false;
    boolean hasCounty = false;
    boolean hasKicko = false;
    boolean hasSrInterp = false;
    boolean isOW = false;
    boolean hasWellsMaster = false;
    boolean hasIGDSep = false;
    boolean hasIGDHdr = false;
    boolean hasLthTrnSch = false;
    boolean hasUserColour = false;
    boolean hasUserPassword = false;
    boolean hasWellPerm = false;
    boolean hasUserPerm = false;
    boolean hasSIPMdict = false;
    boolean useSampleTops = false;
    boolean hasSamplesWellID = false;
    boolean hasSAMBA = false;
    boolean hideDepthRange = false;
    boolean hideCommonSampleTypes = false;
    boolean hasEventExtensions = false;
    boolean hasEnvTrn = false;
    boolean hasSampleEnv = false;
    boolean hasBiocomSource = false;
    boolean hasTxLoadOccType = false;
    boolean hasTWT = false;
    boolean hasSBimage = false;
    boolean hasLithGS = false;
    boolean sbwlIsView = false;
    boolean hasCasdiam = false;
    public static final int DTMACRO = 1;
    public static final int DTMACROBS = 2;
    public static final int DTMICRO = 3;
    public static final int DTMICROBS = 4;
    public static final int DTNANNO = 5;
    public static final int DTNANNOBS = 6;
    public static final int DTPALY = 7;
    public static final int DTPALYBS = 8;
    public static final int DTLITHOSTRAT = 9;
    public static final int DTCHRONO = 10;
    public static final int DTSEQUENCE = 11;
    public static final int DTBIOZONE1 = 12;
    public static final int DTBIOZONE2 = 13;
    public static final int DTBIOZONE3 = 14;
    public static final int DTBIOZONE4 = 15;
    public static final int DTENV = 16;
    public static final int DTCORES = 17;
    public static final int DTCASING = 18;
    public static final int DTLITHOLOGY = 19;
    public static final int DTLOGDATA = 20;
    public static final int DTMARKERS = 21;
    public static final int DTSAMPLES = 22;
    public static final int DTTVD = 23;
    public static final int DTTWT = 24;
    public static final int DTSAMPLELITH = 25;
    public static final int DTEVENTS = 26;
    public static final int DTQSLOC = 27;
    public static final String[] dTypeNames = new String[]{"Well/Outcrop", "Macro", "Macro. comments", "Micro", "Micro. comments", "Nanno", "Nanno. comments", "Paly", "Paly. comments", "Lithostrat", "Chronostrat", "Sequences", "Biozone 1", "Biozone 2", "Biozone 3", "Biozone 4", "Palaeoenv.", "Cores", "Casing", "Interpreted Lithology", "Log data", "Markers", "Samples", "TVD", "TWT", "Sample Lithology", "Events", "LOCs"};
    public static final int NDTYPES = 28;
    List wellMasterFields = new ArrayList();
    Well currentWell = null;
    Lithdesc lithdesc = null;
    public TaxaMap taxa = new TaxaMap(this);
    private Categories categories = null;
    private HashMap<String, Color> catColours = null;
    private HashMap<Integer, TxGroupSet> sets = null;
    private HashMap<Integer, TxGroup> txGroups = null;
    private HashMap<Integer, SynonymScheme> synSch = null;
    ProjectList projects = null;
    private TreeMap<String, Userdef> users = null;
    private List<AbnScheme> abnSchemes = new LinkedList<AbnScheme>();
    private List<EnvScheme> envSchemes = null;
    HashMap<Integer, InterpHdr> interpHdrs = new HashMap();
    private HashMap<Integer, IGDScheme> chronoSchemes = null;
    private HashMap<Integer, IGDScheme> lstratSchemes = null;
    private HashMap<Integer, IGDScheme> sequenceSchemes = null;
    private HashMap<Integer, IGDScheme> biozoneSchemes = null;
    private HashMap<Integer, CompositeStandard> compositeStandards = null;
    List chartScales = null;
    List<String> casingDiameters = null;
    private HashMap<Integer, EvProject> evProjects = null;
    private HashMap<Integer, SBEvent> sbEvents = null;

    public Connection getDatabase() {
        return this.connection;
    }

    public boolean hasTVD() {
        return this.hasTVD;
    }

    public boolean hasTWT() {
        return this.hasTWT;
    }

    public DBType getDBType() {
        return this.dbType;
    }

    public Userdef getUser() {
        return this.user;
    }

    public boolean needsPassword() {
        return this.dbType != DBType.ORACLE;
    }

    public boolean hasAlphaCode() {
        return this.hasAlphaCode;
    }

    public boolean hasAnalystHeader() {
        return this.hasAnalystHeader;
    }

    public boolean hasOcs() {
        return this.hasOcs;
    }

    public boolean hasCounty() {
        return this.hasCounty;
    }

    public boolean hasIGDHdr() {
        return this.hasIGDHdr;
    }

    public boolean hasLthTrnSch() {
        return this.hasLthTrnSch;
    }

    public boolean hasSipmDict() {
        return this.hasSIPMdict;
    }

    public boolean hasEventExtensions() {
        return this.hasEventExtensions;
    }

    public boolean hasEnvTrn() {
        return this.hasEnvTrn;
    }

    public boolean hasSampleEnv() {
        return this.hasSampleEnv;
    }

    public boolean hasBiocomSource() {
        return this.hasBiocomSource;
    }

    public boolean hasTxLoadOccType() {
        return this.hasTxLoadOccType;
    }

    public static native String getReg(String var0);

    public static native String getUReg(String var0);

    public static native String getRegOption(String var0);

    public static native String getURegOption(String var0);

    public Taxon getTaxon(int specID) throws SQLException, SBException {
        return this.taxa.getTaxon(specID);
    }

    public Categories getCategories() throws SQLException {
        if (this.categories == null) {
            this.categories = new Categories(this);
        }
        return this.categories;
    }

    public Color getCatColour(String abr) throws SQLException {
        Color colour;
        if (this.catColours == null) {
            this.catColours = new HashMap();
        }
        if ((colour = this.catColours.get(abr)) == null) {
            String sql;
            Statement stmt = this.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.modQuery(sql = "SELECT red, green, blue FROM " + this.DBTableName("CATCOL") + " WHERE Ucase(abr)=" + SB.DBString(abr)));
            if (rs.next()) {
                int r = rs.getInt("red");
                int g = rs.getInt("green");
                int b = rs.getInt("blue");
                colour = new Color(r, g, b);
                this.catColours.put(abr, colour);
            }
            stmt.close();
        }
        return colour;
    }

    public TxGroupSet getTxGroupSet(int setID) throws SQLException {
        if (this.sets == null) {
            this.sets = new HashMap();
            TxGroupSet.load(this, this.sets);
        }
        return this.sets.get(setID);
    }

    public Collection<TxGroupSet> getTxGroupSets() throws SQLException {
        if (this.sets == null) {
            this.sets = new HashMap();
            TxGroupSet.load(this, this.sets);
        }
        return this.sets.values();
    }

    public TxGroupSet getTxGroupSet(String name) throws SQLException {
        if (this.sets == null) {
            this.sets = new HashMap();
            TxGroupSet.load(this, this.sets);
        }
        for (TxGroupSet set : this.sets.values()) {
            if (!set.getName().equals(name)) continue;
            return set;
        }
        return null;
    }

    public TxGroupSet addTxGroupSet(String name, Collection<TxGroup> groups) throws SQLException, SBException {
        if (this.getTxGroupSet(name) != null) {
            throw new SBException("Set: " + name + " already exists");
        }
        HashSet<Integer> groupIDs = new HashSet<Integer>();
        for (TxGroup group : groups) {
            groupIDs.add(group.getID());
        }
        TxGroupSet set = new TxGroupSet(this, name, groupIDs);
        this.sets.put(set.getID(), set);
        return set;
    }

    public void deleteTxGroupSet(TxGroupSet set) throws SQLException, SBException {
        set.delete();
        this.sets.remove(set.getID());
    }

    public TxGroup getTxGroup(int groupID) throws SQLException {
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
            TxGroup.load(this, this.txGroups);
        }
        return this.txGroups.get(groupID);
    }

    public TxGroup getTxGroup(String name) throws SQLException {
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
            TxGroup.load(this, this.txGroups);
        }
        for (TxGroup group : this.txGroups.values()) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            return group;
        }
        return null;
    }

    public Collection<Taxon> getTxGroupTaxa(TxGroup group) throws SQLException, SBException {
        group.load();
        TreeSet<Taxon> set = new TreeSet<Taxon>();
        for (Integer i : group.getSpecIDs()) {
            set.add(this.getTaxon(i));
        }
        return set;
    }

    public void insertGroupTaxa(TxGroup group, Well well, char discID, String analyst) throws SQLException, SBException {
        LinkedList<Taxon> toAdd = new LinkedList<Taxon>();
        List<Integer> wellTaxa = this.getWellSpecIDs(well, discID, analyst);
        for (int specID : wellTaxa) {
            if (group.isMember(specID)) continue;
            toAdd.add(this.getTaxon(specID));
        }
        if (toAdd.size() > 0) {
            group.addTaxa(toAdd);
        }
    }

    public List<Taxon> getWellTaxa(Well well, char discID, String analyst) throws SQLException, SBException {
        LinkedList<Taxon> wellTaxa = new LinkedList<Taxon>();
        List<Integer> wellSpecID = this.getWellSpecIDs(well, discID, analyst);
        for (int specID : wellSpecID) {
            wellTaxa.add(this.getTaxon(specID));
        }
        return wellTaxa;
    }

    private List<Integer> getWellSpecIDs(Well well, char discID, String analyst) throws SQLException, SBException {
        String sql = "SELECT distinct(spec_id) FROM " + this.DBTableName("FSSABND") + " WHERE samp_id>=" + well.wellID * 65536 + " AND samp_id<" + (well.wellID + 1) * 65536;
        sql = sql + " AND disc_id=" + SB.DBChar(discID);
        if (analyst != null && analyst.length() > 0) {
            sql = sql + " AND analyst=" + SB.DBString(analyst);
        }
        Statement stmt = this.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        LinkedList<Integer> wellTaxa = new LinkedList<Integer>();
        while (rs.next()) {
            int specID = rs.getInt("spec_id");
            wellTaxa.add(specID);
        }
        stmt.close();
        return wellTaxa;
    }

    public void deleteTxGroup(TxGroup group) throws SQLException, SBException {
        group.delete();
        this.txGroups.remove(group.getID());
        this.setChanged();
        this.notifyObservers(group);
    }

    public TxGroup addTxGroup(String name) throws SQLException, SBException {
        if (this.getTxGroup(name) != null) {
            throw new SBException("Group:" + name + " already exists");
        }
        TxGroup group = new TxGroup(this, name, null);
        this.txGroups.put(group.getID(), group);
        this.setChanged();
        this.notifyObservers(group);
        return group;
    }

    public Collection<TxGroup> getTxGroups() throws SQLException {
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
            TxGroup.load(this, this.txGroups);
        }
        return this.txGroups.values();
    }

    public boolean hasSynonymSchemes() {
        return this.hasSynonymSchemes;
    }

    public void unloadEnvSchemes() {
        this.envSchemes = null;
    }

    public List<EnvScheme> getEnvSchemes() throws SQLException {
        if (this.envSchemes == null) {
            this.envSchemes = new LinkedList<EnvScheme>();
            EnvScheme.loadAll(this, this.envSchemes);
        }
        return this.envSchemes;
    }

    public void addEnvScheme(EnvScheme scheme) throws SBException, SQLException {
        for (EnvScheme e : this.envSchemes) {
            if (!e.getName().equals(scheme.getName())) continue;
            throw new SBException("New scheme name is not unique");
        }
        scheme.store(this);
        this.envSchemes.add(scheme);
    }

    public void unloadAbnSchemes() {
        this.abnSchemes.clear();
    }

    public List<AbnScheme> getAbnSchemes() throws SQLException {
        AbnScheme.loadAll(this, this.abnSchemes);
        return this.abnSchemes;
    }

    public void addAbnScheme(AbnScheme scheme) throws SQLException, SBException {
        scheme.store(this);
        this.abnSchemes.add(scheme);
        Collections.sort(this.abnSchemes);
    }

    public void deleteEnvScheme(EnvScheme scheme) throws SQLException, SBException {
        scheme.deleteEntries();
        scheme.delete();
        this.envSchemes.remove(scheme);
    }

    public void deleteIGDScheme(IGDScheme scheme) throws SQLException, SBException {
        scheme.delete();
        switch (scheme.getIGDType()) {
            case 3: {
                this.chronoSchemes.remove(scheme.getID());
                break;
            }
            case 4: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.biozoneSchemes.remove(scheme.getID());
                break;
            }
            case 2: {
                this.lstratSchemes.remove(scheme.getID());
                break;
            }
            case 10: {
                this.sequenceSchemes.remove(scheme.getID());
                break;
            }
            default: {
                throw new SBException("Cannot remove scheme, unknown IGD type: " + scheme.getIGDType());
            }
        }
    }

    public void addIGDScheme(IGDScheme scheme) throws SQLException, SBException {
        if (!scheme.store(this)) {
            throw new SBException("Scheme not stored - check name");
        }
        switch (scheme.getIGDType()) {
            case 3: {
                this.chronoSchemes.put(scheme.getID(), scheme);
                break;
            }
            case 4: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.biozoneSchemes.put(scheme.getID(), scheme);
                break;
            }
            case 2: {
                this.lstratSchemes.put(scheme.getID(), scheme);
                break;
            }
            case 10: {
                this.sequenceSchemes.put(scheme.getID(), scheme);
                break;
            }
            default: {
                throw new SBException("Cannot add new scheme, unknown IGD type: " + scheme.getIGDType());
            }
        }
    }

    public void mergeAbnScheme(AbnScheme target, AbnScheme donor) throws SQLException, SBException {
        target.merge(donor);
        this.abnSchemes.remove(donor);
        Iterator<Well> it = this.getProject(0).getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            if (!well.abn.containsValue(donor)) continue;
            well.replaceAbnScheme(target, donor);
        }
    }

    public Collection<SynonymScheme> getSynSchemes() throws SQLException {
        if (this.synSch == null) {
            this.synSch = SynonymScheme.getSchemes(this);
        }
        return this.synSch.values();
    }

    public SynonymScheme getSynSch(int schID) throws SQLException {
        if (this.synSch == null) {
            this.synSch = SynonymScheme.getSchemes(this);
        }
        if (!this.hasSynonymSchemes && schID == 0) {
            schID = 1;
        }
        return this.synSch.get(schID);
    }

    public AbnScheme getDefaultAbnScheme() throws SQLException {
        AbnScheme abnScheme = AbnScheme.getDefault(this, this.abnSchemes);
        return abnScheme;
    }

    public AbnScheme getAbnScheme(Well well, char discID, boolean useDefault) throws SQLException {
        AbnScheme abn = well.abn.get("" + discID);
        if (abn == null && (abn = well.fillAbnScheme(this.abnSchemes, discID, useDefault)) != null) {
            well.abn.put("" + discID, abn);
        }
        return abn;
    }

    public void deleteAbnScheme(AbnScheme scheme) throws SQLException, SBException {
        scheme.delete();
        this.abnSchemes.remove(scheme);
    }

    public EvProject getEvProject(int qsID) throws SQLException {
        EvProject evProject;
        if (this.evProjects == null) {
            this.evProjects = new HashMap();
        }
        if ((evProject = this.evProjects.get(new Integer(qsID))) == null) {
            evProject = new EvProject(this, qsID);
            this.evProjects.put(new Integer(qsID), evProject);
        }
        return evProject;
    }

    public SBEvent getSBEvent(int evID) throws SQLException, SBException {
        if (this.sbEvents == null) {
            this.loadSBEvents();
        }
        return this.sbEvents.get(new Integer(evID));
    }

    public SBEvent getSBEvent(String evName) throws SQLException, SBException {
        if (this.sbEvents == null) {
            this.loadSBEvents();
        }
        for (SBEvent event : this.sbEvents.values()) {
            if (!event.getName().equals(evName)) continue;
            return event;
        }
        return null;
    }

    public void updateSBEvent(SBEvent event, String name) throws SQLException, SBException {
        event.updateName(name);
    }

    private void loadSBEvents() throws SQLException, SBException {
        if (this.sbEvents == null) {
            this.sbEvents = new HashMap();
        }
        LinkedList list = new LinkedList();
        SBEvent.loadAll(this, list);
        for (SBEvent e : list) {
            if (this.sbEvents.get(new Integer(e.getEvID())) != null) continue;
            if (e.getSpecID() > 0) {
                e.setTaxon(this.getTaxon(e.getSpecID()));
            }
            this.sbEvents.put(new Integer(e.getEvID()), e);
        }
    }

    public Collection getSBEvents() throws SQLException, SBException {
        if (this.sbEvents == null) {
            this.loadSBEvents();
        }
        return this.sbEvents.values();
    }

    public EnvScheme getEnvScheme(int schID) throws SQLException {
        if (this.envSchemes == null) {
            EnvScheme.loadAll(this, this.envSchemes);
        }
        for (EnvScheme scheme : this.envSchemes) {
            if (scheme.getID() != schID) continue;
            return scheme;
        }
        return null;
    }

    public Collection<CompositeStandard> getCompositeStandards() throws SQLException, SBException {
        if (this.compositeStandards == null) {
            this.compositeStandards = new HashMap();
            LinkedList stds = new LinkedList();
            CompositeStandard.load(this, stds);
            for (Object o : stds) {
                CompositeStandard std = (CompositeStandard)o;
                this.compositeStandards.put(std.getStdID(), std);
            }
        }
        return this.compositeStandards.values();
    }

    public void unloadIGDSchemes() {
        this.chronoSchemes = null;
        this.lstratSchemes = null;
        this.biozoneSchemes = null;
        this.sequenceSchemes = null;
    }

    public Collection<IGDScheme> getIGDSchemes(int igdType) throws SQLException {
        switch (igdType) {
            case 3: {
                if (this.chronoSchemes == null) {
                    this.loadChronoSchemes();
                }
                return this.chronoSchemes.values();
            }
            case 2: {
                if (this.lstratSchemes == null) {
                    this.loadLstratSchemes();
                }
                return this.lstratSchemes.values();
            }
            case 4: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                if (this.biozoneSchemes == null) {
                    this.loadBiozoneSchemes();
                }
                return this.biozoneSchemes.values();
            }
            case 10: {
                if (this.sequenceSchemes == null) {
                    this.loadSequenceSchemes();
                }
                return this.sequenceSchemes.values();
            }
        }
        return null;
    }

    public IGDScheme getIGDScheme(int schID) {
        IGDScheme scheme = null;
        if (this.chronoSchemes != null && (scheme = this.chronoSchemes.get(schID)) != null) {
            return scheme;
        }
        if (this.lstratSchemes != null && (scheme = this.lstratSchemes.get(schID)) != null) {
            return scheme;
        }
        if (this.biozoneSchemes != null && (scheme = this.biozoneSchemes.get(schID)) != null) {
            return scheme;
        }
        if (this.sequenceSchemes != null && (scheme = this.sequenceSchemes.get(schID)) != null) {
            return scheme;
        }
        return null;
    }

    public IGDScheme getIGDScheme(int schID, int igdType) throws SQLException {
        switch (igdType) {
            case 3: {
                if (this.chronoSchemes == null) {
                    this.loadChronoSchemes();
                }
                return this.chronoSchemes.get(schID);
            }
            case 2: {
                if (this.lstratSchemes == null) {
                    this.loadLstratSchemes();
                }
                return this.lstratSchemes.get(schID);
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                if (this.biozoneSchemes == null) {
                    this.loadBiozoneSchemes();
                }
                return this.biozoneSchemes.get(schID);
            }
            case 10: {
                if (this.sequenceSchemes == null) {
                    this.loadSequenceSchemes();
                }
                return this.sequenceSchemes.get(schID);
            }
        }
        return null;
    }

    private void loadChronoSchemes() throws SQLException {
        this.chronoSchemes = new HashMap();
        List list = IGDScheme.getSchemes(this, 3, false);
        for (Object o : list) {
            IGDScheme scheme = (IGDScheme)o;
            this.chronoSchemes.put(scheme.schID, scheme);
        }
    }

    private void loadLstratSchemes() throws SQLException {
        this.lstratSchemes = new HashMap();
        List list = IGDScheme.getSchemes(this, 2, false);
        for (Object o : list) {
            IGDScheme scheme = (IGDScheme)o;
            this.lstratSchemes.put(scheme.schID, scheme);
        }
    }

    private void loadBiozoneSchemes() throws SQLException {
        this.biozoneSchemes = new HashMap();
        List list = IGDScheme.getSchemes(this, 41, true);
        for (Object o : list) {
            IGDScheme scheme = (IGDScheme)o;
            this.biozoneSchemes.put(scheme.schID, scheme);
        }
    }

    private void loadSequenceSchemes() throws SQLException {
        this.sequenceSchemes = new HashMap();
        List list = IGDScheme.getSchemes(this, 10, false);
        for (Object o : list) {
            IGDScheme scheme = (IGDScheme)o;
            this.sequenceSchemes.put(scheme.schID, scheme);
        }
    }

    public Userdef getUser(String userID) throws SQLException {
        if (this.users == null) {
            this.getUsers();
        }
        return this.users.get(userID);
    }

    public void putUser(Userdef user) throws SQLException {
        if (this.users == null) {
            this.getUsers();
        }
        if (this.users.get(user.getUsrID()) == null) {
            this.users.put(user.getUsrID(), user);
        }
    }

    void removeUser(String userID) {
        this.users.remove(userID);
    }

    public Collection<Userdef> getUsers() throws SQLException {
        if (this.users == null) {
            this.users = this.users = new TreeMap();
            LinkedList list = new LinkedList();
            Userdef.getUsers(this, list);
            for (Object o : list) {
                Userdef u = (Userdef)o;
                this.users.put(u.getUsrID(), u);
            }
        }
        return this.users.values();
    }

    public Lithdesc getLithdesc() throws SQLException {
        if (this.lithdesc == null) {
            this.lithdesc = new Lithdesc(this, false);
        }
        return this.lithdesc;
    }

    public JComboBox getLithologyCombo() throws SQLException {
        JComboBox<String> comboBox = new JComboBox<String>();
        Enumeration<Lithology> en = this.getLithdesc().lithologies.elements();
        while (en.hasMoreElements()) {
            Lithology lith = en.nextElement();
            if (lith.getLithID() < 1000 || lith.getLithID() >= 2000) continue;
            String descr = lith.getDescr();
            boolean inserted = false;
            for (int i = 0; i < comboBox.getItemCount(); ++i) {
                String item = (String)comboBox.getItemAt(i);
                if (item.compareTo(descr) > 0) {
                    comboBox.insertItemAt(descr, i);
                    inserted = true;
                    break;
                }
                if (!item.equals(descr)) continue;
                inserted = true;
                break;
            }
            if (inserted) continue;
            comboBox.addItem(descr);
        }
        comboBox.setMaximumRowCount(25);
        return comboBox;
    }

    public void deleteSpecies(List specIDs, boolean delFss, ProgressBarMonitor prog) throws SQLException, SBException {
        Taxon.deleteSpecies(this, specIDs, delFss, prog);
        Iterator it = specIDs.iterator();
        while (it.hasNext()) {
            Taxon taxon = this.taxa.get((Integer)it.next());
            this.taxa.remove(taxon);
            Iterator<Well> itw = this.getProject(0).getWellIterator();
            while (itw.hasNext()) {
                Well well = itw.next();
                for (Sample sample : well.samples) {
                    for (Smpdtl smpdtl : sample.analyses) {
                        if (!smpdtl.removeSpecies(taxon)) continue;
                        smpdtl.notifyObservers();
                    }
                }
            }
        }
        for (TxGroup group : this.txGroups.values()) {
            it = specIDs.iterator();
            while (it.hasNext()) {
                int specID = (Integer)it.next();
                group.removeSpecies(specID);
            }
            if (!group.hasChanged()) continue;
            group.notifyObservers();
        }
    }

    public int updateOcc(Taxon taxon, String field, char newValue) throws SQLException, SBException {
        int nUpdated = taxon.updateOcc(field, newValue);
        Iterator<Well> itw = this.getProject(0).getWellIterator();
        while (itw.hasNext()) {
            Well well = itw.next();
            for (Sample sample : well.samples) {
                for (Smpdtl smpdtl : sample.analyses) {
                    if (!smpdtl.updateOcc(taxon, field, newValue)) continue;
                    smpdtl.notifyObservers();
                }
            }
        }
        return nUpdated;
    }

    public void loadInterps() throws SQLException {
        InterpHdr.loadAll(this, this.interpHdrs);
    }

    public List<InterpHdr> getInterps() {
        LinkedList<InterpHdr> list = new LinkedList<InterpHdr>();
        Collection<InterpHdr> c = this.interpHdrs.values();
        for (InterpHdr o : c) {
            InterpHdr interp = o;
            if (interp.getInterpID() <= 0) continue;
            list.add(interp);
        }
        Collections.sort(list);
        list.add(0, this.interpHdrs.get(new Integer(0)));
        return list;
    }

    public InterpHdr getInterp(int interpID) {
        return this.interpHdrs.get(new Integer(interpID));
    }

    void removeInterp(InterpHdr interp) throws SQLException, SBException {
        Project project = this.getProject(0);
        Iterator<Well> it = project.getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            try {
                WellInterp wellInterp = well.getInterp(interp.getInterpID());
                well.removeInterp(wellInterp);
                well.notifyObservers(interp);
            }
            catch (SBException ex) {}
        }
        this.interpHdrs.remove(interp.getInterpID());
    }

    public void load() throws SQLException, SBException {
        Calendar time = Calendar.getInstance();
        this.taxa.loadAll();
        System.out.println("Number of taxa loaded: " + this.taxa.getSize());
        this.lithdesc = new Lithdesc(this, false);
        System.out.println("User: " + this.user.getUsrID());
        AbnScheme.loadAll(this, this.abnSchemes);
        this.getEnvScheme(0);
        String sql = "SELECT well_id FROM " + this.DBTableName("version") + " ORDER BY well_id";
        Statement stmt = this.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            Well well = new Well(this, wellID);
            if (well.wellCode() == null || well.wellCode().length() == 0) {
                System.out.println("Well not found for well_id: " + well.wellID);
                continue;
            }
            this.getProject(0).addWell(well);
        }
        System.out.println("Loaded " + this.getProject(0).getSize() + " wells");
        HashMap<Integer, Sample> samples = Sample.loadAll(this, this.getProject(0));
        System.out.println("Loaded " + samples.size() + " samples");
        System.out.println("Loaded: " + Smpdtl.loadAll(this, samples) + " analyses.");
        System.out.println("Loaded: " + Fssabnd.loadAll(this, samples, this.taxa) + " occurrences.");
        InterpHdr.loadAll(this, this.interpHdrs);
        HashMap<Integer, Well> wellLookup = new HashMap<Integer, Well>();
        Iterator<Well> it = this.getProject(0).getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            wellLookup.put(well.wellID, well);
        }
        System.out.println("Loaded: " + IGDIntervalZone.loadAll(this, wellLookup, this.interpHdrs) + " IGD intervals.");
        System.out.println("Loaded: " + Biocom.loadAll(this, wellLookup, this.interpHdrs) + " Biostrat Comments.");
        it = this.getProject(0).getWellIterator();
        int totalWells = this.getProject(0).getSize();
        int n = 0;
        while (it.hasNext()) {
            Well well = it.next();
            System.out.println("Loading data for well (" + ++n + "/" + totalWells + ") :" + well);
            System.out.flush();
            block8: for (int dType = 1; dType < 28; ++dType) {
                well.getDataRange(dType, 'M');
                switch (dType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 22: {
                        continue block8;
                    }
                    default: {
                        try {
                            well.loadData(dType, this.lithdesc, this.envSchemes, this.interpHdrs);
                            continue block8;
                        }
                        catch (SBException sbe) {
                            System.out.println("Exception while loading data type: " + dType + " : " + sbe.getMessage());
                        }
                    }
                }
            }
            Runtime.getRuntime().gc();
        }
        System.out.println("Elapsed: " + (Calendar.getInstance().getTimeInMillis() - time.getTimeInMillis()) / 1000L + " secs.");
    }

    public void loadScales(DefaultComboBoxModel model) throws SQLException {
        if (this.chartScales == null) {
            this.chartScales = new ArrayList();
            String sql = "SELECT scale FROM " + this.DBTableName("SBSCALES") + " ORDER BY scale";
            Statement stmt = this.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            while (rs.next()) {
                int iScale = rs.getInt("scale");
                this.chartScales.add(iScale);
            }
            stmt.close();
        }
        model.removeAllElements();
        for (Object iScale : this.chartScales) {
            model.addElement(iScale.toString());
        }
    }

    public List getChartScales() throws SQLException {
        if (this.chartScales == null) {
            this.chartScales = new ArrayList();
            String sql = "SELECT scale FROM " + this.DBTableName("SBSCALES") + " ORDER BY scale";
            Statement stmt = this.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            while (rs.next()) {
                int iScale = rs.getInt("scale");
                this.chartScales.add(Integer.toString(iScale));
            }
            stmt.close();
        }
        return this.chartScales;
    }

    public List getCasingDiameters() throws SQLException {
        if (this.casingDiameters == null) {
            this.casingDiameters = new ArrayList<String>();
            if (this.hasCasdiam) {
                String sql = "SELECT diam FROM " + this.DBTableName("casdiam") + " ORDER BY sort_order";
                Statement stmt = this.getDatabase().createStatement();
                ResultSet rs = stmt.executeQuery(this.modQuery(sql));
                while (rs.next()) {
                    String diam = rs.getString("diam");
                    this.casingDiameters.add(diam);
                }
                stmt.close();
            } else {
                String[] diams;
                for (String d : diams = new String[]{"42", "36", "32 3/4", "32", "30", "26", "24", "20", "18 3/4", "18 5/8", "18 1/2", "18", "16", "13 3/8", "10 3/4", "10 3/8", "9 5/8", "8 1/2", "7 5/8", "7", "6", "5 1/2", "5", "4 1/2"}) {
                    this.casingDiameters.add(d);
                }
            }
        }
        return this.casingDiameters;
    }

    public void createCasdiam() throws SQLException {
        if (!this.hasCasdiam) {
            Statement stmt = this.getDatabase().createStatement();
            String sql = "CREATE TABLE " + this.DBTableName("casdiam") + " (sort_order number, diam ";
            sql = this.dbType == DBType.ORACLE ? sql + "varchar2" : sql + "text";
            sql = sql + "(10))";
            stmt.executeUpdate(this.modQuery(sql));
            if (this.dbType == DBType.ORACLE) {
                sql = "GRANT SELECT,INSERT,UPDATE,DELETE TO PUBLIC ON " + this.DBTableName("casdiam");
                stmt.executeUpdate(this.modQuery(sql));
            }
            stmt.close();
            this.hasCasdiam = true;
        }
    }

    public void storeCasingDiameters(List<String> diameters) throws SQLException, SBException {
        if (diameters != null && this.hasCasdiam) {
            Statement stmt = this.getDatabase().createStatement();
            String sql = "DELETE FROM " + this.DBTableName("casdiam");
            stmt.executeUpdate(this.modQuery(sql));
            int n = 1;
            for (String d : diameters) {
                if (d == null || d.length() == 0) {
                    throw new SBException("Casing diameter blank");
                }
                sql = "INSERT INTO " + this.DBTableName("casdiam") + " (sort_order, diam) VALUES (" + n + "," + d + ")";
                stmt.executeUpdate(this.modQuery(sql));
                ++n;
            }
            stmt.close();
        }
        this.casingDiameters = diameters;
    }

    public boolean getHasCasdiam() {
        return this.hasCasdiam;
    }

    public String getSchema() {
        String schema = null;
        if (this.tablePrefix != null && this.tablePrefix.length() > 0) {
            schema = this.tablePrefix.indexOf(46) > 0 ? this.tablePrefix.substring(0, this.tablePrefix.indexOf(46)) : this.tablePrefix;
            schema = schema.toUpperCase();
        }
        return schema;
    }

    public Well getCurrentWell() throws SQLException, SBException {
        if (this.currentWell != null) {
            return this.currentWell;
        }
        int wellID = Lastval.getInt(this, "WELL_ID");
        if (wellID > 0) {
            this.currentWell = this.getAddWell(wellID);
            return this.currentWell;
        }
        return null;
    }

    public ProjectList getProjects() throws SQLException, SBException {
        if (this.projects == null) {
            this.projects = new ProjectList(this);
        }
        return this.projects;
    }

    public Project getProject(int ID) throws SQLException, SBException {
        this.getProjects();
        return this.projects.getProject(ID);
    }

    public void deleteWell(Well well) throws SQLException, SBException {
        Well.deleteWell(this, well.getWellCode());
        this.projects.removeWell(well);
    }

    public Well getAddWell(int wellID) throws SQLException, SBException {
        Project project = this.getProject(0);
        return project.getWell(this, wellID);
    }

    public void insertWell(Well well) throws SQLException, SBException {
        Project project = this.getProject(0);
        project.addWell(well);
    }

    public int nextControl(String name) throws SBException, SQLException {
        String sql;
        int oldval = -1;
        int tries = 0;
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(this.modQuery(sql = "SELECT conval FROM " + this.DBTableName("control") + " WHERE name='" + name + "'"));
        if (rs.next()) {
            oldval = rs.getInt("conval");
        }
        rs.close();
        if (oldval < 0) {
            sql = "INSERT INTO " + this.DBTableName("control") + " (name, conval) VALUES ('" + name + "',1" + ")";
            stmt.executeUpdate(this.modQuery(sql));
            return 1;
        }
        int newval = oldval;
        block2: while (true) {
            try {
                while (true) {
                    sql = "UPDATE " + this.DBTableName("control") + " SET conval=" + ++newval + " WHERE name='" + name + "'";
                    if (oldval > 0) {
                        sql = sql + " AND conval=" + oldval;
                    }
                    if (stmt.executeUpdate(this.modQuery(sql)) == 1) break block2;
                    ++tries;
                }
            }
            catch (SQLException dsex) {
                if (tries++ <= 10) continue;
                throw new SBException("Cannot update control table after 10 attempts");
            }
            break;
        }
        stmt.close();
        return newval;
    }

    void queryMetaData() throws SQLException {
        String tableName;
        assert (this.meta != null) : "Metadata not set";
        this.connection.setAutoCommit(false);
        String schema = this.getSchema();
        this.hasSynonymSchemes = false;
        ResultSet rs = this.meta.getColumns(null, schema, "%", "%");
        while (rs.next()) {
            tableName = rs.getString("TABLE_NAME");
            String columnName = rs.getString("COLUMN_NAME");
            if (tableName.equalsIgnoreCase("SIPMDICT") && columnName.equalsIgnoreCase("CCODE")) {
                this.hasSIPMdict = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("SPECIES") && columnName.equalsIgnoreCase("ALPHACODE")) {
                this.hasAlphaCode = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("WELLS") && columnName.equalsIgnoreCase("COUNTY")) {
                this.hasCounty = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("WELLS") && columnName.equalsIgnoreCase("OCS")) {
                this.hasOcs = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("SBSSR") && columnName.equalsIgnoreCase("INTERP_ID")) {
                this.hasSrInterp = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("WELLS") && columnName.equalsIgnoreCase("KICKO")) {
                this.hasKicko = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("VERSION") && columnName.equalsIgnoreCase("OW_WELL_ID")) {
                this.isOW = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("SAMPLES") && columnName.equalsIgnoreCase("WELL_ID")) {
                this.hasSamplesWellID = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("IGD") && columnName.equalsIgnoreCase("SEP")) {
                this.hasIGDSep = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("IGD_HDR")) {
                this.hasIGDHdr = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("USERDEF") && columnName.equalsIgnoreCase("COLOUR")) {
                this.hasUserColour = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("WELLPERM")) {
                this.hasWellPerm = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("USERPERM")) {
                this.hasUserPerm = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("WELLTWT")) {
                this.hasTWT = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("CASDIAM")) {
                this.hasCasdiam = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("SBIMAGE")) {
                this.hasSBimage = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("SYNSCH")) {
                this.hasSynonymSchemes = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("ANALY_HDR")) {
                this.hasAnalystHeader = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("WELLTVD")) {
                this.hasTVD = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("ENVTRN")) {
                this.hasEnvTrn = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("EVENTDIC") && columnName.equalsIgnoreCase("EV_DESC")) {
                this.hasEventExtensions = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("SMPDTL") && columnName.equalsIgnoreCase("PROXIMAL")) {
                this.hasSampleEnv = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("BCMMNTS") && columnName.equalsIgnoreCase("SOURCE")) {
                this.hasBiocomSource = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("LITHDESC") && columnName.equalsIgnoreCase("GRAIN_SIZE")) {
                this.hasLithGS = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("TXLOAD") && columnName.equalsIgnoreCase("OCC_TYPE")) {
                this.hasTxLoadOccType = true;
                continue;
            }
            if (this.dbType != DBType.ORACLE && tableName.equalsIgnoreCase("USERDEF") && columnName.equalsIgnoreCase("PASSWORD")) {
                this.hasUserPassword = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("SBLTHTRN") && columnName.equalsIgnoreCase("SCH_ID")) {
                this.hasLthTrnSch = true;
                continue;
            }
            if (!tableName.equalsIgnoreCase("LITHDESC") || !columnName.equalsIgnoreCase("GRAIN_SIZE")) continue;
            this.hasLithGS = true;
        }
        rs.close();
        rs = this.meta.getTables(null, schema, "%", null);
        while (rs.next()) {
            tableName = rs.getString("TABLE_NAME");
            String tableType = rs.getString("TABLE_TYPE");
            if (tableName.equalsIgnoreCase("SBWLMB")) {
                if (!tableType.equalsIgnoreCase("VIEW")) continue;
                this.sbwlIsView = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("WELLS")) {
                if (!tableType.equalsIgnoreCase("VIEW")) continue;
                this.isOW = true;
                continue;
            }
            if (!tableName.equalsIgnoreCase("WELLS_MASTER")) continue;
            if (tableType.equalsIgnoreCase("VIEW")) {
                if (this.isOW) {
                    System.out.println("WARNING: WELLS table is view but so is WELLS_MASTER - wells table not updated from master");
                    this.hasWellsMaster = false;
                } else {
                    this.hasWellsMaster = true;
                }
            }
            Well.loadWellMasterFields(this, this.wellMasterFields);
        }
        rs.close();
        if (this.dbType == DBType.ORACLE) {
            rs = this.meta.getTables(null, "EPISAMGR", "CORES", null);
            if (rs.next()) {
                this.hasSAMBA = true;
            }
            rs.close();
        }
    }

    public static String getJregOption(String str) throws UnsatisfiedLinkError {
        String value = SBdb.getURegOption(str);
        if (value == null || value.length() == 0 || value.startsWith("Error")) {
            String setting = SBdb.getRegOption(str);
            return setting;
        }
        return value;
    }

    public static String getJreg(String str) throws UnsatisfiedLinkError {
        String value = SBdb.getUReg(str);
        if (value == null || value.length() == 0 || value.startsWith("Error")) {
            String setting = SBdb.getReg(str);
            return setting;
        }
        return value;
    }

    public boolean isConnected() throws SQLException {
        if (this.connection == null) {
            return false;
        }
        try {
            Statement stmt = this.connection.createStatement();
            stmt.close();
            return true;
        }
        catch (SQLException sqle) {
            return false;
        }
    }

    public boolean Connect(String DSN, String tablePrefix, String loginName, String password, boolean emptyConnection) throws SQLException, SBException, Exception {
        Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        if (DSN.toLowerCase().endsWith(".mdb")) {
            DSN = "Driver={Microsoft Access Driver (*.mdb)};DBQ=" + DSN;
        } else if (DSN.toLowerCase().endsWith(".accdb")) {
            DSN = "Driver={Microsoft Access Driver (*.mdb, *.accdb)};DBQ=" + DSN;
        }
        System.out.println("Connecting with: " + DSN + "," + loginName + "," + password);
        this.connection = DriverManager.getConnection("jdbc:odbc:" + DSN, loginName, password != null ? password.toUpperCase() : null);
        if (this.connection == null) {
            System.out.println("Connecting with: " + DSN + "," + loginName + "," + password);
            this.connection = DriverManager.getConnection("jdbc:odbc:" + DSN, loginName, password);
            throw new SBException("Cannot connect to data source '" + DSN + "'");
        }
        if (password != null) {
            password = password.toUpperCase();
        }
        this.meta = this.connection.getMetaData();
        this.setDBType();
        if (tablePrefix != null) {
            this.tablePrefix = tablePrefix;
        } else if (this.getDBType() != DBType.ACCESS) {
            this.tablePrefix = this.meta.getUserName() + ".";
            System.out.println("Table prefix from username is: " + this.tablePrefix);
        } else {
            System.out.println("Access database - no table prefix set.");
        }
        this.emptyConnection = emptyConnection;
        if (!emptyConnection) {
            this.queryMetaData();
            this.licence = new Licence(this);
            if (loginName != null) {
                this.fillUserDetails(loginName, password);
            }
        }
        return true;
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void createTables(File schemaFile) throws SQLException, IOException, SBException {
        BufferedReader tableDef = new BufferedReader(new FileReader(schemaFile));
        String line = tableDef.readLine();
        boolean requiredTable = true;
        String tableName = null;
        LinkedList<Column> columns = new LinkedList<Column>();
        Statement stmt = this.connection.createStatement();
        while (line != null) {
            if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                if (line.indexOf(35) > 0) {
                    line = line.substring(0, line.indexOf(35)).trim();
                }
                if (line.equalsIgnoreCase("[OPTIONAL]")) {
                    if (!this.saveTable(requiredTable, stmt, tableName, columns)) {
                        tableName = null;
                        break;
                    }
                    tableName = null;
                    requiredTable = false;
                } else if (line.equalsIgnoreCase("[REQUIRED]")) {
                    if (!this.saveTable(requiredTable, stmt, tableName, columns)) {
                        tableName = null;
                        break;
                    }
                    tableName = null;
                    requiredTable = true;
                } else if (line.startsWith("Column") || line.startsWith("Optional")) {
                    StringTokenizer tok = new StringTokenizer(line);
                    Column column = new Column();
                    if (tok.nextToken().equals("Optional")) {
                        tok.nextToken();
                    }
                    column.name = tok.nextToken();
                    if (column.name.equalsIgnoreCase("references")) {
                        column.name = "reference";
                    }
                    column.type = tok.nextToken();
                    if (tok.hasMoreTokens()) {
                        column.size = Integer.parseInt(tok.nextToken().trim());
                    }
                    while (tok.hasMoreTokens()) {
                        String constraint = tok.nextToken();
                        if (constraint.equalsIgnoreCase("NOTNULL")) {
                            column.notNull = true;
                            continue;
                        }
                        if (constraint.equalsIgnoreCase("PRIMARYKEY")) {
                            column.primaryKey = true;
                            continue;
                        }
                        throw new SBException("Unrecognised constraint in line: " + line);
                    }
                    columns.add(column);
                } else {
                    if (tableName != null && columns.size() > 0) {
                        if (!this.saveTable(requiredTable, stmt, tableName, columns)) {
                            tableName = null;
                            break;
                        }
                        tableName = null;
                    }
                    tableName = line;
                }
            }
            line = tableDef.readLine();
        }
        if (!this.saveTable(requiredTable, stmt, tableName, columns)) {
            return;
        }
        stmt.close();
        this.connection.commit();
        tableDef.close();
    }

    boolean saveTable(boolean requiredTable, Statement stmt, String tableName, List columns) throws SQLException {
        if (tableName == null) {
            return true;
        }
        if (requiredTable || tableName.equalsIgnoreCase("ANALY_HDR") || tableName.equalsIgnoreCase("CASDIAM") || tableName.equalsIgnoreCase("ENVTRN") || tableName.equalsIgnoreCase("IGD_HDR") || tableName.equalsIgnoreCase("SBLTHTRN") || tableName.equalsIgnoreCase("LTHTRNSCH") || tableName.equalsIgnoreCase("SYNSCH")) {
            this.createTable(stmt, tableName, columns, false);
            System.out.println("Created table: " + tableName);
            columns.clear();
        } else {
            columns.clear();
        }
        return true;
    }

    public void copyTables(SBdb newDB) throws SQLException {
        ResultSet tables = this.meta.getTables(null, this.getSchema(), "%", new String[]{"TABLE"});
        while (tables.next()) {
            String tableName = tables.getString("table_name");
            try {
                int opt = JOptionPane.showConfirmDialog(null, "Copy table: " + tableName + "?", "New Schema", 1);
                if (opt == 2) {
                    return;
                }
                if (opt != 0) continue;
                this.copyTable(newDB, tableName, null, true);
            }
            catch (SQLException se) {
                String message = se.getMessage();
                newDB.getDatabase().rollback();
                int opt = JOptionPane.showConfirmDialog(null, "Error copying data: " + message + "\nClick yes to continue after correcting error, no to cancel.", "New Schema", 0);
                if (opt != 0) continue;
                this.copyTable(newDB, tableName, null, true);
            }
        }
    }

    public void copyTable(SBdb newDB, String tableName, String whereClause, boolean clearValues) throws SQLException {
        int i;
        ResultSet rs;
        Statement newStmt = newDB.connection.createStatement();
        if (clearValues) {
            System.out.println("Deleting from table: " + newDB.DBTableName(tableName));
            newStmt.executeUpdate("DELETE FROM " + newDB.DBTableName(tableName));
        }
        String selectQuery = "SELECT * FROM " + newDB.DBTableName(tableName);
        ResultSet rsNew = newStmt.executeQuery(selectQuery);
        ResultSetMetaData copyMeta = rsNew.getMetaData();
        int nCols = copyMeta.getColumnCount();
        selectQuery = "SELECT ";
        for (int i2 = 1; i2 <= nCols; ++i2) {
            selectQuery = selectQuery + copyMeta.getColumnName(i2);
            if (i2 >= nCols) continue;
            selectQuery = selectQuery + ",";
        }
        selectQuery = selectQuery + " FROM " + this.DBTableName(tableName);
        Statement stmt = this.getDatabase().createStatement();
        if (whereClause != null) {
            selectQuery = selectQuery + whereClause;
        }
        try {
            System.out.println("Executing query in copyTable: " + selectQuery);
            rs = stmt.executeQuery(selectQuery);
        }
        catch (SQLException se) {
            selectQuery = "SELECT * FROM " + this.DBTableName(tableName);
            if (whereClause != null) {
                selectQuery = selectQuery + whereClause;
            }
            System.out.println("Re-trying: Select query: " + selectQuery);
            rs = stmt.executeQuery(selectQuery);
            copyMeta = rs.getMetaData();
            nCols = copyMeta.getColumnCount();
        }
        String sql = "INSERT INTO " + newDB.DBTableName(tableName) + " (";
        for (i = 1; i <= nCols; ++i) {
            sql = sql + copyMeta.getColumnName(i);
            if (i >= nCols) continue;
            sql = sql + ",";
        }
        sql = sql + " ) VALUES (";
        for (i = 1; i <= nCols; ++i) {
            sql = sql + "?";
            if (i >= nCols) continue;
            sql = sql + ",";
        }
        sql = sql + ")";
        PreparedStatement pStmt = newDB.getDatabase().prepareStatement(sql);
        while (rs.next()) {
            String paramString = "";
            pStmt.clearParameters();
            for (int col = 1; col <= nCols; ++col) {
                Object obj = rs.getObject(col);
                if (obj != null) {
                    pStmt.setObject(col, obj);
                } else if (copyMeta.getColumnName(col).equalsIgnoreCase("INTERP_ID")) {
                    pStmt.setInt(col, 0);
                } else {
                    int type = copyMeta.getColumnType(col);
                    if (type == 3) {
                        type = 8;
                    }
                    pStmt.setNull(col, type);
                }
                paramString = paramString + obj + ",";
            }
            try {
                pStmt.executeUpdate();
            }
            catch (SQLException se) {
                if ((newDB.dbType == DBType.ACCESS || newDB.dbType == DBType.ACCESS_MULTI) && se.getMessage().equalsIgnoreCase("GENERAL ERROR")) {
                    System.out.println("Duplicate/General record error when inserting into " + tableName + ": " + paramString);
                    continue;
                }
                if (newDB.dbType == DBType.ORACLE && se.getMessage().indexOf("ORA-00001") >= 0) {
                    System.out.println("Unique constraint error when inserting into " + tableName + ": " + paramString);
                    continue;
                }
                System.out.println("SQL :" + sql);
                throw se;
            }
        }
        newStmt.close();
        pStmt.close();
        stmt.close();
        newDB.commit();
    }

    public void setGrants(String grantee) throws SQLException, SBException {
        if (this.dbType != DBType.ORACLE) {
            throw new SBException("Not an Oracle database");
        }
        ResultSet tables = this.meta.getTables(null, this.getSchema(), "%", new String[]{"TABLE"});
        Statement stmt = this.connection.createStatement();
        while (tables.next()) {
            String tableName = tables.getString("table_name");
            String sql = "GRANT ALL ON " + this.DBTableName(tableName) + " TO " + grantee;
            stmt.execute(sql);
        }
        stmt.close();
        this.connection.commit();
    }

    void createTable(Statement stmt, String name, List columns, boolean drop) throws SQLException {
        String sql;
        if (name.equalsIgnoreCase("image")) {
            return;
        }
        if (drop) {
            try {
                sql = "DROP table " + name;
                stmt.executeUpdate(sql);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        sql = "CREATE TABLE " + this.DBTableName(name) + " ( ";
        Iterator it = columns.iterator();
        String pk = " CONSTRAINT " + name + "_pk PRIMARY KEY (";
        boolean hasPk = false;
        while (it.hasNext()) {
            Column column = (Column)it.next();
            sql = sql + column.name + " ";
            sql = sql + column.getType(this.dbType);
            if (column.type.equalsIgnoreCase("text")) {
                sql = sql + "(" + column.size + ")";
            }
            if (column.notNull) {
                sql = sql + " NOT NULL";
            }
            if (column.primaryKey) {
                if (hasPk) {
                    pk = pk + ",";
                }
                pk = pk + column.name;
                hasPk = true;
            }
            if (!it.hasNext()) continue;
            sql = sql + ",";
        }
        if (hasPk) {
            sql = sql + "," + pk + ")";
        }
        sql = sql + ")";
        stmt.executeUpdate(sql);
    }

    private void setDBType() throws Exception {
        String dbTypeName = this.meta.getDatabaseProductName();
        if (dbTypeName.equalsIgnoreCase("ACCESS")) {
            this.dbType = DBType.ACCESS;
        } else if (dbTypeName.equalsIgnoreCase("ORACLE")) {
            this.dbType = DBType.ORACLE;
            Statement stmt = this.connection.createStatement();
            stmt.executeUpdate("ALTER SESSION SET NLS_DATE_FORMAT='yyyy-mm-dd'");
            stmt.close();
        } else {
            throw new Exception("Cannot recognise database type of ODBC connection: " + dbTypeName);
        }
    }

    public String DBTableName(String tableName) {
        if (this.tablePrefix != null) {
            return this.tablePrefix + tableName;
        }
        return tableName;
    }

    public String modQuery(String query) {
        if (this.dbType == DBType.ORACLE) {
            int i;
            while ((i = query.indexOf(" ucase")) >= 0) {
                query = query.substring(0, i) + " upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf(" lcase")) >= 0) {
                query = query.substring(0, i) + " lower" + query.substring(i + 6);
            }
            while ((i = query.indexOf("=ucase")) >= 0) {
                query = query.substring(0, i) + "=upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf(",ucase")) >= 0) {
                query = query.substring(0, i) + ",upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf("=lcase")) >= 0) {
                query = query.substring(0, i) + "=lower" + query.substring(i + 6);
            }
            while ((i = query.indexOf(",lcase")) >= 0) {
                query = query.substring(0, i) + ",lower" + query.substring(i + 6);
            }
            while ((i = query.indexOf(" UCASE")) >= 0) {
                query = query.substring(0, i) + " upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf(" LCASE")) >= 0) {
                query = query.substring(0, i) + " lower" + query.substring(i + 6);
            }
            while ((i = query.indexOf(",UCASE")) >= 0) {
                query = query.substring(0, i) + ",upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf(",LCASE")) >= 0) {
                query = query.substring(0, i) + ",lower" + query.substring(i + 6);
            }
            while ((i = query.indexOf("=UCASE")) >= 0) {
                query = query.substring(0, i) + "=upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf("=LCASE")) >= 0) {
                query = query.substring(0, i) + "=lower" + query.substring(i + 6);
            }
            while ((i = query.indexOf(" Ucase")) >= 0) {
                query = query.substring(0, i) + " upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf(" Lcase")) >= 0) {
                query = query.substring(0, i) + " lower" + query.substring(i + 6);
            }
            while ((i = query.indexOf("=Ucase")) >= 0) {
                query = query.substring(0, i) + "=upper" + query.substring(i + 6);
            }
            while ((i = query.indexOf("=Lcase")) >= 0) {
                query = query.substring(0, i) + "=lower" + query.substring(i + 6);
            }
        } else {
            int i;
            while ((i = query.indexOf("floor(")) >= 0) {
                query = query.substring(0, i) + "int(" + query.substring(i + 6);
            }
        }
        SB.sql = query;
        if (SB.showSql) {
            if (SB.sqlLogFile != null) {
                SB.sqlLogFile.println(SB.sql);
            } else {
                System.out.println(SB.sql);
            }
        }
        return query;
    }

    void fillUserDetails(String sysName, String password) throws SQLException, SBException {
        ResultSet rs;
        Statement stmt;
        block11: {
            stmt = this.connection.createStatement();
            String sql = "SELECT name, usrid, disc, user_priv";
            if (this.hasUserColour) {
                sql = sql + ",colour";
            }
            if (this.dbType != DBType.ORACLE) {
                sql = sql + ",password";
            }
            sql = sql + " FROM " + this.DBTableName("USERDEF") + " WHERE sys_name='" + sysName + "'";
            sql = this.modQuery(sql);
            rs = stmt.executeQuery(sql);
            try {
                String userPassword = "";
                Color colour = Color.BLACK;
                if (rs.next()) {
                    String strg;
                    String name = rs.getString("name");
                    String usrid = rs.getString("usrid");
                    char discID = rs.getString("disc").charAt(0);
                    int priv = rs.getInt("user_priv");
                    if (this.hasUserColour && (strg = rs.getString("colour")) != null && strg.length() > 0) {
                        StringTokenizer tok = new StringTokenizer(strg, ",");
                        try {
                            colour = new Color(Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()));
                        }
                        catch (Exception n) {
                            colour = Color.BLACK;
                        }
                    }
                    if (this.dbType != DBType.ORACLE) {
                        userPassword = rs.getString("password");
                        userPassword = SB.crypt(false, "SBPW", userPassword);
                    }
                    if (this.dbType != DBType.ORACLE && !userPassword.equals(password)) {
                        stmt.close();
                        throw new SBException("Password incorrect");
                    }
                    this.user = this.getUser(usrid);
                    if (this.user == null) {
                        this.user = new Userdef(usrid, name, sysName, discID, colour, userPassword, priv, this);
                    }
                    break block11;
                }
                stmt.close();
                throw new SBException("Login name not recognised");
            }
            catch (NumberFormatException ne) {
                stmt.close();
                throw new SBException("Problem getting password from database");
            }
        }
        rs.close();
        stmt.close();
    }

    public static int did2dtype(char discID) {
        switch (discID) {
            default: {
                return 0;
            }
            case 'M': {
                return 3;
            }
            case 'N': {
                return 5;
            }
            case 'P': {
                return 7;
            }
            case 'A': 
        }
        return 1;
    }

    public static int did2comType(char discID) {
        switch (discID) {
            default: {
                return 0;
            }
            case 'M': {
                return 4;
            }
            case 'N': {
                return 6;
            }
            case 'P': {
                return 8;
            }
            case 'A': 
        }
        return 2;
    }

    public static String getDiscNoun(char discID) {
        switch (discID) {
            default: {
                return discNounString[0];
            }
            case 'N': {
                return discNounString[1];
            }
            case 'P': {
                return discNounString[2];
            }
            case 'A': 
        }
        return discNounString[3];
    }

    public static char getDiscIDFromNoun(String discAdj) {
        if (discAdj.equalsIgnoreCase(discNounString[0])) {
            return 'M';
        }
        if (discAdj.equalsIgnoreCase(discNounString[1])) {
            return 'N';
        }
        if (discAdj.equalsIgnoreCase(discNounString[2])) {
            return 'P';
        }
        if (discAdj.equalsIgnoreCase(discNounString[3])) {
            return 'A';
        }
        return '\u0000';
    }

    public static int did2i(char discID) {
        switch (discID) {
            default: {
                return 0;
            }
            case 'N': {
                return 1;
            }
            case 'P': {
                return 2;
            }
            case 'A': 
        }
        return 3;
    }

    public static char dt2discID(int dataType) {
        switch (dataType) {
            case 3: 
            case 4: {
                return 'M';
            }
            case 5: 
            case 6: {
                return 'N';
            }
            case 7: 
            case 8: {
                return 'P';
            }
            case 1: 
            case 2: {
                return 'A';
            }
        }
        return ' ';
    }

    public static String getDiscAbr(char discID) {
        switch (discID) {
            default: {
                return "Micro.";
            }
            case 'N': {
                return "Nanno.";
            }
            case 'P': {
                return "Palyno.";
            }
            case 'A': 
        }
        return "Macro.";
    }

    public static String getDiscAdj(char discID) {
        switch (discID) {
            default: {
                return "Microfaunal";
            }
            case 'N': {
                return "Nannofloral";
            }
            case 'P': {
                return "Palynofloral";
            }
            case 'A': 
        }
        return "Macrofaunal";
    }

    public static char getDiscIDFromAdj(String discAdj) {
        if (discAdj.equalsIgnoreCase("Microfaunal")) {
            return 'M';
        }
        if (discAdj.equalsIgnoreCase("Nannofloral")) {
            return 'N';
        }
        if (discAdj.equalsIgnoreCase("Palynofloral")) {
            return 'P';
        }
        if (discAdj.equalsIgnoreCase("Macrofaunal")) {
            return 'A';
        }
        return '\u0000';
    }

    public void putTableColumnWidths(String name, JTable table) throws SQLException {
        String widths = "";
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int columnWidth = table.getColumnModel().getColumn(i).getWidth();
            widths = widths + columnWidth + " ";
        }
        Lastval.putString(this, name, widths);
    }

    public void setTableColumnWidths(String name, JTable table) throws SQLException {
        String widths = Lastval.getString(this, name);
        if (widths != null && widths.length() > 0) {
            StringTokenizer tok = new StringTokenizer(widths);
            if (tok.countTokens() != table.getColumnCount()) {
                return;
            }
            int i = 0;
            while (tok.hasMoreTokens()) {
                int columnWidth = Integer.parseInt(tok.nextToken());
                table.getColumnModel().getColumn(i++).setPreferredWidth(columnWidth);
            }
        }
    }

    public void commit() throws SQLException {
        this.getDatabase().commit();
    }

    public void doRollback() {
        try {
            this.getDatabase().rollback();
        }
        catch (SQLException sqle) {
            System.out.println("Error rolling back: " + sqle.getMessage());
            sqle.printStackTrace();
        }
    }

    public Taxon getPreferredTerm(int schID, int specID) throws SQLException, SBException {
        SynonymScheme scheme = this.getSynSch(schID);
        if (scheme == null) {
            throw new SBException("Synonym scheme ID: " + schID + " unknown in SBdb.getPreferredTerm");
        }
        int prefID = scheme.getPref(specID);
        if (prefID > 0) {
            return this.getTaxon(prefID);
        }
        return null;
    }

    public void updateSynonymy(int schID, Taxon taxon, Taxon pref, List<Taxon> synonymList) throws SQLException, SBException {
        SynonymScheme scheme = this.getSynSch(schID);
        if (synonymList == null) {
            scheme.remove(taxon.getSpecID());
        } else {
            if (pref == null) {
                throw new SBException("No prefrred term");
            }
            ArrayList<Integer> list = new ArrayList<Integer>(synonymList.size());
            for (Taxon t : synonymList) {
                if (t == pref) {
                    throw new SBException("Synonym is same as preferred term");
                }
                list.add(new Integer(t.getSpecID()));
            }
            Taxon prefPref = this.getPreferredTerm(schID, pref.getSpecID());
            if (prefPref != null) {
                if (!list.contains(prefPref.getSpecID())) {
                    throw new SBException("Preferred term: " + pref + " is a junior synonym of: " + prefPref);
                }
                scheme.deleteSyn(prefPref.getSpecID());
            }
            if (taxon != pref && !list.contains(taxon.getSpecID())) {
                list.add(taxon.getSpecID());
            }
            scheme.updateSyn(pref.getSpecID(), list);
        }
    }

    public List<Taxon> getSynonymy(int schID, int specID) throws SQLException, SBException {
        SynonymScheme scheme = this.getSynSch(schID);
        if (scheme == null) {
            throw new SBException("Synonym scheme ID: " + schID + " unknown in SBdb.getSynonymy");
        }
        LinkedList<Taxon> tSyn = new LinkedList<Taxon>();
        List syn = scheme.getSyn(specID);
        for (Integer synID : syn) {
            tSyn.add(this.getTaxon(synID));
        }
        return tSyn;
    }

    public void deleteSynonymScheme(SynonymScheme scheme) throws SQLException, SBException {
        scheme.delete();
        this.synSch.remove(scheme.getSchID());
    }

    public SynonymScheme addSynonymScheme(String name) throws SQLException, SBException {
        Collection<SynonymScheme> c = this.getSynSchemes();
        for (SynonymScheme s : c) {
            if (!s.getName().equalsIgnoreCase(name)) continue;
            throw new SBException("New Scheme already exists");
        }
        SynonymScheme scheme = new SynonymScheme(this, name);
        this.synSch.put(scheme.getSchID(), scheme);
        return scheme;
    }

    public void mergeOcc(CoOccurrence coOcc) throws SQLException, SBException {
        Project project = this.projects.getProject(0);
        project.mergeOcc(this, coOcc);
    }

    public void mergeTaxa(Taxon donor, Taxon target) throws SQLException, SBException {
        Taxon.merge(this, true, donor.getSpecID(), target.getSpecID());
        this.commit();
        Project project = this.projects.getProject(0);
        project.updateTaxonRef(donor, target);
        this.taxa.remove(donor);
        this.taxa.notifyObservers();
        for (TxGroup group : this.txGroups.values()) {
            group.removeSpecies(donor.getSpecID());
            group.insertSpecies(target.getSpecID());
            if (!group.hasChanged()) continue;
            group.notifyObservers();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DBType {
        ORACLE(2),
        ACCESS(6),
        ACCESS_MULTI(7);

        private int regType;

        private DBType(int regType) {
            this.regType = regType;
        }

        public int getRegType() {
            return this.regType;
        }
    }
}

