/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.Vector;
import model1_8.Lithdesc;
import model1_8.Project;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.SampleDepth;
import model1_8.SampleInsertException;
import model1_8.SampleLithology;
import model1_8.Smpdtl;
import model1_8.Well;
import model1_8.WellInterp;
import util.MergeStatus;
import util.SB;
import util.SbugsStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sample
extends Observable
implements SbugsStatus,
Comparable {
    public static final double SMALL = 0.003048;
    static final String[] SBSampleTypes = new String[]{"CU", "CO", "SC", "OC", "LOG"};
    private SBdb SB;
    private int sampID;
    private SampleDepth depth = null;
    private String type = "";
    private int gridX;
    private int gridY;
    private Date created;
    private Date modified;
    private String creator = "";
    private String modifier = "";
    private String textLabel = "";
    private double ageErrorPlus;
    private double ageErrorMinus;
    private double age;
    private double ageBelow;
    private double ratio;
    private char sectionType = (char)87;
    int donorID;
    String donorAnalyst = "";
    String donorSampleType = null;
    boolean hasImportedAgeData = false;
    Color status = SbugsStatus.UNKNOWN;
    public char displayUnits = (char)77;
    List alternativeIDs = null;
    boolean[] detailsLoaded = new boolean[4];
    List<Smpdtl> analyses = new LinkedList<Smpdtl>();
    List<SampleLithology> lithology = new LinkedList<SampleLithology>();

    public List<SampleLithology> getLithology() {
        return this.lithology;
    }

    public int compareTo(Object o) {
        Sample rhs = (Sample)o;
        if (rhs.depth.getDepthBaseInt() == this.depth.getDepthBaseInt()) {
            if (rhs.depth.getDepthTopInt() == this.depth.getDepthTopInt()) {
                return this.type.compareTo(rhs.type);
            }
            return this.depth.getDepthTopInt() - rhs.depth.getDepthTopInt();
        }
        return this.depth.getDepthBaseInt() - rhs.depth.getDepthBaseInt();
    }

    public Date getCreated() {
        return this.created;
    }

    public String getCreator() {
        return this.creator;
    }

    public Date getModified() {
        return this.modified;
    }

    public String getModifier() {
        return this.modifier;
    }

    public int getGridX() {
        return this.gridX;
    }

    public int getGridY() {
        return this.gridY;
    }

    public double getAge() {
        return this.age;
    }

    public double getAgeBelow() {
        return this.ageBelow;
    }

    Sample(SBdb SB2, char sectionType) {
        this.SB = SB2;
        this.sectionType = sectionType;
    }

    public List<Smpdtl> getAnalyses() {
        return this.analyses;
    }

    Sample(SBdb SB2, char sectionType, int sampID, double topDepth, double baseDepth, String sampleType, int gridX, int gridY, Date created, String creator, Date modified, String modifier, String label) throws SBException {
        this.SB = SB2;
        this.sectionType = sectionType;
        this.sampID = sampID;
        this.setDepth(topDepth, baseDepth, 'M');
        this.type = sampleType;
        this.gridX = gridX;
        this.gridY = gridY;
        this.created = created;
        this.creator = creator;
        this.modified = modified;
        this.modifier = modifier;
        this.textLabel = label;
    }

    Sample(SBdb SB2, char sectionType, double topDepth, double baseDepth, String sampleType, String label) throws SBException {
        this.SB = SB2;
        this.sectionType = sectionType;
        this.setDepth(topDepth, baseDepth, 'M');
        this.type = sampleType;
        this.textLabel = label;
    }

    public Sample(SBdb SB2, int sampID, char sectionType) throws SQLException, SBException {
        Statement stmt;
        this.sectionType = sectionType;
        this.SB = SB2;
        if (sampID != 0) {
            String sql = "SELECT depth,bot_depth,type,grid_x,grid_y,label,created,creator,modified,modifier";
            sql = sql + " FROM " + SB2.DBTableName("SAMPLES") + " WHERE samp_id =" + sampID;
            stmt = SB2.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
            if (rs.next()) {
                this.sampID = sampID;
                this.depth = new SampleDepth();
                this.depth.top = rs.getDouble("depth");
                this.depth.base = rs.getDouble("bot_depth");
                this.type = rs.getString("type");
                this.status = SbugsStatus.STORED;
                this.gridX = rs.getInt("grid_x");
                this.gridY = rs.getInt("grid_y");
                String strg = rs.getString("label");
                if (strg != null) {
                    this.textLabel = strg;
                }
            } else {
                throw new SBException("Sample missing for ID: " + sampID);
            }
            this.created = rs.getDate("created");
            this.creator = rs.getString("creator");
            this.modified = rs.getDate("modified");
            this.modifier = rs.getString("modifier");
        } else {
            throw new SBException("Can't create new sample from zero sample ID");
        }
        stmt.close();
    }

    public String getType() {
        return this.type;
    }

    void update(double topDepth, double baseDepth, String type, String label) throws SQLException, SBException {
        if (this.SB == null) {
            throw new SBException("Attempt to update sample with null Model pointer");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        this.setDepth(topDepth, baseDepth, 'M');
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "UPDATE " + this.SB.DBTableName("samples") + " SET depth=" + this.depth.top + ",bot_depth=" + this.depth.base + ",type='" + type + "',label='" + label + "'" + ",modified='" + df.format(new Date()) + "',modifier='" + this.SB.user.getUsrID() + "' WHERE samp_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        this.type = type;
        this.textLabel = label;
        this.modified = new Date();
        this.modifier = this.SB.user.getUsrID();
    }

    public String getLabel() {
        if (this.textLabel != null && this.textLabel.length() > 0) {
            return this.textLabel.toString();
        }
        return "";
    }

    public double getDepth() throws SBException {
        if (this.depth == null) {
            throw new SBException("Null depth requested for sample, ID no: " + this.sampID);
        }
        if (this.depth.base > 0.003048) {
            return this.depth.base;
        }
        return this.depth.top;
    }

    public double getDepth(char units) throws SBException {
        if (this.depth == null) {
            throw new SBException("Null depth requested for sample, ID no: " + this.sampID);
        }
        if (this.depth.base > 0.003048) {
            return util.SB.convFromM(this.depth.base, units);
        }
        return util.SB.convFromM(this.depth.top, units);
    }

    public boolean hasDepthRange() {
        if (this.depth == null) {
            return false;
        }
        return Math.abs(this.depth.top - this.depth.base) > 0.003048;
    }

    public void setDepth(double d, char units) {
        this.depth = new SampleDepth(util.SB.convToM(d, units));
    }

    public double getTopDepth(char units) throws SBException {
        if (this.depth == null) {
            throw new SBException("Null depth requested for sample, ID no: " + this.sampID);
        }
        return util.SB.convFromM(this.depth.top, units);
    }

    public double getBaseDepth(char units) throws SBException {
        if (this.depth == null) {
            throw new SBException("Null depth requested for sample, ID no: " + this.sampID);
        }
        return util.SB.convFromM(this.depth.base, units);
    }

    public double getTopDepth() throws SBException {
        if (this.depth == null) {
            throw new SBException("Null depth requested for sample, ID no: " + this.sampID);
        }
        return this.depth.top;
    }

    public double getBaseDepth() throws SBException {
        if (this.depth == null) {
            throw new SBException("Null depth requested for sample, ID no: " + this.sampID);
        }
        return this.depth.base;
    }

    public boolean hasDepth() {
        return this.depth != null;
    }

    public void setBaseDepth(double d, char units) throws SBException {
        if (this.depth == null) {
            this.depth = new SampleDepth(util.SB.convToM(d, units));
        } else {
            this.depth.base = util.SB.convToM(d, units);
        }
        if (this.sectionType == 'W') {
            if (this.depth.top > this.depth.base) {
                throw new SBException("Top depth larger than base depth: " + util.SB.convFromM(this.depth.top, units) + " - " + util.SB.convFromM(this.depth.base, units));
            }
        } else if (this.depth.base > this.depth.top) {
            throw new SBException("Base depth larger than top depth: " + util.SB.convFromM(this.depth.top, units) + " - " + util.SB.convFromM(this.depth.base, units));
        }
        if (this.depth.base > 99999.0) {
            throw new SBException("Base depth set to unreasonably high value: " + util.SB.convFromM(this.depth.base, units));
        }
    }

    void clearDepths() {
        this.depth = null;
    }

    public void setTopDepth(double d, char units) throws SBException {
        if (this.depth == null) {
            this.depth = new SampleDepth(util.SB.convToM(d, units));
        } else {
            this.depth.top = util.SB.convToM(d, units);
        }
        if (this.sectionType == 'W') {
            if (this.depth.top > this.depth.base) {
                throw new SBException("Top depth larger than base depth");
            }
        } else if (this.depth.base > this.depth.top) {
            throw new SBException("Base depth larger than top depth");
        }
        if (this.depth.top > 99999.0 || this.depth.top < -99999.0) {
            throw new SBException("Top depth set to unreasonably high value");
        }
    }

    public void setDepth(double top, double base, char units) throws SBException {
        if (base == 0.0) {
            base = top;
        }
        if (this.sectionType == 'W') {
            if (top - 0.001 > base) {
                throw new SBException("Top depth larger than base depth in sample: " + top + " - " + base);
            }
        } else if (base - 0.001 > top) {
            throw new SBException("Base height higher than top in outcrop sample: " + top + " - " + base);
        }
        this.depth = new SampleDepth(util.SB.convToM(top, units), util.SB.convToM(base, units));
        if (this.depth.top > 99999.0 || this.depth.base > 99999.0) {
            throw new SBException("Top or base depth set to unreasonably high value in sample: " + top + " - " + base);
        }
    }

    int compareDepth(Sample s) {
        if (this.depth != null && s.depth != null) {
            if (Math.abs(this.depth.base - s.depth.base) < 0.003048) {
                if (Math.abs(this.depth.top - s.depth.top) < 0.003048) {
                    return 0;
                }
                return this.depth.top < s.depth.top ? -1 : 1;
            }
            return this.depth.base < s.depth.base ? -1 : 1;
        }
        return 1;
    }

    void parseDepthTypeLabelString(String buff, char units, boolean decideUnits) throws SBException, NumberFormatException {
        String strg;
        StringTokenizer tok = new StringTokenizer(buff, " -");
        boolean hasTopDepth = false;
        boolean hasBaseDepth = false;
        boolean hasType = false;
        boolean hasUnits = false;
        while (tok.hasMoreTokens()) {
            strg = tok.nextToken();
            if (strg.equalsIgnoreCase("m")) {
                units = (char)77;
                hasUnits = true;
                continue;
            }
            if (!strg.equalsIgnoreCase("f") && !strg.equalsIgnoreCase("ft")) continue;
            units = (char)70;
            hasUnits = true;
        }
        if (!hasUnits && decideUnits) {
            if (buff.indexOf(109) >= 0 || buff.indexOf(77) >= 0) {
                units = (char)77;
            }
            if (buff.indexOf(102) >= 0 || buff.indexOf(70) >= 0) {
                units = (char)70;
            }
            if (buff.indexOf(39) >= 0) {
                units = (char)70;
            }
        }
        tok = new StringTokenizer(buff, " -");
        while (tok.hasMoreTokens()) {
            strg = tok.nextToken();
            if (hasUnits && (strg.equalsIgnoreCase("m") || strg.equalsIgnoreCase("f") || strg.equalsIgnoreCase("ft"))) {
                hasUnits = false;
                continue;
            }
            if (Character.isDigit(strg.charAt(0))) {
                if (!hasTopDepth) {
                    this.setDepth(Float.parseFloat(this.stripUnitsFromDepth(strg)), units);
                    hasTopDepth = true;
                    continue;
                }
                if (!hasBaseDepth) {
                    this.setBaseDepth(Float.parseFloat(this.stripUnitsFromDepth(strg)), units);
                    hasBaseDepth = true;
                    continue;
                }
                if (strg != null && !strg.toUpperCase().trim().equals("SAMPLE")) {
                    this.textLabel = this.textLabel + strg;
                }
                if (!hasTopDepth) continue;
                hasBaseDepth = true;
                continue;
            }
            if (hasTopDepth) {
                hasBaseDepth = true;
            }
            if (!hasType) {
                hasType = this.parseType(strg);
                if (hasType) continue;
                this.textLabel = this.textLabel + strg;
                continue;
            }
            if (strg == null || strg.toUpperCase().trim().equals("SAMPLE")) continue;
            this.textLabel = this.textLabel + strg;
        }
    }

    boolean parseType(String buff) {
        boolean parsed = false;
        String[] types = new String[]{"CU", "DC", "WDC", "DDC", "SC", "SWC", "MSCT", "CO", "CORE", "CC", "OC", "CUTTING", "SW"};
        String[] sbTypes = new String[]{"CU", "CU", "CU", "CU", "SC", "SC", "SC", "CO", "CO", "CO", "OC", "CU", "SC"};
        for (int i = 0; i < types.length; ++i) {
            if (!buff.equalsIgnoreCase(types[i])) continue;
            this.type = sbTypes[i];
            parsed = true;
            break;
        }
        if (buff.startsWith("SWC")) {
            this.type = "SC";
            this.textLabel = this.textLabel + buff.substring(3);
            parsed = true;
        } else if (buff.startsWith("SC")) {
            this.type = "SC";
            this.textLabel = this.textLabel + buff.substring(2);
            parsed = true;
        }
        if (!parsed) {
            this.donorSampleType = buff;
        }
        return parsed;
    }

    void parseDepthString(String buff, char units, boolean decideUnits) throws SBException, NumberFormatException {
        StringTokenizer tok;
        if (decideUnits) {
            if ((buff = buff.trim()).indexOf(109) >= 0 || buff.indexOf(77) >= 0) {
                units = (char)77;
            }
            if (buff.indexOf(102) >= 0 || buff.indexOf(70) >= 0) {
                units = (char)70;
            }
            if (buff.indexOf(39) >= 0) {
                units = (char)70;
            }
        }
        if ((tok = new StringTokenizer(buff, " -")).countTokens() == 1) {
            String topDepthString = tok.nextToken();
            this.setDepth(Float.parseFloat(this.stripUnitsFromDepth(topDepthString)), units);
        } else {
            String topDepthString = tok.nextToken();
            String baseDepthString = tok.nextToken();
            try {
                this.setDepth(Float.parseFloat(this.stripUnitsFromDepth(topDepthString)), Float.parseFloat(this.stripUnitsFromDepth(baseDepthString)), units);
            }
            catch (NumberFormatException ex) {
                this.setDepth(Float.parseFloat(topDepthString), units);
            }
        }
    }

    public String stripUnitsFromDepth(String buff) {
        buff = buff.trim();
        if ((buff = buff.toLowerCase()).indexOf(109) > 0) {
            buff = buff.substring(0, buff.indexOf(109));
        }
        if (buff.indexOf(102) > 0) {
            buff = buff.substring(0, buff.indexOf(102));
        }
        if (buff.indexOf(39) > 0) {
            buff = buff.substring(0, buff.indexOf(39));
        }
        for (int i = 0; i < buff.length(); ++i) {
            if (Character.isDigit(buff.charAt(i)) || buff.charAt(i) == '.') continue;
            System.out.println("Warning: truncating string: " + buff);
            buff = buff.substring(0, i);
        }
        return buff;
    }

    public int compareTo(Sample other) {
        int comp = this.compareDepth(other);
        if (comp != 0) {
            return comp;
        }
        comp = this.type.compareTo(other.type);
        if (comp != 0) {
            return comp;
        }
        return 0;
    }

    void setType(String type) throws SBException {
        for (int i = 0; i < SBSampleTypes.length; ++i) {
            if (!type.equalsIgnoreCase(SBSampleTypes[i])) continue;
            this.type = SBSampleTypes[i];
            return;
        }
        if (this.type.length() == 0) {
            throw new SBException("Can't parse sample type: " + type);
        }
    }

    void setLabel(String label) {
        if (label != null) {
            this.textLabel = label;
        }
    }

    void loadLithology(Lithdesc lithdesc) throws SQLException {
        if (this.sampID > 0) {
            this.lithology.clear();
            String sql = "SELECT lith_id,percnt FROM " + this.SB.DBTableName("SBSLITH") + " WHERE samp_id=" + this.sampID;
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                int lithID = rs.getInt("lith_id");
                SampleLithology lith = new SampleLithology(this.SB, this.SB.getLithdesc().getLithology(lithID), rs.getInt("percnt"));
                this.lithology.add(lith);
            }
            stmt.close();
        }
    }

    @Override
    public Color getStatus() {
        if (this.status == UNKNOWN) {
            this.status = this.sampID != 0 ? STORED : NOTSTORED;
        }
        return this.status;
    }

    void loadAges(int interpID) throws SQLException {
        if (this.sampID == 0) {
            return;
        }
        if (this.hasImportedAgeData) {
            return;
        }
        this.age = 0.0;
        this.ageBelow = 0.0;
        this.ageErrorPlus = 0.0;
        this.ageErrorMinus = 0.0;
        this.ratio = 0.0;
        String sql = "SELECT age,age_below,ageplus,ageminus,ratio FROM " + this.SB.DBTableName("SBSSR") + " WHERE samp_id=" + this.sampID;
        if (this.SB.hasSrInterp) {
            sql = interpID > 0 ? sql + " AND interp_id=" + interpID : sql + " AND (interp_id is null OR interp_id=0)";
        }
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            this.age = rs.getDouble("age");
            this.ageBelow = rs.getDouble("age_below");
            this.ageErrorPlus = rs.getDouble("ageplus");
            this.ageErrorMinus = rs.getDouble("ageminus");
            this.ratio = rs.getDouble("ratio");
        }
        stmt.close();
    }

    void loadDetails(char discID, String ianalyst) throws SQLException, SBException {
        if (ianalyst.length() == 0) {
            if (this.detailsLoaded[SBdb.did2i(discID)]) {
                return;
            }
        }
        if (this.sampID == 0) {
            return;
        }
        if (ianalyst.length() > 0 && this.getSmpdtl(discID, ianalyst) != null) {
            return;
        }
        String sql = "SELECT samp_id,analyst,picker,source,modified,modifier,barren,notes";
        if (this.SB.hasSampleEnv) {
            sql = sql + ",proximal,distal";
        }
        if (this.SB.hasWeightSplits[SBdb.did2i(discID)]) {
            sql = sql + ",weight,coarse,medium,fine";
        }
        sql = sql + " FROM " + this.SB.DBTableName("SMPDTL") + " WHERE ( samp_id=" + this.sampID;
        if (this.alternativeIDs != null) {
            Iterator it = this.alternativeIDs.iterator();
            while (it.hasNext()) {
                sql = sql + " OR samp_id=" + it.next();
            }
        }
        sql = sql + ") AND disc_id='" + discID + "'";
        if (ianalyst.length() > 0) {
            sql = sql + " AND analyst='" + ianalyst + "'";
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        sql = this.SB.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        String strg = null;
        while (rs.next()) {
            int sampID = rs.getInt("samp_id");
            String analyst = rs.getString("analyst");
            String picker = rs.getString("picker");
            String source = rs.getString("source");
            Timestamp modified = rs.getTimestamp("modified");
            String modifier = rs.getString("modifier");
            boolean isAnalysed = true;
            boolean barren = false;
            strg = rs.getString("barren");
            if (strg == null) {
                isAnalysed = false;
            } else {
                isAnalysed = true;
                if (strg.length() > 0 && strg.charAt(0) == 'Y') {
                    barren = true;
                }
            }
            String notes = rs.getString("notes");
            int proximal = 0;
            int distal = 0;
            if (this.SB.hasSampleEnv) {
                proximal = rs.getInt("proximal");
                distal = rs.getInt("distal");
            }
            float weight = 0.0f;
            float coarse = 0.0f;
            float medium = 0.0f;
            float fine = 0.0f;
            if (this.SB.hasWeightSplits[SBdb.did2i(discID)]) {
                weight = rs.getFloat("weight");
                coarse = rs.getFloat("coarse");
                medium = rs.getFloat("medium");
                fine = rs.getFloat("fine");
            }
            if (analyst == null || analyst.length() == 0) {
                throw new SBException("Analyst null for sample : " + this);
            }
            Smpdtl dtl = new Smpdtl(this.SB, this, discID, analyst, picker, source, notes, modified, modifier, barren, proximal, distal, weight, coarse, medium, fine);
            dtl.load();
            dtl.status = STORED;
            Iterator<Smpdtl> it = this.analyses.iterator();
            boolean toAdd = true;
            while (it.hasNext()) {
                Smpdtl analysis = it.next();
                if (analysis.getDiscID() != dtl.getDiscID() || !analysis.getAnalyst().equals(dtl.getAnalyst())) continue;
                String message = "Duplicate analyst for discID: " + analysis.getDiscID() + ", analyst:" + analysis.getAnalyst() + ", sample ID: " + sampID;
                if (this.alternativeIDs != null) {
                    Iterator it2 = this.alternativeIDs.iterator();
                    while (it2.hasNext()) {
                        message = message + ", " + it2.next();
                    }
                }
                if (dtl.occur.size() > 0 && analysis.occur.size() == 0) {
                    System.out.println(message + ", sample details: " + analysis + " removed.");
                    it.remove();
                    break;
                }
                if (dtl.occur.size() == analysis.occur.size()) {
                    System.out.println(message + ", sample details: " + dtl + " ignored.");
                    toAdd = false;
                    continue;
                }
                throw new SBException(message + ", analyses have different occurrence records");
            }
            if (!toAdd) continue;
            this.analyses.add(dtl);
        }
        rs.close();
        stmt.close();
        if (ianalyst.length() == 0) {
            this.detailsLoaded[SBdb.did2i((char)discID)] = true;
        }
    }

    void fillTaxa(Hashtable taxa) throws SBException, SQLException {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            smpdtl.fillTaxa(taxa);
        }
    }

    void fillTaxa(List taxa, char discID) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (discID != '\u0000' && discID != smpdtl.getDiscID()) continue;
            smpdtl.fillTaxonList(taxa);
        }
    }

    public boolean hasDisciplineData(char discID) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID) continue;
            return true;
        }
        return false;
    }

    void delete() throws SQLException {
        if (this.sampID == 0) {
            return;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.SB.DBTableName("SBSLITH") + " WHERE samp_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("SBSSR") + " WHERE samp_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("FSSABND") + " WHERE samp_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("SMPDTL") + " WHERE samp_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("SAMPLES") + " WHERE samp_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.sampID = 0;
    }

    void replace(int newSampID) throws SQLException {
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "UPDATE " + this.SB.DBTableName("SBSLITH") + " SET samp_id=" + newSampID + " WHERE samp_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("SBSSR") + " SET samp_id=" + newSampID + " WHERE samp_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("FSSABND") + " SET samp_id=" + newSampID + " WHERE samp_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("SMPDTL") + " SET samp_id=" + newSampID + " WHERE samp_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("EVENTS") + " SET samp_id=" + newSampID + " WHERE samp_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("IGD") + " SET top_id=" + newSampID + " WHERE top_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("IGD_ENV") + " SET top_id=" + newSampID + " WHERE top_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("IGD") + " SET base_id=" + newSampID + " WHERE base_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("IGD_ENV") + " SET base_id=" + newSampID + " WHERE base_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("BCMMNTS") + " SET usamp_id=" + newSampID + " WHERE usamp_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("BCMMNTS") + " SET lsamp_id=" + newSampID + " WHERE lsamp_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("SQTRACT") + " SET top_id=" + newSampID + " WHERE top_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("SQTRACT") + " SET base_id=" + newSampID + " WHERE base_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("SQTRACT") + " SET ts_id=" + newSampID + " WHERE ts_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "UPDATE " + this.SB.DBTableName("SQTRACT") + " SET mfs_id=" + newSampID + " WHERE mfs_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("SAMPLES") + " WHERE samp_id=" + this.sampID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
        this.sampID = 0;
    }

    boolean hasIGDdataInDB() throws SQLException {
        String sql;
        if (this.sampID == 0) {
            return false;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql = "SELECT top_id FROM " + this.SB.DBTableName("IGD") + " WHERE top_id=" + this.sampID));
        if (rs.next()) {
            return true;
        }
        sql = "SELECT top_id FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE top_id=" + this.sampID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return true;
        }
        sql = "SELECT base_id FROM " + this.SB.DBTableName("IGD") + " WHERE base_id=" + this.sampID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return true;
        }
        sql = "SELECT base_id FROM " + this.SB.DBTableName("IGD_ENV") + " WHERE base_id=" + this.sampID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return true;
        }
        sql = "SELECT top_id FROM " + this.SB.DBTableName("SQTRACT") + " WHERE top_id=" + this.sampID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return true;
        }
        sql = "SELECT base_id FROM " + this.SB.DBTableName("SQTRACT") + " WHERE base_id=" + this.sampID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return true;
        }
        sql = "SELECT samp_id FROM " + this.SB.DBTableName("SBSLITH") + " WHERE samp_id=" + this.sampID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return true;
        }
        sql = "SELECT usamp_id FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE usamp_id=" + this.sampID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return true;
        }
        sql = "SELECT lsamp_id FROM " + this.SB.DBTableName("BCMMNTS") + " WHERE lsamp_id=" + this.sampID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return true;
        }
        sql = "SELECT samp_id FROM " + this.SB.DBTableName("EVENTS") + " WHERE samp_id=" + this.sampID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return true;
        }
        sql = "SELECT samp_id FROM " + this.SB.DBTableName("SBSSR") + " WHERE samp_id=" + this.sampID;
        rs = stmt.executeQuery(this.SB.modQuery(sql));
        if (rs.next()) {
            return true;
        }
        stmt.close();
        return false;
    }

    public Smpdtl getAnySmpdtl(char discID, String analyst) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID || analyst.length() != 0 && !smpdtl.getAnalyst().equals(analyst)) continue;
            return smpdtl;
        }
        return null;
    }

    public List getAnalysts(char discID) throws SQLException {
        LinkedList<String> analysts = new LinkedList<String>();
        if (this.sampID > 0) {
            String sql = "SELECT distinct analyst FROM " + this.SB.DBTableName("SMPDTL") + " WHERE samp_id=" + this.sampID;
            if (discID > '\u0000') {
                sql = sql + " AND disc_id='" + discID + "'";
            }
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                analysts.add(rs.getString("analyst"));
            }
            stmt.close();
        }
        for (Smpdtl dtl : this.analyses) {
            if (discID != '\u0000' && discID != dtl.getDiscID() || analysts.contains(dtl.getAnalyst())) continue;
            analysts.add(dtl.getAnalyst());
        }
        return analysts;
    }

    Smpdtl getSmpdtl(char discID, String analyst) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID || !smpdtl.getAnalyst().equals(analyst)) continue;
            return smpdtl;
        }
        return null;
    }

    void removeSmpdtl(char discID) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID) continue;
            this.analyses.remove(i);
            break;
        }
    }

    void removeSmpdtl(char discID, String analyst) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID || !smpdtl.getAnalyst().equals(analyst)) continue;
            this.analyses.remove(i);
            break;
        }
    }

    boolean hasDonorSpecies(char discID, int specID) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID || !smpdtl.hasDonorSpecies(specID)) continue;
            return true;
        }
        return false;
    }

    Color updateStatus(int wellID) throws SQLException, SBException {
        if (this.sampID == 0) {
            Statement stmt;
            ResultSet rs;
            String sql = "SELECT samp_id,grid_x,grid_y,label,created,creator,modified,modifier";
            sql = sql + " FROM " + this.SB.DBTableName("SAMPLES") + " WHERE samp_id >=" + wellID * 65536 + " AND samp_id<" + (wellID + 1) * 65536;
            sql = sql + " AND bot_depth >" + Double.toString(this.depth.base - 0.003048) + " AND bot_depth < " + Double.toString(this.depth.base + 0.003048) + " AND type='" + this.type + "'";
            if (this.hasDepthRange()) {
                sql = sql + " AND depth >" + Double.toString(this.depth.top - 0.003048) + " AND depth < " + Double.toString(this.depth.top + 0.003048);
            }
            if ((rs = (stmt = this.SB.getDatabase().createStatement()).executeQuery(this.SB.modQuery(sql))).next()) {
                this.sampID = rs.getInt("samp_id");
                this.status = STORED;
                MergeStatus m = new MergeStatus(this.status);
                this.gridX = m.compareIntField("grid x", this.gridX, rs.getInt("grid_x"));
                this.gridY = m.compareIntField("grid y", this.gridY, rs.getInt("grid_y"));
                m.compareStringField("Label", this.textLabel, rs.getString("label"), true);
                this.status = m.getStatus();
                if (this.status != CONFLICT) {
                    this.created = rs.getDate("created");
                    this.creator = rs.getString("creator");
                    this.modified = rs.getDate("modified");
                    this.modifier = rs.getString("modifier");
                }
            }
            stmt.close();
        }
        if (this.sampID != 0) {
            for (int i = 0; i < this.analyses.size(); ++i) {
                Smpdtl smpdtl = this.analyses.get(i);
                smpdtl.updateStatus(this.sampID);
            }
        } else {
            this.status = NOTSTORED;
        }
        return this.status;
    }

    boolean hasSpecies(char discID, int specID) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID || !smpdtl.hasSpecies(specID)) continue;
            return true;
        }
        return false;
    }

    boolean hasInSituSpecies(char discID, int specID, char flag) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID || !smpdtl.hasInSituSpecies(specID, flag)) continue;
            return true;
        }
        return false;
    }

    void writeSbugs(FileWriter out, char discID) throws IOException {
        String blanks = "                        ";
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID) continue;
            out.write("S ");
            if (Math.abs(this.depth.top) > 0.003048) {
                out.write(this.padFloat(9, 3, this.depth.top));
            } else {
                out.write(this.padFloat(9, 3, this.depth.base));
            }
            out.write(blanks.substring(0, 6 - this.type.length()) + this.type + '\t');
            out.write(this.padInt(6, this.gridX) + '\t');
            out.write(this.padInt(6, this.gridY) + '\t');
            if (Math.abs(this.depth.top) > 0.003048 && Math.abs(this.depth.top - this.depth.base) > 0.003048) {
                out.write(this.padFloat(9, 3, this.depth.base));
            }
            out.write(10);
            smpdtl.writeSbugs(out);
        }
    }

    public String padFloat(int width, int precision, double number) {
        String result = String.valueOf(number);
        if (result.length() - result.indexOf(46) > precision) {
            result = result.substring(0, result.indexOf(46) + precision);
        }
        while (result.length() < width) {
            result = " " + result;
        }
        return result;
    }

    public String padInt(int width, int value) {
        String result = String.valueOf(value);
        while (result.length() < width) {
            result = " " + result;
        }
        return result;
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    @Override
    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.toString(this.displayUnits);
    }

    public String toString(char units) {
        double displayTop = util.SB.convFromM(this.depth.top, units);
        double displayBase = util.SB.convFromM(this.depth.base, units);
        int dp = 0;
        if (this.type.compareTo("CO") == 0 || this.type.compareTo("OC") == 0) {
            displayTop = (double)Math.round(displayTop * 100.0) / 100.0;
            displayBase = (double)Math.round(displayBase * 100.0) / 100.0;
            dp = 2;
        } else if (this.type.compareTo("SC") == 0 || this.type.compareTo("LOG") == 0) {
            displayTop = (double)Math.round(displayTop * 10.0) / 10.0;
            displayBase = (double)Math.round(displayBase * 10.0) / 10.0;
            dp = 1;
        } else {
            displayTop = Math.round(displayTop);
            displayBase = Math.round(displayBase);
            dp = 0;
        }
        String s = new String();
        if (Math.abs(displayTop - displayBase) > 0.003048 && !this.SB.hideDepthRange) {
            s = util.SB.floatString(displayTop, dp) + " - ";
            s = s + util.SB.floatString(displayBase, dp).trim();
        } else {
            s = s + util.SB.floatString(displayBase, dp);
        }
        s = units == 'F' ? s + '\'' : s + 'm';
        if (this.SB.hideCommonSampleTypes) {
            if (!this.type.equals("CU") && !this.type.equals("OC")) {
                s = s + ' ' + this.type;
            }
        } else {
            s = s + ' ' + this.type;
        }
        if (this.textLabel != null && this.textLabel.length() > 0) {
            s = s + ' ';
            s = s + this.textLabel;
        }
        return s;
    }

    public void addDtl(char discID, String analyst, boolean barren, String picker, String source, String notes, float weight, float coarse, float medium, float fine, int proximal, int distal) throws SBException, SQLException {
        for (Smpdtl o : this.analyses) {
            Smpdtl d = o;
            if (d.getDiscID() != discID || !d.getAnalyst().equals(analyst)) continue;
            throw new SBException("Duplicate analyst: " + analyst + " & discipline: " + discID + " for sample: " + this.toString());
        }
        Smpdtl smpdtl = new Smpdtl(this.SB, this, discID, analyst, barren, picker, source, notes, weight, coarse, medium, fine, proximal, distal);
        this.insert(smpdtl);
        this.setChanged();
    }

    public void deleteDtl(Smpdtl smpdtl) throws SQLException {
        Smpdtl.delete(this.SB, smpdtl.getDiscID(), smpdtl.getAnalyst(), this.sampID);
        this.analyses.remove(smpdtl);
        this.setChanged();
    }

    public void updateDtl(Smpdtl smpdtl, char discID, String analyst, boolean barren, String picker, String source, String notes, float weight, float coarse, float medium, float fine, int proximal, int distal) throws SBException, SQLException {
        for (Smpdtl o : this.analyses) {
            Smpdtl d = o;
            if (d == smpdtl || d.getDiscID() != discID || !d.getAnalyst().equals(analyst)) continue;
            throw new SBException("Duplicate analyst & discipline for sample: " + this.toString());
        }
        smpdtl.update(discID, analyst, barren, picker, source, notes, weight, coarse, medium, fine, proximal, distal);
    }

    void insert(Smpdtl smpdtl) throws SBException {
        this.checkDtl(smpdtl);
        this.analyses.add(smpdtl);
    }

    void checkDtl(Smpdtl smpdtl) throws SBException {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl dtl = this.analyses.get(i);
            if (dtl.getDiscID() != smpdtl.getDiscID() || !dtl.getAnalyst().equals(smpdtl.getAnalyst())) continue;
            throw new SBException("Duplicate analyst & discipline for sample: " + this.toString());
        }
    }

    int store(int wellID, int serialNumber) throws SQLException, SBException {
        block28: {
            Statement stmt;
            String sql;
            SimpleDateFormat df;
            block23: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                if (this.type == null || this.type.length() == 0) {
                                    throw new SBException("Cannot save sample with null sample type: " + this.toString());
                                }
                                if (this.sampID != 0) break block23;
                                this.sampID = wellID * 65536 + ++serialNumber;
                                df = new SimpleDateFormat("yyyy-MM-dd");
                                sql = "INSERT INTO " + this.SB.DBTableName("SAMPLES") + " (samp_id,depth,bot_depth,type,created,creator,modified,modifier";
                                if (this.textLabel.length() > 0) {
                                    sql = sql + ",label";
                                }
                                if (this.gridX > 0) {
                                    sql = sql + ",grid_x";
                                }
                                if (this.gridY > 0) {
                                    sql = sql + ",grid_y";
                                }
                                if (this.SB.hasSamplesWellID) {
                                    sql = sql + ",well_id";
                                }
                                sql = sql + ") VALUES (";
                                this.creator = this.SB.user.getUsrID();
                                if (this.modified == null) break block24;
                                if (SBdb.preserveAudit) break block25;
                            }
                            this.modified = new Date();
                        }
                        if (this.modifier == null || this.modifier.length() == 0) break block26;
                        if (SBdb.preserveAudit) break block27;
                    }
                    this.modifier = this.SB.user.getUsrID();
                }
                sql = sql + this.sampID + "," + this.depth.top + "," + this.depth.base + ",'" + this.type + "','" + df.format(this.created != null ? this.created : new Date()) + "','" + this.creator + "','" + df.format(this.modified) + "','" + this.SB.user.getUsrID() + "'";
                if (this.gridX > 0) {
                    sql = sql + "," + this.gridX;
                }
                if (this.gridY > 0) {
                    sql = sql + "," + this.gridY;
                }
                if (this.textLabel.length() > 0) {
                    sql = sql + ",'" + this.textLabel.toString() + "'";
                }
                if (this.SB.hasSamplesWellID) {
                    sql = sql + "," + wellID;
                }
                sql = sql + ")";
                stmt = this.SB.getDatabase().createStatement();
                stmt.executeUpdate(this.SB.modQuery(sql));
                stmt.close();
                break block28;
            }
            if (this.status == PARTSTORED) {
                df = new SimpleDateFormat("yyyy-MM-dd");
                sql = "UPDATE " + this.SB.DBTableName("SAMPLES") + " SET ";
                sql = sql + "depth=" + Double.toString(this.depth.top) + ",";
                if (this.modified == null || !SBdb.preserveAudit) {
                    this.modified = new Date();
                }
                if (this.modifier == null || this.modifier.length() == 0 || !SBdb.preserveAudit) {
                    this.modifier = this.SB.user.getUsrID();
                }
                sql = sql + "bot_depth=" + this.depth.base + ",type='" + this.type + "',modified='" + df.format(this.modified) + "',modifier='" + this.SB.user.getUsrID() + "'";
                if (this.textLabel.length() > 0) {
                    sql = sql + ",label='" + this.textLabel.toString() + "'";
                }
                if (this.gridX > 0) {
                    sql = sql + ",grid_x=" + this.gridX;
                }
                if (this.gridY > 0) {
                    sql = sql + ",grid_y=" + this.gridY;
                }
                sql = sql + " WHERE samp_id=" + this.sampID;
                stmt = this.SB.getDatabase().createStatement();
                stmt.executeUpdate(this.SB.modQuery(sql));
                stmt.close();
            }
        }
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            smpdtl.store();
        }
        for (int i = 0; i < this.lithology.size(); ++i) {
            SampleLithology sampLith = this.lithology.get(i);
            sampLith.store(this.sampID);
        }
        this.storeAge(0);
        this.status = STORED;
        return serialNumber;
    }

    public void updateLithology(List<SampleLithology> liths) throws SQLException {
        LinkedList<SampleLithology> newLiths = new LinkedList<SampleLithology>();
        SampleLithology.clear(this.SB, this.sampID);
        for (SampleLithology lith : liths) {
            SampleLithology newLith = new SampleLithology(this.SB, lith.getDescription(), lith.getPercent());
            newLith.store(this.sampID);
            newLiths.add(newLith);
        }
        this.lithology = newLiths;
    }

    void storeAge(int interpID) throws SQLException {
        if (this.sampID == 0) {
            return;
        }
        String sql = "DELETE FROM " + this.SB.DBTableName("SBSSR") + " WHERE samp_id=" + this.sampID;
        if (this.SB.hasSrInterp) {
            sql = interpID > 0 ? sql + " AND interp_id=" + interpID : sql + " AND (interp_id is null OR interp_id=0)";
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        if (this.age >= 1.0E-6 || Math.abs(this.ratio) > 0.001) {
            sql = "INSERT INTO " + this.SB.DBTableName("SBSSR") + " (samp_id,ratio,age,age_below,ageplus,ageminus";
            if (this.SB.hasSrInterp) {
                sql = sql + ",interp_id";
            }
            sql = sql + ") VALUES(";
            sql = sql + this.sampID + "," + this.ratio + "," + this.age + "," + this.ageBelow + "," + this.ageErrorPlus + "," + this.ageErrorMinus;
            if (this.SB.hasSrInterp) {
                sql = sql + ",";
                sql = sql + interpID;
            }
            sql = sql + ")";
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        stmt.close();
        this.hasImportedAgeData = false;
    }

    void parseXML(String chars, String element, char units) throws ParseException {
        if (element.compareTo("Label") == 0) {
            this.textLabel = this.textLabel + chars;
        } else if (element.compareTo("TopDepth") == 0) {
            try {
                this.setTopDepth(Float.parseFloat(chars), units);
                this.displayUnits = units;
            }
            catch (SBException se) {
                throw new ParseException("Error trying to parse: " + chars + " : " + se.getMessage(), 0);
            }
        } else if (element.compareTo("BaseDepth") == 0) {
            try {
                this.setBaseDepth(Float.parseFloat(chars), units);
                this.displayUnits = units;
            }
            catch (SBException se) {
                throw new ParseException("Error trying to parse: " + chars + " : " + se.getMessage(), 0);
            }
        } else if (element.compareTo("Type") == 0) {
            this.type = chars;
        } else if (element.compareTo("Created") == 0) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            this.created = df.parse(chars);
        } else if (element.compareTo("Creator") == 0) {
            this.creator = chars;
        } else if (element.compareTo("Modified") == 0) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            this.modified = df.parse(chars);
        } else if (element.compareTo("Modifier") == 0) {
            this.modifier = chars;
        } else if (element.compareTo("GridX") == 0) {
            this.gridX = Integer.parseInt(chars);
        } else if (element.compareTo("GridY") == 0) {
            this.gridY = Integer.parseInt(chars);
        } else if (element.compareTo("Age") == 0) {
            this.age = Float.parseFloat(chars);
        } else if (element.compareTo("AgeBelowUnconformity") == 0) {
            this.ageBelow = Float.parseFloat(chars);
        } else if (element.compareTo("AgeErrorPlus") == 0) {
            this.ageErrorPlus = Float.parseFloat(chars);
        } else if (element.compareTo("AgeErrorMinus") == 0) {
            this.ageErrorMinus = Float.parseFloat(chars);
        } else if (element.compareTo("Ratio") == 0) {
            this.ratio = Float.parseFloat(chars);
        }
    }

    void writeXML(FileWriter out, int indent, char units, boolean useDonorSpecID) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        if (this.textLabel != null && this.textLabel.length() > 0) {
            out.write(ind + "<Label>" + this.textLabel.toString() + "</Label>\n");
        }
        if (Math.abs(this.depth.top) > 0.001) {
            out.write(ind + "<TopDepth>" + util.SB.convFromM(this.depth.top, units) + "</TopDepth>\n");
        }
        out.write(ind + "<BaseDepth>" + util.SB.convFromM(this.depth.base, units) + "</BaseDepth>\n");
        out.write(ind + "<Type>" + this.type + "</Type>\n");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (this.created != null) {
            out.write(ind + "<Created>" + df.format(this.created) + "</Created>\n");
        }
        if (this.creator != null && this.creator.length() > 0) {
            out.write(ind + "<Creator>" + this.creator + "</Creator>\n");
        }
        if (this.modified != null) {
            out.write(ind + "<Modified>" + df.format(this.modified) + "</Modified>\n");
        }
        if (this.modifier != null && this.modifier.length() > 0) {
            out.write(ind + "<Modifier>" + this.modifier + "</Modifier>\n");
        }
        if (this.gridX != 0) {
            out.write(ind + "<GridX>" + this.gridX + "</GridX>\n");
        }
        if (this.gridY != 0) {
            out.write(ind + "<GridY>" + this.gridY + "</GridY>\n");
        }
        if (Math.abs(this.age) > 1.0E-6) {
            out.write(ind + "<Age>" + this.age + "</Age>\n");
        }
        if (Math.abs(this.ageBelow) > 1.0E-6) {
            out.write(ind + "<AgeBelowUnconformity>" + this.ageBelow + "</AgeBelowUnconformity>\n");
        }
        if (Math.abs(this.ageErrorPlus) > 1.0E-4) {
            out.write(ind + "<AgeErrorPlus>" + this.ageErrorPlus + "</AgeErrorPlus>\n");
        }
        if (Math.abs(this.ageErrorMinus) > 1.0E-4) {
            out.write(ind + "<AgeErrorMinus>" + this.ageErrorMinus + "</AgeErrorMinus>\n");
        }
        if (Math.abs(this.ratio) > 1.0E-4) {
            out.write(ind + "<Ratio>" + this.ratio + "</Ratio>\n");
        }
        for (int i = 0; i < this.lithology.size(); ++i) {
            out.write(ind + "<Lithology>\n");
            SampleLithology lith = this.lithology.get(i);
            lith.writeXML(out, indent + 3);
            out.write(ind + "</Lithology>\n");
        }
        for (int i = 0; i < this.analyses.size(); ++i) {
            out.write(ind + "<Analyses>\n");
            Smpdtl smpdtl = this.analyses.get(i);
            smpdtl.writeXML(out, indent + 3, useDonorSpecID);
            out.write(ind + "</Analyses>\n");
        }
    }

    public int getSampID() {
        return this.sampID;
    }

    void setAge(double age, double ageBelow, double ageErrorPlus, double ageErrorMinus, double ratio) {
        this.age = age;
        this.ageBelow = ageBelow;
        this.ageErrorPlus = ageErrorPlus;
        this.ageErrorMinus = ageErrorMinus;
    }

    public void updateAge(double age, WellInterp interp) throws SQLException {
        String sql = "UPDATE " + this.SB.DBTableName("sbssr") + " SET age=" + age + " WHERE samp_id=" + this.sampID + " AND interp_id=" + interp.interpID;
        Statement stmt = this.SB.getDatabase().createStatement();
        int nRow = stmt.executeUpdate(this.SB.modQuery(sql));
        if (nRow == 0) {
            sql = "INSERT INTO " + this.SB.DBTableName("sbssr") + " (samp_id,age,interp_id) VALUES (" + this.sampID + "," + age + "," + interp.interpID + ")";
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        this.age = age;
        this.setChanged();
    }

    public void updateAgeBelow(double age, WellInterp interp) throws SQLException {
        String sql = "UPDATE " + this.SB.DBTableName("sbssr") + " SET age_below=" + age + " WHERE samp_id=" + this.sampID + " AND interp_id=" + interp.interpID;
        Statement stmt = this.SB.getDatabase().createStatement();
        int nRow = stmt.executeUpdate(this.SB.modQuery(sql));
        if (nRow == 0) {
            sql = "INSERT INTO " + this.SB.DBTableName("sbssr") + " (samp_id,age_below,interp_id) VALUES (" + this.sampID + "," + age + "," + interp.interpID + ")";
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        this.ageBelow = age;
        this.setChanged();
    }

    int getID() throws SBException {
        if (this.sampID == 0 && this.donorID == 0) {
            throw new SBException("Attempt to write sample : " + this + " with no sample ID");
        }
        if (this.sampID > 0) {
            return this.sampID;
        }
        return this.donorID;
    }

    void writeDEX(FileWriter out, Vector dataTypes, boolean useDonorTaxa, boolean useAges, boolean useLithology, LinkedList taxa, char units, String eol, SimpleDateFormat df) throws IOException, SBException {
        this.displayUnits = units;
        out.write("[SAMPLE " + this.toString().trim() + "]" + eol);
        if (this.hasDepthRange()) {
            out.write("Top Depth = " + util.SB.getDepthString(this.depth.top, units, 3).trim() + eol);
            out.write("Base Depth = " + util.SB.getDepthString(this.depth.base, units, 3).trim() + eol);
        } else if (this.SB.useSampleTops) {
            out.write("Top Depth = " + util.SB.getDepthString(this.depth.top, units, 3).trim() + eol);
        } else {
            out.write("Base Depth = " + util.SB.getDepthString(this.depth.base, units, 3).trim() + eol);
        }
        out.write("Type = " + this.type + eol);
        if (this.gridX > 0) {
            out.write("Grid X = " + this.gridX + eol);
        }
        if (this.gridY > 0) {
            out.write("Grid Y = " + this.gridY + eol);
        }
        if (this.created != null) {
            out.write("Created = " + df.format(this.created) + eol);
        }
        if (this.modified != null) {
            out.write("Modified = " + df.format(this.modified) + eol);
        }
        out.write("Sample id = " + this.getID() + eol);
        if (this.textLabel.length() > 0) {
            out.write("Label = " + this.textLabel + eol);
        }
        if (useAges && this.age > 0.0) {
            out.write("Age = " + this.age + eol);
            out.write("Age error plus : " + this.ageErrorPlus + eol);
            out.write("Age error minus : " + this.ageErrorMinus + eol);
        }
        if (useAges && this.ageBelow > 0.0) {
            out.write("Age below unconformity = " + this.ageBelow + eol);
        }
        if (useAges && this.ratio > 0.0) {
            out.write("Ratio : " + this.ratio + eol);
        }
        if (useLithology) {
            for (int i = 0; i < this.lithology.size(); ++i) {
                SampleLithology lith = this.lithology.get(i);
                out.write("Lithology = " + lith.getDescription().getDescr() + eol);
                out.write("  Lithology code : " + lith.getDescription().getLithID() + eol);
                out.write("  Lithology percent : " + lith.getPercent() + eol);
            }
        }
        Enumeration en = dataTypes.elements();
        while (en.hasMoreElements()) {
            int columnType = (Integer)en.nextElement();
            if (columnType != 1) {
                if (columnType != 3) {
                    if (columnType != 7) {
                        if (columnType != 5) continue;
                    }
                }
            }
            if (!this.hasDisciplineData(SBdb.dt2discID(columnType))) continue;
            out.write(eol);
            for (int i = 0; i < this.analyses.size(); ++i) {
                Smpdtl smpdtl = this.analyses.get(i);
                if (smpdtl.getDiscID() != SBdb.dt2discID(columnType)) continue;
                smpdtl.writeDEX(out, useDonorTaxa, taxa, df, eol);
            }
        }
        out.write(eol);
    }

    void removeAgeData() {
        this.ratio = 0.0;
        this.ageErrorPlus = 0.0;
        this.ageErrorMinus = 0.0;
        this.ageBelow = 0.0;
        this.age = 0.0;
    }

    public boolean hasAgeData() {
        if (this.age > 0.0) {
            return true;
        }
        return this.ageBelow > 0.0;
    }

    public static void insert(List samples, Sample sample, char wellUnits) throws SBException {
        int i;
        for (i = 0; i < samples.size(); ++i) {
            Sample existing = (Sample)samples.get(i);
            int compare = sample.compareTo(existing);
            if (compare == 0) {
                if (sample.sampID > 0 && existing.sampID == 0) {
                    existing.sampID = sample.sampID;
                    existing.status = sample.status;
                } else {
                    if (sample.sampID > 0 && existing.sampID > 0 && sample.sampID != existing.sampID || sample.donorID > 0 && existing.donorID > 0 && sample.donorID != existing.donorID) break;
                    sample.displayUnits = wellUnits;
                    throw new SampleInsertException("Duplicate sample at depth: " + sample.toString(), existing);
                }
            }
            if (compare < 0) break;
        }
        samples.add(i, sample);
    }

    static int getNumAnalyses(SBdb SB2, String userID) throws SQLException {
        int num = 0;
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = null;
        int i = 0;
        while (true) {
            if (i >= 4) break;
            String sql = "SELECT count(analyst) AS analyses FROM " + SB2.DBTableName("SMPDTL") + " WHERE disc_id='" + SBdb.discArr[i] + "' AND analyst='" + userID + "'";
            rs = stmt.executeQuery(SB2.modQuery(sql));
            if (rs.next()) {
                num += rs.getInt("analyses");
            }
            ++i;
        }
        stmt.close();
        return num;
    }

    public int hashCode() {
        return this.sampID;
    }

    static HashMap<Integer, Sample> loadAll(SBdb SB2, Project project) throws SQLException, SBException {
        HashMap<Integer, Sample> samples = new HashMap<Integer, Sample>();
        String sql = "SELECT SAMP_ID,DEPTH,BOT_DEPTH,TYPE,GRID_X,GRID_Y,CREATED,CREATOR,MODIFIED,MODIFIER,LABEL\tFROM " + SB2.DBTableName("samples") + " ORDER BY samp_id";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int sampID = rs.getInt("samp_id");
            Well well = project.getWell(SB2, sampID / 65536);
            if (well == null) {
                System.out.println("WARNING: well is null for sample: " + sampID);
                continue;
            }
            Sample sample = new Sample(SB2, well.getType());
            try {
                sample.sampID = sampID;
                double topDepth = rs.getDouble("depth");
                double baseDepth = rs.getDouble("bot_depth");
                String type = rs.getString("type");
                if (type == null || type.length() == 0) {
                    type = "CU";
                }
                sample.setType(type);
                if (baseDepth == 0.0 && topDepth > baseDepth && !sample.type.equals("OC")) {
                    baseDepth = topDepth;
                }
                sample.setTopDepth(topDepth, 'M');
                sample.setBaseDepth(baseDepth, 'M');
                sample.gridX = rs.getInt("grid_x");
                sample.gridY = rs.getInt("grid_y");
                sample.created = rs.getDate("created");
                sample.creator = rs.getString("creator");
                sample.modified = rs.getDate("modified");
                sample.modifier = rs.getString("modifier");
                String strg = rs.getString("label");
                if (strg != null) {
                    sample.setLabel(strg);
                }
                samples.put(sample.sampID, sample);
                Sample.insert(well.samples, sample, well.getWellUnits());
            }
            catch (SBException sbe) {
                System.out.println("Exception inserting sample for well: " + well + " : " + sbe.getMessage());
            }
        }
        return samples;
    }
}

