/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import model1_8.Lithology;
import model1_8.SBException;
import model1_8.SBdb;

public class SampleLithology {
    SBdb SB;
    private Lithology description;
    private int percent;

    SampleLithology(SBdb SB2, Lithology descr, int percent) {
        this.SB = SB2;
        this.description = descr;
        this.percent = percent;
    }

    public SampleLithology(Lithology descr, int percent) {
        this.description = descr;
        this.percent = percent;
    }

    public void setPercent(int percent) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set sample lithology");
        }
        this.percent = percent;
    }

    public void setDescription(Lithology descr) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set sample lithology");
        }
        this.description = descr;
    }

    void writeXML(FileWriter out, int indent) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write(ind + "<Description>" + this.description.getDescr() + "</Description>\n");
        out.write(ind + "<Code>" + this.description.getLithID() + "</Code>\n");
        out.write(ind + "<Percent>" + this.percent + "</Percent>\n");
    }

    void parseXML(String chars, String element) throws ParseException, SQLException {
    }

    void store(int sampID) throws SQLException {
        String sql = "INSERT INTO " + this.SB.DBTableName("SBSLITH") + " (samp_id,lith_id,percnt) VALUES(" + sampID + "," + this.description.getLithID() + "," + this.percent + ")";
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    static void clear(SBdb SB2, int sampID) throws SQLException {
        String sql = "DELETE FROM " + SB2.DBTableName("SBSLITH") + " WHERE samp_id=" + sampID;
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
    }

    public Lithology getDescription() {
        return this.description;
    }

    public int getPercent() {
        return this.percent;
    }
}

