/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import model1_8.Markers;
import model1_8.SBdb;
import util.SB;
import util.SbugsStatus;

public class SeismicMarker
implements SbugsStatus {
    private double depth;
    private String colour = "";
    Color status = SbugsStatus.UNKNOWN;

    public SeismicMarker(double depth, String colour) {
        this.depth = depth;
        this.colour = colour;
        this.status = NOTSTORED;
    }

    public double getDepth() {
        return this.depth;
    }

    public String getColour() {
        return this.colour;
    }

    public String toString() {
        return this.colour;
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    public String statusString() {
        return this.toString();
    }

    public Color getStatus() {
        return this.status;
    }

    public void store(SBdb SB2, String wellCode) throws SQLException {
        if (this.status == NOTSTORED) {
            String sql = "INSERT INTO " + SB2.DBTableName("WELLSMARK") + " (well_code,depth,colour) VALUES ('" + wellCode + "'," + this.depth + ",'" + this.colour + "')";
            Statement stmt = SB2.getDatabase().createStatement();
            stmt.executeUpdate(SB2.modQuery(sql));
            stmt.close();
            this.status = STORED;
        }
    }

    public void delete(SBdb SB2, String wellCode) throws SQLException {
        String sql = "DELETE FROM " + SB2.DBTableName("WELLSMARK") + " WHERE well_code='" + wellCode + "' AND depth > " + (this.depth - 0.01) + " AND depth < " + (this.depth + 0.01);
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        this.status = NOTSTORED;
        stmt.close();
    }

    public void updateStatus(Markers oldData) {
        int nzD = (int)(this.depth * 100.0);
        this.status = NOTSTORED;
        for (int i = 0; i < oldData.getSize(); ++i) {
            int cD;
            SeismicMarker SeismicMarker2 = oldData.get(i);
            if (SeismicMarker2 == this || (cD = (int)(SeismicMarker2.depth * 100.0)) != nzD) continue;
            this.status = STORED;
            if (this.colour.equalsIgnoreCase(SeismicMarker2.colour)) continue;
            this.status = CONFLICT;
            break;
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        out.write("[MARKER " + SB.getDepthString(this.depth, units, 2).trim() + "]" + eol);
        out.write("Depth = " + SB.getDepthString(this.depth, units, 2).trim() + eol);
        out.write("Marker = " + this.colour + eol);
        out.write(eol);
    }
}

