/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import javax.swing.tree.DefaultMutableTreeNode;
import model1_8.AbnScheme;
import model1_8.EnvScheme;
import model1_8.Fssabnd;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Sample;
import model1_8.Taxon;
import util.MergeStatus;
import util.SB;
import util.SbugsStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Smpdtl
extends Observable
implements SbugsStatus {
    SBdb SB;
    private Sample sample;
    Color status = NOTSTORED;
    int donorID;
    private char discID;
    private String analyst;
    private String picker;
    private String source;
    private String notes;
    private Date modified;
    private String modifier = null;
    private boolean barren = false;
    private float weight = 0.0f;
    private float coarse = 0.0f;
    private float medium = 0.0f;
    private float fine = 0.0f;
    EnvScheme envScheme = null;
    private int proximal;
    private int distal;
    private boolean isLoaded = false;
    boolean isStored = false;
    boolean isAnalysed = false;
    List<Fssabnd> occur = new LinkedList<Fssabnd>();
    static SimpleDateFormat defaultFormat = new SimpleDateFormat("dd-MMM-yyyy");

    public List<Fssabnd> getOccur() {
        return this.occur;
    }

    public char getDiscID() {
        return this.discID;
    }

    public String getAnalyst() {
        return this.analyst;
    }

    public Date getModified() {
        return this.modified;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Sample getSample() {
        return this.sample;
    }

    public boolean getBarren() {
        return this.barren;
    }

    public float getWeight() {
        return this.weight;
    }

    public float getCoarse() {
        return this.coarse;
    }

    public float getMedium() {
        return this.medium;
    }

    public float getFine() {
        return this.fine;
    }

    public String getPicker() {
        return this.picker;
    }

    public String getSource() {
        return this.source;
    }

    public String getNotes() {
        return this.notes;
    }

    Smpdtl(SBdb SB2) {
        this.SB = SB2;
    }

    Smpdtl(SBdb SB2, Sample sample, char discID, String analyst, String picker, String source, String notes, Date modified, String modifier, boolean barren, int proximal, int distal, float weight, float coarse, float medium, float fine) throws SBException {
        if (analyst == null) {
            throw new SBException("Analyst null in Smpdtl constructor");
        }
        this.analyst = analyst;
        this.SB = SB2;
        this.sample = sample;
        this.discID = discID;
        this.picker = picker;
        this.source = source;
        this.notes = notes;
        this.modified = modified;
        this.modifier = modifier;
        this.barren = barren;
        this.proximal = proximal;
        this.distal = distal;
        this.weight = weight;
        this.coarse = coarse;
        this.medium = medium;
        this.fine = fine;
    }

    Smpdtl(SBdb SB2, Sample sample, char discID, String analyst, boolean barren, String picker, String source, String notes, float weight, float coarse, float medium, float fine, int proximal, int distal) throws SQLException, SBException {
        this.analyst = analyst;
        this.SB = SB2;
        this.sample = sample;
        this.discID = discID;
        this.picker = picker;
        this.source = source;
        this.notes = notes;
        this.modified = new Date();
        this.modifier = SB2.user.getUsrID();
        this.barren = barren;
        this.proximal = proximal;
        this.distal = distal;
        this.weight = weight;
        this.coarse = coarse;
        this.medium = medium;
        this.fine = fine;
        this.store();
    }

    void update(char discID, String analyst, boolean barren, String picker, String source, String notes, float weight, float coarse, float medium, float fine, int proximal, int distal) throws SQLException, SBException {
        if (this.discID != discID) {
            throw new SBException("Attempt to update discipline");
        }
        if (!this.analyst.equals(analyst)) {
            this.updateAnalyst(true, analyst);
        }
        this.picker = picker;
        this.source = source;
        this.notes = notes;
        this.modified = new Date();
        this.modifier = this.SB.user.getUsrID();
        if (this.barren != barren) {
            this.setBarren(barren);
        }
        this.proximal = proximal;
        this.distal = distal;
        this.weight = weight;
        this.coarse = coarse;
        this.medium = medium;
        this.fine = fine;
        this.updateHeader();
    }

    boolean updateOcc(Taxon taxon, String field, char newValue) throws SBException {
        for (Fssabnd fss : this.occur) {
            if (fss.getSpecID() != taxon.getSpecID()) continue;
            if (field.equalsIgnoreCase("status")) {
                fss.setReworked(newValue == 'R', true);
            } else if (field.equalsIgnoreCase("ident_type")) {
                fss.setIdentType(newValue, true);
            } else if (field.equalsIgnoreCase("caved")) {
                fss.setCaved(newValue == 'Y', true);
            }
            this.setChanged();
        }
        return this.hasChanged();
    }

    boolean removeSpecies(Taxon taxon) throws SBException {
        for (Fssabnd fss : this.occur) {
            if (fss.getSpecID() != taxon.getSpecID()) continue;
            this.occur.remove(fss);
            this.setChanged();
        }
        return this.hasChanged();
    }

    @Override
    public Color getStatus() {
        if (this.status == UNKNOWN) {
            this.status = this.sample.getSampID() != 0 ? (this.isStored ? STORED : PARTSTORED) : NOTSTORED;
        }
        return this.status;
    }

    public String getStatusString() {
        if (this.barren) {
            return "Barren";
        }
        return "Analysed";
    }

    static boolean dataExists(SBdb SB2, char discID, int sampID) throws SQLException {
        String sql = "SELECT samp_id";
        sql = sql + " FROM " + SB2.DBTableName("SMPDTL") + " WHERE discID='" + discID + "' AND samp_id=" + sampID;
        sql = SB2.modQuery(sql);
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        boolean exists = false;
        if (rs.next()) {
            exists = true;
        }
        stmt.close();
        return exists;
    }

    Color updateStatus(int iSampID) throws SQLException, SBException {
        this.status = NOTSTORED;
        for (int i = 0; i < this.occur.size(); ++i) {
            Fssabnd occ = this.occur.get(i);
            if (this.sample.getSampID() == 0) {
                occ.status = Fssabnd.NOTSTORED;
            }
            occ.updateStatus(this.occur);
            this.status = MergeStatus.merge(this.status, occ.status);
        }
        if (iSampID == 0) {
            return this.status;
        }
        String sql = "SELECT picker,source,barren,notes";
        if (this.SB.hasSampleEnv) {
            sql = sql + ",proximal,distal";
        }
        sql = sql + ",modified,modifier FROM " + this.SB.DBTableName("SMPDTL") + " WHERE disc_id='" + this.discID + "' AND analyst='" + this.analyst + "' AND samp_id=" + this.sample.getSampID();
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            this.status = STORED;
            MergeStatus m = new MergeStatus(this.status);
            m.compareStringField("Picker", this.picker, rs.getString("picker"), true);
            m.compareStringField("Source", this.source, rs.getString("source"), true);
            StringBuffer barrenString = new StringBuffer(2);
            barrenString.append(rs.getString("barren"));
            this.status = m.getStatus();
            if (barrenString.length() > 0 && (this.barren && barrenString.charAt(0) != 'Y' || !this.barren && barrenString.charAt(0) == 'Y')) {
                this.status = CONFLICT;
            }
            m.compareStringField("notes", this.notes, rs.getString("notes"), true);
            if (this.SB.hasSampleEnv) {
                m.compareIntField("Proximal", this.proximal, rs.getInt("proximal"));
                m.compareIntField("Distal", this.proximal, rs.getInt("distal"));
            }
            if (this.status != CONFLICT) {
                this.modified = rs.getTimestamp("modified");
                this.modifier = rs.getString("modifier");
            }
        } else {
            this.status = NOTSTORED;
        }
        rs.close();
        if (this.occur.size() > 0) {
            sql = "SELECT spec_id,status,ident_type,form,growth,subj_abund,counts,caved,marker";
            sql = sql + " FROM " + this.SB.DBTableName("FSSABND") + " WHERE disc_id='" + this.discID + "' AND analyst='" + this.analyst + "' AND samp_id=" + this.sample.getSampID();
            sql = this.SB.modQuery(sql);
            rs = stmt.executeQuery(sql);
            for (int i = 0; i < this.occur.size(); ++i) {
                Fssabnd occ = this.occur.get(i);
                occ.status = NOTSTORED;
            }
            int numberInDatabase = 0;
            if (rs.next()) {
                throw new SBException("In Fssabnd::updateStatus");
            }
            stmt.close();
            if (numberInDatabase > this.occur.size()) {
                this.status = CONFLICT;
            } else {
                for (int i = 0; i < this.occur.size(); ++i) {
                    Fssabnd occ = this.occur.get(i);
                    if (occ.status == CONFLICT) {
                        this.status = CONFLICT;
                        break;
                    }
                    if (this.status != STORED || occ.status != NOTSTORED) continue;
                    this.status = CONFLICT;
                }
            }
        }
        return this.status;
    }

    void updateAnalyst(boolean inDatabase, String newAnalyst) throws SQLException, SBException {
        if (this.sample.getSampID() != 0 && inDatabase) {
            String sql;
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql = "SELECT samp_id FROM " + this.SB.DBTableName("smpdtl") + " WHERE samp_id=" + this.sample.getSampID() + " AND disc_id='" + this.discID + "' AND analyst='" + newAnalyst + "'"));
            if (rs.next()) {
                stmt.close();
                throw new SBException("Cannot update sample: " + this.sample.getSampID() + ", analyst: " + this.analyst.toString() + "->" + newAnalyst + ", it would create a duplicate analysis in database.");
            }
            sql = "UPDATE " + this.SB.DBTableName("smpdtl") + " SET analyst='" + newAnalyst + "' WHERE samp_id=" + this.sample.getSampID() + " AND disc_id='" + this.discID + "' AND analyst='" + this.analyst.toString() + "'";
            stmt.executeUpdate(this.SB.modQuery(sql));
            sql = "UPDATE " + this.SB.DBTableName("fssabnd") + " SET analyst='" + newAnalyst + "' WHERE samp_id=" + this.sample.getSampID() + " AND disc_id='" + this.discID + "' AND analyst='" + this.analyst.toString() + "'";
            stmt.executeUpdate(this.SB.modQuery(sql));
            stmt.close();
        }
        this.analyst = newAnalyst;
    }

    void loadHeader() throws SQLException {
        String sql = "SELECT picker,source,modified,modifier,barren,notes";
        sql = sql + " FROM " + this.SB.DBTableName("SMPDTL") + " WHERE disc_id='" + this.discID + "' AND analyst='" + this.analyst + "' AND samp_id=" + this.sample.getSampID();
        Statement stmt = this.SB.getDatabase().createStatement();
        sql = this.SB.modQuery(sql);
        ResultSet rs = stmt.executeQuery(sql);
        Object strg = null;
        this.status = UNKNOWN;
        if (rs.next()) {
            this.picker = rs.getString("picker");
            this.source = rs.getString("source");
            this.modified = rs.getTimestamp("modified");
            this.modifier = rs.getString("modifier");
            String barrenString = rs.getString("barren");
            if (barrenString != null && barrenString.length() > 0 && barrenString.charAt(0) == 'Y') {
                this.barren = true;
                this.isAnalysed = true;
            }
            this.notes = rs.getString("notes");
            this.status = STORED;
        }
        stmt.close();
    }

    void deleteOcc(boolean clearFss) throws SQLException {
        if (this.sample.getSampID() != 0) {
            String sql = "DELETE ";
            sql = sql + " FROM " + this.SB.DBTableName("FSSABND") + " WHERE disc_id='" + this.discID + "' AND analyst='" + this.analyst + "' AND samp_id=" + this.sample.getSampID();
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(this.SB.modQuery(sql));
        }
        if (clearFss) {
            this.occur.clear();
            this.setChanged();
        }
    }

    public void load(SBdb SB2) throws SQLException, SBException {
        if (SB2.getDatabase() == null) {
            throw new SBException("Attempt to load smpdtl with null connection");
        }
        this.SB = SB2;
        this.load();
    }

    public void load() throws SQLException, SBException {
        if (this.isLoaded) {
            return;
        }
        String sql = "SELECT spec_id,status,ident_type,form,growth,subj_abund,counts,coarse,fine,caved,marker,preserv,colour,comments";
        sql = sql + " FROM " + this.SB.DBTableName("FSSABND") + " WHERE disc_id='" + this.discID + "' AND analyst='" + this.analyst + "' AND samp_id=" + this.sample.getSampID();
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        this.isAnalysed = false;
        while (rs.next()) {
            this.isAnalysed = true;
            int sampID = this.sample.getSampID();
            int specID = rs.getInt("spec_id");
            String strg = rs.getString("status");
            boolean reworked = false;
            if (strg != null && strg.compareToIgnoreCase("R") == 0) {
                reworked = true;
            }
            char identType = rs.getString("ident_type").charAt(0);
            strg = rs.getString("form");
            char form = 'C';
            if (strg != null) {
                form = strg.charAt(0);
            }
            strg = rs.getString("growth");
            char growth = 'A';
            if (strg != null) {
                growth = strg.charAt(0);
            }
            String subjAbund = (strg = rs.getString("subj_abund")) != null ? strg : "";
            int counts = rs.getInt("counts");
            int coarse = rs.getInt("coarse");
            int fine = rs.getInt("fine");
            strg = rs.getString("caved");
            boolean caved = false;
            if (strg != null && (strg.equalsIgnoreCase("C") || strg.equalsIgnoreCase("Y"))) {
                caved = true;
            }
            strg = rs.getString("marker");
            boolean marker = false;
            if (strg != null && strg.compareToIgnoreCase("Y") == 0) {
                marker = true;
            }
            String preservation = rs.getString("preserv");
            String colour = rs.getString("colour");
            String comment = rs.getString("comments");
            Taxon taxon = this.SB.getTaxon(specID);
            Fssabnd fss = new Fssabnd(this.SB, sampID, specID, taxon, reworked, identType, form, growth, subjAbund, coarse, counts, fine, caved, marker, preservation, colour, comment);
            fss.status = STORED;
            this.occur.add(fss);
        }
        stmt.close();
        this.isStored = true;
        this.isLoaded = true;
        this.status = STORED;
    }

    void fillTaxa(Hashtable taxa) throws SBException, SQLException {
        for (int i = 0; i < this.occur.size(); ++i) {
            Fssabnd fss = this.occur.get(i);
            fss.fillTaxon(taxa);
        }
    }

    void fillTaxonList(List taxa) {
        for (int i = 0; i < this.occur.size(); ++i) {
            Fssabnd fss = this.occur.get(i);
            fss.fillTaxonList(taxa);
        }
    }

    void updateModified() throws SQLException, SBException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String sql = "UPDATE " + this.SB.DBTableName("SMPDTL") + " SET modified='" + df.format(this.modified) + "'" + " WHERE samp_id=" + this.sample.getSampID() + " AND disc_id='" + this.discID + "' AND analyst='" + this.analyst + "'";
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
    }

    void updateHeader() throws SQLException, SBException {
        SimpleDateFormat df;
        block10: {
            block9: {
                block8: {
                    block7: {
                        df = new SimpleDateFormat("yyyy-MM-dd");
                        if (this.modified == null) break block7;
                        if (SBdb.preserveAudit) break block8;
                    }
                    this.modified = new Date();
                }
                if (this.modifier == null || this.modifier.length() == 0) break block9;
                if (SBdb.preserveAudit) break block10;
            }
            this.modifier = this.SB.user.getUsrID();
        }
        String sql = "UPDATE " + this.SB.DBTableName("SMPDTL") + " SET modified='" + df.format(this.modified) + "'" + ",modifier='" + this.modifier + "'" + ",barren='" + (this.barren ? "Y" : (this.isAnalysed ? "N" : "")) + "'" + ",picker='" + (this.picker != null ? this.picker.toString() : "") + "'" + ",source='" + (this.source != null ? this.source.toString() : "") + "'" + ",weight=" + this.weight + ",coarse=" + this.coarse + ",medium=" + this.medium + ",fine=" + this.fine + ",notes=" + util.SB.DBString(this.notes.toString());
        if (this.SB.hasSampleEnv) {
            sql = sql + ",proximal=" + this.proximal + ",distal=" + this.distal;
        }
        sql = sql + " WHERE samp_id=" + this.sample.getSampID() + " AND disc_id='" + this.discID + "' AND analyst='" + this.analyst + "'";
        sql = this.SB.modQuery(sql);
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        this.setChanged();
    }

    void store() throws SQLException, SBException {
        Fssabnd fss;
        int i;
        SimpleDateFormat df;
        block34: {
            block33: {
                block32: {
                    block31: {
                        if (this.analyst.length() == 0) {
                            throw new SBException("Analyst blank while attempting to store analysis for discipline : " + this.discID);
                        }
                        if (this.sample.getSampID() == 0) {
                            throw new SBException("Attempt to store SMPDTL entry with null sampleID, analyst=" + this.analyst + ",discipline=" + this.discID);
                        }
                        df = new SimpleDateFormat("yyyy-MM-dd");
                        if (this.modified == null) break block31;
                        if (SBdb.preserveAudit) break block32;
                    }
                    this.modified = new Date();
                }
                if (this.modifier == null || this.modifier.length() == 0) break block33;
                if (SBdb.preserveAudit) break block34;
            }
            this.modifier = this.SB.user.getUsrID();
        }
        if (this.status == NOTSTORED) {
            String sql = "INSERT INTO " + this.SB.DBTableName("SMPDTL") + " (samp_id,disc_id,analyst,modified,modifier,barren";
            if (this.picker != null && this.picker.length() > 0) {
                sql = sql + ",picker";
            }
            if (this.source != null && this.source.length() > 0) {
                sql = sql + ",source";
            }
            if ((double)Math.abs(this.weight) > 0.001) {
                sql = sql + ",weight";
            }
            if ((double)Math.abs(this.coarse) > 0.001) {
                sql = sql + ",coarse";
            }
            if ((double)Math.abs(this.medium) > 0.001) {
                sql = sql + ",medium";
            }
            if ((double)Math.abs(this.fine) > 0.001) {
                sql = sql + ",fine";
            }
            if (this.notes.length() > 0) {
                sql = sql + ",notes";
            }
            if (this.SB.hasSampleEnv && this.proximal > 0) {
                sql = sql + ",proximal,distal";
            }
            sql = sql + ") VALUES (" + this.sample.getSampID() + ",'" + this.discID + "','" + this.analyst + "','" + df.format(this.modified) + "','" + this.modifier + "','" + (this.barren ? "Y" : (this.isAnalysed ? "N" : "")) + "'";
            if (this.picker != null && this.picker.length() > 0) {
                sql = sql + ",'" + this.picker + "'";
            }
            if (this.source != null && this.source.length() > 0) {
                sql = sql + ",'" + this.source + "'";
            }
            if ((double)Math.abs(this.weight) > 0.001) {
                sql = sql + "," + this.weight;
            }
            if ((double)Math.abs(this.coarse) > 0.001) {
                sql = sql + "," + this.coarse;
            }
            if ((double)Math.abs(this.medium) > 0.001) {
                sql = sql + "," + this.medium;
            }
            if ((double)Math.abs(this.fine) > 0.001) {
                sql = sql + "," + this.fine;
            }
            if (this.notes.length() > 0) {
                sql = sql + "," + util.SB.DBString(this.notes.toString());
            }
            if (this.SB.hasSampleEnv && this.proximal > 0) {
                sql = sql + "," + this.proximal + "," + this.distal;
            }
            sql = sql + ")";
            sql = this.SB.modQuery(sql);
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(sql);
            stmt.close();
        } else if (this.status == PARTSTORED) {
            this.updateHeader();
        }
        boolean toStore = false;
        for (i = 0; i < this.occur.size(); ++i) {
            fss = this.occur.get(i);
            if (fss.status != Fssabnd.PARTSTORED) {
                if (fss.status != Fssabnd.NOTSTORED) continue;
            }
            toStore = true;
            break;
        }
        if (toStore) {
            this.deleteOcc(false);
            for (i = 0; i < this.occur.size(); ++i) {
                fss = this.occur.get(i);
                fss.store(this.sample.getSampID(), this.discID, this.analyst.toString());
            }
        }
        this.isStored = true;
        this.status = STORED;
    }

    void writeDEX(FileWriter out, boolean useDonorTaxa, LinkedList taxa, SimpleDateFormat df, String eol) throws IOException {
        out.write("Discipline = " + this.discID + eol);
        if (this.modified != null) {
            out.write("  Modified : " + df.format(this.modified) + eol);
        }
        if (this.modifier != null) {
            out.write("  Modifier : " + this.modifier + eol);
        }
        if (this.analyst.length() > 0) {
            out.write("  Analyst : " + this.analyst.toString() + eol);
        }
        if (this.picker.length() > 0) {
            out.write("  Picker : " + this.picker.toString() + eol);
        }
        if (this.source.length() > 0) {
            out.write("  Source : " + this.source.toString() + eol);
        }
        if (this.notes.length() > 0) {
            out.write("  Notes : " + this.notes.toString() + eol);
        }
        if (this.weight > 0.0f) {
            out.write("  Weight : " + this.weight + eol);
        }
        if (this.coarse > 0.0f || this.medium > 0.0f || this.fine > 0.0f) {
            out.write("  Coarse fraction : " + this.coarse + eol);
            out.write("  Medium fraction : " + this.medium + eol);
            out.write("  Fine fraction : " + this.fine + eol);
        }
        if (this.barren) {
            out.write("  Analysis : barren" + eol);
        }
        for (Fssabnd fss : this.occur) {
            out.write("Species = " + fss.getTaxon().toString(false) + eol);
            if (!taxa.contains(fss.getTaxon())) {
                taxa.add(fss.getTaxon());
            }
            out.write("  Code : " + fss.getTaxon().getCatMnem() + eol);
            fss.writeDEX(out, eol);
        }
    }

    void writeXML(FileWriter out, int indent, boolean useDonorSpecID) throws IOException {
        String ind = new String();
        while (ind.length() < indent) {
            ind = ind + ' ';
        }
        out.write(ind + "<Discipline>" + this.discID + "</Discipline>\n");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (this.modified != null) {
            out.write(ind + "<Modified>" + df.format(this.modified) + "</Modified>\n");
        }
        if (this.modifier != null && this.modifier.length() > 0) {
            out.write(ind + "<Modifier>" + this.modifier + "</Modifier>\n");
        }
        if (this.analyst != null && this.analyst.length() > 0) {
            out.write(ind + "<Analyst>" + this.analyst + "</Analyst>\n");
        }
        if (this.picker != null && this.picker.length() > 0) {
            out.write(ind + "<Picker>" + this.picker + "</Picker>\n");
        }
        if (this.source != null && this.source.length() > 0) {
            out.write(ind + "<Source>" + this.source + "</Source>\n");
        }
        if (this.notes != null && this.notes.length() > 0) {
            out.write(ind + "<Notes>" + this.notes + "</Notes>\n");
        }
        if ((double)Math.abs(this.weight) > 0.001) {
            out.write(ind + "<Weight>" + this.weight + "</Weight>\n");
        }
        if (this.coarse > 0.0f) {
            out.write(ind + "<CoarseFraction>" + this.coarse + "</CoarseFraction>\n");
        }
        if (this.medium > 0.0f) {
            out.write(ind + "<MediumFraction>" + this.medium + "</MediumFraction>\n");
        }
        if (this.fine > 0.0f) {
            out.write(ind + "<FineFraction>" + this.fine + "</FineFraction>\n");
        }
        out.write(ind + "<Analysis>");
        if (this.barren) {
            out.write("Barren");
        } else if (this.analyst != null && this.analyst.length() > 0) {
            out.write("Analysed");
        } else {
            out.write("Prepared");
        }
        out.write("</Analysis>\n");
        for (int i = 0; i < this.occur.size(); ++i) {
            Fssabnd fss = this.occur.get(i);
            out.write(ind + "<Occurrence>\n");
            fss.writeXML(out, indent + 3, useDonorSpecID);
            out.write(ind + "</Occurrence>\n");
        }
    }

    public String dbStatusString() {
        return "";
    }

    public Color getDbStatus() {
        return Color.WHITE;
    }

    @Override
    public String statusString() {
        return this.toString();
    }

    public String toString() {
        if (this.modified == null) {
            return "";
        }
        return defaultFormat.format(this.modified);
    }

    void fillTree(DefaultMutableTreeNode top) {
        for (int i = 0; i < this.occur.size(); ++i) {
            Fssabnd fss = this.occur.get(i);
            DefaultMutableTreeNode fssNode = new DefaultMutableTreeNode(fss);
            top.add(fssNode);
        }
    }

    void insert(Fssabnd fss, boolean showConflict) throws SQLException, SBException {
        for (int i = 0; i < this.occur.size(); ++i) {
            Fssabnd existing = this.occur.get(i);
            if (existing.getTaxon() == null) {
                if (showConflict) {
                    fss.status = Fssabnd.CONFLICT;
                } else {
                    throw new SBException("Null fssabnd taxon reference : " + fss.toString());
                }
            }
            if (existing.getTaxon() != fss.getTaxon() || existing.getReworked() != fss.getReworked() || existing.getIdentType() != fss.getIdentType() || existing.getForm() != fss.getForm() || existing.getGrowth() != fss.getGrowth()) continue;
            if (showConflict) {
                fss.status = Fssabnd.CONFLICT;
                continue;
            }
            throw new SBException("Duplicate occurrence : " + fss.getTaxon().toString());
        }
        this.occur.add(fss);
        this.setBarren(false);
        if (fss.status == Fssabnd.UNKNOWN) {
            fss.status = Fssabnd.NOTSTORED;
        }
        this.isStored = false;
        this.isAnalysed = true;
        this.setChanged();
        this.status = MergeStatus.merge(this.status, fss.status);
    }

    public void setBarren(boolean barren) throws SQLException {
        if (this.barren != barren) {
            if (barren && this.occur.size() > 0) {
                this.deleteOcc(true);
            }
            this.barren = barren;
            Statement stmt = this.SB.getDatabase().createStatement();
            String sql = "UPDATE " + this.SB.DBTableName("SMPDTL") + " SET barren='" + (barren ? (char)'Y' : 'N') + "' WHERE samp_id=" + this.sample.getSampID() + " AND disc_id='" + this.discID + "' AND analyst='" + this.analyst + "'";
            stmt.executeUpdate(this.SB.modQuery(sql));
            stmt.close();
            this.setChanged();
        }
    }

    void removeOcc(Fssabnd fss) throws SBException {
        for (Fssabnd f : this.occur) {
            if (f == fss) {
                throw new SBException("Fssabnd object already exists in Fssabnd.removeOcc");
            }
            if (f.getSpecID() != fss.getSpecID() || f.getReworked() != fss.getReworked() || f.getForm() != fss.getForm() || f.getGrowth() != fss.getGrowth() || f.getIdentType() != fss.getIdentType()) continue;
            this.occur.remove(f);
            return;
        }
        System.out.println("Fss record not found in Fssabnd.removeOcc");
        this.setChanged();
    }

    public void deleteOcc(Fssabnd fss) throws SQLException, SBException {
        if (!this.occur.contains(fss)) {
            throw new SBException("Fss not found in smpdtl.delete");
        }
        fss.delete(this.sample.getSampID(), this.discID, this.analyst);
        this.occur.remove(fss);
        this.setChanged();
    }

    public void updateOcc(Fssabnd fss, boolean reworked, boolean questionable, char form, char growth, boolean caved, boolean marker, int coarse, int medium, int fine, String abund, String preserv, String colour, String comment) throws SBException, SQLException {
        for (Fssabnd f : this.occur) {
            if (f == fss || f.getSpecID() != fss.getSpecID() || f.getReworked() != reworked || f.getForm() != form || f.getGrowth() != growth || f.getIdentType() != '?' || !questionable) continue;
            throw new SBException("An occurrence of this type already exists");
        }
        fss.update(this.discID, this.analyst, reworked, questionable, form, growth, caved, marker, coarse, medium, fine, abund, preserv, colour, comment);
        this.setChanged();
    }

    void replaceOcc(Fssabnd fss) throws SBException, SQLException {
        for (Fssabnd f : this.occur) {
            if (f == fss) {
                throw new SBException("Fssabnd object already exists in Fssabnd.replaceOcc");
            }
            if (f.getSpecID() != fss.getSpecID() || f.getReworked() != fss.getReworked() || f.getForm() != fss.getForm() || f.getGrowth() != fss.getGrowth() || f.getIdentType() != fss.getIdentType()) continue;
            this.occur.remove(f);
            this.insert(fss, false);
            return;
        }
        System.out.println("Fss record not found in Fssabnd.replaceOcc");
    }

    void replaceSubjAbund(String donor, String target) {
        if (donor.equals(target)) {
            return;
        }
        for (Fssabnd f : this.occur) {
            if (!f.getSubAbund().equals(donor)) continue;
            f.setSubjAbund(target);
            this.setChanged();
        }
        this.notifyObservers();
    }

    void mergeDuplicateOccurrences(AbnScheme abn) throws SBException {
        boolean wasMerger = true;
        block0: while (wasMerger) {
            wasMerger = false;
            for (Fssabnd fss1 : this.occur) {
                if (fss1.getTaxon() == null) {
                    throw new SBException("Null fssabnd reference : " + fss1.toString());
                }
                Iterator<Fssabnd> it2 = this.occur.iterator();
                while (it2.hasNext()) {
                    Fssabnd fss2 = it2.next();
                    if (fss1 == fss2) continue;
                    if (fss2.getTaxon() == null) {
                        throw new SBException("Null fssabnd reference : " + fss2.toString());
                    }
                    if (fss2.getTaxon().getSpecID() != fss1.getTaxon().getSpecID() || fss2.getReworked() != fss1.getReworked() || fss2.getIdentType() != fss1.getIdentType() || fss2.getGrowth() != fss1.getGrowth() || fss2.getForm() != fss1.getForm()) continue;
                    wasMerger = true;
                    fss1.merge(fss2, abn);
                    it2.remove();
                }
                if (!wasMerger) continue;
                continue block0;
            }
        }
        if (wasMerger) {
            this.isStored = false;
        }
    }

    void sortFss() throws SBException {
        boolean sorted = false;
        block0: while (!sorted) {
            sorted = true;
            for (int i = 1; i < this.occur.size(); ++i) {
                Fssabnd fss = this.occur.get(i);
                if (fss.getTaxon() == null) {
                    throw new SBException("Null fssabnd reference : " + fss.toString());
                }
                Fssabnd prevFss = this.occur.get(i - 1);
                if (prevFss.getTaxon() == null) {
                    throw new SBException("Null fssabnd reference : " + fss.toString());
                }
                if (prevFss.getTaxon().compareTo(fss.getTaxon()) <= 0) continue;
                this.occur.set(i - 1, fss);
                this.occur.set(i, prevFss);
                sorted = false;
                continue block0;
            }
        }
    }

    void parseXML(String chars, String element) throws ParseException {
        if (element.compareTo("Discipline") == 0) {
            this.discID = chars.charAt(0);
        } else if (element.compareTo("Modified") == 0) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            this.modified = df.parse(chars);
        } else if (element.compareTo("Modifier") == 0) {
            this.modifier = chars;
        } else if (element.compareTo("Analyst") == 0) {
            this.analyst = chars;
        } else if (element.compareTo("Picker") == 0) {
            this.picker = chars;
        } else if (element.compareTo("Source") == 0) {
            this.source = chars;
        } else if (element.compareTo("Notes") == 0) {
            this.notes = chars;
        } else if (element.compareTo("Weight") == 0) {
            this.weight = Float.parseFloat(chars);
        } else if (element.compareTo("CoarseFraction") == 0) {
            this.coarse = Float.parseFloat(chars);
        } else if (element.compareTo("MediumFraction") == 0) {
            this.medium = Float.parseFloat(chars);
        } else if (element.compareTo("FineFraction") == 0) {
            this.fine = Float.parseFloat(chars);
        }
    }

    boolean hasDonorSpecies(int donorID) {
        for (int i = 0; i < this.occur.size(); ++i) {
            Fssabnd fss = this.occur.get(i);
            if (fss.getTaxon().donorID != donorID) continue;
            return true;
        }
        return false;
    }

    boolean hasSpecies(int specID) {
        for (int i = 0; i < this.occur.size(); ++i) {
            Fssabnd fss = this.occur.get(i);
            int specIDtoUse = fss.getTaxon().getSpecID();
            if (specIDtoUse == 0) {
                specIDtoUse = fss.getTaxon().donorID;
            }
            if (specIDtoUse != specID) continue;
            return true;
        }
        return false;
    }

    Fssabnd getFss(int specID) {
        for (int i = 0; i < this.occur.size(); ++i) {
            Fssabnd fss = this.occur.get(i);
            int specIDtoUse = fss.getTaxon().getSpecID();
            if (specIDtoUse == 0) {
                specIDtoUse = fss.getTaxon().donorID;
            }
            if (specIDtoUse != specID) continue;
            return fss;
        }
        return null;
    }

    public Fssabnd getFss(Taxon taxon, boolean reworked, char identType, char form, char growth) {
        for (Fssabnd f : this.occur) {
            if (f.getTaxon() != taxon && f.getTaxon().getSpecID() != taxon.getSpecID() || f.getIdentType() != identType || f.getReworked() != reworked || f.getForm() != form || f.getGrowth() != growth) continue;
            return f;
        }
        return null;
    }

    boolean updateTaxonRef(Taxon donor, Taxon target) throws SBException {
        for (Fssabnd f1 : this.occur) {
            if (f1.getTaxon() != donor) continue;
            for (Fssabnd f2 : this.occur) {
                if (f2.getTaxon() != target || f2.getForm() != f1.getForm() || f2.getGrowth() != f1.getGrowth() || f1.getIdentType() != f2.getIdentType() || f1.getReworked() != f2.getReworked()) continue;
                throw new SBException("Error updating records: " + f1 + " and " + f2);
            }
            f1.setTaxon(target);
            this.setChanged();
        }
        return this.hasChanged();
    }

    void fssIncrement() {
        this.setChanged();
    }

    boolean hasInSituSpecies(int specID, char flag) {
        for (int i = 0; i < this.occur.size(); ++i) {
            Fssabnd fss = this.occur.get(i);
            int specIDtoUse = fss.getTaxon().getSpecID();
            if (specIDtoUse == 0) {
                specIDtoUse = fss.getTaxon().donorID;
            }
            if (specIDtoUse != specID) continue;
            if (flag == 'R' && !fss.getReworked()) {
                return true;
            }
            if (flag != 'C' || fss.getCaved()) continue;
            return true;
        }
        return false;
    }

    static void delete(SBdb SB2, char discID, String analyst, int sampID) throws SQLException {
        if (sampID == 0) {
            return;
        }
        String sql = "DELETE FROM " + SB2.DBTableName("FSSABND") + " WHERE samp_id=" + sampID + " AND disc_id='" + discID + "' AND analyst='" + analyst + "'";
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        sql = "DELETE FROM " + SB2.DBTableName("SMPDTL") + " WHERE samp_id=" + sampID + " AND disc_id='" + discID + "' AND analyst='" + analyst + "'";
        stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
    }

    void writeSbugs(FileWriter out) throws IOException {
        out.write("D " + (this.barren ? "Y" : "N"));
        if (this.analyst != null) {
            out.write(this.analyst.toString());
        }
        out.write(9);
        if (this.picker != null) {
            out.write(this.picker.toString());
        }
        out.write(9);
        if (this.source != null) {
            out.write(this.source.toString());
        }
        out.write(9);
        if (this.notes != null) {
            out.write(this.notes.toString());
        }
        out.write(9);
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        if (this.modified != null) {
            out.write(df.format(this.modified));
        }
        out.write(10);
        for (int i = 0; i < this.occur.size(); ++i) {
            Fssabnd fss = this.occur.get(i);
            fss.writeSbugs(out);
        }
    }

    public static int loadAll(SBdb SB2, HashMap<Integer, Sample> samples) throws SQLException, SBException {
        int nAnalyses = 0;
        String sql = "SELECT samp_id,disc_id,analyst,picker,source,modified,modifier,barren,notes";
        if (SB2.hasSampleEnv) {
            sql = sql + ",proximal,distal";
        }
        sql = sql + ",weight,coarse,medium,fine";
        sql = sql + " FROM " + SB2.DBTableName("SMPDTL");
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int sampID = rs.getInt("samp_id");
            char discID = util.SB.getDBChar(rs, "disc_id");
            String analyst = rs.getString("analyst");
            String picker = rs.getString("picker");
            String source = rs.getString("source");
            Timestamp modified = rs.getTimestamp("modified");
            String modifier = rs.getString("modifier");
            boolean isAnalysed = true;
            boolean barren = false;
            String strg = rs.getString("barren");
            if (strg == null) {
                isAnalysed = false;
            } else {
                isAnalysed = true;
                if (strg.length() > 0 && strg.charAt(0) == 'Y') {
                    barren = true;
                }
            }
            String notes = rs.getString("notes");
            int proximal = 0;
            int distal = 0;
            if (SB2.hasSampleEnv) {
                proximal = rs.getInt("proximal");
                distal = rs.getInt("distal");
            }
            float weight = 0.0f;
            float coarse = 0.0f;
            float medium = 0.0f;
            float fine = 0.0f;
            if (SB2.hasWeightSplits[SBdb.did2i(discID)]) {
                weight = rs.getFloat("weight");
                coarse = rs.getFloat("coarse");
                medium = rs.getFloat("medium");
                fine = rs.getFloat("fine");
            }
            Smpdtl dtl = new Smpdtl(SB2, samples.get(sampID), discID, analyst, picker, source, notes, modified, modifier, barren, proximal, distal, weight, coarse, medium, fine);
            dtl.status = STORED;
            if (dtl.analyst.length() == 0) {
                System.out.println("Analyst null for sample : " + sampID);
                continue;
            }
            if (dtl.sample == null) {
                System.out.println("Sample null for sample ID : " + sampID);
                continue;
            }
            try {
                dtl.sample.insert(dtl);
                ++nAnalyses;
            }
            catch (SBException sbe) {
                System.out.println("Exception inserting smpdtl for sample: " + dtl.sample + " : " + sbe.getMessage());
            }
        }
        return nAnalyses;
    }
}

