/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import model1_8.SBException;
import model1_8.SBdb;
import util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynonymScheme {
    private SBdb SB;
    private String name;
    private int ID;
    public static final String DEFAULT_TEXT = "Default scheme";
    private HashMap<Integer, Integer> synonymy = null;

    SynonymScheme(SBdb SB2, String name) throws SQLException, SBException {
        if (!SB2.hasSynonymSchemes()) {
            throw new SBException("Attempt to add new scheme wheen no scheme available");
        }
        this.SB = SB2;
        this.ID = SB2.nextControl("SYN_SCH");
        Statement stmt = SB2.getDatabase().createStatement();
        String sql = "INSERT INTO " + SB2.DBTableName("synsch") + " (sch_id,name) VALUES (" + this.ID + "," + util.SB.DBString(name) + ")";
        stmt.executeUpdate(SB2.modQuery(sql));
        this.name = name;
        stmt.close();
    }

    SynonymScheme(SBdb SB2, int ID, String name) {
        this.SB = SB2;
        this.ID = ID;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getSchID() {
        return this.ID;
    }

    public String toString() {
        return this.getName();
    }

    private void load() throws SQLException, SBException {
        if (this.synonymy == null) {
            this.synonymy = new HashMap();
        } else {
            this.synonymy.clear();
        }
        String sql = "SELECT spec_id,pref FROM " + this.SB.DBTableName("SYNONYMY");
        if (this.SB.hasSynonymSchemes) {
            sql = sql + " WHERE sch_id=" + this.ID;
        } else if (this.ID > 1) {
            throw new SBException("Cannot load synonym Scheme: " + this.ID);
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            int specID = rs.getInt("spec_id");
            int prefID = rs.getInt("pref");
            this.synonymy.put(specID, prefID);
        }
        stmt.close();
    }

    int getPref(int specID) throws SQLException, SBException {
        Integer pref;
        if (this.synonymy == null) {
            this.load();
        }
        if ((pref = this.synonymy.get(specID)) != null) {
            return pref;
        }
        return 0;
    }

    List getSyn(int prefID) throws SQLException, SBException {
        if (this.synonymy == null) {
            this.load();
        }
        LinkedList<Integer> syn = new LinkedList<Integer>();
        Set<Map.Entry<Integer, Integer>> set = this.synonymy.entrySet();
        for (Map.Entry<Integer, Integer> entry : set) {
            if (entry.getValue() != prefID) continue;
            syn.add(entry.getKey());
        }
        return syn;
    }

    void remove(int specID) throws SQLException, SBException {
        if (this.synonymy == null) {
            this.load();
        }
        this.delete(specID);
        this.deleteSyn(specID);
    }

    void delete(int specID) throws SQLException {
        if (this.synonymy.get(specID) != null) {
            String sql = "DELETE FROM " + this.SB.DBTableName("synonymy") + " WHERE spec_id=" + specID;
            if (this.SB.hasSynonymSchemes) {
                sql = sql + " AND sch_id=" + this.ID;
            }
            Statement stmt = this.SB.getDatabase().createStatement();
            stmt.executeUpdate(this.SB.modQuery(sql));
            this.synonymy.remove(specID);
        }
    }

    void deleteSyn(int specID) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("synonymy") + " WHERE pref=" + specID;
        if (this.SB.hasSynonymSchemes) {
            sql = sql + " AND sch_id=" + this.ID;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        Set<Map.Entry<Integer, Integer>> set = this.synonymy.entrySet();
        Iterator<Map.Entry<Integer, Integer>> it = set.iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Integer> entry = it.next();
            if (entry.getValue() != specID) continue;
            it.remove();
        }
    }

    void updateSyn(int specID, List<Integer> syn) throws SQLException, SBException {
        if (this.synonymy == null) {
            this.load();
        }
        Set<Map.Entry<Integer, Integer>> set = this.synonymy.entrySet();
        for (Map.Entry<Integer, Integer> entry : set) {
            for (Integer synID : syn) {
                if (entry.getValue().intValue() != synID.intValue()) continue;
                throw new SBException("Taxon: " + synID + " is already a preferred term");
            }
        }
        this.deleteSyn(specID);
        Statement stmt = this.SB.getDatabase().createStatement();
        for (Integer synID : syn) {
            String sql = "INSERT INTO " + this.SB.DBTableName("synonymy") + " (spec_id,pref";
            if (this.SB.hasSynonymSchemes) {
                sql = sql + ",sch_id";
            }
            sql = sql + ") VALUES (" + synID + "," + specID;
            if (this.SB.hasSynonymSchemes) {
                sql = sql + "," + this.ID;
            }
            sql = sql + ")";
            stmt.executeUpdate(this.SB.modQuery(sql));
            this.synonymy.put(synID, specID);
        }
    }

    void updatePref(int specID, int prefID) throws SQLException, SBException {
        String sql;
        Integer pID;
        if (this.synonymy == null) {
            this.load();
        }
        if ((pID = this.synonymy.get(specID)) != null && pID == prefID) {
            return;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        if (pID != null) {
            sql = "DELETE FROM " + this.SB.DBTableName("synonymy") + " WHERE spec_id=" + specID;
            if (this.SB.hasSynonymSchemes) {
                sql = sql + " AND sch_id=" + this.ID;
            }
            stmt.executeUpdate(this.SB.modQuery(sql));
            this.synonymy.remove(specID);
        }
        sql = "INSERT INTO " + this.SB.DBTableName("synonymy") + " (spec_id,pref";
        if (this.SB.hasSynonymSchemes) {
            sql = sql + ",sch_id";
        }
        sql = sql + ") VALUES (" + specID + "," + prefID;
        if (this.SB.hasSynonymSchemes) {
            sql = sql + "," + this.ID;
        }
        sql = sql + ")";
        this.synonymy.put(specID, prefID);
        stmt.executeUpdate(this.SB.modQuery(sql));
    }

    public int getNTerms() throws SQLException, SBException {
        ResultSet rs;
        int nTerms = 0;
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "SELECT count(spec_id) as nterms FROM " + this.SB.DBTableName("SYNONYMY");
        if (this.SB.hasSynonymSchemes()) {
            sql = sql + " WHERE sch_id=" + this.ID;
        }
        if ((rs = stmt.executeQuery(this.SB.modQuery(sql))).next()) {
            nTerms = rs.getInt("nterms");
        }
        if (this.synonymy == null) {
            this.load();
        }
        if (nTerms != this.synonymy.size()) {
            throw new SBException("Number of terms from scheme: " + this.ID + " does not match synonyms loaded: " + nTerms + " vs. " + this.synonymy.size());
        }
        return nTerms;
    }

    void delete() throws SQLException {
        if (!this.SB.hasSynonymSchemes() || this.ID == 1) {
            return;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.SB.DBTableName("synonymy") + " WHERE sch_id=" + this.ID;
        stmt.executeUpdate(this.SB.modQuery(sql));
        sql = "DELETE FROM " + this.SB.DBTableName("synsch") + " WHERE sch_id=" + this.ID;
        stmt.executeUpdate(this.SB.modQuery(sql));
    }

    public void setName(String name) throws SQLException, SBException {
        String sql;
        if (!this.SB.hasSynonymSchemes() || this.ID == 1) {
            return;
        }
        if (name.equals(this.name)) {
            return;
        }
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql = "SELECT sch_id FROM " + this.SB.DBTableName("synsch") + " WHERE ucase(name)='" + name.toUpperCase() + "'"));
        if (rs.next()) {
            throw new SBException("Scheme already exists");
        }
        sql = "UPDATE " + this.SB.DBTableName("synsch") + " SET name=" + util.SB.DBString(name) + " WHERE sch_id=" + this.ID;
        if (stmt.executeUpdate(this.SB.modQuery(sql)) != 1) {
            throw new SBException("Cannot update synonym scheme name");
        }
        this.name = name;
        stmt.close();
    }

    static HashMap<Integer, SynonymScheme> getSchemes(SBdb SB2) throws SQLException {
        HashMap<Integer, SynonymScheme> schemes = new HashMap<Integer, SynonymScheme>();
        schemes.put(1, new SynonymScheme(SB2, 1, DEFAULT_TEXT));
        if (SB2.hasSynonymSchemes) {
            Statement stmt = SB2.getDatabase().createStatement();
            String sql = "SELECT sch_id,name FROM " + SB2.DBTableName("SYNSCH");
            ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
            while (rs.next()) {
                int ID = rs.getInt("sch_id");
                String name = rs.getString("name");
                if (schemes.get(ID) == null) {
                    schemes.put(ID, new SynonymScheme(SB2, ID, name));
                    continue;
                }
                if (ID == 1) continue;
                System.out.println("Duplicate Synonym Scheme: " + ID + "," + name);
            }
        }
        return schemes;
    }
}

