/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.TVDepth;
import util.SB;

public class TVDList
extends Observable {
    private SBdb SB;
    boolean isDirty = false;
    boolean isLoaded = false;
    private List<TVDepth> list = new LinkedList<TVDepth>();

    public TVDList(SBdb SB2) {
        this.SB = SB2;
    }

    public int getSize() {
        return this.list.size();
    }

    public TVDepth get(int row) {
        return this.list.get(row);
    }

    public boolean add(TVDepth tvd) throws SBException {
        Iterator<TVDepth> it = this.list.iterator();
        int insertPoint = 0;
        int nzD = (int)(tvd.getDDepth() * 100.0);
        boolean ignore = false;
        while (it.hasNext()) {
            TVDepth compareWith = it.next();
            if (compareWith != tvd) {
                int cD = (int)(compareWith.getDDepth() * 100.0);
                if (nzD == cD) {
                    ignore = true;
                }
                if (nzD < cD) break;
                ++insertPoint;
                continue;
            }
            return false;
        }
        if (!ignore) {
            this.list.add(insertPoint, tvd);
            this.setChanged();
            this.isDirty = true;
        }
        return true;
    }

    public void load(String wellCode) throws SQLException {
        if (!this.isLoaded || this.list == null) {
            this.list = new LinkedList<TVDepth>();
            String sql = "SELECT ddepth, tvdepth FROM " + this.SB.DBTableName("WELLTVD") + " WHERE well_code='" + wellCode + "'";
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                try {
                    double dDepth = rs.getDouble("ddepth");
                    double tvDepth = rs.getDouble("tvdepth");
                    TVDepth tvd = new TVDepth(dDepth, tvDepth);
                    this.list.add(tvd);
                }
                catch (SBException se) {
                    System.out.println(se.getMessage());
                }
            }
            stmt.close();
            this.isDirty = false;
            this.isLoaded = true;
        }
    }

    public void deleteAll(String wellCode) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("WELLTVD") + " WHERE well_code='" + wellCode + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    public void clear() {
        this.isDirty = false;
        this.isLoaded = false;
        if (this.list != null) {
            this.list.clear();
        }
    }

    public void store(String wellCode) throws SQLException {
        if (this.isDirty) {
            Iterator<TVDepth> it = this.list.iterator();
            this.deleteAll(wellCode);
            it = this.list.iterator();
            String sql = "INSERT INTO " + this.SB.DBTableName("WELLTVD") + "(well_code,ddepth,tvdepth) VALUES ('" + wellCode + "',?,?)";
            PreparedStatement pstmt = this.SB.getDatabase().prepareStatement(sql);
            while (it.hasNext()) {
                TVDepth tvd = it.next();
                pstmt.setDouble(1, tvd.getDDepth());
                pstmt.setDouble(2, tvd.getTVDepth());
                pstmt.executeUpdate();
            }
            pstmt.close();
            this.isDirty = false;
            this.isLoaded = true;
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        if (this.list.size() > 0) {
            Iterator<TVDepth> it = this.list.iterator();
            out.write("[TVD]" + eol);
            while (it.hasNext()) {
                TVDepth tvd = it.next();
                out.write("Depth/TVD = " + util.SB.getDepthString(tvd.getDDepth(), units, 2).trim() + " : " + util.SB.getDepthString(tvd.getTVDepth(), units, 2).trim() + eol);
            }
            out.write(eol);
        }
    }
}

