/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.TWTDepth;
import util.SB;

public class TWTList
extends Observable {
    SBdb SB;
    boolean isDirty = false;
    boolean isLoaded = false;
    private List<TWTDepth> list = new LinkedList<TWTDepth>();

    public TWTList(SBdb SB2) {
        this.SB = SB2;
    }

    public int getSize() {
        return this.list.size();
    }

    public TWTDepth get(int row) {
        return this.list.get(row);
    }

    public boolean add(TWTDepth twt) throws SBException {
        Iterator<TWTDepth> it = this.list.iterator();
        int insertPoint = 0;
        int nzD = (int)(twt.getDepth() * 100.0);
        boolean ignore = false;
        while (it.hasNext()) {
            TWTDepth compareWith = it.next();
            if (compareWith != twt) {
                int cD = (int)(compareWith.getDepth() * 100.0);
                if (nzD == cD) {
                    ignore = true;
                }
                if (nzD < cD) break;
                ++insertPoint;
                continue;
            }
            return false;
        }
        if (!ignore) {
            this.list.add(insertPoint, twt);
            this.isDirty = true;
        }
        return true;
    }

    public void load(String wellCode) throws SQLException {
        if (!this.isLoaded) {
            this.clear();
            String sql = "SELECT ddepth, TWT FROM " + this.SB.DBTableName("WELLTWT") + " WHERE well_code='" + wellCode + "'";
            Statement stmt = this.SB.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
            while (rs.next()) {
                try {
                    double dDepth = rs.getDouble("ddepth");
                    double TWTDepth2 = rs.getDouble("TWT");
                    TWTDepth twt = new TWTDepth(dDepth, TWTDepth2);
                    this.add(twt);
                }
                catch (SBException se) {
                    System.out.println(se.getMessage());
                }
            }
            stmt.close();
            this.isDirty = false;
            this.isLoaded = true;
        }
    }

    public void deleteAll(String wellCode) throws SQLException {
        String sql = "DELETE FROM " + this.SB.DBTableName("WELLTWT") + " WHERE well_code='" + wellCode + "'";
        Statement stmt = this.SB.getDatabase().createStatement();
        stmt.executeUpdate(this.SB.modQuery(sql));
        stmt.close();
    }

    public void clear() {
        this.isDirty = false;
        this.isLoaded = false;
        this.list.clear();
    }

    public void store(String wellCode) throws SQLException {
        if (this.isDirty) {
            Iterator<TWTDepth> it = this.list.iterator();
            this.deleteAll(wellCode);
            it = this.list.iterator();
            Statement stmt = this.SB.getDatabase().createStatement();
            while (it.hasNext()) {
                TWTDepth twt = it.next();
                String sql = "INSERT INTO " + this.SB.DBTableName("WELLTWT") + "(well_code,ddepth,twt) VALUES ('" + wellCode + "'," + twt.getDepth() + "," + twt.getTWT() + ")";
                stmt.executeUpdate(this.SB.modQuery(sql));
            }
            stmt.close();
            this.isDirty = false;
            this.isLoaded = true;
        }
    }

    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        if (this.list.size() > 0) {
            Iterator<TWTDepth> it = this.list.iterator();
            out.write("[TWT]" + eol);
            while (it.hasNext()) {
                TWTDepth twt = it.next();
                out.write("Depth/TWT = " + util.SB.getDepthString(twt.getDepth(), units, 2).trim() + " : " + util.SB.floatString(twt.getTWT(), 2) + eol);
            }
            out.write(eol);
        }
    }
}

