/*
 * Decompiled with CFR 0.152.
 */
package model1_8;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model1_8.SBException;
import model1_8.SBdb;
import model1_8.Taxon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaxaMap
extends Observable {
    private HashMap<Integer, Taxon> taxa;
    private SBdb SB;

    public TaxaMap(SBdb SB2) {
        this.SB = SB2;
        this.taxa = new HashMap();
    }

    public List<Taxon> getTaxa() {
        return new LinkedList<Taxon>(this.taxa.values());
    }

    public boolean hasTaxon(Taxon taxon) {
        return this.taxa.containsValue(taxon);
    }

    public Taxon getTaxon(int specID) throws SQLException, SBException {
        Taxon taxon = this.taxa.get(new Integer(specID));
        if (taxon == null) {
            taxon = new Taxon(this.SB, specID);
            this.taxa.put(specID, taxon);
            this.setChanged();
        }
        return taxon;
    }

    void addTaxon(Taxon taxon) throws SQLException {
        if (this.taxa.get(new Integer(taxon.getSpecID())) == null) {
            this.taxa.put(taxon.getSpecID(), taxon);
            this.setChanged();
        }
    }

    void updateGenID(int oldGenID, int newGenID, Taxon baseTaxon) {
        for (Taxon taxon : this.taxa.values()) {
            if (taxon.getGenID() != oldGenID) continue;
            taxon.setGenusFields(baseTaxon);
            this.setChanged();
        }
    }

    void remove(Taxon taxon) {
        if (this.taxa.remove(taxon.getSpecID()) != null) {
            this.setChanged();
        }
    }

    void remove(int specID) {
        if (this.taxa.remove(specID) != null) {
            this.setChanged();
        }
    }

    Taxon get(int specID) {
        return this.taxa.get(specID);
    }

    void loadAll() throws SQLException, SBException {
        Taxon.loadAll(this.SB, this.taxa);
        this.setChanged();
    }

    int getSize() {
        return this.taxa.size();
    }
}

